/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.diagnostic.Activity;
import com.intellij.diagnostic.ActivityCategory;
import com.intellij.diagnostic.ActivityImpl;
import com.intellij.diagnostic.LoadingState;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class StartUpMeasurer {
    static final AtomicReference<LoadingState> currentState = new AtomicReference<LoadingState>(LoadingState.BOOTSTRAP);
    public static final long MEASURE_THRESHOLD = TimeUnit.MILLISECONDS.toNanos(10L);
    public static boolean measuringPluginStartupCosts = true;
    private static long startTime = System.nanoTime();
    private static final ConcurrentLinkedQueue<ActivityImpl> items = new ConcurrentLinkedQueue();
    private static boolean isEnabled = true;
    @ApiStatus.Internal
    public static final Map<String, Object2LongOpenHashMap<String>> pluginCostMap = new ConcurrentHashMap<String, Object2LongOpenHashMap<String>>();

    public static void stopPluginCostMeasurement() {
        measuringPluginStartupCosts = false;
    }

    public static boolean isEnabled() {
        return isEnabled;
    }

    @TestOnly
    public static void disable() {
        isEnabled = false;
    }

    public static long getCurrentTime() {
        return System.nanoTime();
    }

    public static long getCurrentTimeIfEnabled() {
        return isEnabled ? System.nanoTime() : -1L;
    }

    public static long sinceStart() {
        return TimeUnit.NANOSECONDS.toMillis(StartUpMeasurer.getCurrentTime() - startTime);
    }

    public static void addInstantEvent(@NonNls @NotNull String name) {
        if (!isEnabled) {
            return;
        }
        ActivityImpl activity = new ActivityImpl(name, StartUpMeasurer.getCurrentTime(), null, null);
        activity.setEnd(-1L);
        StartUpMeasurer.addActivity(activity);
    }

    @NotNull
    public static Activity startActivity(@NonNls @NotNull String name, @NotNull ActivityCategory category) {
        return new ActivityImpl(name, StartUpMeasurer.getCurrentTime(), null, null, category);
    }

    @NotNull
    public static Activity startActivity(@NonNls @NotNull String name) {
        return new ActivityImpl(name, StartUpMeasurer.getCurrentTime(), null, null, ActivityCategory.DEFAULT);
    }

    @NotNull
    public static Activity startActivity(@NonNls @NotNull String name, @NotNull ActivityCategory category, @Nullable String pluginId) {
        return new ActivityImpl(name, StartUpMeasurer.getCurrentTime(), null, pluginId, category);
    }

    public static long addCompletedActivity(long start, @NotNull Class<?> clazz, @NotNull ActivityCategory category, @Nullable String pluginId) {
        return StartUpMeasurer.addCompletedActivity(start, clazz, category, pluginId, -1L);
    }

    public static long addCompletedActivity(long start, @NotNull Class<?> clazz, @NotNull ActivityCategory category, @Nullable String pluginId, long threshold) {
        if (!isEnabled) {
            return -1L;
        }
        long end = StartUpMeasurer.getCurrentTime();
        long duration = end - start;
        if (duration <= threshold) {
            return duration;
        }
        StartUpMeasurer.addCompletedActivity(start, end, clazz.getName(), category, pluginId);
        return duration;
    }

    public static long addCompletedActivity(long start, @NonNls @NotNull String name, @NotNull ActivityCategory category, String pluginId) {
        long end = StartUpMeasurer.getCurrentTime();
        long duration = end - start;
        if (duration <= MEASURE_THRESHOLD) {
            return duration;
        }
        StartUpMeasurer.addCompletedActivity(start, end, name, category, pluginId);
        return duration;
    }

    public static void addCompletedActivity(long start, long end, @NonNls @NotNull String name, @NotNull ActivityCategory category, String pluginId) {
        if (!isEnabled) {
            return;
        }
        ActivityImpl item = new ActivityImpl(name, start, null, pluginId, category);
        item.setEnd(end);
        StartUpMeasurer.addActivity(item);
    }

    public static void setCurrentState(@NotNull LoadingState state) {
        BiConsumer<String, Throwable> errorHandler;
        LoadingState old = currentState.getAndSet(state);
        if (old.compareTo(state) > 0 && (errorHandler = LoadingState.errorHandler) != null) {
            errorHandler.accept("New state " + (Object)((Object)state) + " cannot precede old " + (Object)((Object)old), new Throwable());
        }
        StartUpMeasurer.stateSet(state);
    }

    public static void compareAndSetCurrentState(@NotNull LoadingState expectedState, @NotNull LoadingState newState) {
        if (currentState.compareAndSet(expectedState, newState)) {
            StartUpMeasurer.stateSet(newState);
        }
    }

    private static void stateSet(@NotNull LoadingState state) {
        StartUpMeasurer.addInstantEvent(state.displayName);
    }

    @ApiStatus.Internal
    public static void processAndClear(boolean isContinueToCollect, @NotNull Consumer<? super ActivityImpl> consumer) {
        ActivityImpl item;
        isEnabled = isContinueToCollect;
        while ((item = items.poll()) != null) {
            consumer.accept(item);
        }
    }

    @ApiStatus.Internal
    public static long getStartTime() {
        return startTime;
    }

    static void addActivity(@NotNull ActivityImpl activity) {
        if (isEnabled) {
            items.add(activity);
        }
    }

    @ApiStatus.Internal
    public static void addTimings(@NotNull LinkedHashMap<String, Long> timings, @NotNull String groupName) {
        if (!items.isEmpty()) {
            throw new IllegalStateException("addTimings must be not called if some events were already added using API");
        }
        if (timings.isEmpty()) {
            return;
        }
        ArrayList<Map.Entry<String, Long>> entries = new ArrayList<Map.Entry<String, Long>>(timings.entrySet());
        ActivityImpl parent = new ActivityImpl(groupName, (Long)((Map.Entry)entries.get(0)).getValue(), null, null);
        parent.setEnd(StartUpMeasurer.getCurrentTime());
        for (int i = 0; i < entries.size(); ++i) {
            long start = (Long)((Map.Entry)entries.get(i)).getValue();
            if (start < startTime) {
                startTime = start;
            }
            ActivityImpl activity = new ActivityImpl((String)((Map.Entry)entries.get(i)).getKey(), start, parent, null);
            activity.setEnd(i == entries.size() - 1 ? parent.getEnd() : ((Long)((Map.Entry)entries.get(i + 1)).getValue()).longValue());
            items.add(activity);
        }
        items.add(parent);
    }

    @ApiStatus.Internal
    public static void addPluginCost(@NonNls @NotNull String pluginId, @NonNls @NotNull String phase, long time) {
        if (StartUpMeasurer.isMeasuringPluginStartupCosts()) {
            StartUpMeasurer.doAddPluginCost(pluginId, phase, time, pluginCostMap);
        }
    }

    public static boolean isMeasuringPluginStartupCosts() {
        return measuringPluginStartupCosts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    public static void doAddPluginCost(@NonNls @NotNull String pluginId, @NonNls @NotNull String phase, long time, @NotNull Map<String, Object2LongOpenHashMap<String>> pluginCostMap) {
        Object2LongMap costPerPhaseMap;
        Object2LongMap object2LongMap = costPerPhaseMap = (Object2LongMap)pluginCostMap.computeIfAbsent(pluginId, __ -> new Object2LongOpenHashMap());
        synchronized (object2LongMap) {
            costPerPhaseMap.mergeLong((Object)phase, time, Math::addExact);
        }
    }

    public static final class Activities {
        public static final String INIT_APP = "app initialization";
        public static final String PLACE_ON_EVENT_QUEUE = "place on event queue";
        public static final String REGISTER_COMPONENTS_SUFFIX = "component registration";
        public static final String CREATE_COMPONENTS_SUFFIX = "component creation";
        public static final String PROJECT_DUMB_POST_START_UP_ACTIVITIES = "project post-startup dumb-aware activities";
        public static final String EDITOR_RESTORING = "editor restoring";
        public static final String EDITOR_RESTORING_TILL_PAINT = "editor restoring till paint";
    }
}

