/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.diagnostic.PluginProblemReporter;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.ExceptionWithAttachments;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PluginException
extends RuntimeException
implements ExceptionWithAttachments {
    private final PluginId myPluginId;
    private final List<Attachment> myAttachments;

    public PluginException(@NotNull String message, Throwable cause, @Nullable PluginId pluginId) {
        super(message, cause);
        this.myPluginId = pluginId;
        this.myAttachments = Collections.emptyList();
    }

    public PluginException(@NotNull Throwable e, @Nullable PluginId pluginId) {
        super(e.getMessage(), e);
        this.myPluginId = pluginId;
        this.myAttachments = Collections.emptyList();
    }

    public PluginException(@NotNull String message, @Nullable PluginId pluginId) {
        super(message);
        this.myPluginId = pluginId;
        this.myAttachments = Collections.emptyList();
    }

    public PluginException(@NotNull String message, @Nullable PluginId pluginId, @NotNull List<Attachment> attachments) {
        super(message);
        this.myPluginId = pluginId;
        this.myAttachments = attachments;
    }

    public PluginException(@NotNull String message, @Nullable Throwable cause, @Nullable PluginId pluginId, @NotNull List<Attachment> attachments) {
        super(message, cause);
        this.myPluginId = pluginId;
        this.myAttachments = attachments;
    }

    @Nullable
    public final PluginId getPluginId() {
        return this.myPluginId;
    }

    @Override
    @NotNull
    public String getMessage() {
        String message = super.getMessage();
        if (this.myPluginId == null || message != null && message.contains("PluginDescriptor(")) {
            return message;
        }
        return (message != null ? message : "null") + " [Plugin: " + this.myPluginId + "]";
    }

    @Override
    public final Attachment @NotNull [] getAttachments() {
        return this.myAttachments.toArray(Attachment.EMPTY_ARRAY);
    }

    @NotNull
    public static PluginException createByClass(@NotNull String errorMessage, @Nullable Throwable cause, @NotNull Class<?> pluginClass) {
        return PluginProblemReporter.getInstance().createPluginExceptionByClass(errorMessage, cause, pluginClass);
    }

    @NotNull
    public static PluginException createByClass(@NotNull Throwable cause, @NotNull Class<?> pluginClass) {
        String message = cause.getMessage();
        return PluginProblemReporter.getInstance().createPluginExceptionByClass(message != null ? message : "", cause, pluginClass);
    }

    public static void logPluginError(@NotNull Logger logger, @NotNull String errorMessage, @Nullable Throwable cause, @NotNull Class<?> pluginClass) {
        logger.error(PluginException.createByClass(errorMessage, cause, pluginClass));
    }

    public static void reportDeprecatedUsage(@NotNull String signature, @NotNull String details) {
        String message = "'" + signature + "' is deprecated and going to be removed soon. " + details;
        Logger.getInstance(PluginException.class).error(message);
    }

    public static void reportDeprecatedDefault(@NotNull Class<?> violator, @NotNull String methodName, @NotNull String details) {
        String message = "The default implementation of method '" + methodName + "' is deprecated, you need to override it in '" + violator + "'. " + details;
        Logger.getInstance(violator).error(PluginException.createByClass(message, null, violator));
    }
}

