/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.diagnostic.InstanceHolder;
import com.intellij.diagnostic.LoadingState;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import java.awt.AWTEvent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
@ApiStatus.Internal
public interface EventWatcher {
    public static boolean isEnabled() {
        return InstanceHolder.isEnabled;
    }

    @Nullable
    public static EventWatcher getInstanceOrNull() {
        Application app;
        if (!EventWatcher.isEnabled()) {
            return null;
        }
        EventWatcher result = InstanceHolder.instance;
        if (result == null && LoadingState.CONFIGURATION_STORE_INITIALIZED.isOccurred() && (app = ApplicationManager.getApplication()) != null && !app.isDisposed()) {
            InstanceHolder.instance = result = app.getService(EventWatcher.class);
        }
        return result;
    }

    @RequiresEdt
    public void runnableStarted(@NotNull Runnable var1, long var2);

    @RequiresEdt
    public void runnableFinished(@NotNull Runnable var1, long var2);

    @RequiresEdt
    public void edtEventStarted(@NotNull AWTEvent var1, long var2);

    @RequiresEdt
    public void edtEventFinished(@NotNull AWTEvent var1, long var2);

    public void reset();

    public void logTimeMillis(@NotNull String var1, long var2, @NotNull Class<? extends Runnable> var4);

    default public void logTimeMillis(@NotNull String processId, long startedAt) {
        this.logTimeMillis(processId, startedAt, Runnable.class);
    }
}

