/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.diagnostic.Activity;
import com.intellij.diagnostic.ActivityCategory;
import com.intellij.diagnostic.StartUpMeasurer;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ActivityImpl
implements Activity {
    private final String name;
    private String description;
    private String threadName;
    private long threadId;
    private final long start;
    private long end;
    private final ActivityImpl parent;
    @Nullable
    private final ActivityCategory category;
    @Nullable
    private final String pluginId;
    @ApiStatus.Internal
    public static volatile Consumer<ActivityImpl> listener;

    ActivityImpl(@Nullable String name, long start, @Nullable ActivityImpl parent, @Nullable String pluginId) {
        this(name, start, parent, pluginId, null);
    }

    ActivityImpl(@Nullable String name, long start, @Nullable ActivityImpl parent, @Nullable String pluginId, @Nullable ActivityCategory category) {
        this.name = name;
        this.start = start;
        this.parent = parent;
        this.pluginId = pluginId;
        this.category = category;
        this.updateThreadName();
        Consumer<ActivityImpl> listener = ActivityImpl.listener;
        if (listener != null) {
            listener.accept(this);
        }
    }

    @NotNull
    public String getThreadName() {
        return this.threadName;
    }

    @Override
    public void updateThreadName() {
        Thread thread = Thread.currentThread();
        this.threadId = thread.getId();
        this.threadName = thread.getName();
    }

    public long getThreadId() {
        return this.threadId;
    }

    @Nullable
    public ActivityImpl getParent() {
        return this.parent;
    }

    @Nullable
    public ActivityCategory getCategory() {
        return this.category;
    }

    @Override
    @NotNull
    public ActivityImpl startChild(@NotNull String name) {
        return new ActivityImpl(name, StartUpMeasurer.getCurrentTime(), this, this.pluginId, this.category);
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Nullable
    public String getPluginId() {
        return this.pluginId;
    }

    public long getStart() {
        return this.start;
    }

    public long getEnd() {
        return this.end;
    }

    void setEnd(long end) {
        assert (this.end == 0L);
        this.end = end;
    }

    @Override
    public void end() {
        assert (this.end == 0L) : "not started or already ended";
        this.end = StartUpMeasurer.getCurrentTime();
        StartUpMeasurer.addActivity(this);
        Consumer<ActivityImpl> listener = ActivityImpl.listener;
        if (listener != null) {
            listener.accept(this);
        }
    }

    @Override
    public void setDescription(@NotNull String value) {
        this.description = value;
    }

    @Override
    @NotNull
    public Activity endAndStart(@NotNull String name) {
        this.end();
        return new ActivityImpl(name, this.end, this.parent, this.pluginId, this.category);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ActivityImpl(name=").append(this.name).append(", start=");
        ActivityImpl.nanoToString(this.start, builder);
        builder.append(", end=");
        ActivityImpl.nanoToString(this.end, builder);
        builder.append(", category=").append((Object)this.category).append(")");
        return builder.toString();
    }

    private static void nanoToString(long start, @NotNull StringBuilder builder) {
        builder.append(TimeUnit.NANOSECONDS.toMillis(start - StartUpMeasurer.getStartTime())).append("ms (").append(TimeUnit.NANOSECONDS.toMicros(start - StartUpMeasurer.getStartTime())).append("\u03bcs)");
    }
}

