/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.concurrency;

import com.intellij.concurrency.ThreadContext;
import com.intellij.openapi.application.AccessToken;
import kotlin.coroutines.CoroutineContext;
import org.jetbrains.annotations.NotNull;

final class ContextRunnable
implements Runnable {
    @NotNull
    private final CoroutineContext myParentContext = ThreadContext.currentThreadContext();
    @NotNull
    private final Runnable myRunnable;

    ContextRunnable(@NotNull Runnable runnable) {
        this.myRunnable = runnable;
    }

    @Override
    public void run() {
        ThreadContext.checkUninitializedThreadContext();
        try (AccessToken ignored = ThreadContext.replaceThreadContext(this.myParentContext);){
            this.myRunnable.run();
        }
    }
}

