/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.concurrency;

import com.intellij.concurrency.ThreadContext;
import com.intellij.openapi.application.AccessToken;
import java.util.concurrent.Callable;
import kotlin.coroutines.CoroutineContext;
import org.jetbrains.annotations.NotNull;

final class ContextCallable<V>
implements Callable<V> {
    @NotNull
    private final CoroutineContext myParentContext = ThreadContext.currentThreadContext();
    @NotNull
    private final Callable<? extends V> myCallable;

    ContextCallable(@NotNull Callable<? extends V> callable) {
        this.myCallable = callable;
    }

    @Override
    public V call() throws Exception {
        ThreadContext.checkUninitializedThreadContext();
        try (AccessToken ignored = ThreadContext.replaceThreadContext(this.myParentContext);){
            V v = this.myCallable.call();
            return v;
        }
    }
}

