/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.analytics;

import com.intellij.analytics.NullAndroidStudioAnalytics;
import com.intellij.openapi.editor.Document;
import com.intellij.util.PlatformUtils;
import java.awt.GraphicsEnvironment;
import org.jetbrains.annotations.NotNull;

public abstract class AndroidStudioAnalytics {
    static AndroidStudioAnalytics INSTANCE;

    public static void initialize(AndroidStudioAnalytics analytics) {
        INSTANCE = analytics;
    }

    public static AndroidStudioAnalytics getInstance() {
        if (INSTANCE == null) {
            if (PlatformUtils.isAndroidStudio() && !GraphicsEnvironment.isHeadless()) {
                throw new RuntimeException("call to AndroidStudioAnalytics before initialization");
            }
            AndroidStudioAnalytics.initialize(new NullAndroidStudioAnalytics());
        }
        return INSTANCE;
    }

    public abstract void recordHighlightingLatency(Document var1, long var2);

    public abstract void logUpdateDialogOpenManually(@NotNull String var1);

    public abstract void logNotificationShown(@NotNull String var1);

    public abstract void logClickNotification(@NotNull String var1);

    public abstract void logUpdateDialogOpenFromNotification(@NotNull String var1);

    public abstract void logClickIgnore(String var1);

    public abstract void logClickLater(String var1);

    public abstract void logDownloadSuccess(String var1);

    public abstract void logDownloadFailure(String var1);

    public abstract void updateAndroidStudioMetrics();

    public abstract void initializeAndroidStudioUsageTrackerAndPublisher();

    public abstract boolean isAllowed();
}

