/*
 * Decompiled with CFR 0.152.
 */
package com.intellij;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.text.OrdinalFormat;
import java.lang.reflect.Field;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@ApiStatus.NonExtendable
public abstract class BundleBase {
    public static final char MNEMONIC = '\u001b';
    @NlsSafe
    public static final String MNEMONIC_STRING = Character.toString('\u001b');
    public static final boolean SHOW_LOCALIZED_MESSAGES = Boolean.getBoolean("idea.l10n");
    public static final boolean SHOW_DEFAULT_MESSAGES = Boolean.getBoolean("idea.l10n.english");
    public static final boolean SHOW_KEYS = Boolean.getBoolean("idea.l10n.keys");
    static final String L10N_MARKER = "\ud83d\udd05";
    private static final Logger LOG = Logger.getInstance(BundleBase.class);
    private static boolean assertOnMissedKeys;
    private static final String[] SUFFIXES;
    private static volatile BiConsumer<? super String, ? super String> ourTranslationConsumer;

    public static void assertOnMissedKeys(boolean doAssert) {
        assertOnMissedKeys = doAssert;
    }

    @Nls
    public static String partialMessage(@NotNull ResourceBundle bundle, @NotNull String key, int unassignedParams, Object ... params) {
        if (unassignedParams <= 0) {
            throw new IllegalArgumentException();
        }
        Object[] newParams = Arrays.copyOf(params, params.length + unassignedParams);
        String prefix = "#$$$TemplateParameter$$$#";
        String suffix = "#$$$/TemplateParameter$$$#";
        for (int i = 0; i < unassignedParams; ++i) {
            newParams[i + params.length] = prefix + i + suffix;
        }
        String message = BundleBase.message(bundle, key, newParams);
        return BundleBase.quotePattern(message).replace(prefix, "{").replace(suffix, "}");
    }

    @NlsSafe
    private static String quotePattern(String message) {
        boolean inQuotes = false;
        StringBuilder sb = new StringBuilder(message.length() + 5);
        for (int i = 0; i < message.length(); ++i) {
            boolean needToQuote;
            char c = message.charAt(i);
            boolean bl = needToQuote = c == '{' || c == '}';
            if (needToQuote != inQuotes) {
                inQuotes = needToQuote;
                sb.append('\'');
            }
            if (c == '\'') {
                sb.append("''");
                continue;
            }
            sb.append(c);
        }
        if (inQuotes) {
            sb.append('\'');
        }
        return sb.toString();
    }

    @Nls
    @NotNull
    public static String message(@NotNull ResourceBundle bundle, @NotNull String key, Object ... params) {
        return BundleBase.messageOrDefault(bundle, key, null, params);
    }

    @Nls
    public static String messageOrDefault(@Nullable ResourceBundle bundle, @NotNull String key, @Nullable @Nls String defaultValue, Object ... params) {
        String value;
        if (bundle == null) {
            return defaultValue;
        }
        boolean resourceFound = true;
        try {
            value = bundle.getString(key);
        }
        catch (MissingResourceException e) {
            resourceFound = false;
            value = BundleBase.useDefaultValue(bundle, key, defaultValue);
        }
        String result = BundleBase.postprocessValue(bundle, value, params);
        BiConsumer<? super String, ? super String> consumer = ourTranslationConsumer;
        if (consumer != null) {
            consumer.accept(key, result);
        }
        if (!resourceFound) {
            return result;
        }
        if (SHOW_KEYS && SHOW_DEFAULT_MESSAGES) {
            return BundleBase.appendLocalizationSuffix(result, " (" + key + "=" + BundleBase.getDefaultMessage(bundle, key) + ")");
        }
        if (SHOW_KEYS) {
            return BundleBase.appendLocalizationSuffix(result, " (" + key + ")");
        }
        if (SHOW_DEFAULT_MESSAGES) {
            return BundleBase.appendLocalizationSuffix(result, " (" + BundleBase.getDefaultMessage(bundle, key) + ")");
        }
        if (SHOW_LOCALIZED_MESSAGES) {
            return BundleBase.appendLocalizationSuffix(result, L10N_MARKER);
        }
        return result;
    }

    @NotNull
    public static String getDefaultMessage(@NotNull ResourceBundle bundle, @NotNull String key) {
        try {
            Object parentBundle;
            Field parent = ReflectionUtil.getDeclaredField(ResourceBundle.class, "parent");
            if (parent != null && (parentBundle = parent.get(bundle)) instanceof ResourceBundle) {
                return ((ResourceBundle)parentBundle).getString(key);
            }
        }
        catch (IllegalAccessException e) {
            LOG.warn("Cannot fetch default message with 'idea.l10n.english' enabled, by key '" + key + "'");
        }
        return "undefined";
    }

    @NlsSafe
    @NotNull
    protected static String appendLocalizationSuffix(@NotNull String result, @NotNull String suffixToAppend) {
        for (String suffix : SUFFIXES) {
            if (!result.endsWith(suffix)) continue;
            return result.substring(0, result.length() - suffix.length()) + L10N_MARKER + suffix;
        }
        return result + suffixToAppend;
    }

    @Nls
    @NotNull
    static String useDefaultValue(@Nullable ResourceBundle bundle, @NotNull String key, @Nullable @Nls String defaultValue) {
        if (defaultValue != null) {
            return defaultValue;
        }
        if (assertOnMissedKeys) {
            String bundleName = bundle != null ? "(" + bundle.getBaseBundleName() + ")" : "";
            LOG.error("'" + key + "' is not found in " + bundle + bundleName);
        }
        return "!" + key + "!";
    }

    @Nls
    @NotNull
    static String postprocessValue(@NotNull ResourceBundle bundle, @NotNull @Nls String value, Object ... params) {
        value = BundleBase.replaceMnemonicAmpersand(value);
        if (params.length > 0 && value.indexOf(123) >= 0) {
            Locale locale = bundle.getLocale();
            try {
                MessageFormat format = locale != null ? new MessageFormat(value, locale) : new MessageFormat(value);
                OrdinalFormat.apply((MessageFormat)format);
                value = format.format(params);
            }
            catch (IllegalArgumentException e) {
                value = "!invalid format: `" + value + "`!";
            }
        }
        return value;
    }

    @Contract(pure=true)
    @NotNull
    public static String format(@NotNull String value, Object ... params) {
        return params.length > 0 && value.indexOf(123) >= 0 ? MessageFormat.format(value, params) : value;
    }

    @Contract(value="null -> null; !null -> !null")
    @Nls
    public static String replaceMnemonicAmpersand(@Nullable @Nls String value) {
        if (value == null || value.indexOf(38) < 0 || value.indexOf(27) >= 0) {
            return value;
        }
        StringBuilder builder = new StringBuilder();
        boolean macMnemonic = value.contains("&&");
        boolean mnemonicAdded = false;
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c == '\\') {
                if (i < value.length() - 1 && value.charAt(i + 1) == '&') {
                    builder.append('&');
                    ++i;
                    continue;
                }
                builder.append(c);
                continue;
            }
            if (c == '&') {
                if (i < value.length() - 1 && value.charAt(i + 1) == '&') {
                    if (SystemInfoRt.isMac && !mnemonicAdded) {
                        mnemonicAdded = true;
                        builder.append('\u001b');
                    }
                    ++i;
                    continue;
                }
                if (SystemInfoRt.isMac && macMnemonic || mnemonicAdded) continue;
                mnemonicAdded = true;
                builder.append('\u001b');
                continue;
            }
            builder.append(c);
        }
        @NlsSafe String result = builder.toString();
        return result;
    }

    @TestOnly
    public static void setTranslationConsumer(@Nullable BiConsumer<? super String, ? super String> consumer) {
        ourTranslationConsumer = consumer;
    }

    static {
        SUFFIXES = new String[]{"</body></html>", "</html>"};
    }
}

