/*
 * Decompiled with CFR 0.152.
 */
package com.intellij;

import com.intellij.BundleBase;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.reference.SoftReference;
import com.intellij.util.DefaultBundleService;
import com.intellij.util.lang.UrlClassLoader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.ref.Reference;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.function.Supplier;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AbstractBundle {
    private static final Logger LOG = Logger.getInstance(AbstractBundle.class);
    private Reference<ResourceBundle> myBundle;
    private Reference<ResourceBundle> myDefaultBundle;
    @NotNull
    private final ClassLoader myBundleClassLoader;
    @NonNls
    private final String myPathToBundle;

    public AbstractBundle(@NotNull Class<?> bundleClass, @NonNls @NotNull String pathToBundle) {
        this.myPathToBundle = pathToBundle;
        this.myBundleClassLoader = bundleClass.getClassLoader();
    }

    public AbstractBundle(@NonNls @NotNull String pathToBundle) {
        this.myPathToBundle = pathToBundle;
        this.myBundleClassLoader = this.getClass().getClassLoader();
    }

    @ApiStatus.Internal
    @NotNull
    protected final ClassLoader getBundleClassLoader() {
        return this.myBundleClassLoader;
    }

    @ApiStatus.Internal
    @NotNull
    public static ResourceBundle.Control getControl() {
        return MyResourceControl.INSTANCE;
    }

    @Contract(pure=true)
    @NotNull
    @Nls
    public String getMessage(@NotNull @NonNls String key, Object ... params) {
        return BundleBase.messageOrDefault(this.getResourceBundle(), key, null, params);
    }

    @Contract(pure=true)
    @NotNull
    @Nls
    public String getPartialMessage(@NotNull @NonNls String key, int unassignedParams, Object ... params) {
        return BundleBase.partialMessage(this.getResourceBundle(), key, unassignedParams, params);
    }

    public @NotNull Supplier<@Nls String> getLazyMessage(@NotNull @NonNls String key, Object ... params) {
        return () -> this.getMessage(key, params);
    }

    @Nullable
    @Nls
    public String messageOrNull(@NotNull @NonNls String key, Object ... params) {
        return AbstractBundle.messageOrNull(this.getResourceBundle(), key, params);
    }

    @Nls
    public String messageOrDefault(@NotNull @NonNls String key, @Nullable @Nls String defaultValue, Object ... params) {
        return AbstractBundle.messageOrDefault(this.getResourceBundle(), key, defaultValue, params);
    }

    @Contract(value="null, _, _, _ -> param3")
    @Nls
    public static String messageOrDefault(@Nullable ResourceBundle bundle, @NotNull @NonNls String key, @Nullable @Nls String defaultValue, Object ... params) {
        if (bundle == null) {
            return defaultValue;
        }
        if (!bundle.containsKey(key)) {
            return BundleBase.postprocessValue(bundle, BundleBase.useDefaultValue(bundle, key, defaultValue), params);
        }
        return BundleBase.messageOrDefault(bundle, key, defaultValue, params);
    }

    @Nls
    @NotNull
    public static String message(@NotNull ResourceBundle bundle, @NotNull @NonNls String key, Object ... params) {
        return BundleBase.messageOrDefault(bundle, key, null, params);
    }

    @Nullable
    @Nls
    public static String messageOrNull(@NotNull ResourceBundle bundle, @NotNull @NonNls String key, Object ... params) {
        String value = AbstractBundle.messageOrDefault(bundle, key, key, params);
        return key.equals(value) ? null : value;
    }

    public boolean containsKey(@NotNull @NonNls String key) {
        return this.getResourceBundle().containsKey(key);
    }

    public ResourceBundle getResourceBundle() {
        return this.getResourceBundle(this.myBundleClassLoader);
    }

    @ApiStatus.Internal
    @NotNull
    public final ResourceBundle getResourceBundle(@NotNull ClassLoader classLoader) {
        boolean isDefault = DefaultBundleService.isDefaultBundle();
        ResourceBundle bundle = SoftReference.dereference(isDefault ? this.myDefaultBundle : this.myBundle);
        if (bundle == null) {
            bundle = this.resolveResourceBundle(this.myPathToBundle, classLoader);
            java.lang.ref.SoftReference<ResourceBundle> ref = new java.lang.ref.SoftReference<ResourceBundle>(bundle);
            if (isDefault) {
                this.myDefaultBundle = ref;
            } else {
                this.myBundle = ref;
            }
        }
        return bundle;
    }

    @NotNull
    private ResourceBundle resolveResourceBundle(@NotNull String pathToBundle, @NotNull ClassLoader loader) {
        return AbstractBundle.resolveResourceBundleWithFallback(() -> this.findBundle(pathToBundle, loader, MyResourceControl.INSTANCE), loader, pathToBundle);
    }

    @ApiStatus.Internal
    @NotNull
    protected static ResourceBundle resolveResourceBundleWithFallback(@NotNull @NotNull Supplier<? extends @NotNull ResourceBundle> firstTry, @NotNull ClassLoader loader, @NotNull String pathToBundle) {
        try {
            return firstTry.get();
        }
        catch (MissingResourceException e) {
            LOG.info("Cannot load resource bundle from *.properties file, falling back to slow class loading: " + pathToBundle);
            ResourceBundle.clearCache(loader);
            return ResourceBundle.getBundle(pathToBundle, Locale.getDefault(), loader);
        }
    }

    @NotNull
    protected ResourceBundle findBundle(@NotNull @NonNls String pathToBundle, @NotNull ClassLoader loader, @NotNull ResourceBundle.Control control) {
        return ResourceBundle.getBundle(pathToBundle, Locale.getDefault(), loader, control);
    }

    public void clearLocaleCache() {
        if (this.myBundle != null) {
            this.myBundle.clear();
        }
    }

    @ApiStatus.Internal
    @NotNull
    protected static ResourceBundle resolveBundle(@NotNull ClassLoader loader, @NonNls @NotNull String pathToBundle) {
        return ResourceBundle.getBundle(pathToBundle, Locale.getDefault(), loader, MyResourceControl.INSTANCE);
    }

    private static final class MyResourceControl
    extends ResourceBundle.Control {
        static final MyResourceControl INSTANCE = new MyResourceControl();

        private MyResourceControl() {
        }

        @Override
        public List<String> getFormats(String baseName) {
            return FORMAT_PROPERTIES;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ResourceBundle newBundle(String baseName, Locale locale, String format, ClassLoader loader, boolean reload) throws IOException {
            String resourceName;
            String bundleName = this.toBundleName(baseName, locale);
            String string2 = resourceName = bundleName.contains("://") ? null : this.toResourceName(bundleName, "properties");
            if (resourceName == null) {
                return null;
            }
            if (loader instanceof UrlClassLoader) {
                byte[] data = ((UrlClassLoader)loader).getResourceAsBytes(resourceName, true);
                if (data == null) {
                    return null;
                }
                return new PropertyResourceBundle(new InputStreamReader((InputStream)new ByteArrayInputStream(data), StandardCharsets.UTF_8));
            }
            InputStream stream = loader.getResourceAsStream(resourceName);
            if (stream == null) {
                return null;
            }
            try {
                PropertyResourceBundle propertyResourceBundle = new PropertyResourceBundle(new InputStreamReader(stream, StandardCharsets.UTF_8));
                return propertyResourceBundle;
            }
            finally {
                stream.close();
            }
        }
    }
}

