/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.compose.debug;

import com.intellij.debugger.MultiRequestPositionManager;
import com.intellij.debugger.NoDataException;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.PositionManagerWithMultipleStackFrames;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.jdi.VirtualMachineProxy;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.requests.ClassPrepareRequestor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.PsiFile;
import com.intellij.util.ThreeState;
import com.intellij.xdebugger.frame.XStackFrame;
import com.sun.jdi.Location;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.request.ClassPrepareRequest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fileClasses.JvmFileClassInfo;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtil;
import org.jetbrains.kotlin.idea.core.KotlinFileTypeFactoryUtils;
import org.jetbrains.kotlin.idea.debugger.KotlinPositionManager;
import org.jetbrains.kotlin.load.kotlin.PackagePartClassUtils;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u001a\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u001e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\r0\u00132\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J&\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u00132\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0003\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J(\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020\tH\u0016J\u000e\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!H\u0016J\u0016\u0010#\u001a\b\u0012\u0004\u0012\u00020$0\u00132\u0006\u0010%\u001a\u00020\u0011H\u0016J!\u0010&\u001a\t\u0018\u00010\u0011\u00a2\u0006\u0002\b'2\u000f\b\u0001\u0010(\u001a\t\u0018\u00010\u001a\u00a2\u0006\u0002\b'H\u0097\u0001JS\u0010)\u001a.\u0012\f\u0012\n +*\u0004\u0018\u00010\u001a0\u001a +*\u0015\u0012\f\u0012\n +*\u0004\u0018\u00010\u001a0\u001a0\u0013\u00a2\u0006\u0002\b,0*\u00a2\u0006\u0002\b,2\r\b\u0001\u0010(\u001a\u00070$\u00a2\u0006\u0002\b,2\r\b\u0001\u0010-\u001a\u00070\u0011\u00a2\u0006\u0002\b,H\u0097\u0001R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lcom/android/tools/compose/debug/ComposePositionManager;", "Lcom/intellij/debugger/MultiRequestPositionManager;", "Lcom/intellij/debugger/engine/PositionManagerWithMultipleStackFrames;", "debugProcess", "Lcom/intellij/debugger/engine/DebugProcess;", "kotlinPositionManager", "Lorg/jetbrains/kotlin/idea/debugger/KotlinPositionManager;", "(Lcom/intellij/debugger/engine/DebugProcess;Lorg/jetbrains/kotlin/idea/debugger/KotlinPositionManager;)V", "computeComposableSingletonsClassName", "", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "createPrepareRequest", "Lcom/sun/jdi/request/ClassPrepareRequest;", "requestor", "Lcom/intellij/debugger/requests/ClassPrepareRequestor;", "position", "Lcom/intellij/debugger/SourcePosition;", "createPrepareRequests", "", "createStackFrames", "Lcom/intellij/xdebugger/frame/XStackFrame;", "frame", "Lcom/intellij/debugger/jdi/StackFrameProxyImpl;", "Lcom/intellij/debugger/engine/DebugProcessImpl;", "location", "Lcom/sun/jdi/Location;", "evaluateCondition", "Lcom/intellij/util/ThreeState;", "context", "Lcom/intellij/debugger/engine/evaluation/EvaluationContext;", "expression", "getAcceptedFileTypes", "", "Lcom/intellij/openapi/fileTypes/FileType;", "getAllClasses", "Lcom/sun/jdi/ReferenceType;", "classPosition", "getSourcePosition", "Lorg/jetbrains/annotations/Nullable;", "p0", "locationsOfLine", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "p1", "intellij.android.compose-ide-plugin"})
public final class ComposePositionManager
implements MultiRequestPositionManager,
PositionManagerWithMultipleStackFrames {
    @NotNull
    private final DebugProcess debugProcess;
    @NotNull
    private final KotlinPositionManager kotlinPositionManager;

    public ComposePositionManager(@NotNull DebugProcess debugProcess, @NotNull KotlinPositionManager kotlinPositionManager) {
        Intrinsics.checkNotNullParameter((Object)debugProcess, (String)"debugProcess");
        Intrinsics.checkNotNullParameter((Object)kotlinPositionManager, (String)"kotlinPositionManager");
        this.debugProcess = debugProcess;
        this.kotlinPositionManager = kotlinPositionManager;
    }

    @Nullable
    public SourcePosition getSourcePosition(@Nullable Location p0) {
        return this.kotlinPositionManager.getSourcePosition(p0);
    }

    @NotNull
    public List<Location> locationsOfLine(@NotNull ReferenceType p0, @NotNull SourcePosition p1) {
        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
        Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
        return this.kotlinPositionManager.locationsOfLine(p0, p1);
    }

    @NotNull
    public Set<FileType> getAcceptedFileTypes() {
        Set set = KotlinFileTypeFactoryUtils.KOTLIN_FILE_TYPES_SET;
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"KOTLIN_FILE_TYPES_SET");
        return set;
    }

    @NotNull
    public List<XStackFrame> createStackFrames(@NotNull StackFrameProxyImpl frame, @NotNull DebugProcessImpl debugProcess, @NotNull Location location) {
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        Intrinsics.checkNotNullParameter((Object)debugProcess, (String)"debugProcess");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        return this.kotlinPositionManager.createStackFrames(frame, debugProcess, location);
    }

    @NotNull
    public ThreeState evaluateCondition(@NotNull EvaluationContext context, @NotNull StackFrameProxyImpl frame, @NotNull Location location, @NotNull String expression) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        return this.kotlinPositionManager.evaluateCondition(context, frame, location, expression);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<ReferenceType> getAllClasses(@NotNull SourcePosition classPosition) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)classPosition, (String)"classPosition");
        PsiFile psiFile = classPosition.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"classPosition.file");
        PsiFile file = psiFile;
        if (!(file instanceof KtFile)) {
            NoDataException noDataException = NoDataException.INSTANCE;
            Intrinsics.checkNotNullExpressionValue((Object)noDataException, (String)"INSTANCE");
            throw (Throwable)noDataException;
        }
        VirtualMachineProxy vm = this.debugProcess.getVirtualMachineProxy();
        List list = vm.classesByName(this.computeComposableSingletonsClassName((KtFile)file));
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"vm.classesByName(compute\u2026ingletonsClassName(file))");
        Iterable $this$flatMap$iv = list;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            ReferenceType referenceType = (ReferenceType)element$iv$iv;
            boolean bl = false;
            List list2 = referenceType.isPrepared() ? vm.nestedTypes(referenceType) : CollectionsKt.emptyList();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"if (referenceType.isPrep\u2026erenceType) else listOf()");
            Iterable list$iv$iv = list2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List singletonClasses = (List)destination$iv$iv;
        if (singletonClasses.isEmpty()) {
            NoDataException noDataException = NoDataException.INSTANCE;
            Intrinsics.checkNotNullExpressionValue((Object)noDataException, (String)"INSTANCE");
            throw (Throwable)noDataException;
        }
        List kotlinReferences = this.kotlinPositionManager.getAllClasses(classPosition);
        return CollectionsKt.plus((Collection)kotlinReferences, (Iterable)singletonClasses);
    }

    @NotNull
    public List<ClassPrepareRequest> createPrepareRequests(@NotNull ClassPrepareRequestor requestor, @NotNull SourcePosition position) {
        Intrinsics.checkNotNullParameter((Object)requestor, (String)"requestor");
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        PsiFile psiFile = position.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"position.file");
        PsiFile file = psiFile;
        if (!(file instanceof KtFile)) {
            NoDataException noDataException = NoDataException.INSTANCE;
            Intrinsics.checkNotNullExpressionValue((Object)noDataException, (String)"INSTANCE");
            throw (Throwable)noDataException;
        }
        List kotlinRequests = this.kotlinPositionManager.createPrepareRequests(requestor, position);
        ClassPrepareRequest singletonRequest = this.debugProcess.getRequestsManager().createClassPrepareRequest(requestor, this.computeComposableSingletonsClassName((KtFile)file) + "$*");
        return singletonRequest == null ? kotlinRequests : CollectionsKt.plus((Collection)kotlinRequests, (Object)singletonRequest);
    }

    @Nullable
    public ClassPrepareRequest createPrepareRequest(@NotNull ClassPrepareRequestor requestor, @NotNull SourcePosition position) {
        Intrinsics.checkNotNullParameter((Object)requestor, (String)"requestor");
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        return (ClassPrepareRequest)CollectionsKt.firstOrNull(this.createPrepareRequests(requestor, position));
    }

    private final String computeComposableSingletonsClassName(KtFile file) {
        Object object = file.getVirtualFile();
        if (object == null || (object = object.getPath()) == null) {
            object = file.getName();
        }
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"file.virtualFile?.path ?: file.name");
        Object filePath = object;
        char[] cArray = new char[]{'/'};
        String fileName = (String)CollectionsKt.last((List)StringsKt.split$default((CharSequence)((CharSequence)filePath), (char[])cArray, (boolean)false, (int)0, (int)6, null));
        String shortName = PackagePartClassUtils.getFilePartShortName((String)fileName);
        boolean $i$f$runReadAction = false;
        FqName fileClassFqName = ((JvmFileClassInfo)ApplicationManager.getApplication().runReadAction(new Computable(file){
            final /* synthetic */ KtFile $file$inlined;
            {
                this.$file$inlined = ktFile;
            }

            public final T compute() {
                boolean bl = false;
                return (T)JvmFileClassUtil.getFileClassInfoNoResolve((KtFile)this.$file$inlined);
            }
        })).getFacadeClassFqName();
        return fileClassFqName.parent().asString() + ".ComposableSingletons$" + shortName;
    }
}

