/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.compose;

import com.android.tools.compose.ColorIconRenderer;
import com.android.tools.compose.ComposeColorAnnotatorKt;
import com.android.tools.compose.ComposeColorConstructor;
import com.android.tools.idea.projectsystem.AndroidModuleSystem;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import java.awt.Color;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtCallElement;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UastCallKind;
import org.jetbrains.uast.UastContextKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006\r"}, d2={"Lcom/android/tools/compose/ComposeColorAnnotator;", "Lcom/intellij/lang/annotation/Annotator;", "()V", "annotate", "", "element", "Lcom/intellij/psi/PsiElement;", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "getColor", "Ljava/awt/Color;", "uElement", "Lorg/jetbrains/uast/UElement;", "intellij.android.compose-ide-plugin"})
public final class ComposeColorAnnotator
implements Annotator {
    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        AndroidModuleSystem androidModuleSystem = ProjectSystemUtil.getModuleSystem((PsiElement)element);
        if (!(androidModuleSystem != null ? androidModuleSystem.getUsesCompose() : false)) {
            return;
        }
        if (element instanceof KtCallElement) {
            UCallExpression uCallExpression = (UCallExpression)UastContextKt.toUElement((PsiElement)element, UCallExpression.class);
            if (uCallExpression == null) {
                return;
            }
            UCallExpression uElement = uCallExpression;
            PsiType psiType = uElement.getReturnType();
            if (psiType == null) {
                return;
            }
            PsiType returnType = psiType;
            if (!(Intrinsics.areEqual((Object)uElement.getKind(), (Object)UastCallKind.METHOD_CALL) && Intrinsics.areEqual((Object)returnType, (Object)PsiType.LONG) && Intrinsics.areEqual((Object)"Color", (Object)uElement.getMethodName()))) {
                return;
            }
            Object object = uElement.resolve();
            if (object == null || (object = object.getContainingClass()) == null || (object = object.getQualifiedName()) == null) {
                return;
            }
            Object fqName = object;
            if (Intrinsics.areEqual((Object)fqName, (Object)"androidx.compose.ui.graphics.ColorKt")) {
                Color color = this.getColor((UElement)uElement);
                if (color == null) {
                    return;
                }
                Color color2 = color;
                holder.newSilentAnnotation(HighlightSeverity.INFORMATION).gutterIconRenderer((GutterIconRenderer)new ColorIconRenderer(uElement, color2)).create();
            }
        }
    }

    private final Color getColor(UElement uElement) {
        Color color;
        UCallExpression uCallExpression = uElement instanceof UCallExpression ? (UCallExpression)uElement : null;
        if (uCallExpression == null) {
            return null;
        }
        UCallExpression callElement = uCallExpression;
        PsiElement psiElement = uElement.getSourcePsi();
        Object object = psiElement instanceof KtCallExpression ? (KtCallExpression)psiElement : null;
        if (object == null || (object = object.getValueArguments()) == null) {
            return null;
        }
        Object arguments = object;
        ComposeColorConstructor composeColorConstructor = ComposeColorAnnotatorKt.access$getConstructorType(callElement.getValueArguments());
        switch (composeColorConstructor == null ? -1 : WhenMappings.$EnumSwitchMapping$0[composeColorConstructor.ordinal()]) {
            case 1: {
                color = ComposeColorAnnotatorKt.access$getColorInt((List)arguments);
                break;
            }
            case 2: {
                color = ComposeColorAnnotatorKt.access$getColorLong((List)arguments);
                break;
            }
            case 3: {
                color = ComposeColorAnnotatorKt.access$getColorIntX3((List)arguments);
                break;
            }
            case 4: {
                color = ComposeColorAnnotatorKt.access$getColorIntX4((List)arguments);
                break;
            }
            case 5: {
                color = ComposeColorAnnotatorKt.access$getColorFloatX3((List)arguments);
                break;
            }
            case 6: {
                color = ComposeColorAnnotatorKt.access$getColorFloatX4((List)arguments);
                break;
            }
            case 7: {
                color = null;
                break;
            }
            default: {
                color = null;
            }
        }
        return color;
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ComposeColorConstructor.values().length];
            nArray[ComposeColorConstructor.INT.ordinal()] = 1;
            nArray[ComposeColorConstructor.LONG.ordinal()] = 2;
            nArray[ComposeColorConstructor.INT_X3.ordinal()] = 3;
            nArray[ComposeColorConstructor.INT_X4.ordinal()] = 4;
            nArray[ComposeColorConstructor.FLOAT_X3.ordinal()] = 5;
            nArray[ComposeColorConstructor.FLOAT_X4.ordinal()] = 6;
            nArray[ComposeColorConstructor.FLOAT_X4_COLORSPACE.ordinal()] = 7;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

