/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.compose;

import com.android.tools.compose.ComposeFqNamesKt;
import com.android.tools.compose.ComposeWritableSlices;
import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotated;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.descriptors.impl.LocalVariableDescriptor;
import org.jetbrains.kotlin.js.resolve.diagnostics.SourceLocationUtilsKt;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMapping;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMatch;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.VariableAsFunctionResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.util.OperatorNameConventions;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u001a\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u001a\u001a\u0010\u0006\u001a\u00020\u0007*\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u001a\u0014\u0010\n\u001a\u00020\u0007*\u00020\u000b2\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u001a\u0010\u0010\f\u001a\u00020\u0007*\u0006\u0012\u0002\b\u00030\rH\u0000\u001a\f\u0010\u000e\u001a\u00020\u0007*\u00020\u000bH\u0000\u001a\u000e\u0010\u000f\u001a\u00020\u0007*\u0006\u0012\u0002\b\u00030\r\u00a8\u0006\u0010"}, d2={"getArgumentDescriptor", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "argument", "Lorg/jetbrains/kotlin/psi/KtFunction;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "hasComposableAnnotation", "", "", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "isComposableCallable", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "isComposableInvocation", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "isMarkedAsComposable", "isReadOnlyComposableInvocation", "intellij.android.compose-ide-plugin"})
public final class ComposableCallCheckerKt {
    public static final boolean isReadOnlyComposableInvocation(@NotNull ResolvedCall<?> $this$isReadOnlyComposableInvocation) {
        boolean bl;
        Intrinsics.checkNotNullParameter($this$isReadOnlyComposableInvocation, (String)"<this>");
        if ($this$isReadOnlyComposableInvocation instanceof VariableAsFunctionResolvedCall) {
            return false;
        }
        CallableDescriptor candidateDescriptor = $this$isReadOnlyComposableInvocation.getCandidateDescriptor();
        CallableDescriptor callableDescriptor = candidateDescriptor;
        if (callableDescriptor instanceof ValueParameterDescriptor) {
            bl = false;
        } else if (callableDescriptor instanceof LocalVariableDescriptor) {
            bl = false;
        } else if (callableDescriptor instanceof PropertyDescriptor) {
            boolean isGetter = $this$isReadOnlyComposableInvocation.getValueArguments().isEmpty();
            PropertyGetterDescriptor getter = ((PropertyDescriptor)candidateDescriptor).getGetter();
            bl = isGetter && getter != null ? ComposeFqNamesKt.hasReadonlyComposableAnnotation((Annotated)getter) : false;
        } else if (callableDescriptor instanceof PropertyGetterDescriptor) {
            Intrinsics.checkNotNullExpressionValue((Object)candidateDescriptor, (String)"candidateDescriptor");
            bl = ComposeFqNamesKt.hasReadonlyComposableAnnotation((Annotated)candidateDescriptor);
        } else {
            Intrinsics.checkNotNullExpressionValue((Object)candidateDescriptor, (String)"candidateDescriptor");
            bl = ComposeFqNamesKt.hasReadonlyComposableAnnotation((Annotated)candidateDescriptor);
        }
        return bl;
    }

    public static final boolean isComposableInvocation(@NotNull ResolvedCall<?> $this$isComposableInvocation) {
        boolean bl;
        CallableDescriptor callableDescriptor;
        Intrinsics.checkNotNullParameter($this$isComposableInvocation, (String)"<this>");
        if ($this$isComposableInvocation instanceof VariableAsFunctionResolvedCall) {
            KotlinType kotlinType = ((VariableDescriptor)((VariableAsFunctionResolvedCall)$this$isComposableInvocation).getVariableCall().getCandidateDescriptor()).getType();
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"variableCall.candidateDescriptor.type");
            if (ComposeFqNamesKt.hasComposableAnnotation(kotlinType)) {
                return true;
            }
            CallableDescriptor callableDescriptor2 = ((VariableAsFunctionResolvedCall)$this$isComposableInvocation).getFunctionCall().getResultingDescriptor();
            Intrinsics.checkNotNullExpressionValue((Object)callableDescriptor2, (String)"functionCall.resultingDescriptor");
            return ComposeFqNamesKt.hasComposableAnnotation((Annotated)callableDescriptor2);
        }
        CallableDescriptor candidateDescriptor = $this$isComposableInvocation.getCandidateDescriptor();
        if (candidateDescriptor instanceof FunctionDescriptor && ((FunctionDescriptor)candidateDescriptor).isOperator() && Intrinsics.areEqual((Object)((FunctionDescriptor)candidateDescriptor).getName(), (Object)OperatorNameConventions.INVOKE)) {
            ReceiverValue receiverValue = $this$isComposableInvocation.getDispatchReceiver();
            boolean bl2 = receiverValue != null && (receiverValue = receiverValue.getType()) != null ? ComposeFqNamesKt.hasComposableAnnotation((KotlinType)receiverValue) : false;
            if (bl2) {
                return true;
            }
        }
        if ((callableDescriptor = candidateDescriptor) instanceof ValueParameterDescriptor) {
            bl = false;
        } else if (callableDescriptor instanceof LocalVariableDescriptor) {
            bl = false;
        } else if (callableDescriptor instanceof PropertyDescriptor) {
            boolean isGetter = $this$isComposableInvocation.getValueArguments().isEmpty();
            PropertyGetterDescriptor getter = ((PropertyDescriptor)candidateDescriptor).getGetter();
            bl = isGetter && getter != null ? ComposeFqNamesKt.hasComposableAnnotation((Annotated)getter) : false;
        } else if (callableDescriptor instanceof PropertyGetterDescriptor) {
            PropertyDescriptor propertyDescriptor = ((PropertyGetterDescriptor)candidateDescriptor).getCorrespondingProperty();
            Intrinsics.checkNotNullExpressionValue((Object)propertyDescriptor, (String)"candidateDescriptor.correspondingProperty");
            bl = ComposeFqNamesKt.hasComposableAnnotation((Annotated)propertyDescriptor);
        } else {
            Intrinsics.checkNotNullExpressionValue((Object)candidateDescriptor, (String)"candidateDescriptor");
            bl = ComposeFqNamesKt.hasComposableAnnotation((Annotated)candidateDescriptor);
        }
        return bl;
    }

    public static final boolean isMarkedAsComposable(@NotNull CallableDescriptor $this$isMarkedAsComposable) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$isMarkedAsComposable, (String)"<this>");
        CallableDescriptor callableDescriptor = $this$isMarkedAsComposable;
        if (callableDescriptor instanceof PropertyGetterDescriptor) {
            bl = ComposeFqNamesKt.hasComposableAnnotation((Annotated)$this$isMarkedAsComposable);
        } else if (callableDescriptor instanceof ValueParameterDescriptor) {
            KotlinType kotlinType = ((ValueParameterDescriptor)$this$isMarkedAsComposable).getType();
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"type");
            bl = ComposeFqNamesKt.hasComposableAnnotation(kotlinType);
        } else if (callableDescriptor instanceof LocalVariableDescriptor) {
            KotlinType kotlinType = ((LocalVariableDescriptor)$this$isMarkedAsComposable).getType();
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"type");
            bl = ComposeFqNamesKt.hasComposableAnnotation(kotlinType);
        } else {
            bl = callableDescriptor instanceof PropertyDescriptor ? false : ComposeFqNamesKt.hasComposableAnnotation((Annotated)$this$isMarkedAsComposable);
        }
        return bl;
    }

    public static final boolean isComposableCallable(@NotNull CallableDescriptor $this$isComposableCallable, @NotNull BindingContext bindingContext) {
        KtLambdaExpression lambdaExpr;
        Intrinsics.checkNotNullParameter((Object)$this$isComposableCallable, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)bindingContext, (String)"bindingContext");
        if (ComposableCallCheckerKt.isMarkedAsComposable($this$isComposableCallable)) {
            return true;
        }
        if ($this$isComposableCallable instanceof FunctionDescriptor && Intrinsics.areEqual((Object)bindingContext.get((ReadOnlySlice)ComposeWritableSlices.INSTANCE.getINFERRED_COMPOSABLE_DESCRIPTOR(), (Object)$this$isComposableCallable), (Object)true)) {
            return true;
        }
        PsiElement psiElement = SourceLocationUtilsKt.findPsi((DeclarationDescriptor)((DeclarationDescriptor)$this$isComposableCallable));
        KtFunctionLiteral ktFunctionLiteral = psiElement instanceof KtFunctionLiteral ? (KtFunctionLiteral)psiElement : null;
        if (ktFunctionLiteral == null) {
            return false;
        }
        KtFunctionLiteral functionLiteral = ktFunctionLiteral;
        List list = functionLiteral.getAnnotationEntries();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"functionLiteral.annotationEntries");
        if (ComposableCallCheckerKt.hasComposableAnnotation(list, bindingContext)) {
            return true;
        }
        psiElement = functionLiteral.getParent();
        KtLambdaExpression ktLambdaExpression = lambdaExpr = psiElement instanceof KtLambdaExpression ? (KtLambdaExpression)psiElement : null;
        if (lambdaExpr != null && Intrinsics.areEqual((Object)bindingContext.get((ReadOnlySlice)ComposeWritableSlices.INSTANCE.getINFERRED_COMPOSABLE_LITERAL(), (Object)lambdaExpr), (Object)true)) {
            return true;
        }
        ValueParameterDescriptor valueParameterDescriptor = ComposableCallCheckerKt.getArgumentDescriptor((KtFunction)functionLiteral, bindingContext);
        if (valueParameterDescriptor == null) {
            return false;
        }
        ValueParameterDescriptor arg = valueParameterDescriptor;
        KotlinType kotlinType = arg.getType();
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"arg.type");
        return ComposeFqNamesKt.hasComposableAnnotation(kotlinType);
    }

    @Nullable
    public static final ValueParameterDescriptor getArgumentDescriptor(@NotNull KtFunction argument, @NotNull BindingContext bindingContext) {
        Intrinsics.checkNotNullParameter((Object)argument, (String)"argument");
        Intrinsics.checkNotNullParameter((Object)bindingContext, (String)"bindingContext");
        KtExpression ktExpression = KtPsiUtil.getParentCallIfPresent((KtExpression)((KtExpression)argument));
        if (ktExpression == null) {
            return null;
        }
        KtExpression call = ktExpression;
        ResolvedCall resolvedCall = CallUtilKt.getResolvedCall((KtElement)((KtElement)call), (BindingContext)bindingContext);
        if (resolvedCall == null) {
            return null;
        }
        ResolvedCall resolvedCall2 = resolvedCall;
        Call call2 = resolvedCall2.getCall();
        Intrinsics.checkNotNullExpressionValue((Object)call2, (String)"resolvedCall.call");
        ValueArgument valueArgument = CallUtilKt.getValueArgumentForExpression((Call)call2, (KtExpression)((KtExpression)argument));
        if (valueArgument == null) {
            return null;
        }
        ValueArgument valueArgument2 = valueArgument;
        ArgumentMapping argumentMapping = resolvedCall2.getArgumentMapping(valueArgument2);
        ArgumentMatch argumentMatch = argumentMapping instanceof ArgumentMatch ? (ArgumentMatch)argumentMapping : null;
        if (argumentMatch == null) {
            return null;
        }
        ArgumentMatch mapping = argumentMatch;
        return mapping.getValueParameter();
    }

    public static final boolean hasComposableAnnotation(@NotNull List<? extends KtAnnotationEntry> $this$hasComposableAnnotation, @NotNull BindingContext bindingContext) {
        Intrinsics.checkNotNullParameter($this$hasComposableAnnotation, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)bindingContext, (String)"bindingContext");
        for (KtAnnotationEntry ktAnnotationEntry : $this$hasComposableAnnotation) {
            AnnotationDescriptor descriptor;
            if ((AnnotationDescriptor)bindingContext.get((ReadOnlySlice)BindingContext.ANNOTATION, (Object)ktAnnotationEntry) == null || !ComposeFqNamesKt.isComposableAnnotation(descriptor)) continue;
            return true;
        }
        return false;
    }
}

