/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.util;

import com.intellij.collaboration.hosting.GitHostingUrlUtil;
import com.intellij.openapi.util.NlsSafe;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.GHRepositoryPath;

public final class GithubUrlUtil {
    @NlsSafe
    @NotNull
    private static String removeTrailingSlash(@NotNull String s) {
        if (s.endsWith("/")) {
            return s.substring(0, s.length() - 1);
        }
        return s;
    }

    @Nullable
    public static GHRepositoryPath getUserAndRepositoryFromRemoteUrl(@NotNull String remoteUrl) {
        int index1 = (remoteUrl = GitHostingUrlUtil.removeProtocolPrefix((String)GithubUrlUtil.removeEndingDotGit(remoteUrl))).lastIndexOf(47);
        if (index1 == -1) {
            return null;
        }
        String url = remoteUrl.substring(0, index1);
        int index2 = Math.max(url.lastIndexOf(47), url.lastIndexOf(58));
        if (index2 == -1) {
            return null;
        }
        String username = remoteUrl.substring(index2 + 1, index1);
        String reponame = remoteUrl.substring(index1 + 1);
        if (username.isEmpty() || reponame.isEmpty()) {
            return null;
        }
        return new GHRepositoryPath(username, reponame);
    }

    @NlsSafe
    @NotNull
    private static String removeEndingDotGit(@NotNull String url) {
        url = GithubUrlUtil.removeTrailingSlash(url);
        String DOT_GIT = ".git";
        if (url.endsWith(".git")) {
            return url.substring(0, url.length() - ".git".length());
        }
        return url;
    }

    @Deprecated(forRemoval=true)
    @NotNull
    public static String getHostFromUrl(@NotNull String url) {
        String path = GitHostingUrlUtil.removeProtocolPrefix((String)url).replace(':', '/');
        int index = path.indexOf(47);
        if (index == -1) {
            return path;
        }
        return path.substring(0, index);
    }

    @Deprecated(forRemoval=true)
    @Nullable
    public static String makeGithubRepoUrlFromRemoteUrl(@NotNull String remoteUrl, @NotNull String host) {
        GHRepositoryPath repo = GithubUrlUtil.getUserAndRepositoryFromRemoteUrl(remoteUrl);
        if (repo == null) {
            return null;
        }
        return host + "/" + repo.getOwner() + "/" + repo.getRepository();
    }
}

