/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.util;

import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationListener;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DoNotAskOption;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.vcs.VcsNotifier;
import git4idea.i18n.GitBundle;
import java.util.function.Supplier;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.exceptions.GithubOperationCanceledException;
import org.jetbrains.plugins.github.util.GithubUtil;

public final class GithubNotifications {
    private static final Logger LOG = GithubUtil.LOG;

    private static boolean isOperationCanceled(@NotNull Throwable e) {
        return e instanceof GithubOperationCanceledException || e instanceof ProcessCanceledException;
    }

    public static void showInfo(@NotNull Project project, @NonNls @Nullable String displayId, @NlsContexts.NotificationTitle @NotNull String title, @NlsContexts.NotificationContent @NotNull String message) {
        LOG.info(title + "; " + message);
        VcsNotifier.getInstance((Project)project).notifyImportantInfo(displayId, title, message);
    }

    public static void showWarning(@NotNull Project project, @NonNls @Nullable String displayId, @NlsContexts.NotificationTitle @NotNull String title, @NlsContexts.NotificationContent @NotNull String message) {
        LOG.info(title + "; " + message);
        VcsNotifier.getInstance((Project)project).notifyImportantWarning(displayId, title, message);
    }

    public static void showError(@NotNull Project project, @NonNls @Nullable String displayId, @NlsContexts.NotificationTitle @NotNull String title, @NlsContexts.NotificationContent @NotNull String message) {
        LOG.info(title + "; " + message);
        VcsNotifier.getInstance((Project)project).notifyError(displayId, title, message);
    }

    public static void showError(@NotNull Project project, @NonNls @Nullable String displayId, @NlsContexts.NotificationTitle @NotNull String title, @NlsContexts.NotificationContent @NotNull String message, @NotNull String logDetails) {
        LOG.warn(title + "; " + message + "; " + logDetails);
        VcsNotifier.getInstance((Project)project).notifyError(displayId, title, message);
    }

    public static void showError(@NotNull Project project, @NonNls @Nullable String displayId, @NlsContexts.NotificationTitle @NotNull String title, @NotNull Throwable e) {
        LOG.warn(title + "; ", e);
        if (GithubNotifications.isOperationCanceled(e)) {
            return;
        }
        VcsNotifier.getInstance((Project)project).notifyError(displayId, title, GithubUtil.getErrorTextFromException(e));
    }

    public static void showInfoURL(@NotNull Project project, @NonNls @Nullable String displayId, @NlsContexts.NotificationTitle @NotNull String title, @NlsContexts.NotificationContent @NotNull String message, @NotNull String url) {
        LOG.info(title + "; " + message + "; " + url);
        VcsNotifier.getInstance((Project)project).notifyImportantInfo(displayId, title, HtmlChunk.link((String)url, (String)message).toString(), NotificationListener.URL_OPENING_LISTENER);
    }

    public static void showWarningURL(@NotNull Project project, @NonNls @Nullable String displayId, @NlsContexts.NotificationTitle @NotNull String title, @NotNull String prefix, @NotNull String highlight, @NotNull String postfix, @NotNull String url) {
        LOG.info(title + "; " + prefix + highlight + postfix + "; " + url);
        VcsNotifier.getInstance((Project)project).notifyImportantWarning(displayId, title, prefix + "<a href='" + url + "'>" + highlight + "</a>" + postfix, NotificationListener.URL_OPENING_LISTENER);
    }

    public static void showErrorURL(@NotNull Project project, @NonNls @Nullable String displayId, @NlsContexts.NotificationTitle @NotNull String title, @NotNull String prefix, @NotNull String highlight, @NotNull String postfix, @NotNull String url) {
        LOG.info(title + "; " + prefix + highlight + postfix + "; " + url);
        VcsNotifier.getInstance((Project)project).notifyError(displayId, title, prefix + "<a href='" + url + "'>" + highlight + "</a>" + postfix, NotificationListener.URL_OPENING_LISTENER);
    }

    public static void showWarningDialog(@Nullable Project project, @NlsContexts.NotificationTitle @NotNull String title, @NlsContexts.NotificationContent @NotNull String message) {
        LOG.info(title + "; " + message);
        Messages.showWarningDialog((Project)project, (String)message, (String)title);
    }

    public static void showErrorDialog(@Nullable Project project, @NlsContexts.NotificationTitle @NotNull String title, @NlsContexts.NotificationContent @NotNull String message) {
        LOG.info(title + "; " + message);
        Messages.showErrorDialog((Project)project, (String)message, (String)title);
    }

    @Messages.YesNoResult
    public static boolean showYesNoDialog(@Nullable Project project, @NlsContexts.NotificationTitle @NotNull String title, @NlsContexts.NotificationContent @NotNull String message) {
        return MessageDialogBuilder.yesNo((String)title, (String)message).ask(project);
    }

    @Messages.YesNoResult
    public static boolean showYesNoDialog(@Nullable Project project, @NlsContexts.NotificationTitle @NotNull String title, @NlsContexts.NotificationContent @NotNull String message, @NotNull DoNotAskOption doNotAskOption) {
        return ((MessageDialogBuilder.YesNo)((MessageDialogBuilder.YesNo)MessageDialogBuilder.yesNo((String)title, (String)message).icon(Messages.getQuestionIcon())).doNotAsk(doNotAskOption)).ask(project);
    }

    @NotNull
    public static AnAction getConfigureAction(@NotNull Project project) {
        return NotificationAction.createSimple((Supplier)GitBundle.messagePointer((String)"action.NotificationAction.GithubNotifications.text.configure", (Object[])new Object[0]), () -> ShowSettingsUtil.getInstance().showSettingsDialog(project, "GitHub"));
    }
}

