/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.util;

import com.intellij.diff.util.Range;
import com.intellij.diff.util.Side;
import com.intellij.openapi.diff.impl.patch.PatchHunk;
import com.intellij.openapi.diff.impl.patch.PatchLine;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.util.GHPatchHunkUtil$WhenMappings;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004J%\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\b\u00a2\u0006\u0002\u0010\u000eJ$\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\b\u0018\u00010\u00102\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\bJ\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u0015\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u0016\u001a\u00020\u00142\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/plugins/github/util/GHPatchHunkUtil;", "", "()V", "createPatchFromHunk", "", "filePath", "diffHunk", "findHunkLineIndexFromFileSideLineIndex", "", "hunk", "Lcom/intellij/openapi/diff/impl/patch/PatchHunk;", "side", "Lcom/intellij/diff/util/Side;", "fileLineIndex", "(Lcom/intellij/openapi/diff/impl/patch/PatchHunk;Lcom/intellij/diff/util/Side;I)Ljava/lang/Integer;", "findSideFileLineFromHunkLineIndex", "Lkotlin/Pair;", "hunkLineIndex", "getChangeOnlyRanges", "", "Lcom/intellij/diff/util/Range;", "getHunkLinesCount", "getRange", "intellij.vcs.github"})
public final class GHPatchHunkUtil {
    @NotNull
    public static final GHPatchHunkUtil INSTANCE;

    @NotNull
    public final Range getRange(@NotNull PatchHunk hunk) {
        int end1 = hunk.getStartLineBefore();
        int end2 = hunk.getStartLineAfter();
        for (PatchLine line : hunk.getLines()) {
            switch (GHPatchHunkUtil$WhenMappings.$EnumSwitchMapping$0[line.getType().ordinal()]) {
                case 1: {
                    ++end1;
                    break;
                }
                case 2: {
                    ++end2;
                    break;
                }
                case 3: {
                    ++end1;
                    ++end2;
                    break;
                }
            }
        }
        return new Range(hunk.getStartLineBefore(), end1, hunk.getStartLineAfter(), end2);
    }

    @NotNull
    public final List<Range> getChangeOnlyRanges(@NotNull PatchHunk hunk) {
        List ranges = new ArrayList();
        int start1 = hunk.getStartLineBefore();
        int start2 = hunk.getStartLineAfter();
        int end1 = hunk.getStartLineBefore();
        int end2 = hunk.getStartLineAfter();
        boolean changeFound = false;
        boolean newLine1 = false;
        boolean newLine2 = false;
        for (PatchLine line : hunk.getLines()) {
            switch (GHPatchHunkUtil$WhenMappings.$EnumSwitchMapping$1[line.getType().ordinal()]) {
                case 1: {
                    ++end1;
                    changeFound = true;
                    newLine1 = !line.isSuppressNewLine();
                    break;
                }
                case 2: {
                    ++end2;
                    changeFound = true;
                    newLine2 = !line.isSuppressNewLine();
                    break;
                }
                case 3: {
                    if (changeFound) {
                        ranges.add(new Range(start1, end1, start2, end2));
                        start1 = end1;
                        start2 = end2;
                    }
                    ++start1;
                    ++start2;
                    ++end1;
                    ++end2;
                    changeFound = false;
                    newLine1 = !line.isSuppressNewLine();
                    newLine2 = !line.isSuppressNewLine();
                }
            }
        }
        if (changeFound) {
            if (newLine1 != newLine2) {
                if (newLine1) {
                    ++end1;
                }
                if (newLine2) {
                    ++end2;
                }
            }
            ranges.add(new Range(start1, end1, start2, end2));
        }
        return ranges;
    }

    @NotNull
    public final String createPatchFromHunk(@NotNull String filePath, @NotNull String diffHunk) {
        return "--- a/" + filePath + "\n+++ b/" + filePath + "\n" + diffHunk;
    }

    @Nullable
    public final Integer findHunkLineIndexFromFileSideLineIndex(@NotNull PatchHunk hunk, @NotNull Side side, int fileLineIndex) {
        int sideFileLineIndex = fileLineIndex - side.select(hunk.getStartLineBefore(), hunk.getStartLineAfter());
        int sideFileLineCounter = 0;
        int hunkLineIndex = 1;
        Integer lastMatchedLineWithNewline = null;
        for (PatchLine line : hunk.getLines()) {
            if (line.getType() == PatchLine.Type.ADD && side == Side.RIGHT || line.getType() == PatchLine.Type.REMOVE && side == Side.LEFT || line.getType() == PatchLine.Type.CONTEXT) {
                if (sideFileLineCounter == sideFileLineIndex) {
                    return hunkLineIndex;
                }
                if (++sideFileLineCounter == sideFileLineIndex && !line.isSuppressNewLine()) {
                    lastMatchedLineWithNewline = hunkLineIndex;
                }
            }
            hunkLineIndex += line.isSuppressNewLine() ? 2 : 1;
        }
        return lastMatchedLineWithNewline;
    }

    @Nullable
    public final Pair<Side, Integer> findSideFileLineFromHunkLineIndex(@NotNull PatchHunk hunk, int hunkLineIndex) {
        int hunkLineIterator = 1;
        int lineNumberLeft = hunk.getStartLineBefore();
        int lineNumberRight = hunk.getStartLineAfter();
        for (PatchLine line : hunk.getLines()) {
            if (hunkLineIterator == hunkLineIndex) {
                Pair pair;
                switch (GHPatchHunkUtil$WhenMappings.$EnumSwitchMapping$2[line.getType().ordinal()]) {
                    case 1: {
                        pair = TuplesKt.to((Object)Side.LEFT, (Object)lineNumberLeft);
                        break;
                    }
                    case 2: 
                    case 3: {
                        pair = TuplesKt.to((Object)Side.RIGHT, (Object)lineNumberRight);
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                return pair;
            }
            switch (GHPatchHunkUtil$WhenMappings.$EnumSwitchMapping$3[line.getType().ordinal()]) {
                case 1: {
                    ++lineNumberLeft;
                    break;
                }
                case 2: {
                    ++lineNumberRight;
                    break;
                }
                case 3: {
                    ++lineNumberLeft;
                    ++lineNumberRight;
                }
            }
            if ((hunkLineIterator += !line.isSuppressNewLine() ? 1 : 2) <= hunkLineIndex) continue;
            return null;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public final int getHunkLinesCount(@NotNull PatchHunk hunk) {
        int n;
        void $this$count$iv;
        Iterable iterable = hunk.getLines();
        int n2 = hunk.getLines().size();
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                int n3;
                PatchLine it = (PatchLine)element$iv;
                boolean bl = false;
                if (!it.isSuppressNewLine() || (n3 = ++count$iv) >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        int n4 = n;
        return n2 + n4 + 1;
    }

    private GHPatchHunkUtil() {
    }

    static {
        GHPatchHunkUtil gHPatchHunkUtil;
        INSTANCE = gHPatchHunkUtil = new GHPatchHunkUtil();
    }
}

