/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.ui.component;

import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.ui.BrowserHyperlinkListener;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.util.ui.UIUtil;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.data.GithubErrorMessage;
import org.jetbrains.plugins.github.exceptions.GithubStatusCodeException;
import org.jetbrains.plugins.github.i18n.GithubBundle;
import org.jetbrains.plugins.github.ui.component.GHErrorPanelModel;
import org.jetbrains.plugins.github.ui.component.GHImmutableErrorPanelModel;
import org.jetbrains.plugins.github.ui.util.GHUIUtilKt;
import org.jetbrains.plugins.github.ui.util.HtmlEditorPane;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0011B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\b\u0002\u0010\f\u001a\u00020\rJ\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\f\u001a\u00020\rJ\u0010\u0010\u0010\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0003R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/plugins/github/ui/component/GHHtmlErrorPanel;", "", "()V", "ERROR_ACTION_HREF", "", "create", "Ljavax/swing/JComponent;", "errorPrefix", "error", "", "errorAction", "Ljavax/swing/Action;", "horizontalAlignment", "", "model", "Lorg/jetbrains/plugins/github/ui/component/GHErrorPanelModel;", "getLoadingErrorText", "Controller", "intellij.vcs.github"})
public final class GHHtmlErrorPanel {
    private static final String ERROR_ACTION_HREF = "ERROR_ACTION";
    @NotNull
    public static final GHHtmlErrorPanel INSTANCE;

    @NotNull
    public final JComponent create(@NotNull String errorPrefix, @NotNull Throwable error, @Nullable Action errorAction, int horizontalAlignment) {
        GHImmutableErrorPanelModel model2 = new GHImmutableErrorPanelModel(errorPrefix, error, errorAction);
        return this.create(model2, horizontalAlignment);
    }

    public static /* synthetic */ JComponent create$default(GHHtmlErrorPanel gHHtmlErrorPanel, String string, Throwable throwable, Action action2, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            action2 = null;
        }
        if ((n2 & 8) != 0) {
            n = 0;
        }
        return gHHtmlErrorPanel.create(string, throwable, action2, n);
    }

    @NotNull
    public final JComponent create(@NotNull GHErrorPanelModel model2, int horizontalAlignment) {
        HtmlEditorPane htmlEditorPane;
        HtmlEditorPane $this$apply = htmlEditorPane = new HtmlEditorPane();
        boolean bl = false;
        $this$apply.setForeground(UIUtil.getErrorForeground());
        $this$apply.setFocusable(true);
        $this$apply.removeHyperlinkListener((HyperlinkListener)BrowserHyperlinkListener.INSTANCE);
        $this$apply.addHyperlinkListener((HyperlinkListener)new HyperlinkAdapter($this$apply, model2){
            final /* synthetic */ HtmlEditorPane $this_apply;
            final /* synthetic */ GHErrorPanelModel $model$inlined;
            {
                this.$this_apply = $receiver;
                this.$model$inlined = gHErrorPanelModel;
            }

            protected void hyperlinkActivated(@NotNull HyperlinkEvent e) {
                if (Intrinsics.areEqual((Object)e.getDescription(), (Object)"ERROR_ACTION")) {
                    Action action2 = this.$model$inlined.getErrorAction();
                    if (action2 != null) {
                        action2.actionPerformed(new ActionEvent((Object)((Object)this.$this_apply), 1001, "perform"));
                    }
                } else {
                    BrowserUtil.browse((String)e.getDescription());
                }
            }
        });
        $this$apply.registerKeyboardAction(new ActionListener(model2){
            final /* synthetic */ GHErrorPanelModel $model$inlined;
            {
                this.$model$inlined = gHErrorPanelModel;
            }

            public final void actionPerformed(ActionEvent it) {
                block0: {
                    Action action2 = this.$model$inlined.getErrorAction();
                    if (action2 == null) break block0;
                    action2.actionPerformed(it);
                }
            }
        }, KeyStroke.getKeyStroke(10, 0), 0);
        HtmlEditorPane pane2 = htmlEditorPane;
        new Controller(model2, pane2, horizontalAlignment);
        return (JComponent)((Object)pane2);
    }

    public static /* synthetic */ JComponent create$default(GHHtmlErrorPanel gHHtmlErrorPanel, GHErrorPanelModel gHErrorPanelModel, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        return gHHtmlErrorPanel.create(gHErrorPanelModel, n);
    }

    /*
     * WARNING - void declaration
     */
    @Nls
    private final String getLoadingErrorText(Throwable error) {
        String string;
        if (error instanceof GithubStatusCodeException && ((GithubStatusCodeException)error).getError() != null) {
            GithubErrorMessage githubErrorMessage = ((GithubStatusCodeException)error).getError();
            Intrinsics.checkNotNull((Object)githubErrorMessage);
            if (githubErrorMessage.getMessage() != null) {
                List list2;
                GithubErrorMessage githubErrorMessage2 = ((GithubStatusCodeException)error).getError();
                Intrinsics.checkNotNull((Object)githubErrorMessage2);
                GithubErrorMessage githubError = githubErrorMessage2;
                String string2 = githubError.getMessage();
                Intrinsics.checkNotNull((Object)string2);
                String message = StringsKt.removeSuffix((String)StringsKt.removePrefix((String)string2, (CharSequence)"["), (CharSequence)"]");
                HtmlBuilder builder = new HtmlBuilder().append(message);
                if (StringsKt.startsWith((String)message, (String)"Could not resolve to a Repository", (boolean)true)) {
                    String explanation = " Either repository doesn't exist or you don't have access. The most probable cause is that OAuth App access restrictions are enabled in organization.";
                    builder.append(explanation);
                }
                List<GithubErrorMessage.Error> list3 = githubError.getErrors();
                if (list3 != null) {
                    void $this$mapTo$iv$iv;
                    Iterable $this$map$iv = list3;
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void e;
                        GithubErrorMessage.Error error2 = (GithubErrorMessage.Error)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        String string3 = e.getMessage();
                        if (string3 == null) {
                            Object[] objectArray = new Object[3];
                            objectArray[0] = e.getCode();
                            objectArray[1] = e.getResource();
                            String string4 = e.getField();
                            String string5 = string4;
                            if (string5 == null) {
                                string5 = "";
                            }
                            objectArray[2] = string5;
                            string3 = GithubBundle.message("gql.error.in.field", objectArray);
                        }
                        HtmlChunk htmlChunk = HtmlChunk.text((String)string3);
                        collection.add(htmlChunk);
                    }
                    list2 = (List)destination$iv$iv;
                } else {
                    list2 = null;
                }
                List errors = list2;
                Collection collection = errors;
                if (!(collection == null || collection.isEmpty())) {
                    builder.append(": ").append((HtmlChunk)HtmlChunk.br()).appendWithSeparators((HtmlChunk)HtmlChunk.br(), (Iterable)errors);
                }
                return builder.toString();
            }
        }
        if ((string = error.getMessage()) == null) {
            string = GithubBundle.message("unknown.loading.error", new Object[0]);
        }
        return string;
    }

    private GHHtmlErrorPanel() {
    }

    static {
        GHHtmlErrorPanel gHHtmlErrorPanel;
        INSTANCE = gHHtmlErrorPanel = new GHHtmlErrorPanel();
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u000b\u001a\u00020\fH\u0002J\u0014\u0010\r\u001a\u00020\u000e*\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0016\u0010\r\u001a\u00020\u000e*\u00020\u000e2\b\b\u0001\u0010\u0011\u001a\u00020\nH\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/plugins/github/ui/component/GHHtmlErrorPanel$Controller;", "", "model", "Lorg/jetbrains/plugins/github/ui/component/GHErrorPanelModel;", "pane", "Lorg/jetbrains/plugins/github/ui/util/HtmlEditorPane;", "horizontalAlignment", "", "(Lorg/jetbrains/plugins/github/ui/component/GHErrorPanelModel;Lorg/jetbrains/plugins/github/ui/util/HtmlEditorPane;I)V", "alignmentText", "", "update", "", "appendP", "Lcom/intellij/openapi/util/text/HtmlBuilder;", "chunk", "Lcom/intellij/openapi/util/text/HtmlChunk;", "text", "intellij.vcs.github"})
    private static final class Controller {
        private final String alignmentText;
        private final GHErrorPanelModel model;
        private final HtmlEditorPane pane;

        private final void update() {
            Throwable error = this.model.getError();
            if (error != null) {
                this.pane.setVisible(true);
                HtmlBuilder errorTextBuilder = this.appendP(this.appendP(new HtmlBuilder(), this.model.getErrorPrefix()), INSTANCE.getLoadingErrorText(error));
                Action errorAction = this.model.getErrorAction();
                if (errorAction != null) {
                    this.appendP(errorTextBuilder.br(), (HtmlChunk)HtmlChunk.link((String)GHHtmlErrorPanel.ERROR_ACTION_HREF, (String)GHUIUtilKt.getName(errorAction)));
                }
                this.pane.setBody(errorTextBuilder.toString());
            } else {
                this.pane.setVisible(false);
                this.pane.setBody("");
            }
            this.pane.setSize(0x3FFFFFFF, 0x3FFFFFFF);
        }

        private final HtmlBuilder appendP(HtmlBuilder $this$appendP, HtmlChunk chunk) {
            return $this$appendP.append((HtmlChunk)HtmlChunk.p().attr("align", this.alignmentText).child(chunk));
        }

        private final HtmlBuilder appendP(HtmlBuilder $this$appendP, @Nls String text) {
            return this.appendP($this$appendP, HtmlChunk.text((String)text));
        }

        public Controller(@NotNull GHErrorPanelModel model2, @NotNull HtmlEditorPane pane2, int horizontalAlignment) {
            String string;
            this.model = model2;
            this.pane = pane2;
            switch (horizontalAlignment) {
                case 2: {
                    string = "left";
                    break;
                }
                case 4: {
                    string = "right";
                    break;
                }
                default: {
                    string = "center";
                }
            }
            this.alignmentText = string;
            this.model.addAndInvokeChangeEventListener((Function0<Unit>)((Function0)new Function0<Unit>(this){

                public final void invoke() {
                    ((Controller)this.receiver).update();
                }
            }));
        }
    }
}

