/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.ui;

import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBTextArea;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.builder.RowLayout;
import com.intellij.ui.dsl.gridLayout.HorizontalAlign;
import com.intellij.ui.dsl.gridLayout.VerticalAlign;
import com.intellij.ui.layout.ValidationInfoBuilder;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.dialog.DialogUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import javax.swing.ComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JTextField;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.plugins.github.authentication.accounts.GithubAccount;
import org.jetbrains.plugins.github.authentication.ui.GHAccountsComboBoxModel;
import org.jetbrains.plugins.github.authentication.ui.GHAccountsHost;
import org.jetbrains.plugins.github.i18n.GithubBundle;
import org.jetbrains.plugins.github.ui.GithubShareDialog;
import org.jetbrains.plugins.github.ui.util.DialogValidationUtils;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B_\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0007\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0006\u0012*\u0010\u000b\u001a&\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\r\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u00060\u000e0\f\u00a2\u0006\u0002\u0010\u0010J\b\u0010#\u001a\u00020$H\u0014J\u000e\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00150&H\u0014J\b\u0010'\u001a\u0004\u0018\u00010\u0007J\u0012\u0010(\u001a\u0004\u0018\u00010)2\u0006\u0010*\u001a\u00020\nH\u0016J\b\u0010+\u001a\u00020\nH\u0007J\b\u0010,\u001a\u00020\nH\u0014J\b\u0010-\u001a\u00020\nH\u0014J\b\u0010.\u001a\u00020!H\u0016J\b\u0010/\u001a\u00020\nH\u0007J\b\u00100\u001a\u00020\nH\u0007J\u0006\u00101\u001a\u00020\u000fJ\u0012\u00102\u001a\u0002032\b\u00104\u001a\u0004\u0018\u00010\u0007H\u0002J\u0010\u00105\u001a\u0002032\u0006\u00106\u001a\u00020\nH\u0007J\n\u00107\u001a\u0004\u0018\u00010\u0015H\u0002J\n\u00108\u001a\u0004\u0018\u00010\u0015H\u0002J\n\u00109\u001a\u0004\u0018\u00010\u0015H\u0002R\u0016\u0010\u0011\u001a\n \u0013*\u0004\u0018\u00010\u00120\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R2\u0010\u000b\u001a&\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\r\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u00060\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001f\u001a\u00020\n8\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Lorg/jetbrains/plugins/github/ui/GithubShareDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "Lcom/intellij/openapi/actionSystem/DataProvider;", "project", "Lcom/intellij/openapi/project/Project;", "accounts", "", "Lorg/jetbrains/plugins/github/authentication/accounts/GithubAccount;", "defaultAccount", "existingRemotes", "", "accountInformationSupplier", "Lkotlin/Function2;", "Ljava/awt/Component;", "Lkotlin/Pair;", "", "(Lcom/intellij/openapi/project/Project;Ljava/util/Set;Lorg/jetbrains/plugins/github/authentication/accounts/GithubAccount;Ljava/util/Set;Lkotlin/jvm/functions/Function2;)V", "GITHUB_REPO_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "accountInformationLoadingError", "Lcom/intellij/openapi/ui/ValidationInfo;", "accountsModel", "Lorg/jetbrains/plugins/github/authentication/ui/GHAccountsComboBoxModel;", "descriptionTextArea", "Lcom/intellij/ui/components/JBTextArea;", "existingRemoteValidator", "Lorg/jetbrains/plugins/github/ui/util/DialogValidationUtils$RecordUniqueValidator;", "existingRepoValidator", "privateCheckBox", "Lcom/intellij/ui/components/JBCheckBox;", "remoteName", "remoteTextField", "Lcom/intellij/ui/components/JBTextField;", "repositoryTextField", "createCenterPanel", "Lcom/intellij/openapi/ui/DialogPanel;", "doValidateAll", "", "getAccount", "getData", "", "dataId", "getDescription", "getDimensionServiceKey", "getHelpId", "getPreferredFocusedComponent", "getRemoteName", "getRepositoryName", "isPrivate", "switchAccount", "", "account", "testSetRepositoryName", "name", "validateRemote", "validateRepository", "validateRepositoryName", "intellij.vcs.github"})
public final class GithubShareDialog
extends DialogWrapper
implements DataProvider {
    private final Pattern GITHUB_REPO_PATTERN;
    private final JBTextField repositoryTextField;
    private final JBCheckBox privateCheckBox;
    @NlsSafe
    private final String remoteName;
    private final JBTextField remoteTextField;
    private final JBTextArea descriptionTextArea;
    private final DialogValidationUtils.RecordUniqueValidator existingRepoValidator;
    private final DialogValidationUtils.RecordUniqueValidator existingRemoteValidator;
    private ValidationInfo accountInformationLoadingError;
    private final GHAccountsComboBoxModel accountsModel;
    private final Function2<GithubAccount, Component, Pair<Boolean, Set<String>>> accountInformationSupplier;

    private final void switchAccount(GithubAccount account) {
        if (account == null) {
            return;
        }
        try {
            this.accountInformationLoadingError = null;
            Object object = this.accountInformationSupplier.invoke((Object)account, (Object)this.getWindow());
            Pair it = (Pair)object;
            boolean bl = false;
            this.privateCheckBox.setEnabled(((Boolean)it.getFirst()).booleanValue());
            if (!((Boolean)it.getFirst()).booleanValue()) {
                this.privateCheckBox.setToolTipText(GithubBundle.message("share.error.private.repos.not.supported", new Object[0]));
            } else {
                this.privateCheckBox.setToolTipText((String)null);
            }
            this.existingRepoValidator.setRecords((Set)it.getSecond());
        }
        catch (Exception e) {
            String errorText = GithubBundle.message("share.dialog.account.info.load.error.prefix", new Object[]{account}) + (e instanceof ProcessCanceledException ? GithubBundle.message("share.dialog.account.info.load.process.canceled", new Object[0]) : e.getMessage());
            this.accountInformationLoadingError = new ValidationInfo(errorText);
            this.privateCheckBox.setEnabled(false);
            this.privateCheckBox.setToolTipText((String)null);
            this.existingRepoValidator.setRecords(SetsKt.emptySet());
            this.startTrackingValidation();
        }
    }

    @NotNull
    protected DialogPanel createCenterPanel() {
        DialogPanel dialogPanel;
        DialogPanel $this$apply = dialogPanel = BuilderKt.panel((Function1)((Function1)new Function1<Panel, Unit>(this){
            final /* synthetic */ GithubShareDialog this$0;

            public final void invoke(@NotNull Panel $this$panel) {
                $this$panel.row(GithubBundle.message("share.dialog.repo.name", new Object[0]), (Function1)new Function1<Row, Unit>(this){
                    final /* synthetic */ createCenterPanel.1 this$0;

                    public final void invoke(@NotNull Row $this$row) {
                        $this$row.cell((JComponent)GithubShareDialog.access$getRepositoryTextField$p(this.this$0.this$0)).horizontalAlign(HorizontalAlign.FILL).validationOnApply((Function2)new Function2<ValidationInfoBuilder, JBTextField, ValidationInfo>(this){
                            final /* synthetic */ createCenterPanel.1 this$0;

                            @Nullable
                            public final ValidationInfo invoke(@NotNull ValidationInfoBuilder $this$validationOnApply, @NotNull JBTextField it) {
                                return GithubShareDialog.access$validateRepository(this.this$0.this$0.this$0);
                            }
                            {
                                this.this$0 = var1_1;
                                super(2);
                            }
                        }).resizableColumn();
                        $this$row.cell((JComponent)GithubShareDialog.access$getPrivateCheckBox$p(this.this$0.this$0));
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                });
                $this$panel.row(GithubBundle.message("share.dialog.remote", new Object[0]), (Function1)new Function1<Row, Unit>(this){
                    final /* synthetic */ createCenterPanel.1 this$0;

                    public final void invoke(@NotNull Row $this$row) {
                        $this$row.cell((JComponent)GithubShareDialog.access$getRemoteTextField$p(this.this$0.this$0)).horizontalAlign(HorizontalAlign.FILL).validationOnApply((Function2)new Function2<ValidationInfoBuilder, JBTextField, ValidationInfo>(this){
                            final /* synthetic */ createCenterPanel.2 this$0;

                            @Nullable
                            public final ValidationInfo invoke(@NotNull ValidationInfoBuilder $this$validationOnApply, @NotNull JBTextField it) {
                                return GithubShareDialog.access$validateRemote(this.this$0.this$0.this$0);
                            }
                            {
                                this.this$0 = var1_1;
                                super(2);
                            }
                        });
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                });
                Panel.DefaultImpls.row$default((Panel)$this$panel, null, (Function1)((Function1)new Function1<Row, Unit>(this){
                    final /* synthetic */ createCenterPanel.1 this$0;

                    public final void invoke(@NotNull Row $this$row) {
                        $this$row.label(GithubBundle.message("share.dialog.description", new Object[0])).verticalAlign(VerticalAlign.TOP);
                        $this$row.scrollCell((JComponent)GithubShareDialog.access$getDescriptionTextArea$p(this.this$0.this$0)).horizontalAlign(HorizontalAlign.FILL).verticalAlign(VerticalAlign.FILL);
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                }), (int)1, null).layout(RowLayout.LABEL_ALIGNED).resizableRow();
                if (GithubShareDialog.access$getAccountsModel$p(this.this$0).getSize() != 1) {
                    $this$panel.row(GithubBundle.message("share.dialog.share.by", new Object[0]), (Function1)new Function1<Row, Unit>(this){
                        final /* synthetic */ createCenterPanel.1 this$0;

                        public final void invoke(@NotNull Row $this$row) {
                            Row.DefaultImpls.comboBox$default((Row)$this$row, (ComboBoxModel)((ComboBoxModel)((Object)GithubShareDialog.access$getAccountsModel$p(this.this$0.this$0))), null, (int)2, null).horizontalAlign(HorizontalAlign.FILL).validationOnApply((Function2)new Function2<ValidationInfoBuilder, ComboBox<GithubAccount>, ValidationInfo>(this){
                                final /* synthetic */ createCenterPanel.4 this$0;

                                @Nullable
                                public final ValidationInfo invoke(@NotNull ValidationInfoBuilder $this$validationOnApply, @NotNull ComboBox<GithubAccount> it) {
                                    return GithubShareDialog.access$getAccountsModel$p(this.this$0.this$0.this$0).getSelected() == null ? $this$validationOnApply.error(GithubBundle.message("dialog.message.account.cannot.be.empty", new Object[0])) : null;
                                }
                                {
                                    this.this$0 = var1_1;
                                    super(2);
                                }
                            }).applyToComponent((Function1)new Function1<ComboBox<GithubAccount>, Unit>(this){
                                final /* synthetic */ createCenterPanel.4 this$0;

                                public final void invoke(@NotNull ComboBox<GithubAccount> $this$applyToComponent) {
                                    $this$applyToComponent.addActionListener(new ActionListener(this){
                                        final /* synthetic */ createCenterPanel.2 this$0;

                                        public final void actionPerformed(ActionEvent it) {
                                            GithubShareDialog.access$switchAccount(this.this$0.this$0.this$0.this$0, this.this$0.this$0.this$0.this$0.getAccount());
                                        }
                                        {
                                            this.this$0 = var1_1;
                                        }
                                    });
                                }
                                {
                                    this.this$0 = var1_1;
                                    super(1);
                                }
                            }).resizableColumn();
                            if (GithubShareDialog.access$getAccountsModel$p(this.this$0.this$0).getSize() == 0) {
                                $this$row.cell((JComponent)GHAccountsHost.Companion.createAddAccountLink());
                            }
                        }
                        {
                            this.this$0 = var1_1;
                            super(1);
                        }
                    });
                }
            }
            {
                this.this$0 = githubShareDialog;
                super(1);
            }
        }));
        boolean bl = false;
        $this$apply.setPreferredSize((Dimension)JBUI.size((int)500, (int)250));
        return dialogPanel;
    }

    @NotNull
    protected List<ValidationInfo> doValidateAll() {
        List uiErrors = super.doValidateAll();
        ValidationInfo loadingError = this.accountInformationLoadingError;
        return loadingError != null ? CollectionsKt.plus((Collection)uiErrors, (Object)loadingError) : uiErrors;
    }

    private final ValidationInfo validateRepository() {
        ValidationInfo validationInfo;
        ValidationInfo validationInfo2 = DialogValidationUtils.INSTANCE.notBlank((JTextField)this.repositoryTextField, GithubBundle.message("share.validation.no.repo.name", new Object[0]));
        if (validationInfo2 == null) {
            validationInfo2 = validationInfo = this.validateRepositoryName();
        }
        if (validationInfo2 == null) {
            validationInfo = this.existingRepoValidator.invoke();
        }
        return validationInfo;
    }

    private final ValidationInfo validateRepositoryName() {
        return this.GITHUB_REPO_PATTERN.matcher(this.repositoryTextField.getText()).matches() ? null : new ValidationInfo(GithubBundle.message("share.validation.invalid.repo.name", new Object[0]), (JComponent)this.repositoryTextField);
    }

    private final ValidationInfo validateRemote() {
        ValidationInfo validationInfo = DialogValidationUtils.INSTANCE.notBlank((JTextField)this.remoteTextField, GithubBundle.message("share.validation.no.remote.name", new Object[0]));
        if (validationInfo == null) {
            validationInfo = this.existingRemoteValidator.invoke();
        }
        return validationInfo;
    }

    @NotNull
    protected String getHelpId() {
        return "github.share";
    }

    @NotNull
    protected String getDimensionServiceKey() {
        return "Github.ShareDialog";
    }

    @NotNull
    public JBTextField getPreferredFocusedComponent() {
        return this.repositoryTextField;
    }

    @Nullable
    public Object getData(@NotNull String dataId) {
        return GHAccountsHost.Companion.getKEY().is(dataId) ? this.accountsModel : null;
    }

    @NlsSafe
    @NotNull
    public final String getRepositoryName() {
        return this.repositoryTextField.getText();
    }

    @NlsSafe
    @NotNull
    public final String getRemoteName() {
        return this.remoteTextField.getText();
    }

    public final boolean isPrivate() {
        return this.privateCheckBox.isSelected();
    }

    @NlsSafe
    @NotNull
    public final String getDescription() {
        return this.descriptionTextArea.getText();
    }

    @Nullable
    public final GithubAccount getAccount() {
        return (GithubAccount)((Object)this.accountsModel.getSelected());
    }

    @TestOnly
    public final void testSetRepositoryName(@NotNull String name) {
        this.repositoryTextField.setText(name);
    }

    public GithubShareDialog(@NotNull Project project, @NotNull Set<GithubAccount> accounts, @Nullable GithubAccount defaultAccount, @NotNull Set<String> existingRemotes, @NotNull Function2<? super GithubAccount, ? super Component, ? extends Pair<Boolean, ? extends Set<String>>> accountInformationSupplier) {
        super(project);
        Object $this$apply;
        this.accountInformationSupplier = accountInformationSupplier;
        this.GITHUB_REPO_PATTERN = Pattern.compile("[a-zA-Z0-9_.-]+");
        this.repositoryTextField = new JBTextField(project.getName());
        this.privateCheckBox = new JBCheckBox(GithubBundle.message("share.dialog.private", new Object[0]), false);
        this.remoteName = existingRemotes.isEmpty() ? "origin" : "github";
        this.remoteTextField = new JBTextField(this.remoteName);
        Object object = new JBTextArea();
        JBTextArea jBTextArea = object;
        GithubShareDialog githubShareDialog = this;
        boolean bl = false;
        $this$apply.setLineWrap(true);
        Unit unit = Unit.INSTANCE;
        githubShareDialog.descriptionTextArea = object;
        this.existingRepoValidator = new DialogValidationUtils.RecordUniqueValidator((JTextField)this.repositoryTextField, GithubBundle.message("share.error.repo.with.selected.name.exists", new Object[0]));
        $this$apply = object = new DialogValidationUtils.RecordUniqueValidator((JTextField)this.remoteTextField, GithubBundle.message("share.error.remote.with.selected.name.exists", new Object[0]));
        githubShareDialog = this;
        boolean bl2 = false;
        ((DialogValidationUtils.RecordUniqueValidator)$this$apply).setRecords(existingRemotes);
        unit = Unit.INSTANCE;
        githubShareDialog.existingRemoteValidator = object;
        GithubAccount githubAccount = defaultAccount;
        if (githubAccount == null) {
            githubAccount = (GithubAccount)((Object)CollectionsKt.firstOrNull((Iterable)accounts));
        }
        this.accountsModel = new GHAccountsComboBoxModel(accounts, githubAccount);
        this.setTitle(GithubBundle.message("share.on.github", new Object[0]));
        this.setOKButtonText(GithubBundle.message("share.button", new Object[0]));
        this.init();
        DialogUtils.invokeLaterAfterDialogShown((DialogWrapper)this, (Runnable)new Runnable(){

            @Override
            public final void run() {
                this.switchAccount(this.getAccount());
            }
        });
    }

    public static final /* synthetic */ JBTextField access$getRepositoryTextField$p(GithubShareDialog $this) {
        return $this.repositoryTextField;
    }

    public static final /* synthetic */ ValidationInfo access$validateRepository(GithubShareDialog $this) {
        return $this.validateRepository();
    }

    public static final /* synthetic */ JBCheckBox access$getPrivateCheckBox$p(GithubShareDialog $this) {
        return $this.privateCheckBox;
    }

    public static final /* synthetic */ JBTextField access$getRemoteTextField$p(GithubShareDialog $this) {
        return $this.remoteTextField;
    }

    public static final /* synthetic */ ValidationInfo access$validateRemote(GithubShareDialog $this) {
        return $this.validateRemote();
    }

    public static final /* synthetic */ JBTextArea access$getDescriptionTextArea$p(GithubShareDialog $this) {
        return $this.descriptionTextArea;
    }

    public static final /* synthetic */ GHAccountsComboBoxModel access$getAccountsModel$p(GithubShareDialog $this) {
        return $this.accountsModel;
    }
}

