/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.tasks;

import com.intellij.credentialStore.CredentialAttributes;
import com.intellij.credentialStore.CredentialAttributesKt;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.tasks.Comment;
import com.intellij.tasks.Task;
import com.intellij.tasks.TaskRepository;
import com.intellij.tasks.TaskRepositoryType;
import com.intellij.tasks.TaskState;
import com.intellij.tasks.TaskType;
import com.intellij.tasks.impl.BaseRepository;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.annotations.Tag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.GithubApiRequestExecutor;
import org.jetbrains.plugins.github.api.GithubApiRequests;
import org.jetbrains.plugins.github.api.GithubServerPath;
import org.jetbrains.plugins.github.api.data.GithubIssue;
import org.jetbrains.plugins.github.api.data.GithubIssueBase;
import org.jetbrains.plugins.github.api.data.GithubIssueCommentWithHtml;
import org.jetbrains.plugins.github.api.data.GithubIssueState;
import org.jetbrains.plugins.github.api.util.GithubApiPagesLoader;
import org.jetbrains.plugins.github.exceptions.GithubAuthenticationException;
import org.jetbrains.plugins.github.exceptions.GithubJsonException;
import org.jetbrains.plugins.github.exceptions.GithubRateLimitExceededException;
import org.jetbrains.plugins.github.exceptions.GithubStatusCodeException;
import org.jetbrains.plugins.github.issue.GithubIssuesLoadingHelper;
import org.jetbrains.plugins.github.tasks.GithubComment;
import org.jetbrains.plugins.github.tasks.GithubRepositoryType;

@Tag(value="GitHub")
final class GithubRepository
extends BaseRepository {
    private Pattern myPattern = Pattern.compile("($^)");
    @NotNull
    private String myRepoAuthor = "";
    @NotNull
    private String myRepoName = "";
    @NotNull
    private String myUser = "";
    private boolean myAssignedIssuesOnly = false;

    GithubRepository() {
    }

    GithubRepository(GithubRepository other) {
        super((BaseRepository)other);
        this.setRepoName(other.myRepoName);
        this.setRepoAuthor(other.myRepoAuthor);
        this.setAssignedIssuesOnly(other.myAssignedIssuesOnly);
    }

    GithubRepository(GithubRepositoryType type) {
        super((TaskRepositoryType)type);
        this.setUrl("https://github.com");
    }

    @NotNull
    public TaskRepository.CancellableConnection createCancellableConnection() {
        return new TaskRepository.CancellableConnection(){
            private final GithubApiRequestExecutor myExecutor;
            private final ProgressIndicator myIndicator;
            {
                this.myExecutor = GithubRepository.this.getExecutor();
                this.myIndicator = new EmptyProgressIndicator();
            }

            protected void doTest() throws Exception {
                try {
                    this.myExecutor.execute(this.myIndicator, GithubApiRequests.Repos.get(GithubRepository.this.getServer(), GithubRepository.this.getRepoAuthor(), GithubRepository.this.getRepoName()));
                }
                catch (ProcessCanceledException processCanceledException) {
                    // empty catch block
                }
            }

            public void cancel() {
                this.myIndicator.cancel();
            }
        };
    }

    public boolean isConfigured() {
        return super.isConfigured() && !StringUtil.isEmptyOrSpaces((String)this.getRepoAuthor()) && !StringUtil.isEmptyOrSpaces((String)this.getRepoName()) && !StringUtil.isEmptyOrSpaces((String)this.getPassword());
    }

    public String getPresentableName() {
        String name = super.getPresentableName();
        return name + (String)(!StringUtil.isEmpty((String)this.getRepoAuthor()) ? "/" + this.getRepoAuthor() : "") + (String)(!StringUtil.isEmpty((String)this.getRepoName()) ? "/" + this.getRepoName() : "");
    }

    public Task[] getIssues(@Nullable String query, int offset, int limit, boolean withClosed) throws Exception {
        try {
            return this.getIssues(query, offset + limit, withClosed);
        }
        catch (GithubRateLimitExceededException e) {
            return Task.EMPTY_ARRAY;
        }
        catch (GithubAuthenticationException | GithubStatusCodeException e) {
            throw new Exception(e.getMessage(), e);
        }
        catch (GithubJsonException e) {
            throw new Exception("Bad response format", e);
        }
    }

    public Task[] getIssues(@Nullable String query, int offset, int limit, boolean withClosed, @NotNull ProgressIndicator cancelled) throws Exception {
        return this.getIssues(query, offset, limit, withClosed);
    }

    private Task @NotNull [] getIssues(@Nullable String query, int max, boolean withClosed) throws Exception {
        GithubApiRequestExecutor executor = this.getExecutor();
        ProgressIndicator indicator = GithubRepository.getProgressIndicator();
        GithubServerPath server = this.getServer();
        String assigned = null;
        if (this.myAssignedIssuesOnly) {
            if (StringUtil.isEmptyOrSpaces((String)this.myUser)) {
                this.myUser = executor.execute(indicator, GithubApiRequests.CurrentUser.get(server)).getLogin();
            }
            assigned = this.myUser;
        }
        List<GithubIssueBase> issues = StringUtil.isEmptyOrSpaces((String)query) ? GithubIssuesLoadingHelper.load(executor, indicator, server, this.getRepoAuthor(), this.getRepoName(), withClosed, max, assigned) : GithubIssuesLoadingHelper.search(executor, indicator, server, this.getRepoAuthor(), this.getRepoName(), withClosed, assigned, query);
        ArrayList<Task> tasks = new ArrayList<Task>();
        for (GithubIssueBase issue : issues) {
            List<GithubIssueCommentWithHtml> comments = GithubApiPagesLoader.loadAll(executor, indicator, GithubApiRequests.Repos.Issues.Comments.pages(issue.getCommentsUrl()));
            tasks.add(this.createTask(issue, comments));
        }
        return tasks.toArray(Task.EMPTY_ARRAY);
    }

    @NotNull
    private Task createTask(final @NotNull GithubIssueBase issue, final @NotNull List<GithubIssueCommentWithHtml> comments) {
        return new Task(){
            @NotNull
            private final String myRepoName;
            private final Comment @NotNull [] myComments;
            {
                this.myRepoName = GithubRepository.this.getRepoName();
                this.myComments = (Comment[])ContainerUtil.map2Array((Collection)comments, Comment.class, comment -> new GithubComment(comment.getCreatedAt(), comment.getUser().getLogin(), comment.getBodyHtml(), comment.getUser().getAvatarUrl(), comment.getUser().getHtmlUrl()));
            }

            public boolean isIssue() {
                return true;
            }

            public String getIssueUrl() {
                return issue.getHtmlUrl();
            }

            @NlsSafe
            @NotNull
            public String getId() {
                return this.myRepoName + "-" + issue.getNumber();
            }

            @NotNull
            public String getSummary() {
                return issue.getTitle();
            }

            public String getDescription() {
                return issue.getBody();
            }

            public Comment @NotNull [] getComments() {
                return this.myComments;
            }

            @NotNull
            public Icon getIcon() {
                return AllIcons.Vcs.Vendors.Github;
            }

            @NotNull
            public TaskType getType() {
                return TaskType.BUG;
            }

            public Date getUpdated() {
                return issue.getUpdatedAt();
            }

            public Date getCreated() {
                return issue.getCreatedAt();
            }

            public boolean isClosed() {
                return issue.getState() == GithubIssueState.closed;
            }

            public TaskRepository getRepository() {
                return GithubRepository.this;
            }

            public String getPresentableName() {
                return this.getId() + ": " + this.getSummary();
            }
        };
    }

    @Nullable
    public String extractId(@NotNull String taskName) {
        Matcher matcher = this.myPattern.matcher(taskName);
        return matcher.find() ? matcher.group(1) : null;
    }

    @Nullable
    public Task findTask(@NotNull String id) throws Exception {
        ProgressIndicator indicator;
        int index = id.lastIndexOf("-");
        if (index < 0) {
            return null;
        }
        String numericId = id.substring(index + 1);
        GithubApiRequestExecutor executor = this.getExecutor();
        GithubIssue issue = executor.execute(indicator = GithubRepository.getProgressIndicator(), GithubApiRequests.Repos.Issues.get(this.getServer(), this.getRepoAuthor(), this.getRepoName(), numericId));
        if (issue == null) {
            return null;
        }
        List<GithubIssueCommentWithHtml> comments = GithubApiPagesLoader.loadAll(executor, indicator, GithubApiRequests.Repos.Issues.Comments.pages(issue.getCommentsUrl()));
        return this.createTask(issue, comments);
    }

    public void setTaskState(@NotNull Task task2, @NotNull TaskState state2) throws Exception {
        boolean isOpen;
        switch (state2) {
            case OPEN: {
                isOpen = true;
                break;
            }
            case RESOLVED: {
                isOpen = false;
                break;
            }
            default: {
                throw new IllegalStateException("Unknown state: " + state2);
            }
        }
        GithubApiRequestExecutor executor = this.getExecutor();
        GithubServerPath server = this.getServer();
        String repoAuthor = this.getRepoAuthor();
        String repoName = this.getRepoName();
        ProgressIndicator indicator = GithubRepository.getProgressIndicator();
        executor.execute(indicator, GithubApiRequests.Repos.Issues.updateState(server, repoAuthor, repoName, task2.getNumber(), isOpen));
    }

    @NotNull
    public BaseRepository clone() {
        return new GithubRepository(this);
    }

    @NlsSafe
    @NotNull
    public String getRepoName() {
        return this.myRepoName;
    }

    public void setRepoName(@NotNull String repoName) {
        this.myRepoName = repoName;
        this.myPattern = Pattern.compile("(" + StringUtil.escapeToRegexp((String)repoName) + "\\-\\d+)");
    }

    @NlsSafe
    @NotNull
    public String getRepoAuthor() {
        return this.myRepoAuthor;
    }

    public void setRepoAuthor(@NotNull String repoAuthor) {
        this.myRepoAuthor = repoAuthor;
    }

    @NlsSafe
    @NotNull
    public String getUser() {
        return this.myUser;
    }

    public void setUser(@NotNull String user) {
        this.myUser = user;
    }

    public void setPassword(String password) {
        super.setPassword(password);
        this.setUser("");
    }

    public boolean isAssignedIssuesOnly() {
        return this.myAssignedIssuesOnly;
    }

    public void setAssignedIssuesOnly(boolean value) {
        this.myAssignedIssuesOnly = value;
    }

    @NotNull
    protected CredentialAttributes getAttributes() {
        String serviceName = CredentialAttributesKt.generateServiceName((String)"Tasks", (String)(this.getRepositoryType().getName() + " " + this.getPresentableName()));
        return new CredentialAttributes(serviceName, "GitHub OAuth token");
    }

    @NotNull
    private GithubApiRequestExecutor getExecutor() {
        return GithubApiRequestExecutor.Factory.getInstance().create(this.getPassword(), this.myUseProxy);
    }

    @NotNull
    private static ProgressIndicator getProgressIndicator() {
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        if (indicator == null) {
            indicator = new EmptyProgressIndicator();
        }
        return indicator;
    }

    @NotNull
    private GithubServerPath getServer() {
        return GithubServerPath.from(this.getUrl());
    }

    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (!(o instanceof GithubRepository)) {
            return false;
        }
        GithubRepository that = (GithubRepository)((Object)o);
        if (!Objects.equals(this.getRepoAuthor(), that.getRepoAuthor())) {
            return false;
        }
        if (!Objects.equals(this.getRepoName(), that.getRepoName())) {
            return false;
        }
        return Comparing.equal((Object)this.isAssignedIssuesOnly(), (Object)that.isAssignedIssuesOnly());
    }

    public int hashCode() {
        return StringUtil.stringHashCode((CharSequence)this.getRepoName()) + 31 * StringUtil.stringHashCode((CharSequence)this.getRepoAuthor());
    }

    protected int getFeatures() {
        return super.getFeatures() | 8;
    }
}

