/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest.ui.timeline;

import com.intellij.collaboration.async.CompletableFutureUtil;
import com.intellij.collaboration.ui.codereview.timeline.TimelineItemComponentFactory;
import com.intellij.icons.AllIcons;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.plugins.newui.HorizontalLayout;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.ui.components.ActionLink;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.ui.components.labels.LinkListener;
import com.intellij.ui.components.panels.HorizontalBox;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.components.panels.VerticalLayout;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.Date;
import java.util.concurrent.CompletableFuture;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.miginfocom.layout.CC;
import net.miginfocom.layout.LC;
import net.miginfocom.swing.MigLayout;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.GithubIcons;
import org.jetbrains.plugins.github.api.data.GHActor;
import org.jetbrains.plugins.github.api.data.GHCommitShort;
import org.jetbrains.plugins.github.api.data.GHGitActor;
import org.jetbrains.plugins.github.api.data.GHIssueComment;
import org.jetbrains.plugins.github.api.data.GHUser;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequest;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequestCommitShort;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequestReview;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequestShort;
import org.jetbrains.plugins.github.api.data.pullrequest.timeline.GHPRTimelineEvent;
import org.jetbrains.plugins.github.api.data.pullrequest.timeline.GHPRTimelineItem;
import org.jetbrains.plugins.github.i18n.GithubBundle;
import org.jetbrains.plugins.github.pullrequest.comment.GHMarkdownToHtmlConverterKt;
import org.jetbrains.plugins.github.pullrequest.comment.ui.GHPRReviewThreadComponent;
import org.jetbrains.plugins.github.pullrequest.comment.ui.GHPRReviewThreadModel;
import org.jetbrains.plugins.github.pullrequest.data.provider.GHPRCommentsDataProvider;
import org.jetbrains.plugins.github.pullrequest.data.provider.GHPRDetailsDataProvider;
import org.jetbrains.plugins.github.pullrequest.data.provider.GHPRReviewDataProvider;
import org.jetbrains.plugins.github.pullrequest.ui.GHEditableHtmlPaneHandle;
import org.jetbrains.plugins.github.pullrequest.ui.GHTextActions;
import org.jetbrains.plugins.github.pullrequest.ui.changes.GHPRSuggestedChangeHelper;
import org.jetbrains.plugins.github.pullrequest.ui.timeline.GHPRReviewThreadDiffComponentFactory;
import org.jetbrains.plugins.github.pullrequest.ui.timeline.GHPRReviewThreadsModel;
import org.jetbrains.plugins.github.pullrequest.ui.timeline.GHPRReviewThreadsPanel;
import org.jetbrains.plugins.github.pullrequest.ui.timeline.GHPRReviewsThreadsModelsProvider;
import org.jetbrains.plugins.github.pullrequest.ui.timeline.GHPRSelectInToolWindowHelper;
import org.jetbrains.plugins.github.pullrequest.ui.timeline.GHPRTimelineEventComponentFactory;
import org.jetbrains.plugins.github.pullrequest.ui.timeline.GHPRTimelineItemComponentFactory;
import org.jetbrains.plugins.github.pullrequest.ui.timeline.GHPRTimelineItemComponentFactory$WhenMappings;
import org.jetbrains.plugins.github.pullrequest.ui.timeline.GHPRTimelineItemComponentFactory$createComponent$2;
import org.jetbrains.plugins.github.pullrequest.ui.timeline.GHPRTimelineItemComponentFactory$createComponent$panelHandle$1;
import org.jetbrains.plugins.github.pullrequest.ui.timeline.GHPRTimelineItemComponentFactory$createComponent$panelHandle$3;
import org.jetbrains.plugins.github.ui.avatars.GHAvatarIconsProvider;
import org.jetbrains.plugins.github.ui.util.GHUIUtil;
import org.jetbrains.plugins.github.ui.util.HtmlEditorPane;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 +2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002+,Bc\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u0012\u0006\u0010\u0016\u001a\u00020\u0017\u0012\u0006\u0010\u0018\u001a\u00020\u0019\u00a2\u0006\u0002\u0010\u001aJ\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\"H\u0002J\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020$J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010%\u001a\u00020\u0002H\u0016J\u0012\u0010&\u001a\u00020'2\b\u0010(\u001a\u0004\u0018\u00010)H\u0002J\u0012\u0010&\u001a\u00020'2\b\u0010(\u001a\u0004\u0018\u00010*H\u0002R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRTimelineItemComponentFactory;", "Lcom/intellij/collaboration/ui/codereview/timeline/TimelineItemComponentFactory;", "Lorg/jetbrains/plugins/github/api/data/pullrequest/timeline/GHPRTimelineItem;", "project", "Lcom/intellij/openapi/project/Project;", "detailsDataProvider", "Lorg/jetbrains/plugins/github/pullrequest/data/provider/GHPRDetailsDataProvider;", "commentsDataProvider", "Lorg/jetbrains/plugins/github/pullrequest/data/provider/GHPRCommentsDataProvider;", "reviewDataProvider", "Lorg/jetbrains/plugins/github/pullrequest/data/provider/GHPRReviewDataProvider;", "avatarIconsProvider", "Lorg/jetbrains/plugins/github/ui/avatars/GHAvatarIconsProvider;", "reviewsThreadsModelsProvider", "Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRReviewsThreadsModelsProvider;", "reviewDiffComponentFactory", "Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRReviewThreadDiffComponentFactory;", "eventComponentFactory", "Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRTimelineEventComponentFactory;", "Lorg/jetbrains/plugins/github/api/data/pullrequest/timeline/GHPRTimelineEvent;", "selectInToolWindowHelper", "Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRSelectInToolWindowHelper;", "suggestedChangeHelper", "Lorg/jetbrains/plugins/github/pullrequest/ui/changes/GHPRSuggestedChangeHelper;", "currentUser", "Lorg/jetbrains/plugins/github/api/data/GHUser;", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/plugins/github/pullrequest/data/provider/GHPRDetailsDataProvider;Lorg/jetbrains/plugins/github/pullrequest/data/provider/GHPRCommentsDataProvider;Lorg/jetbrains/plugins/github/pullrequest/data/provider/GHPRReviewDataProvider;Lorg/jetbrains/plugins/github/ui/avatars/GHAvatarIconsProvider;Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRReviewsThreadsModelsProvider;Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRReviewThreadDiffComponentFactory;Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRTimelineEventComponentFactory;Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRSelectInToolWindowHelper;Lorg/jetbrains/plugins/github/pullrequest/ui/changes/GHPRSuggestedChangeHelper;Lorg/jetbrains/plugins/github/api/data/GHUser;)V", "createComponent", "Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRTimelineItemComponentFactory$Item;", "comment", "Lorg/jetbrains/plugins/github/api/data/GHIssueComment;", "commit", "Lorg/jetbrains/plugins/github/api/data/pullrequest/GHPullRequestCommitShort;", "review", "Lorg/jetbrains/plugins/github/api/data/pullrequest/GHPullRequestReview;", "details", "Lorg/jetbrains/plugins/github/api/data/pullrequest/GHPullRequestShort;", "item", "userAvatar", "Ljavax/swing/JLabel;", "user", "Lorg/jetbrains/plugins/github/api/data/GHActor;", "Lorg/jetbrains/plugins/github/api/data/GHGitActor;", "Companion", "Item", "intellij.vcs.github"})
public final class GHPRTimelineItemComponentFactory
implements TimelineItemComponentFactory<GHPRTimelineItem> {
    private final Project project;
    private final GHPRDetailsDataProvider detailsDataProvider;
    private final GHPRCommentsDataProvider commentsDataProvider;
    private final GHPRReviewDataProvider reviewDataProvider;
    private final GHAvatarIconsProvider avatarIconsProvider;
    private final GHPRReviewsThreadsModelsProvider reviewsThreadsModelsProvider;
    private final GHPRReviewThreadDiffComponentFactory reviewDiffComponentFactory;
    private final GHPRTimelineEventComponentFactory<GHPRTimelineEvent> eventComponentFactory;
    private final GHPRSelectInToolWindowHelper selectInToolWindowHelper;
    private final GHPRSuggestedChangeHelper suggestedChangeHelper;
    private final GHUser currentUser;
    private static final Logger LOG;
    private static final Dimension NOT_DEFINED_SIZE;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public Item createComponent(@NotNull GHPRTimelineItem item2) {
        try {
            Item item3;
            GHPRTimelineItem gHPRTimelineItem = item2;
            if (gHPRTimelineItem instanceof GHPullRequestCommitShort) {
                item3 = this.createComponent((GHPullRequestCommitShort)item2);
            } else if (gHPRTimelineItem instanceof GHIssueComment) {
                item3 = this.createComponent((GHIssueComment)item2);
            } else if (gHPRTimelineItem instanceof GHPullRequestReview) {
                item3 = this.createComponent((GHPullRequestReview)item2);
            } else if (gHPRTimelineItem instanceof GHPRTimelineEvent) {
                item3 = this.eventComponentFactory.createComponent((GHPRTimelineEvent)item2);
            } else {
                if (gHPRTimelineItem instanceof GHPRTimelineItem.Unknown) {
                    throw (Throwable)new IllegalStateException("Unknown item type: " + ((GHPRTimelineItem.Unknown)item2).get__typename());
                }
                String string = "Undefined item type";
                throw new IllegalStateException(string.toString());
            }
            return item3;
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
            Object[] objectArray = new Object[1];
            String string = e.getMessage();
            if (string == null) {
                string = "";
            }
            objectArray[0] = string;
            return new Item(AllIcons.General.Warning, (JComponent)((Object)new HtmlEditorPane(GithubBundle.message("cannot.display.item", objectArray))), null, null, 12, null);
        }
    }

    private final Item createComponent(GHPullRequestCommitShort commit) {
        NonOpaquePanel nonOpaquePanel;
        GHCommitShort gitCommit = commit.getCommit();
        NonOpaquePanel $this$apply = nonOpaquePanel = new NonOpaquePanel((LayoutManager)new HorizontalLayout(JBUIScale.scale((int)8)));
        boolean bl = false;
        $this$apply.add((Component)this.userAvatar(gitCommit.getAuthor()));
        $this$apply.add((Component)((Object)new HtmlEditorPane(gitCommit.getMessageHeadlineHTML())));
        $this$apply.add((Component)new ActionLink(gitCommit.getAbbreviatedOid(), (Function1)new Function1<ActionEvent, Unit>(this, gitCommit){
            final /* synthetic */ GHPRTimelineItemComponentFactory this$0;
            final /* synthetic */ GHCommitShort $gitCommit$inlined;
            {
                this.this$0 = gHPRTimelineItemComponentFactory;
                this.$gitCommit$inlined = gHCommitShort;
                super(1);
            }

            public final void invoke(@NotNull ActionEvent it) {
                GHPRTimelineItemComponentFactory.access$getSelectInToolWindowHelper$p(this.this$0).selectCommit(this.$gitCommit$inlined.getAbbreviatedOid());
            }
        }));
        NonOpaquePanel titlePanel = nonOpaquePanel;
        return new Item(AllIcons.Vcs.CommitNode, (JComponent)titlePanel, null, null, 12, null);
    }

    @NotNull
    public final Item createComponent(@NotNull GHPullRequestShort details2) {
        NonOpaquePanel nonOpaquePanel;
        JPanel contentPanel = null;
        JPanel actionsPanel = null;
        if (details2 instanceof GHPullRequest) {
            JPanel jPanel;
            HtmlEditorPane textPane = new HtmlEditorPane(GHMarkdownToHtmlConverterKt.convertToHtml(((GHPullRequest)details2).getBody(), this.project));
            GHEditableHtmlPaneHandle panelHandle2 = new GHEditableHtmlPaneHandle(this.project, (JComponent)((Object)textPane), (Function0<String>)((Function0)new GHPRTimelineItemComponentFactory$createComponent$panelHandle$1(details2)), (Function1<? super String, ? extends CompletableFuture<? extends Object>>)((Function1)new Function1<String, CompletableFuture<? extends Object>>(this, textPane){
                final /* synthetic */ GHPRTimelineItemComponentFactory this$0;
                final /* synthetic */ HtmlEditorPane $textPane;

                @NotNull
                public final CompletableFuture<? extends Object> invoke(@NotNull String newText) {
                    return CompletableFutureUtil.successOnEdt$default((CompletableFutureUtil)CompletableFutureUtil.INSTANCE, (CompletableFuture)GHPRDetailsDataProvider.DefaultImpls.updateDetails$default(GHPRTimelineItemComponentFactory.access$getDetailsDataProvider$p(this.this$0), (ProgressIndicator)new EmptyProgressIndicator(), null, newText, 2, null), null, (Function1)((Function1)new Function1<GHPullRequest, Unit>(this){
                        final /* synthetic */ createComponent.panelHandle.2 this$0;

                        public final void invoke(@NotNull GHPullRequest it) {
                            this.this$0.$textPane.setBody(GHMarkdownToHtmlConverterKt.convertToHtml(it.getBody(), GHPRTimelineItemComponentFactory.access$getProject$p(this.this$0.this$0)));
                        }
                        {
                            this.this$0 = var1_1;
                            super(1);
                        }
                    }), (int)1, null);
                }
                {
                    this.this$0 = gHPRTimelineItemComponentFactory;
                    this.$textPane = htmlEditorPane;
                    super(1);
                }
            }));
            contentPanel = panelHandle2.getPanel();
            if (details2.getViewerCanUpdate()) {
                NonOpaquePanel nonOpaquePanel2;
                NonOpaquePanel $this$apply = nonOpaquePanel2 = new NonOpaquePanel((LayoutManager)new HorizontalLayout(JBUIScale.scale((int)8)));
                boolean bl = false;
                $this$apply.add((Component)GHTextActions.INSTANCE.createEditButton(panelHandle2));
                jPanel = (JPanel)nonOpaquePanel2;
            } else {
                jPanel = null;
            }
            actionsPanel = jPanel;
        } else {
            contentPanel = null;
            actionsPanel = null;
        }
        NonOpaquePanel $this$apply = nonOpaquePanel = new NonOpaquePanel((LayoutManager)new HorizontalLayout(JBUIScale.scale((int)12)));
        boolean bl = false;
        $this$apply.add((Component)Companion.actionTitle(details2.getAuthor(), GithubBundle.message("pull.request.timeline.created", new Object[0]), details2.getCreatedAt()));
        if (actionsPanel != null && actionsPanel.getComponentCount() > 0) {
            $this$apply.add((Component)actionsPanel);
        }
        NonOpaquePanel titlePanel = nonOpaquePanel;
        return new Item(this.userAvatar(details2.getAuthor()), (JComponent)titlePanel, (JComponent)contentPanel, null, 8, null);
    }

    private final Item createComponent(GHIssueComment comment) {
        NonOpaquePanel nonOpaquePanel;
        NonOpaquePanel nonOpaquePanel2;
        HtmlEditorPane textPane = new HtmlEditorPane(GHMarkdownToHtmlConverterKt.convertToHtml(comment.getBody(), this.project));
        GHEditableHtmlPaneHandle panelHandle2 = new GHEditableHtmlPaneHandle(this.project, (JComponent)((Object)textPane), (Function0<String>)((Function0)new GHPRTimelineItemComponentFactory$createComponent$panelHandle$3(comment)), (Function1<? super String, ? extends CompletableFuture<? extends Object>>)((Function1)new Function1<String, CompletableFuture<? extends Object>>(this, comment, textPane){
            final /* synthetic */ GHPRTimelineItemComponentFactory this$0;
            final /* synthetic */ GHIssueComment $comment;
            final /* synthetic */ HtmlEditorPane $textPane;

            @NotNull
            public final CompletableFuture<? extends Object> invoke(@NotNull String newText) {
                return CompletableFutureUtil.successOnEdt$default((CompletableFutureUtil)CompletableFutureUtil.INSTANCE, GHPRTimelineItemComponentFactory.access$getCommentsDataProvider$p(this.this$0).updateComment((ProgressIndicator)new EmptyProgressIndicator(), this.$comment.getId(), newText), null, (Function1)((Function1)new Function1<String, Unit>(this){
                    final /* synthetic */ createComponent.panelHandle.4 this$0;

                    public final void invoke(@NotNull String it) {
                        this.this$0.$textPane.setBody(GHMarkdownToHtmlConverterKt.convertToHtml(it, GHPRTimelineItemComponentFactory.access$getProject$p(this.this$0.this$0)));
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                }), (int)1, null);
            }
            {
                this.this$0 = gHPRTimelineItemComponentFactory;
                this.$comment = gHIssueComment;
                this.$textPane = htmlEditorPane;
                super(1);
            }
        }));
        NonOpaquePanel $this$apply = nonOpaquePanel2 = new NonOpaquePanel((LayoutManager)new HorizontalLayout(JBUIScale.scale((int)8)));
        boolean bl = false;
        if (comment.getViewerCanUpdate()) {
            $this$apply.add((Component)GHTextActions.INSTANCE.createEditButton(panelHandle2));
        }
        if (comment.getViewerCanDelete()) {
            $this$apply.add((Component)GHTextActions.INSTANCE.createDeleteButton((Function0<? extends CompletableFuture<? extends Object>>)((Function0)new Function0<CompletableFuture<? extends Object>>(this, comment, panelHandle2){
                final /* synthetic */ GHPRTimelineItemComponentFactory this$0;
                final /* synthetic */ GHIssueComment $comment$inlined;
                final /* synthetic */ GHEditableHtmlPaneHandle $panelHandle$inlined;
                {
                    this.this$0 = gHPRTimelineItemComponentFactory;
                    this.$comment$inlined = gHIssueComment;
                    this.$panelHandle$inlined = gHEditableHtmlPaneHandle;
                    super(0);
                }

                @NotNull
                public final CompletableFuture<? extends Object> invoke() {
                    return GHPRTimelineItemComponentFactory.access$getCommentsDataProvider$p(this.this$0).deleteComment((ProgressIndicator)new EmptyProgressIndicator(), this.$comment$inlined.getId());
                }
            })));
        }
        NonOpaquePanel actionsPanel = nonOpaquePanel2;
        NonOpaquePanel $this$apply2 = nonOpaquePanel = new NonOpaquePanel((LayoutManager)new HorizontalLayout(JBUIScale.scale((int)12)));
        boolean bl2 = false;
        $this$apply2.add((Component)Companion.actionTitle(comment.getAuthor(), GithubBundle.message("pull.request.timeline.commented", new Object[0]), comment.getCreatedAt()));
        if (actionsPanel.getComponentCount() > 0) {
            $this$apply2.add((Component)actionsPanel);
        }
        NonOpaquePanel titlePanel = nonOpaquePanel;
        return new Item(this.userAvatar(comment.getAuthor()), (JComponent)titlePanel, (JComponent)panelHandle2.getPanel(), null, 8, null);
    }

    private final Item createComponent(GHPullRequestReview review) {
        Icon icon;
        String string;
        NonOpaquePanel nonOpaquePanel;
        GHPRReviewThreadsModel reviewThreadsModel = this.reviewsThreadsModelsProvider.getReviewThreadsModel(review.getId());
        GHEditableHtmlPaneHandle panelHandle2 = null;
        CharSequence charSequence = review.getBody();
        if (charSequence.length() > 0) {
            HtmlEditorPane textPane = new HtmlEditorPane(GHMarkdownToHtmlConverterKt.convertToHtml(review.getBody(), this.project));
            panelHandle2 = new GHEditableHtmlPaneHandle(this.project, (JComponent)((Object)textPane), (Function0<String>)((Function0)new GHPRTimelineItemComponentFactory$createComponent$2(review)), (Function1<? super String, ? extends CompletableFuture<? extends Object>>)((Function1)new Function1<String, CompletableFuture<? extends Object>>(this, review, textPane){
                final /* synthetic */ GHPRTimelineItemComponentFactory this$0;
                final /* synthetic */ GHPullRequestReview $review;
                final /* synthetic */ HtmlEditorPane $textPane;

                @NotNull
                public final CompletableFuture<? extends Object> invoke(@NotNull String newText) {
                    return CompletableFutureUtil.successOnEdt$default((CompletableFutureUtil)CompletableFutureUtil.INSTANCE, GHPRTimelineItemComponentFactory.access$getReviewDataProvider$p(this.this$0).updateReviewBody((ProgressIndicator)new EmptyProgressIndicator(), this.$review.getId(), newText), null, (Function1)((Function1)new Function1<String, Unit>(this){
                        final /* synthetic */ createComponent.3 this$0;

                        public final void invoke(@NotNull String it) {
                            this.this$0.$textPane.setBody(GHMarkdownToHtmlConverterKt.convertToHtml(it, GHPRTimelineItemComponentFactory.access$getProject$p(this.this$0.this$0)));
                        }
                        {
                            this.this$0 = var1_1;
                            super(1);
                        }
                    }), (int)1, null);
                }
                {
                    this.this$0 = gHPRTimelineItemComponentFactory;
                    this.$review = gHPullRequestReview;
                    this.$textPane = htmlEditorPane;
                    super(1);
                }
            }));
        } else {
            panelHandle2 = null;
        }
        NonOpaquePanel $this$apply = nonOpaquePanel = new NonOpaquePanel((LayoutManager)new HorizontalLayout(JBUIScale.scale((int)8)));
        boolean bl = false;
        if (panelHandle2 != null && review.getViewerCanUpdate()) {
            $this$apply.add((Component)GHTextActions.INSTANCE.createEditButton(panelHandle2));
        }
        NonOpaquePanel actionsPanel = nonOpaquePanel;
        NonOpaquePanel $this$apply2 = $this$apply = new NonOpaquePanel((LayoutManager)new VerticalLayout(12));
        boolean bl2 = false;
        $this$apply2.setBorder((Border)JBUI.Borders.emptyTop((int)4));
        if (panelHandle2 != null) {
            $this$apply2.add((Component)panelHandle2.getPanel());
        }
        $this$apply2.add((Component)GHPRReviewThreadsPanel.INSTANCE.create(reviewThreadsModel, (Function1<? super GHPRReviewThreadModel, ? extends JComponent>)((Function1)new Function1<GHPRReviewThreadModel, JComponent>(this, panelHandle2, reviewThreadsModel){
            final /* synthetic */ GHPRTimelineItemComponentFactory this$0;
            final /* synthetic */ GHEditableHtmlPaneHandle $panelHandle$inlined;
            final /* synthetic */ GHPRReviewThreadsModel $reviewThreadsModel$inlined;
            {
                this.this$0 = gHPRTimelineItemComponentFactory;
                this.$panelHandle$inlined = gHEditableHtmlPaneHandle;
                this.$reviewThreadsModel$inlined = gHPRReviewThreadsModel;
                super(1);
            }

            @NotNull
            public final JComponent invoke(@NotNull GHPRReviewThreadModel it) {
                return GHPRReviewThreadComponent.INSTANCE.createWithDiff(GHPRTimelineItemComponentFactory.access$getProject$p(this.this$0), it, GHPRTimelineItemComponentFactory.access$getReviewDataProvider$p(this.this$0), GHPRTimelineItemComponentFactory.access$getAvatarIconsProvider$p(this.this$0), GHPRTimelineItemComponentFactory.access$getReviewDiffComponentFactory$p(this.this$0), GHPRTimelineItemComponentFactory.access$getSelectInToolWindowHelper$p(this.this$0), GHPRTimelineItemComponentFactory.access$getSuggestedChangeHelper$p(this.this$0), GHPRTimelineItemComponentFactory.access$getCurrentUser$p(this.this$0));
            }
        })));
        NonOpaquePanel contentPanel = $this$apply;
        switch (GHPRTimelineItemComponentFactory$WhenMappings.$EnumSwitchMapping$0[review.getState().ordinal()]) {
            case 1: {
                string = GithubBundle.message("pull.request.timeline.approved.changes", new Object[0]);
                break;
            }
            case 2: {
                string = GithubBundle.message("pull.request.timeline.requested.changes", new Object[0]);
                break;
            }
            case 3: {
                string = GithubBundle.message("pull.request.timeline.started.review", new Object[0]);
                break;
            }
            case 4: 
            case 5: {
                string = GithubBundle.message("pull.request.timeline.reviewed", new Object[0]);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        String actionText = string;
        NonOpaquePanel $this$apply3 = bl2 = new NonOpaquePanel((LayoutManager)new HorizontalLayout(JBUIScale.scale((int)12)));
        boolean bl3 = false;
        $this$apply3.add((Component)Companion.actionTitle(this.avatarIconsProvider, review.getAuthor(), actionText, review.getCreatedAt()));
        if (actionsPanel.getComponentCount() > 0) {
            $this$apply3.add((Component)actionsPanel);
        }
        NonOpaquePanel titlePanel = bl2;
        switch (GHPRTimelineItemComponentFactory$WhenMappings.$EnumSwitchMapping$1[review.getState().ordinal()]) {
            case 1: {
                icon = GithubIcons.ReviewAccepted;
                break;
            }
            case 2: {
                icon = GithubIcons.ReviewRejected;
                break;
            }
            case 3: {
                icon = GithubIcons.Review;
                break;
            }
            case 4: {
                icon = GithubIcons.Review;
                break;
            }
            case 5: {
                icon = GithubIcons.Review;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        Icon icon2 = icon;
        return new Item(icon2, (JComponent)titlePanel, (JComponent)contentPanel, NOT_DEFINED_SIZE);
    }

    private final JLabel userAvatar(GHActor user) {
        return Companion.userAvatar(this.avatarIconsProvider, user);
    }

    private final JLabel userAvatar(GHGitActor user) {
        GHGitActor gHGitActor = user;
        return (JLabel)new LinkLabel("", this.avatarIconsProvider.getIcon(gHGitActor != null ? gHGitActor.getAvatarUrl() : null), new LinkListener(user){
            final /* synthetic */ GHGitActor $user;

            public final void linkSelected(LinkLabel<Object> $noName_0, Object $noName_1) {
                block0: {
                    Object object;
                    Object object2 = this.$user;
                    if (object2 == null || (object2 = ((GHGitActor)object2).getUrl()) == null) break block0;
                    Object it = object = object2;
                    boolean bl = false;
                    BrowserUtil.browse((String)it);
                }
            }
            {
                this.$user = gHGitActor;
            }
        });
    }

    public GHPRTimelineItemComponentFactory(@NotNull Project project, @NotNull GHPRDetailsDataProvider detailsDataProvider, @NotNull GHPRCommentsDataProvider commentsDataProvider, @NotNull GHPRReviewDataProvider reviewDataProvider, @NotNull GHAvatarIconsProvider avatarIconsProvider, @NotNull GHPRReviewsThreadsModelsProvider reviewsThreadsModelsProvider, @NotNull GHPRReviewThreadDiffComponentFactory reviewDiffComponentFactory, @NotNull GHPRTimelineEventComponentFactory<GHPRTimelineEvent> eventComponentFactory, @NotNull GHPRSelectInToolWindowHelper selectInToolWindowHelper, @NotNull GHPRSuggestedChangeHelper suggestedChangeHelper, @NotNull GHUser currentUser) {
        this.project = project;
        this.detailsDataProvider = detailsDataProvider;
        this.commentsDataProvider = commentsDataProvider;
        this.reviewDataProvider = reviewDataProvider;
        this.avatarIconsProvider = avatarIconsProvider;
        this.reviewsThreadsModelsProvider = reviewsThreadsModelsProvider;
        this.reviewDiffComponentFactory = reviewDiffComponentFactory;
        this.eventComponentFactory = eventComponentFactory;
        this.selectInToolWindowHelper = selectInToolWindowHelper;
        this.suggestedChangeHelper = suggestedChangeHelper;
        this.currentUser = currentUser;
    }

    static {
        Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(GHPRTimelineItemComponentFactory.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
        NOT_DEFINED_SIZE = new Dimension(-1, -1);
    }

    public static final /* synthetic */ GHPRSelectInToolWindowHelper access$getSelectInToolWindowHelper$p(GHPRTimelineItemComponentFactory $this) {
        return $this.selectInToolWindowHelper;
    }

    public static final /* synthetic */ GHPRDetailsDataProvider access$getDetailsDataProvider$p(GHPRTimelineItemComponentFactory $this) {
        return $this.detailsDataProvider;
    }

    public static final /* synthetic */ Project access$getProject$p(GHPRTimelineItemComponentFactory $this) {
        return $this.project;
    }

    public static final /* synthetic */ GHPRCommentsDataProvider access$getCommentsDataProvider$p(GHPRTimelineItemComponentFactory $this) {
        return $this.commentsDataProvider;
    }

    public static final /* synthetic */ GHPRReviewDataProvider access$getReviewDataProvider$p(GHPRTimelineItemComponentFactory $this) {
        return $this.reviewDataProvider;
    }

    public static final /* synthetic */ GHAvatarIconsProvider access$getAvatarIconsProvider$p(GHPRTimelineItemComponentFactory $this) {
        return $this.avatarIconsProvider;
    }

    public static final /* synthetic */ GHPRReviewThreadDiffComponentFactory access$getReviewDiffComponentFactory$p(GHPRTimelineItemComponentFactory $this) {
        return $this.reviewDiffComponentFactory;
    }

    public static final /* synthetic */ GHPRSuggestedChangeHelper access$getSuggestedChangeHelper$p(GHPRTimelineItemComponentFactory $this) {
        return $this.suggestedChangeHelper;
    }

    public static final /* synthetic */ GHUser access$getCurrentUser$p(GHPRTimelineItemComponentFactory $this) {
        return $this.currentUser;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB-\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tB+\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\fR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRTimelineItemComponentFactory$Item;", "Ljavax/swing/JPanel;", "markerIcon", "Ljavax/swing/Icon;", "title", "Ljavax/swing/JComponent;", "content", "size", "Ljava/awt/Dimension;", "(Ljavax/swing/Icon;Ljavax/swing/JComponent;Ljavax/swing/JComponent;Ljava/awt/Dimension;)V", "marker", "Ljavax/swing/JLabel;", "(Ljavax/swing/JLabel;Ljavax/swing/JComponent;Ljavax/swing/JComponent;Ljava/awt/Dimension;)V", "getMarker", "()Ljavax/swing/JLabel;", "Companion", "intellij.vcs.github"})
    public static final class Item
    extends JPanel {
        @NotNull
        private final JLabel marker;
        @NotNull
        public static final Companion Companion = new Companion(null);

        @NotNull
        public final JLabel getMarker() {
            return this.marker;
        }

        /*
         * WARNING - void declaration
         */
        public Item(@NotNull JLabel marker, @NotNull JComponent title, @Nullable JComponent content2, @NotNull Dimension size) {
            void $this$apply;
            MigLayout migLayout;
            this.marker = marker;
            this.setOpaque(false);
            MigLayout migLayout2 = migLayout = new MigLayout(new LC().gridGap("0", "0").insets("0", "0", "0", "0").fill());
            Item item2 = this;
            boolean bl = false;
            $this$apply.setColumnConstraints((Object)("[]" + JBUIScale.scale((int)8) + "[]"));
            Unit unit = Unit.INSTANCE;
            item2.setLayout((LayoutManager)migLayout);
            this.add((Component)this.marker, new CC().pushY());
            this.add((Component)title, new CC().pushX());
            if (content2 != null) {
                this.add((Component)content2, Item.Companion.maxWidth(new CC().newline().skip().grow().push(), size));
            }
        }

        public /* synthetic */ Item(JLabel jLabel, JComponent jComponent, JComponent jComponent2, Dimension dimension, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                jComponent2 = null;
            }
            if ((n & 8) != 0) {
                dimension = Companion.getDefaultSize();
            }
            this(jLabel, jComponent, jComponent2, dimension);
        }

        public Item(@NotNull Icon markerIcon, @NotNull JComponent title, @Nullable JComponent content2, @NotNull Dimension size) {
            this(Item.Companion.createMarkerLabel(markerIcon), title, content2, size);
        }

        public /* synthetic */ Item(Icon icon, JComponent jComponent, JComponent jComponent2, Dimension dimension, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                jComponent2 = null;
            }
            if ((n & 8) != 0) {
                dimension = Companion.getDefaultSize();
            }
            this(icon, jComponent, jComponent2, dimension);
        }

        @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u001c\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\b*\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\f"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRTimelineItemComponentFactory$Item$Companion;", "", "()V", "createMarkerLabel", "Ljavax/swing/JLabel;", "markerIcon", "Ljavax/swing/Icon;", "maxWidth", "Lnet/miginfocom/layout/CC;", "kotlin.jvm.PlatformType", "dimension", "Ljava/awt/Dimension;", "intellij.vcs.github"})
        public static final class Companion {
            private final CC maxWidth(CC $this$maxWidth, Dimension dimension) {
                return dimension.width > 0 ? $this$maxWidth.maxWidth(String.valueOf(dimension.width)) : $this$maxWidth;
            }

            private final JLabel createMarkerLabel(Icon markerIcon) {
                JLabel jLabel;
                JLabel $this$apply = jLabel = new JLabel(markerIcon);
                boolean bl = false;
                float verticalGap = markerIcon.getIconHeight() < 20 ? (20.0f - (float)markerIcon.getIconHeight()) / (float)2 : 0.0f;
                float horizontalGap = markerIcon.getIconWidth() < 20 ? (20.0f - (float)markerIcon.getIconWidth()) / (float)2 : 0.0f;
                $this$apply.setBorder((Border)JBUI.Borders.empty((int)((int)Math.floor(verticalGap)), (int)((int)Math.floor(horizontalGap)), (int)((int)Math.ceil(verticalGap)), (int)((int)Math.ceil(horizontalGap))));
                return jLabel;
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ*\u0010\b\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\b\u0001\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0006\u0010\u0012\u001a\u00020\u0007J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0015\u001a\u0004\u0018\u00010\u000bR\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRTimelineItemComponentFactory$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "NOT_DEFINED_SIZE", "Ljava/awt/Dimension;", "actionTitle", "Ljavax/swing/JComponent;", "actor", "Lorg/jetbrains/plugins/github/api/data/GHActor;", "actionHTML", "", "date", "Ljava/util/Date;", "avatarIconsProvider", "Lorg/jetbrains/plugins/github/ui/avatars/GHAvatarIconsProvider;", "getDefaultSize", "userAvatar", "Ljavax/swing/JLabel;", "user", "intellij.vcs.github"})
    public static final class Companion {
        @NotNull
        public final Dimension getDefaultSize() {
            return new Dimension(GHUIUtil.INSTANCE.getPRTimelineWidth(), -1);
        }

        @NotNull
        public final JLabel userAvatar(@NotNull GHAvatarIconsProvider avatarIconsProvider, @Nullable GHActor user) {
            GHActor gHActor = user;
            return (JLabel)new LinkLabel("", avatarIconsProvider.getIcon(gHActor != null ? gHActor.getAvatarUrl() : null), new LinkListener(user){
                final /* synthetic */ GHActor $user;

                public final void linkSelected(LinkLabel<Object> $noName_0, Object $noName_1) {
                    block0: {
                        Object object;
                        Object object2 = this.$user;
                        if (object2 == null || (object2 = object2.getUrl()) == null) break block0;
                        Object it = object = object2;
                        boolean bl = false;
                        BrowserUtil.browse((String)it);
                    }
                }
                {
                    this.$user = gHActor;
                }
            });
        }

        @NotNull
        public final JComponent actionTitle(@NotNull GHAvatarIconsProvider avatarIconsProvider, @Nullable GHActor actor, @Language(value="HTML") @NotNull String actionHTML, @NotNull Date date) {
            HorizontalBox horizontalBox;
            HorizontalBox $this$apply = horizontalBox = new HorizontalBox();
            boolean bl = false;
            $this$apply.add((Component)Companion.userAvatar(avatarIconsProvider, actor));
            $this$apply.add(Box.createRigidArea((Dimension)new JBDimension(8, 0)));
            $this$apply.add((Component)Companion.actionTitle(actor, actionHTML, date));
            return (JComponent)horizontalBox;
        }

        @NotNull
        public final JComponent actionTitle(@Nullable GHActor actor, @NotNull String actionHTML, @NotNull Date date) {
            HtmlEditorPane htmlEditorPane;
            GHActor gHActor = actor;
            String string = gHActor != null ? gHActor.getUrl() : null;
            Object object = actor;
            if (object == null || (object = object.getLogin()) == null) {
                object = "unknown";
            }
            String text = "<a href='" + string + "'>" + (String)object + "</a> " + actionHTML + " " + GHUIUtil.INSTANCE.formatActionDate(date);
            HtmlEditorPane $this$apply = htmlEditorPane = new HtmlEditorPane(text);
            boolean bl = false;
            $this$apply.setForeground(UIUtil.getContextHelpForeground());
            return (JComponent)((Object)htmlEditorPane);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

