/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest.ui.timeline;

import com.intellij.collaboration.async.CompletableFutureUtil;
import com.intellij.collaboration.ui.SingleValueModel;
import com.intellij.collaboration.ui.codereview.timeline.comment.CommentTextFieldModel;
import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.componentsList.components.ScrollablePanel;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.AnimatedIcon;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import net.miginfocom.layout.AC;
import net.miginfocom.layout.CC;
import net.miginfocom.layout.LC;
import net.miginfocom.swing.MigLayout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.data.GHRepositoryPermissionLevel;
import org.jetbrains.plugins.github.api.data.GHUser;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequest;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequestShort;
import org.jetbrains.plugins.github.api.data.pullrequest.timeline.GHPRTimelineItem;
import org.jetbrains.plugins.github.i18n.GithubBundle;
import org.jetbrains.plugins.github.pullrequest.GHPRTimelineFileEditor;
import org.jetbrains.plugins.github.pullrequest.comment.ui.GHCommentTextFieldFactory;
import org.jetbrains.plugins.github.pullrequest.comment.ui.GHCommentTextFieldModel;
import org.jetbrains.plugins.github.pullrequest.data.GHListLoader;
import org.jetbrains.plugins.github.pullrequest.data.GHPRIdentifier;
import org.jetbrains.plugins.github.pullrequest.data.provider.GHPRCommentsDataProvider;
import org.jetbrains.plugins.github.pullrequest.data.provider.GHPRDetailsDataProvider;
import org.jetbrains.plugins.github.pullrequest.data.provider.GHPRReviewDataProvider;
import org.jetbrains.plugins.github.pullrequest.ui.GHApiLoadingErrorHandler;
import org.jetbrains.plugins.github.pullrequest.ui.changes.GHPRSuggestedChangeHelper;
import org.jetbrains.plugins.github.pullrequest.ui.timeline.GHPRReviewThreadDiffComponentFactory;
import org.jetbrains.plugins.github.pullrequest.ui.timeline.GHPRReviewsThreadsModelsProvider;
import org.jetbrains.plugins.github.pullrequest.ui.timeline.GHPRReviewsThreadsModelsProviderImpl;
import org.jetbrains.plugins.github.pullrequest.ui.timeline.GHPRSelectInToolWindowHelper;
import org.jetbrains.plugins.github.pullrequest.ui.timeline.GHPRTimelineComponent;
import org.jetbrains.plugins.github.pullrequest.ui.timeline.GHPRTimelineEventComponentFactoryImpl;
import org.jetbrains.plugins.github.pullrequest.ui.timeline.GHPRTimelineItemComponentFactory;
import org.jetbrains.plugins.github.pullrequest.ui.timeline.GHPRTimelineMergingModel;
import org.jetbrains.plugins.github.pullrequest.ui.timeline.GHPRTitleComponent;
import org.jetbrains.plugins.github.ui.avatars.GHAvatarIconsProvider;
import org.jetbrains.plugins.github.ui.component.GHHandledErrorPanelModel;
import org.jetbrains.plugins.github.ui.component.GHHtmlErrorPanel;
import org.jetbrains.plugins.github.ui.util.GHUIUtil;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u0014\u001a\u00020\u0015J \u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002JH\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u00182\u0006\u0010\"\u001a\u00020#2\u0006\u0010\r\u001a\u00020$2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010%\u001a\u00020&2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0011\u001a\u00070\u0012\u00a2\u0006\u0002\b\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRFileEditorComponentFactory;", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lorg/jetbrains/plugins/github/pullrequest/GHPRTimelineFileEditor;", "currentDetails", "Lorg/jetbrains/plugins/github/api/data/pullrequest/GHPullRequestShort;", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/plugins/github/pullrequest/GHPRTimelineFileEditor;Lorg/jetbrains/plugins/github/api/data/pullrequest/GHPullRequestShort;)V", "detailsModel", "Lcom/intellij/collaboration/ui/SingleValueModel;", "errorModel", "Lorg/jetbrains/plugins/github/ui/component/GHHandledErrorPanelModel;", "reviewThreadsModelsProvider", "Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRReviewsThreadsModelsProviderImpl;", "timelineModel", "Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRTimelineMergingModel;", "uiDisposable", "Lcom/intellij/openapi/Disposable;", "Lorg/jetbrains/annotations/NotNull;", "create", "Ljavax/swing/JComponent;", "createCommentField", "commentService", "Lorg/jetbrains/plugins/github/pullrequest/data/provider/GHPRCommentsDataProvider;", "avatarIconsProvider", "Lorg/jetbrains/plugins/github/ui/avatars/GHAvatarIconsProvider;", "currentUser", "Lorg/jetbrains/plugins/github/api/data/GHUser;", "createItemComponentFactory", "Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRTimelineItemComponentFactory;", "detailsDataProvider", "Lorg/jetbrains/plugins/github/pullrequest/data/provider/GHPRDetailsDataProvider;", "commentsDataProvider", "reviewDataProvider", "Lorg/jetbrains/plugins/github/pullrequest/data/provider/GHPRReviewDataProvider;", "Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRReviewsThreadsModelsProvider;", "suggestedChangeHelper", "Lorg/jetbrains/plugins/github/pullrequest/ui/changes/GHPRSuggestedChangeHelper;", "intellij.vcs.github"})
public final class GHPRFileEditorComponentFactory {
    private final Disposable uiDisposable;
    private final SingleValueModel<GHPullRequestShort> detailsModel;
    private final GHHandledErrorPanelModel errorModel;
    private final GHPRTimelineMergingModel timelineModel;
    private final GHPRReviewsThreadsModelsProviderImpl reviewThreadsModelsProvider;
    private final Project project;
    private final GHPRTimelineFileEditor editor;

    @NotNull
    public final JComponent create() {
        JLabel jLabel;
        GHPRTimelineComponent gHPRTimelineComponent;
        Wrapper mainPanel = new Wrapper();
        DataManager.registerDataProvider((JComponent)((JComponent)mainPanel), (DataProvider)new DataProvider(this){
            final /* synthetic */ GHPRFileEditorComponentFactory this$0;

            @Nullable
            public final Object getData(@NotNull String it) {
                return PlatformDataKeys.UI_DISPOSABLE.is(it) ? GHPRFileEditorComponentFactory.access$getUiDisposable$p(this.this$0) : null;
            }
            {
                this.this$0 = gHPRFileEditorComponentFactory;
            }
        });
        JComponent header = GHPRTitleComponent.INSTANCE.create(this.project, this.detailsModel, this.editor.getDetailsData());
        GHPRSuggestedChangeHelper suggestedChangesHelper = new GHPRSuggestedChangeHelper(this.project, this.uiDisposable, this.editor.getRepositoryDataService().getRemoteCoordinates().getRepository(), this.editor.getReviewData(), this.editor.getDetailsData());
        GHPRTimelineComponent $this$apply = gHPRTimelineComponent = new GHPRTimelineComponent(this.detailsModel, this.timelineModel, this.createItemComponentFactory(this.project, this.editor.getDetailsData(), this.editor.getCommentsData(), this.editor.getReviewData(), this.reviewThreadsModelsProvider, this.editor.getAvatarIconsProvider(), suggestedChangesHelper, this.editor.getSecurityService().getCurrentUser()));
        boolean bl = false;
        $this$apply.setBorder((Border)JBUI.Borders.empty((int)16, (int)0));
        GHPRTimelineComponent timeline = gHPRTimelineComponent;
        JComponent errorPanel = GHHtmlErrorPanel.create$default(GHHtmlErrorPanel.INSTANCE, this.errorModel, 0, 2, null);
        GHListLoader<GHPRTimelineItem> timelineLoader = this.editor.getTimelineLoader();
        JLabel $this$apply2 = jLabel = new JLabel((Icon)new AnimatedIcon.Default());
        boolean bl2 = false;
        $this$apply2.setBorder((Border)JBUI.Borders.empty((int)8, (int)0));
        $this$apply2.setVisible(timelineLoader.getLoading());
        JLabel loadingIcon = jLabel;
        timelineLoader.addLoadingStateChangeListener(this.uiDisposable, (Function0<Unit>)((Function0)new Function0<Unit>(loadingIcon, timelineLoader){
            final /* synthetic */ JLabel $loadingIcon;
            final /* synthetic */ GHListLoader $timelineLoader;

            public final void invoke() {
                this.$loadingIcon.setVisible(this.$timelineLoader.getLoading());
            }
            {
                this.$loadingIcon = jLabel;
                this.$timelineLoader = gHListLoader;
                super(0);
            }
        }));
        $this$apply2 = new ScrollablePanel();
        JComponent $this$apply3 = $this$apply2;
        boolean bl3 = false;
        $this$apply3.setOpaque(false);
        $this$apply3.setBorder((Border)JBUI.Borders.empty((int)24, (int)20));
        int maxWidth = GHUIUtil.INSTANCE.getPRTimelineWidth();
        $this$apply3.setLayout((LayoutManager)new MigLayout(new LC().gridGap("0", "0").insets("0", "0", "0", "0").fill().flowY(), new AC().grow().gap("push")));
        $this$apply3.add(header, new CC().growX().maxWidth(String.valueOf(maxWidth)));
        $this$apply3.add((Component)((Object)timeline), new CC().growX().minWidth(""));
        int fullTimelineWidth = JBUIScale.scale((int)20) + maxWidth;
        $this$apply3.add(errorPanel, new CC().hideMode(2).width(String.valueOf(fullTimelineWidth)));
        $this$apply3.add(loadingIcon, new CC().hideMode(2).width(String.valueOf(fullTimelineWidth)));
        if (this.editor.getSecurityService().currentUserHasPermissionLevel(GHRepositoryPermissionLevel.READ)) {
            JComponent commentField = this.createCommentField(this.editor.getCommentsData(), this.editor.getAvatarIconsProvider(), this.editor.getSecurityService().getCurrentUser());
            $this$apply3.add(commentField, new CC().growX().pushX().maxWidth(String.valueOf(fullTimelineWidth)));
        }
        JLabel timelinePanel = $this$apply2;
        JComponent $this$apply4 = $this$apply3 = ScrollPaneFactory.createScrollPane((Component)timelinePanel, (boolean)true);
        boolean bl4 = false;
        $this$apply4.setOpaque(false);
        ((JScrollPane)$this$apply4).getViewport().setOpaque(false);
        ((JScrollPane)$this$apply4).getVerticalScrollBar().getModel().addChangeListener(new ChangeListener((JScrollPane)$this$apply4, timelineLoader){
            private boolean firstScroll;
            final /* synthetic */ JScrollPane $this_apply;
            final /* synthetic */ GHListLoader $timelineLoader$inlined;
            {
                this.$this_apply = $receiver;
                this.$timelineLoader$inlined = gHListLoader;
                this.firstScroll = true;
            }

            public void stateChanged(@NotNull ChangeEvent e) {
                if (this.firstScroll && this.$this_apply.getVerticalScrollBar().getValue() > 0) {
                    this.firstScroll = false;
                }
                if (!this.firstScroll && this.$timelineLoader$inlined.canLoadMore()) {
                    GHListLoader.DefaultImpls.loadMore$default(this.$timelineLoader$inlined, false, 1, null);
                }
            }
        });
        JComponent scrollPane = $this$apply3;
        UiNotifyConnector.doWhenFirstShown((JComponent)scrollPane, (Runnable)new Runnable(timelineLoader){
            final /* synthetic */ GHListLoader $timelineLoader;

            public final void run() {
                GHListLoader.DefaultImpls.loadMore$default(this.$timelineLoader, false, 1, null);
            }
            {
                this.$timelineLoader = gHListLoader;
            }
        });
        timelineLoader.addDataListener(this.uiDisposable, new GHListLoader.ListDataListener((JScrollPane)scrollPane, timelineLoader){
            final /* synthetic */ JScrollPane $scrollPane;
            final /* synthetic */ GHListLoader $timelineLoader;

            public void onAllDataRemoved() {
                if (this.$scrollPane.isShowing()) {
                    GHListLoader.DefaultImpls.loadMore$default(this.$timelineLoader, false, 1, null);
                }
            }
            {
                this.$scrollPane = $captured_local_variable$0;
                this.$timelineLoader = $captured_local_variable$1;
            }

            public void onDataAdded(int startIdx) {
                GHListLoader.ListDataListener.DefaultImpls.onDataAdded(this, startIdx);
            }

            public void onDataUpdated(int idx) {
                GHListLoader.ListDataListener.DefaultImpls.onDataUpdated(this, idx);
            }

            public void onDataRemoved(@NotNull Object data) {
                GHListLoader.ListDataListener.DefaultImpls.onDataRemoved(this, data);
            }
        });
        mainPanel.setContent(scrollPane);
        ActionManager actionManager = ActionManager.getInstance();
        actionManager.getAction("Github.PullRequest.Timeline.Update").registerCustomShortcutSet(scrollPane, this.uiDisposable);
        String groupId = "Github.PullRequest.Timeline.Popup";
        PopupHandler.installPopupMenu((JComponent)scrollPane, (String)groupId, (String)groupId);
        return (JComponent)mainPanel;
    }

    private final JComponent createCommentField(GHPRCommentsDataProvider commentService, GHAvatarIconsProvider avatarIconsProvider, GHUser currentUser) {
        GHCommentTextFieldModel model2 = new GHCommentTextFieldModel(this.project, (Function1)new Function1<String, CompletableFuture<?>>(commentService){
            final /* synthetic */ GHPRCommentsDataProvider $commentService;

            @NotNull
            public final CompletableFuture<?> invoke(@NotNull String it) {
                return this.$commentService.addComment((ProgressIndicator)new EmptyProgressIndicator(), it);
            }
            {
                this.$commentService = gHPRCommentsDataProvider;
                super(1);
            }
        });
        return GHCommentTextFieldFactory.create$default(new GHCommentTextFieldFactory((CommentTextFieldModel)model2), avatarIconsProvider, currentUser, null, null, 12, null);
    }

    private final GHPRTimelineItemComponentFactory createItemComponentFactory(Project project, GHPRDetailsDataProvider detailsDataProvider, GHPRCommentsDataProvider commentsDataProvider, GHPRReviewDataProvider reviewDataProvider, GHPRReviewsThreadsModelsProvider reviewThreadsModelsProvider, GHAvatarIconsProvider avatarIconsProvider, GHPRSuggestedChangeHelper suggestedChangeHelper, GHUser currentUser) {
        GHPRSelectInToolWindowHelper selectInToolWindowHelper = new GHPRSelectInToolWindowHelper(project, (GHPRIdentifier)this.detailsModel.getValue());
        GHPRReviewThreadDiffComponentFactory diffFactory = new GHPRReviewThreadDiffComponentFactory(project, EditorFactory.getInstance());
        GHPRTimelineEventComponentFactoryImpl eventsFactory = new GHPRTimelineEventComponentFactoryImpl(avatarIconsProvider);
        return new GHPRTimelineItemComponentFactory(project, detailsDataProvider, commentsDataProvider, reviewDataProvider, avatarIconsProvider, reviewThreadsModelsProvider, diffFactory, eventsFactory, selectInToolWindowHelper, suggestedChangeHelper, currentUser);
    }

    /*
     * WARNING - void declaration
     */
    public GHPRFileEditorComponentFactory(@NotNull Project project, @NotNull GHPRTimelineFileEditor editor, @NotNull GHPullRequestShort currentDetails) {
        void it;
        Disposable disposable;
        this.project = project;
        this.editor = editor;
        Disposable disposable2 = disposable = Disposer.newDisposable();
        GHPRFileEditorComponentFactory gHPRFileEditorComponentFactory = this;
        boolean bl = false;
        Disposer.register((Disposable)((Disposable)this.editor), (Disposable)it);
        Unit unit = Unit.INSTANCE;
        gHPRFileEditorComponentFactory.uiDisposable = disposable;
        this.detailsModel = new SingleValueModel((Object)currentDetails);
        this.errorModel = new GHHandledErrorPanelModel(GithubBundle.message("pull.request.timeline.cannot.load", new Object[0]), new GHApiLoadingErrorHandler(this.project, this.editor.getSecurityService().getAccount(), (Function0<Unit>)((Function0)new Function0<Unit>(this.editor.getTimelineLoader()){

            public final void invoke() {
                ((GHListLoader)this.receiver).reset();
            }
        })));
        this.timelineModel = new GHPRTimelineMergingModel();
        this.reviewThreadsModelsProvider = new GHPRReviewsThreadsModelsProviderImpl(this.editor.getReviewData(), this.uiDisposable);
        this.editor.getDetailsData().loadDetails(this.uiDisposable, (Function1<? super CompletableFuture<GHPullRequest>, Unit>)((Function1)new Function1<CompletableFuture<GHPullRequest>, Unit>(){

            public final void invoke(@NotNull CompletableFuture<GHPullRequest> it) {
                CompletableFutureUtil.INSTANCE.handleOnEdt(it, uiDisposable, (Function2)new Function2<GHPullRequest, Throwable, Unit>(){

                    public final void invoke(@Nullable GHPullRequest pr, @Nullable Throwable $noName_1) {
                        if (pr != null) {
                            detailsModel.setValue((Object)pr);
                        }
                    }
                });
            }
        }));
        this.editor.getTimelineLoader().addErrorChangeListener(this.uiDisposable, (Function0<Unit>)((Function0)new Function0<Unit>(){

            public final void invoke() {
                errorModel.setError(editor.getTimelineLoader().getError());
            }
        }));
        this.errorModel.setError(this.editor.getTimelineLoader().getError());
        this.editor.getTimelineLoader().addDataListener(this.uiDisposable, new GHListLoader.ListDataListener(){

            @Override
            public void onDataAdded(int startIdx) {
                List<GHPRTimelineItem> loadedData = editor.getTimelineLoader().getLoadedData();
                timelineModel.add(loadedData.subList(startIdx, loadedData.size()));
            }

            @Override
            public void onDataUpdated(int idx) {
                List<GHPRTimelineItem> loadedData = editor.getTimelineLoader().getLoadedData();
                GHPRTimelineItem item2 = loadedData.get(idx);
                timelineModel.update(item2);
            }

            @Override
            public void onDataRemoved(@NotNull Object data) {
                if (!(data instanceof GHPRTimelineItem)) {
                    return;
                }
                timelineModel.remove((GHPRTimelineItem)data);
            }

            @Override
            public void onAllDataRemoved() {
                timelineModel.removeAll();
            }
        });
        this.timelineModel.add(this.editor.getTimelineLoader().getLoadedData());
    }
}

