/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest.ui.details;

import com.intellij.collaboration.ui.SimpleEventListener;
import com.intellij.collaboration.ui.SingleValueModel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.Consumer;
import com.intellij.util.EventDispatcher;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.vcs.log.data.DataPack;
import com.intellij.vcs.log.data.DataPackChangeListener;
import com.intellij.vcs.log.impl.VcsLogManager;
import com.intellij.vcs.log.impl.VcsProjectLog;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequest;
import org.jetbrains.plugins.github.pullrequest.data.provider.GHPRDetailsDataProvider;
import org.jetbrains.plugins.github.pullrequest.ui.details.GHPRBranchesModel;
import org.jetbrains.plugins.github.util.GithubGitHelper;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B+\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0016\u0010(\u001a\u00020)2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020)0+H\u0017J\n\u0010,\u001a\u0004\u0018\u00010\rH\u0002J\n\u0010-\u001a\u0004\u0018\u00010!H\u0002J\b\u0010.\u001a\u00020)H\u0002R\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR!\u0010\u0010\u001a\u0015\u0012\f\u0012\n \u0013*\u0004\u0018\u00010\u00120\u00120\u0011\u00a2\u0006\u0002\b\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u000fR\u0014\u0010\u0017\u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u000fR\u0014\u0010\u0019\u001a\u00020\u001a8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001bR\u0016\u0010\u001c\u001a\u0004\u0018\u00010\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u000fR\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010 \u001a\u0004\u0018\u00010!8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#R\u0016\u0010$\u001a\u0004\u0018\u00010\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010\u000fR\u0016\u0010&\u001a\u0004\u0018\u00010\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010\u000fR\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/details/GHPRBranchesModelImpl;", "Lorg/jetbrains/plugins/github/pullrequest/ui/details/GHPRBranchesModel;", "valueModel", "Lcom/intellij/collaboration/ui/SingleValueModel;", "Lorg/jetbrains/plugins/github/api/data/pullrequest/GHPullRequest;", "detailsDataProvider", "Lorg/jetbrains/plugins/github/pullrequest/data/provider/GHPRDetailsDataProvider;", "localRepository", "Lgit4idea/repo/GitRepository;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "(Lcom/intellij/collaboration/ui/SingleValueModel;Lorg/jetbrains/plugins/github/pullrequest/data/provider/GHPRDetailsDataProvider;Lgit4idea/repo/GitRepository;Lcom/intellij/openapi/Disposable;)V", "baseBranch", "", "getBaseBranch", "()Ljava/lang/String;", "changeEventDispatcher", "Lcom/intellij/util/EventDispatcher;", "Lcom/intellij/collaboration/ui/SimpleEventListener;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "headBranch", "getHeadBranch", "headRefName", "getHeadRefName", "isFork", "", "()Z", "localBranch", "getLocalBranch", "getLocalRepository", "()Lgit4idea/repo/GitRepository;", "prRemote", "Lgit4idea/repo/GitRemote;", "getPrRemote", "()Lgit4idea/repo/GitRemote;", "sshUrl", "getSshUrl", "url", "getUrl", "addAndInvokeChangeListener", "", "listener", "Lkotlin/Function0;", "determineLocalBranch", "determinePrRemote", "notifyChanged", "intellij.vcs.github"})
public final class GHPRBranchesModelImpl
implements GHPRBranchesModel {
    private final EventDispatcher<SimpleEventListener> changeEventDispatcher;
    private final SingleValueModel<GHPullRequest> valueModel;
    @NotNull
    private final GitRepository localRepository;
    private final Disposable parentDisposable;

    @Override
    @RequiresEdt
    public void addAndInvokeChangeListener(@NotNull Function0<Unit> listener2) {
        SimpleEventListener.Companion.addAndInvokeListener(this.changeEventDispatcher, this.parentDisposable, listener2);
    }

    @Override
    @NotNull
    public String getBaseBranch() {
        return ((GHPullRequest)this.valueModel.getValue()).getBaseRefName();
    }

    @Override
    @NotNull
    public String getHeadBranch() {
        Object object = this.valueModel.getValue();
        GHPullRequest $this$with = (GHPullRequest)object;
        boolean bl = false;
        if ($this$with.getHeadRepository() == null) {
            return $this$with.getHeadRefName();
        }
        if ($this$with.getHeadRepository().isFork() || Intrinsics.areEqual((Object)$this$with.getBaseRefName(), (Object)$this$with.getHeadRefName())) {
            return $this$with.getHeadRepository().getOwner().getLogin() + ":" + $this$with.getHeadRefName();
        }
        return $this$with.getHeadRefName();
    }

    @Override
    @Nullable
    public GitRemote getPrRemote() {
        return this.determinePrRemote();
    }

    @Override
    @Nullable
    public String getLocalBranch() {
        return this.determineLocalBranch();
    }

    private final String getHeadRefName() {
        return ((GHPullRequest)this.valueModel.getValue()).getHeadRefName();
    }

    private final void notifyChanged() {
        ((SimpleEventListener)this.changeEventDispatcher.getMulticaster()).eventOccurred();
    }

    private final String getUrl() {
        GHPullRequest.HeadRepository headRepository = ((GHPullRequest)this.valueModel.getValue()).getHeadRepository();
        return headRepository != null ? headRepository.getUrl() : null;
    }

    private final String getSshUrl() {
        GHPullRequest.HeadRepository headRepository = ((GHPullRequest)this.valueModel.getValue()).getHeadRepository();
        return headRepository != null ? headRepository.getSshUrl() : null;
    }

    private final boolean isFork() {
        GHPullRequest.HeadRepository headRepository = ((GHPullRequest)this.valueModel.getValue()).getHeadRepository();
        return headRepository != null ? headRepository.isFork() : false;
    }

    private final GitRemote determinePrRemote() {
        return GithubGitHelper.Companion.getInstance().findRemote(this.getLocalRepository(), this.getUrl(), this.getSshUrl());
    }

    private final String determineLocalBranch() {
        GitRemote gitRemote = this.getPrRemote();
        if (gitRemote == null) {
            return null;
        }
        GitRemote prRemote = gitRemote;
        return GithubGitHelper.Companion.getInstance().findLocalBranch(this.getLocalRepository(), prRemote, this.isFork(), this.getHeadRefName());
    }

    @Override
    @NotNull
    public GitRepository getLocalRepository() {
        return this.localRepository;
    }

    public GHPRBranchesModelImpl(@NotNull SingleValueModel<GHPullRequest> valueModel, final @NotNull GHPRDetailsDataProvider detailsDataProvider, @NotNull GitRepository localRepository, @NotNull Disposable parentDisposable) {
        this.valueModel = valueModel;
        this.localRepository = localRepository;
        this.parentDisposable = parentDisposable;
        this.changeEventDispatcher = EventDispatcher.create(SimpleEventListener.class);
        VcsProjectLog.runWhenLogIsReady((Project)this.getLocalRepository().getProject(), (Consumer)new Consumer(){

            public final void consume(final VcsLogManager it) {
                if (!Disposer.isDisposed((Disposable)parentDisposable)) {
                    final DataPackChangeListener dataPackListener2 = new DataPackChangeListener(this){
                        final /* synthetic */ 1 this$0;

                        public final void onDataPackChange(@NotNull DataPack it) {
                            GHPRBranchesModelImpl.access$notifyChanged(this.this$0.this);
                            this.this$0.detailsDataProvider.reloadDetails();
                        }
                        {
                            this.this$0 = var1_1;
                        }
                    };
                    it.getDataManager().addDataPackChangeListener(dataPackListener2);
                    Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

                        public final void dispose() {
                            it.getDataManager().removeDataPackChangeListener(dataPackListener2);
                        }
                    });
                }
            }
        });
    }

    public static final /* synthetic */ void access$notifyChanged(GHPRBranchesModelImpl $this) {
        $this.notifyChanged();
    }
}

