/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest.ui.changes;

import com.intellij.diff.chains.AsyncDiffRequestChain;
import com.intellij.diff.chains.DiffRequestChain;
import com.intellij.diff.chains.DiffRequestProducer;
import com.intellij.diff.comparison.ComparisonManagerImpl;
import com.intellij.diff.comparison.ComparisonPolicy;
import com.intellij.diff.comparison.iterables.DiffIterable;
import com.intellij.diff.comparison.iterables.DiffIterableUtil;
import com.intellij.diff.fragments.LineFragment;
import com.intellij.diff.tools.util.text.LineOffsets;
import com.intellij.diff.tools.util.text.LineOffsetsUtil;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.diff.util.Range;
import com.intellij.icons.AllIcons;
import com.intellij.ide.actions.NonEmptyActionGroup;
import com.intellij.openapi.ListSelection;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.diff.impl.GenericDataProvider;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.actions.diff.ChangeDiffRequestProducer;
import com.intellij.openapi.vcs.ex.RangesBuilder;
import com.intellij.openapi.vcs.history.VcsDiffUtil;
import com.intellij.util.NullableFunction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.data.GHUser;
import org.jetbrains.plugins.github.i18n.GithubBundle;
import org.jetbrains.plugins.github.pullrequest.action.GHPRActionKeys;
import org.jetbrains.plugins.github.pullrequest.comment.GHPRDiffReviewSupport;
import org.jetbrains.plugins.github.pullrequest.comment.GHPRDiffReviewSupportImpl;
import org.jetbrains.plugins.github.pullrequest.comment.action.GHPRDiffReviewResolvedThreadsToggleAction;
import org.jetbrains.plugins.github.pullrequest.comment.action.GHPRDiffReviewThreadsReloadAction;
import org.jetbrains.plugins.github.pullrequest.comment.action.GHPRDiffReviewThreadsToggleAction;
import org.jetbrains.plugins.github.pullrequest.data.GHPRChangeDiffData;
import org.jetbrains.plugins.github.pullrequest.data.GHPRChangesProvider;
import org.jetbrains.plugins.github.pullrequest.data.provider.GHPRChangesDataProvider;
import org.jetbrains.plugins.github.pullrequest.data.provider.GHPRDataProvider;
import org.jetbrains.plugins.github.pullrequest.data.service.GHPRRepositoryDataService;
import org.jetbrains.plugins.github.pullrequest.ui.changes.GHPRDiffRequestChainProducer;
import org.jetbrains.plugins.github.ui.avatars.GHAvatarIconsProvider;
import org.jetbrains.plugins.github.util.DiffRequestChainProducer;
import org.jetbrains.plugins.github.util.GHToolbarLabelAction;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ \u0010\r\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000f\u0012\u0004\u0012\u00020\u00100\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J\u001a\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0016\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00120\u001aH\u0016J\u001a\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u0012H\u0002JJ\u0010\u001d\u001a\u0018\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00100\u000f\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u000e2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00160!2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0!H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/changes/GHPRDiffRequestChainProducer;", "Lorg/jetbrains/plugins/github/util/DiffRequestChainProducer;", "project", "Lcom/intellij/openapi/project/Project;", "dataProvider", "Lorg/jetbrains/plugins/github/pullrequest/data/provider/GHPRDataProvider;", "avatarIconsProvider", "Lorg/jetbrains/plugins/github/ui/avatars/GHAvatarIconsProvider;", "repositoryDataService", "Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRRepositoryDataService;", "currentUser", "Lorg/jetbrains/plugins/github/api/data/GHUser;", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/plugins/github/pullrequest/data/provider/GHPRDataProvider;Lorg/jetbrains/plugins/github/ui/avatars/GHAvatarIconsProvider;Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRRepositoryDataService;Lorg/jetbrains/plugins/github/api/data/GHUser;)V", "createCustomContext", "", "Lcom/intellij/openapi/util/Key;", "", "change", "Lcom/intellij/openapi/vcs/changes/Change;", "getDiffComputer", "Lcom/intellij/diff/util/DiffUserDataKeysEx$DiffComputer;", "changesProvider", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRChangesProvider;", "getRequestChain", "Lcom/intellij/diff/chains/DiffRequestChain;", "changes", "Lcom/intellij/openapi/ListSelection;", "getReviewSupport", "Lorg/jetbrains/plugins/github/pullrequest/comment/GHPRDiffReviewSupport;", "loadRequestDataKeys", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "changesProviderFuture", "Ljava/util/concurrent/CompletableFuture;", "fetchFuture", "Ljava/lang/Void;", "intellij.vcs.github"})
public class GHPRDiffRequestChainProducer
implements DiffRequestChainProducer {
    private final Project project;
    private final GHPRDataProvider dataProvider;
    private final GHAvatarIconsProvider avatarIconsProvider;
    private final GHPRRepositoryDataService repositoryDataService;
    private final GHUser currentUser;

    @Override
    @NotNull
    public DiffRequestChain getRequestChain(@NotNull ListSelection<Change> changes) {
        GHPRChangesDataProvider changesData = this.dataProvider.getChangesData();
        CompletableFuture<GHPRChangesProvider> changesProviderFuture = changesData.loadChanges();
        CompletableFuture<Void> fetchFuture = CompletableFuture.allOf(changesData.fetchBaseBranch(), changesData.fetchHeadBranch());
        return (DiffRequestChain)new AsyncDiffRequestChain(this, changes, changesProviderFuture, fetchFuture){
            final /* synthetic */ GHPRDiffRequestChainProducer this$0;
            final /* synthetic */ ListSelection $changes;
            final /* synthetic */ CompletableFuture $changesProviderFuture;
            final /* synthetic */ CompletableFuture $fetchFuture;

            @NotNull
            protected ListSelection<? extends DiffRequestProducer> loadRequestProducers() {
                return this.$changes.map(new NullableFunction(this){
                    final /* synthetic */ getRequestChain.1 this$0;

                    @Nullable
                    public final ChangeDiffRequestProducer fun(Change change) {
                        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
                        Map changeDataKeys = GHPRDiffRequestChainProducer.access$loadRequestDataKeys(this.this$0.this$0, indicator, change, this.this$0.$changesProviderFuture, this.this$0.$fetchFuture);
                        Map<Key<?>, Object> customDataKeys = this.this$0.this$0.createCustomContext(change);
                        return ChangeDiffRequestProducer.create((Project)GHPRDiffRequestChainProducer.access$getProject$p(this.this$0.this$0), (Change)change, (Map)MapsKt.plus((Map)changeDataKeys, customDataKeys));
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.this$0 = this$0;
                this.$changes = $captured_local_variable$1;
                this.$changesProviderFuture = $captured_local_variable$2;
                this.$fetchFuture = $captured_local_variable$3;
            }
        };
    }

    @NotNull
    protected Map<Key<?>, Object> createCustomContext(@NotNull Change change) {
        return MapsKt.emptyMap();
    }

    /*
     * WARNING - void declaration
     */
    private final Map<Key<? extends Object>, Object> loadRequestDataKeys(ProgressIndicator indicator, Change change, CompletableFuture<GHPRChangesProvider> changesProviderFuture, CompletableFuture<Void> fetchFuture) {
        GHPRDiffReviewSupport reviewSupport;
        GHPRChangesProvider changesProvider = (GHPRChangesProvider)ProgressIndicatorUtils.awaitWithCheckCanceled((Future)changesProviderFuture, (ProgressIndicator)indicator);
        ProgressIndicatorUtils.awaitWithCheckCanceled((Future)fetchFuture, (ProgressIndicator)indicator);
        Map requestDataKeys = new LinkedHashMap();
        VcsDiffUtil.putFilePathsIntoChangeContext((Change)change, (Map)requestDataKeys);
        DiffUserDataKeysEx.DiffComputer diffComputer = this.getDiffComputer(changesProvider, change);
        if (diffComputer != null) {
            requestDataKeys.put(DiffUserDataKeysEx.CUSTOM_DIFF_COMPUTER, diffComputer);
        }
        if ((reviewSupport = this.getReviewSupport(changesProvider, change)) != null) {
            void $this$apply;
            GenericDataProvider genericDataProvider;
            requestDataKeys.put(GHPRDiffReviewSupport.Companion.getKEY(), reviewSupport);
            GenericDataProvider genericDataProvider2 = genericDataProvider = new GenericDataProvider();
            Key key = DiffUserDataKeys.DATA_PROVIDER;
            Map map2 = requestDataKeys;
            boolean bl = false;
            $this$apply.putData(GHPRActionKeys.getPULL_REQUEST_DATA_PROVIDER(), (Object)this.dataProvider);
            $this$apply.putData(GHPRDiffReviewSupport.Companion.getDATA_KEY(), (Object)reviewSupport);
            Unit unit = Unit.INSTANCE;
            map2.put(key, genericDataProvider);
            GenericDataProvider $this$apply2 = genericDataProvider2 = new NonEmptyActionGroup();
            boolean bl2 = false;
            $this$apply2.setPopup(true);
            $this$apply2.getTemplatePresentation().setText(GithubBundle.message("pull.request.diff.view.options", new Object[0]));
            $this$apply2.getTemplatePresentation().setIcon(AllIcons.Actions.Show);
            $this$apply2.add((AnAction)new GHPRDiffReviewThreadsToggleAction());
            $this$apply2.add((AnAction)new GHPRDiffReviewResolvedThreadsToggleAction());
            GenericDataProvider viewOptionsGroup = genericDataProvider2;
            requestDataKeys.put(DiffUserDataKeys.CONTEXT_ACTIONS, CollectionsKt.listOf((Object[])new AnAction[]{(AnAction)new GHToolbarLabelAction(GithubBundle.message("pull.request.diff.review.label", new Object[0])), (AnAction)viewOptionsGroup, (AnAction)new GHPRDiffReviewThreadsReloadAction(), ActionManager.getInstance().getAction("Github.PullRequest.Review.Submit")}));
        }
        return requestDataKeys;
    }

    private final GHPRDiffReviewSupport getReviewSupport(GHPRChangesProvider changesProvider, Change change) {
        GHPRChangeDiffData gHPRChangeDiffData = changesProvider.findChangeDiffData(change);
        if (gHPRChangeDiffData == null) {
            return null;
        }
        GHPRChangeDiffData diffData = gHPRChangeDiffData;
        return new GHPRDiffReviewSupportImpl(this.project, this.dataProvider.getReviewData(), this.dataProvider.getDetailsData(), this.avatarIconsProvider, this.repositoryDataService, diffData, this.currentUser);
    }

    private final DiffUserDataKeysEx.DiffComputer getDiffComputer(GHPRChangesProvider changesProvider, Change change) {
        Object object = changesProvider.findChangeDiffData(change);
        if (object == null || (object = ((GHPRChangeDiffData)object).getDiffRangesWithoutContext()) == null) {
            return null;
        }
        Object diffRanges2 = object;
        return new DiffUserDataKeysEx.DiffComputer((List)diffRanges2, change){
            final /* synthetic */ List $diffRanges;
            final /* synthetic */ Change $change;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<LineFragment> compute(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull ComparisonPolicy policy, boolean innerChanges, @NotNull ProgressIndicator indicator) {
                void $this$mapTo$iv$iv;
                LineOffsets lineOffsets2;
                ComparisonManagerImpl comparisonManager = ComparisonManagerImpl.getInstanceImpl();
                LineOffsets lineOffsets1 = LineOffsetsUtil.create((CharSequence)text1);
                if (!RangesBuilder.isValidRanges((CharSequence)text1, (CharSequence)text2, (LineOffsets)lineOffsets1, (LineOffsets)(lineOffsets2 = LineOffsetsUtil.create((CharSequence)text2)), (List)this.$diffRanges)) {
                    String string = "Invalid diff line ranges for change " + this.$change;
                    throw new IllegalStateException(string.toString());
                }
                DiffIterable iterable = DiffIterableUtil.create((List)this.$diffRanges, (int)lineOffsets1.getLineCount(), (int)lineOffsets2.getLineCount());
                Iterable $this$map$iv = DiffIterableUtil.iterateAll((DiffIterable)iterable);
                boolean $i$f$map = false;
                Iterable iterable2 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Pair pair = (Pair)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    List list2 = comparisonManager.compareLinesInner((Range)it.first, text1, text2, lineOffsets1, lineOffsets2, policy, innerChanges, indicator);
                    collection.add(list2);
                }
                return CollectionsKt.flatten((Iterable)((List)destination$iv$iv));
            }
            {
                this.$diffRanges = list2;
                this.$change = change;
            }
        };
    }

    public GHPRDiffRequestChainProducer(@NotNull Project project, @NotNull GHPRDataProvider dataProvider, @NotNull GHAvatarIconsProvider avatarIconsProvider, @NotNull GHPRRepositoryDataService repositoryDataService, @NotNull GHUser currentUser) {
        this.project = project;
        this.dataProvider = dataProvider;
        this.avatarIconsProvider = avatarIconsProvider;
        this.repositoryDataService = repositoryDataService;
        this.currentUser = currentUser;
    }

    public static final /* synthetic */ Map access$loadRequestDataKeys(GHPRDiffRequestChainProducer $this, ProgressIndicator indicator, Change change, CompletableFuture changesProviderFuture, CompletableFuture fetchFuture) {
        return $this.loadRequestDataKeys(indicator, change, changesProviderFuture, fetchFuture);
    }

    public static final /* synthetic */ Project access$getProject$p(GHPRDiffRequestChainProducer $this) {
        return $this.project;
    }
}

