/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest.data.service;

import com.intellij.collaboration.api.dto.GraphQLPagedResponseDataDTO;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.GHGQLRequests;
import org.jetbrains.plugins.github.api.GHRepositoryCoordinates;
import org.jetbrains.plugins.github.api.GHRepositoryPath;
import org.jetbrains.plugins.github.api.GithubApiRequest;
import org.jetbrains.plugins.github.api.GithubApiRequestExecutor;
import org.jetbrains.plugins.github.api.GithubApiRequests;
import org.jetbrains.plugins.github.api.GithubServerPath;
import org.jetbrains.plugins.github.api.data.GHLabel;
import org.jetbrains.plugins.github.api.data.GHRepositoryOwnerName;
import org.jetbrains.plugins.github.api.data.GHUser;
import org.jetbrains.plugins.github.api.data.GithubIssueLabel;
import org.jetbrains.plugins.github.api.data.GithubUser;
import org.jetbrains.plugins.github.api.data.GithubUserWithPermissions;
import org.jetbrains.plugins.github.api.data.graphql.GHGQLRequestPagination;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequestRequestedReviewer;
import org.jetbrains.plugins.github.api.data.pullrequest.GHTeam;
import org.jetbrains.plugins.github.api.util.GithubApiPagesLoader;
import org.jetbrains.plugins.github.api.util.SimpleGHGQLPagesLoader;
import org.jetbrains.plugins.github.pullrequest.data.service.GHPRRepositoryDataService;
import org.jetbrains.plugins.github.pullrequest.data.service.GHPRRepositoryDataServiceImpl;
import org.jetbrains.plugins.github.util.GHGitRepositoryMapping;
import org.jetbrains.plugins.github.util.GitRemoteUrlCoordinates;
import org.jetbrains.plugins.github.util.LazyCancellableBackgroundProcessValue;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001BI\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\b\u0010\u000e\u001a\u0004\u0018\u00010\r\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0011J\b\u00105\u001a\u000206H\u0016J\b\u00107\u001a\u000206H\u0016R\u001a\u0010\u0012\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0016\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u00140\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001b0\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\u0004\u0018\u00010\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010\u000f\u001a\u00020\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u001eR \u0010\u001f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u00140\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010\u0019R \u0010!\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\"0\u00140\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010\u0019R\u001a\u0010$\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\"0\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010%\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020&0\u00140\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010\u0019R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020+X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010-R\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010\u001dR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010/\u001a\u000200X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u00101\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002020\u00140\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b3\u0010\u0019R\u001a\u00104\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002020\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRRepositoryDataServiceImpl;", "Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRRepositoryDataService;", "progressManager", "Lcom/intellij/openapi/progress/ProgressManager;", "requestExecutor", "Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor;", "remoteCoordinates", "Lorg/jetbrains/plugins/github/util/GitRemoteUrlCoordinates;", "repositoryCoordinates", "Lorg/jetbrains/plugins/github/api/GHRepositoryCoordinates;", "repoOwner", "Lorg/jetbrains/plugins/github/api/data/GHRepositoryOwnerName;", "repositoryId", "", "defaultBranchName", "isFork", "", "(Lcom/intellij/openapi/progress/ProgressManager;Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor;Lorg/jetbrains/plugins/github/util/GitRemoteUrlCoordinates;Lorg/jetbrains/plugins/github/api/GHRepositoryCoordinates;Lorg/jetbrains/plugins/github/api/data/GHRepositoryOwnerName;Ljava/lang/String;Ljava/lang/String;Z)V", "assigneesValue", "Lorg/jetbrains/plugins/github/util/LazyCancellableBackgroundProcessValue;", "", "Lorg/jetbrains/plugins/github/api/data/GHUser;", "collaborators", "Ljava/util/concurrent/CompletableFuture;", "getCollaborators", "()Ljava/util/concurrent/CompletableFuture;", "collaboratorsValue", "Lorg/jetbrains/plugins/github/api/data/GithubUserWithPermissions;", "getDefaultBranchName", "()Ljava/lang/String;", "()Z", "issuesAssignees", "getIssuesAssignees", "labels", "Lorg/jetbrains/plugins/github/api/data/GHLabel;", "getLabels", "labelsValue", "potentialReviewers", "Lorg/jetbrains/plugins/github/api/data/pullrequest/GHPullRequestRequestedReviewer;", "getPotentialReviewers", "getRemoteCoordinates", "()Lorg/jetbrains/plugins/github/util/GitRemoteUrlCoordinates;", "repoPath", "Lorg/jetbrains/plugins/github/api/GHRepositoryPath;", "getRepositoryCoordinates", "()Lorg/jetbrains/plugins/github/api/GHRepositoryCoordinates;", "getRepositoryId", "serverPath", "Lorg/jetbrains/plugins/github/api/GithubServerPath;", "teams", "Lorg/jetbrains/plugins/github/api/data/pullrequest/GHTeam;", "getTeams", "teamsValue", "dispose", "", "resetData", "intellij.vcs.github"})
public final class GHPRRepositoryDataServiceImpl
implements GHPRRepositoryDataService {
    private final GithubServerPath serverPath;
    private final GHRepositoryPath repoPath;
    private final LazyCancellableBackgroundProcessValue<List<GithubUserWithPermissions>> collaboratorsValue;
    private final LazyCancellableBackgroundProcessValue<List<GHTeam>> teamsValue;
    private final LazyCancellableBackgroundProcessValue<List<GHUser>> assigneesValue;
    private final LazyCancellableBackgroundProcessValue<List<GHLabel>> labelsValue;
    private final GithubApiRequestExecutor requestExecutor;
    @NotNull
    private final GitRemoteUrlCoordinates remoteCoordinates;
    @NotNull
    private final GHRepositoryCoordinates repositoryCoordinates;
    private final GHRepositoryOwnerName repoOwner;
    @NotNull
    private final String repositoryId;
    @Nullable
    private final String defaultBranchName;
    private final boolean isFork;

    @Override
    @NotNull
    public CompletableFuture<List<GHUser>> getCollaborators() {
        return ((CompletableFuture)this.collaboratorsValue.getValue()).thenApply((Function)collaborators.1.INSTANCE);
    }

    @Override
    @NotNull
    public CompletableFuture<List<GHTeam>> getTeams() {
        return (CompletableFuture)this.teamsValue.getValue();
    }

    @Override
    @NotNull
    public CompletableFuture<List<GHPullRequestRequestedReviewer>> getPotentialReviewers() {
        return ((CompletableFuture)this.collaboratorsValue.getValue()).thenCombine(this.getTeams(), (BiFunction)potentialReviewers.1.INSTANCE);
    }

    @Override
    @NotNull
    public CompletableFuture<List<GHUser>> getIssuesAssignees() {
        return (CompletableFuture)this.assigneesValue.getValue();
    }

    @Override
    @NotNull
    public CompletableFuture<List<GHLabel>> getLabels() {
        return (CompletableFuture)this.labelsValue.getValue();
    }

    @Override
    public void resetData() {
        this.collaboratorsValue.drop();
        this.teamsValue.drop();
        this.assigneesValue.drop();
        this.labelsValue.drop();
    }

    public void dispose() {
        this.resetData();
    }

    @Override
    @NotNull
    public GitRemoteUrlCoordinates getRemoteCoordinates() {
        return this.remoteCoordinates;
    }

    @Override
    @NotNull
    public GHRepositoryCoordinates getRepositoryCoordinates() {
        return this.repositoryCoordinates;
    }

    @Override
    @NotNull
    public String getRepositoryId() {
        return this.repositoryId;
    }

    @Override
    @Nullable
    public String getDefaultBranchName() {
        return this.defaultBranchName;
    }

    @Override
    public boolean isFork() {
        return this.isFork;
    }

    public GHPRRepositoryDataServiceImpl(@NotNull ProgressManager progressManager, @NotNull GithubApiRequestExecutor requestExecutor, @NotNull GitRemoteUrlCoordinates remoteCoordinates, @NotNull GHRepositoryCoordinates repositoryCoordinates, @NotNull GHRepositoryOwnerName repoOwner, @NotNull String repositoryId, @Nullable String defaultBranchName, boolean isFork) {
        this.requestExecutor = requestExecutor;
        this.remoteCoordinates = remoteCoordinates;
        this.repositoryCoordinates = repositoryCoordinates;
        this.repoOwner = repoOwner;
        this.repositoryId = repositoryId;
        this.defaultBranchName = defaultBranchName;
        this.isFork = isFork;
        this.serverPath = this.getRepositoryCoordinates().getServerPath();
        this.repoPath = this.getRepositoryCoordinates().getRepositoryPath();
        this.requestExecutor.addListener(this, (Function0<Unit>)((Function0)new Function0<Unit>(){

            public final void invoke() {
                this.resetData();
            }
        }));
        this.collaboratorsValue = LazyCancellableBackgroundProcessValue.Companion.create(progressManager, (Function1)new Function1<ProgressIndicator, List<? extends GithubUserWithPermissions>>(this){
            final /* synthetic */ GHPRRepositoryDataServiceImpl this$0;

            @NotNull
            public final List<GithubUserWithPermissions> invoke(@NotNull ProgressIndicator indicator) {
                return GithubApiPagesLoader.loadAll(GHPRRepositoryDataServiceImpl.access$getRequestExecutor$p(this.this$0), indicator, GithubApiRequests.Repos.Collaborators.pages(GHPRRepositoryDataServiceImpl.access$getServerPath$p(this.this$0), GHPRRepositoryDataServiceImpl.access$getRepoPath$p(this.this$0).getOwner(), GHPRRepositoryDataServiceImpl.access$getRepoPath$p(this.this$0).getRepository()));
            }
            {
                this.this$0 = gHPRRepositoryDataServiceImpl;
                super(1);
            }
        });
        this.teamsValue = LazyCancellableBackgroundProcessValue.Companion.create(progressManager, (Function1)new Function1<ProgressIndicator, List<? extends GHTeam>>(this){
            final /* synthetic */ GHPRRepositoryDataServiceImpl this$0;

            @NotNull
            public final List<GHTeam> invoke(@NotNull ProgressIndicator indicator) {
                return !(GHPRRepositoryDataServiceImpl.access$getRepoOwner$p(this.this$0) instanceof GHRepositoryOwnerName.Organization) ? CollectionsKt.emptyList() : new SimpleGHGQLPagesLoader<T>(GHPRRepositoryDataServiceImpl.access$getRequestExecutor$p(this.this$0), (Function1)new Function1<GHGQLRequestPagination, GithubApiRequest.Post<? extends GraphQLPagedResponseDataDTO<? extends GHTeam>>>(this){
                    final /* synthetic */ teamsValue.1 this$0;

                    @NotNull
                    public final GithubApiRequest.Post<GraphQLPagedResponseDataDTO<GHTeam>> invoke(@NotNull GHGQLRequestPagination it) {
                        return GHGQLRequests.Organization.Team.INSTANCE.findAll(GHPRRepositoryDataServiceImpl.access$getServerPath$p(this.this$0.this$0), GHPRRepositoryDataServiceImpl.access$getRepoOwner$p(this.this$0.this$0).getLogin(), it);
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                }, false, 0, 12, null).loadAll(indicator);
            }
            {
                this.this$0 = gHPRRepositoryDataServiceImpl;
                super(1);
            }
        });
        this.assigneesValue = LazyCancellableBackgroundProcessValue.Companion.create(progressManager, (Function1)new Function1<ProgressIndicator, List<? extends GHUser>>(this){
            final /* synthetic */ GHPRRepositoryDataServiceImpl this$0;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<GHUser> invoke(@NotNull ProgressIndicator indicator) {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = GithubApiPagesLoader.loadAll(GHPRRepositoryDataServiceImpl.access$getRequestExecutor$p(this.this$0), indicator, GithubApiRequests.Repos.Assignees.pages(GHPRRepositoryDataServiceImpl.access$getServerPath$p(this.this$0), GHPRRepositoryDataServiceImpl.access$getRepoPath$p(this.this$0).getOwner(), GHPRRepositoryDataServiceImpl.access$getRepoPath$p(this.this$0).getRepository()));
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    GithubUser githubUser = (GithubUser)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    String string = it.getNodeId();
                    String string2 = it.getLogin();
                    String string3 = it.getHtmlUrl();
                    String string4 = it.getAvatarUrl();
                    if (string4 == null) {
                        string4 = "";
                    }
                    GHUser gHUser = new GHUser(string, string2, string3, string4, null);
                    collection.add(gHUser);
                }
                return (List)destination$iv$iv;
            }
            {
                this.this$0 = gHPRRepositoryDataServiceImpl;
                super(1);
            }
        });
        this.labelsValue = LazyCancellableBackgroundProcessValue.Companion.create(progressManager, (Function1)new Function1<ProgressIndicator, List<? extends GHLabel>>(this){
            final /* synthetic */ GHPRRepositoryDataServiceImpl this$0;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<GHLabel> invoke(@NotNull ProgressIndicator indicator) {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = GithubApiPagesLoader.loadAll(GHPRRepositoryDataServiceImpl.access$getRequestExecutor$p(this.this$0), indicator, GithubApiRequests.Repos.Labels.pages(GHPRRepositoryDataServiceImpl.access$getServerPath$p(this.this$0), GHPRRepositoryDataServiceImpl.access$getRepoPath$p(this.this$0).getOwner(), GHPRRepositoryDataServiceImpl.access$getRepoPath$p(this.this$0).getRepository()));
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    GithubIssueLabel githubIssueLabel = (GithubIssueLabel)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    GHLabel gHLabel = new GHLabel(it.getNodeId(), it.getUrl(), it.getName(), it.getColor());
                    collection.add(gHLabel);
                }
                return (List)destination$iv$iv;
            }
            {
                this.this$0 = gHPRRepositoryDataServiceImpl;
                super(1);
            }
        });
    }

    @Override
    @NotNull
    public GHGitRepositoryMapping getRepositoryMapping() {
        return GHPRRepositoryDataService.DefaultImpls.getRepositoryMapping(this);
    }

    public static final /* synthetic */ GithubApiRequestExecutor access$getRequestExecutor$p(GHPRRepositoryDataServiceImpl $this) {
        return $this.requestExecutor;
    }

    public static final /* synthetic */ GithubServerPath access$getServerPath$p(GHPRRepositoryDataServiceImpl $this) {
        return $this.serverPath;
    }

    public static final /* synthetic */ GHRepositoryPath access$getRepoPath$p(GHPRRepositoryDataServiceImpl $this) {
        return $this.repoPath;
    }

    public static final /* synthetic */ GHRepositoryOwnerName access$getRepoOwner$p(GHPRRepositoryDataServiceImpl $this) {
        return $this.repoOwner;
    }
}

