/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest.data.provider;

import com.intellij.collaboration.async.CompletableFutureUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.messages.MessageBus;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.data.GHBranchProtectionRules;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequest;
import org.jetbrains.plugins.github.pullrequest.data.GHPRIdentifier;
import org.jetbrains.plugins.github.pullrequest.data.GHPRMergeabilityState;
import org.jetbrains.plugins.github.pullrequest.data.provider.GHPRDataOperationsListener;
import org.jetbrains.plugins.github.pullrequest.data.provider.GHPRDetailsDataProvider;
import org.jetbrains.plugins.github.pullrequest.data.provider.GHPRStateDataProvider;
import org.jetbrains.plugins.github.pullrequest.data.provider.GHPRStateDataProviderImpl;
import org.jetbrains.plugins.github.pullrequest.data.service.GHPRStateService;
import org.jetbrains.plugins.github.util.LazyCancellableBackgroundProcessValue;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u00012\u00020\u0002B%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u001e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00022\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00170\u001aH\u0016J\u0016\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00170\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020\u0017H\u0016J\u000e\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00140\u001cH\u0016J\u0016\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00170\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J2\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00170\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0012\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00100$2\u0006\u0010%\u001a\u00020\u0010H\u0016J\u001e\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00170\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010%\u001a\u00020\u0010H\u0016J\b\u0010'\u001a\u00020\u0017H\u0016J\u0016\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00170\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J2\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00170\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0012\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00100$2\u0006\u0010%\u001a\u00020\u0010H\u0016J\u001e\u0010*\u001a\b\u0012\u0004\u0012\u0002H+0\u001c\"\u0004\b\u0000\u0010+*\b\u0012\u0004\u0012\u0002H+0\u001cH\u0002R\u0016\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0013\u001a\u0010\u0012\f\u0012\n \u0015*\u0004\u0018\u00010\u00140\u00140\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/data/provider/GHPRStateDataProviderImpl;", "Lorg/jetbrains/plugins/github/pullrequest/data/provider/GHPRStateDataProvider;", "Lcom/intellij/openapi/Disposable;", "stateService", "Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRStateService;", "pullRequestId", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRIdentifier;", "messageBus", "Lcom/intellij/util/messages/MessageBus;", "detailsData", "Lorg/jetbrains/plugins/github/pullrequest/data/provider/GHPRDetailsDataProvider;", "(Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRStateService;Lorg/jetbrains/plugins/github/pullrequest/data/GHPRIdentifier;Lcom/intellij/util/messages/MessageBus;Lorg/jetbrains/plugins/github/pullrequest/data/provider/GHPRDetailsDataProvider;)V", "baseBranchProtectionRulesRequestValue", "Lorg/jetbrains/plugins/github/util/LazyCancellableBackgroundProcessValue;", "Lorg/jetbrains/plugins/github/api/data/GHBranchProtectionRules;", "lastKnownBaseBranch", "", "lastKnownBaseSha", "lastKnownHeadSha", "mergeabilityStateRequestValue", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRMergeabilityState;", "kotlin.jvm.PlatformType", "addMergeabilityStateListener", "", "disposable", "listener", "Lkotlin/Function0;", "close", "Ljava/util/concurrent/CompletableFuture;", "progressIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "dispose", "loadMergeabilityState", "markReadyForReview", "merge", "commitMessage", "Lkotlin/Pair;", "currentHeadRef", "rebaseMerge", "reloadMergeabilityState", "reopen", "squashMerge", "notifyState", "T", "intellij.vcs.github"})
public final class GHPRStateDataProviderImpl
implements GHPRStateDataProvider,
Disposable {
    private String lastKnownBaseBranch;
    private String lastKnownBaseSha;
    private String lastKnownHeadSha;
    private final LazyCancellableBackgroundProcessValue<GHBranchProtectionRules> baseBranchProtectionRulesRequestValue;
    private final LazyCancellableBackgroundProcessValue<GHPRMergeabilityState> mergeabilityStateRequestValue;
    private final GHPRStateService stateService;
    private final GHPRIdentifier pullRequestId;
    private final MessageBus messageBus;
    private final GHPRDetailsDataProvider detailsData;

    @Override
    @NotNull
    public CompletableFuture<GHPRMergeabilityState> loadMergeabilityState() {
        return (CompletableFuture)this.mergeabilityStateRequestValue.getValue();
    }

    @Override
    public void reloadMergeabilityState() {
        if (this.baseBranchProtectionRulesRequestValue.getLastLoadedValue() == null) {
            this.baseBranchProtectionRulesRequestValue.drop();
        }
        this.mergeabilityStateRequestValue.drop();
    }

    @Override
    public void addMergeabilityStateListener(@NotNull Disposable disposable, @NotNull Function0<Unit> listener2) {
        this.mergeabilityStateRequestValue.addDropEventListener(disposable, listener2);
    }

    @Override
    @NotNull
    public CompletableFuture<Unit> close(@NotNull ProgressIndicator progressIndicator) {
        return this.notifyState(this.stateService.close(progressIndicator, this.pullRequestId));
    }

    @Override
    @NotNull
    public CompletableFuture<Unit> reopen(@NotNull ProgressIndicator progressIndicator) {
        return this.notifyState(this.stateService.reopen(progressIndicator, this.pullRequestId));
    }

    @Override
    @NotNull
    public CompletableFuture<Unit> markReadyForReview(@NotNull ProgressIndicator progressIndicator) {
        return CompletableFutureUtil.completionOnEdt$default((CompletableFutureUtil)CompletableFutureUtil.INSTANCE, this.notifyState(this.stateService.markReadyForReview(progressIndicator, this.pullRequestId)), null, (Function0)((Function0)new Function0<Unit>(this){
            final /* synthetic */ GHPRStateDataProviderImpl this$0;

            public final void invoke() {
                GHPRStateDataProviderImpl.access$getMergeabilityStateRequestValue$p(this.this$0).drop();
            }
            {
                this.this$0 = gHPRStateDataProviderImpl;
                super(0);
            }
        }), (int)1, null);
    }

    @Override
    @NotNull
    public CompletableFuture<Unit> merge(@NotNull ProgressIndicator progressIndicator, @NotNull Pair<String, String> commitMessage, @NotNull String currentHeadRef) {
        return this.notifyState(this.stateService.merge(progressIndicator, this.pullRequestId, commitMessage, currentHeadRef));
    }

    @Override
    @NotNull
    public CompletableFuture<Unit> rebaseMerge(@NotNull ProgressIndicator progressIndicator, @NotNull String currentHeadRef) {
        return this.notifyState(this.stateService.rebaseMerge(progressIndicator, this.pullRequestId, currentHeadRef));
    }

    @Override
    @NotNull
    public CompletableFuture<Unit> squashMerge(@NotNull ProgressIndicator progressIndicator, @NotNull Pair<String, String> commitMessage, @NotNull String currentHeadRef) {
        return this.notifyState(this.stateService.squashMerge(progressIndicator, this.pullRequestId, commitMessage, currentHeadRef));
    }

    private final <T> CompletableFuture<T> notifyState(CompletableFuture<T> $this$notifyState) {
        return CompletableFutureUtil.completionOnEdt$default((CompletableFutureUtil)CompletableFutureUtil.INSTANCE, $this$notifyState, null, (Function0)((Function0)new Function0<Unit>(this){
            final /* synthetic */ GHPRStateDataProviderImpl this$0;

            public final void invoke() {
                GHPRStateDataProviderImpl.access$getDetailsData$p(this.this$0).reloadDetails();
                ((GHPRDataOperationsListener)GHPRStateDataProviderImpl.access$getMessageBus$p(this.this$0).syncPublisher(GHPRDataOperationsListener.Companion.getTOPIC())).onStateChanged();
            }
            {
                this.this$0 = gHPRStateDataProviderImpl;
                super(0);
            }
        }), (int)1, null);
    }

    public void dispose() {
        this.mergeabilityStateRequestValue.drop();
        this.baseBranchProtectionRulesRequestValue.drop();
    }

    public GHPRStateDataProviderImpl(@NotNull GHPRStateService stateService, @NotNull GHPRIdentifier pullRequestId, @NotNull MessageBus messageBus2, @NotNull GHPRDetailsDataProvider detailsData) {
        this.stateService = stateService;
        this.pullRequestId = pullRequestId;
        this.messageBus = messageBus2;
        this.detailsData = detailsData;
        this.detailsData.addDetailsLoadedListener(this, (Function0<Unit>)((Function0)new Function0<Unit>(){

            public final void invoke() {
                GHPullRequest gHPullRequest = detailsData.getLoadedDetails();
                if (gHPullRequest == null) {
                    return;
                }
                GHPullRequest details2 = gHPullRequest;
                if (lastKnownBaseBranch != null && Intrinsics.areEqual((Object)lastKnownBaseBranch, (Object)details2.getBaseRefName()) ^ true) {
                    baseBranchProtectionRulesRequestValue.drop();
                    this.reloadMergeabilityState();
                }
                lastKnownBaseBranch = details2.getBaseRefName();
                if (lastKnownBaseSha != null && Intrinsics.areEqual((Object)lastKnownBaseSha, (Object)details2.getBaseRefOid()) ^ true && lastKnownHeadSha != null && Intrinsics.areEqual((Object)lastKnownHeadSha, (Object)details2.getHeadRefOid()) ^ true) {
                    this.reloadMergeabilityState();
                }
                lastKnownBaseSha = details2.getBaseRefOid();
                lastKnownHeadSha = details2.getHeadRefOid();
            }
        }));
        this.baseBranchProtectionRulesRequestValue = LazyCancellableBackgroundProcessValue.Companion.create((Function1)new Function1<ProgressIndicator, CompletableFuture<GHBranchProtectionRules>>(this){
            final /* synthetic */ GHPRStateDataProviderImpl this$0;

            @NotNull
            public final CompletableFuture<GHBranchProtectionRules> invoke(@NotNull ProgressIndicator indicator) {
                return GHPRStateDataProviderImpl.access$getDetailsData$p(this.this$0).loadDetails().thenCompose(new Function(this, indicator){
                    final /* synthetic */ baseBranchProtectionRulesRequestValue.1 this$0;
                    final /* synthetic */ ProgressIndicator $indicator;

                    public final CompletionStage<GHBranchProtectionRules> apply(GHPullRequest it) {
                        return GHPRStateDataProviderImpl.access$getStateService$p(this.this$0.this$0).loadBranchProtectionRules(this.$indicator, GHPRStateDataProviderImpl.access$getPullRequestId$p(this.this$0.this$0), it.getBaseRefName());
                    }
                    {
                        this.this$0 = var1_1;
                        this.$indicator = progressIndicator;
                    }
                });
            }
            {
                this.this$0 = gHPRStateDataProviderImpl;
                super(1);
            }
        });
        this.mergeabilityStateRequestValue = LazyCancellableBackgroundProcessValue.Companion.create((Function1)new Function1<ProgressIndicator, CompletableFuture<GHPRMergeabilityState>>(this){
            final /* synthetic */ GHPRStateDataProviderImpl this$0;

            @NotNull
            public final CompletableFuture<GHPRMergeabilityState> invoke(@NotNull ProgressIndicator indicator) {
                CompletableFuture baseBranchProtectionRulesRequest = (CompletableFuture)GHPRStateDataProviderImpl.access$getBaseBranchProtectionRulesRequestValue$p(this.this$0).getValue();
                return GHPRStateDataProviderImpl.access$getDetailsData$p(this.this$0).loadDetails().thenCompose(new Function(this, baseBranchProtectionRulesRequest, indicator){
                    final /* synthetic */ mergeabilityStateRequestValue.1 this$0;
                    final /* synthetic */ CompletableFuture $baseBranchProtectionRulesRequest;
                    final /* synthetic */ ProgressIndicator $indicator;

                    public final CompletionStage<GHPRMergeabilityState> apply(GHPullRequest details2) {
                        return this.$baseBranchProtectionRulesRequest.thenCompose(new Function(this, details2){
                            final /* synthetic */ mergeabilityStateRequestValue.1 this$0;
                            final /* synthetic */ GHPullRequest $details;

                            public final CompletionStage<GHPRMergeabilityState> apply(@Nullable GHBranchProtectionRules it) {
                                return GHPRStateDataProviderImpl.access$getStateService$p(this.this$0.this$0.this$0).loadMergeabilityState(this.this$0.$indicator, GHPRStateDataProviderImpl.access$getPullRequestId$p(this.this$0.this$0.this$0), this.$details.getHeadRefOid(), this.$details.getUrl(), it);
                            }
                            {
                                this.this$0 = var1_1;
                                this.$details = gHPullRequest;
                            }
                        });
                    }
                    {
                        this.this$0 = var1_1;
                        this.$baseBranchProtectionRulesRequest = completableFuture;
                        this.$indicator = progressIndicator;
                    }
                });
            }
            {
                this.this$0 = gHPRStateDataProviderImpl;
                super(1);
            }
        });
    }

    @Override
    @RequiresEdt
    public void loadMergeabilityState(@NotNull Disposable disposable, @NotNull Function1<? super CompletableFuture<GHPRMergeabilityState>, Unit> consumer) {
        GHPRStateDataProvider.DefaultImpls.loadMergeabilityState(this, disposable, consumer);
    }

    public static final /* synthetic */ LazyCancellableBackgroundProcessValue access$getMergeabilityStateRequestValue$p(GHPRStateDataProviderImpl $this) {
        return $this.mergeabilityStateRequestValue;
    }

    public static final /* synthetic */ MessageBus access$getMessageBus$p(GHPRStateDataProviderImpl $this) {
        return $this.messageBus;
    }

    public static final /* synthetic */ GHPRStateService access$getStateService$p(GHPRStateDataProviderImpl $this) {
        return $this.stateService;
    }

    public static final /* synthetic */ GHPRIdentifier access$getPullRequestId$p(GHPRStateDataProviderImpl $this) {
        return $this.pullRequestId;
    }
}

