/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest.action;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsNotifier;
import git4idea.GitLocalBranch;
import git4idea.branch.GitBranchUiHandler;
import git4idea.branch.GitBranchUiHandlerImpl;
import git4idea.branch.GitBranchUtil;
import git4idea.branch.GitBranchWorker;
import git4idea.branch.GitNewBranchOptions;
import git4idea.commands.Git;
import git4idea.commands.GitCommandResult;
import git4idea.fetch.GitFetchResult;
import git4idea.fetch.GitFetchSupport;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import java.util.Collection;
import java.util.concurrent.Future;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.github.api.data.GHActor;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequest;
import org.jetbrains.plugins.github.i18n.GithubBundle;
import org.jetbrains.plugins.github.pullrequest.action.GHPRActionKeys;
import org.jetbrains.plugins.github.pullrequest.data.provider.GHPRDataProvider;
import org.jetbrains.plugins.github.util.GithubGitHelper;
import org.jetbrains.plugins.github.util.GithubSettings;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J(\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u0005H\u0002J(\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0017\u001a\u00020\u0005H\u0002J(\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0017\u001a\u00020\u0005H\u0002J \u0010\u001c\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0017\u001a\u00020\u0005H\u0002J0\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010 \u001a\u00020\u00042\u0006\u0010!\u001a\u00020\"H\u0002J\u0010\u0010#\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0014\u0010$\u001a\u00020\t*\u00020\u00152\u0006\u0010 \u001a\u00020\u0004H\u0002J&\u0010%\u001a\u0004\u0018\u00010&*\u00020\u001f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010'\u001a\u00020\u00042\u0006\u0010(\u001a\u00020\u0004H\u0002J2\u0010)\u001a\u0004\u0018\u00010&*\u00020\u001f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010'\u001a\u00020\u00042\b\u0010*\u001a\u0004\u0018\u00010\u00042\b\u0010+\u001a\u0004\u0018\u00010\u0004H\u0002R\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u0004*\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0018\u0010\b\u001a\u00020\t*\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\nR\u001a\u0010\u000b\u001a\u0004\u0018\u00010\u0004*\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u0007\u00a8\u0006,"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/action/GHPRCreateBranchAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "()V", "httpForkUrl", "", "Lorg/jetbrains/plugins/github/pullrequest/data/provider/GHPRDataProvider;", "getHttpForkUrl", "(Lorg/jetbrains/plugins/github/pullrequest/data/provider/GHPRDataProvider;)Ljava/lang/String;", "isFork", "", "(Lorg/jetbrains/plugins/github/pullrequest/data/provider/GHPRDataProvider;)Z", "sshForkUrl", "getSshForkUrl", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "checkoutBranch", "project", "Lcom/intellij/openapi/project/Project;", "repository", "Lgit4idea/repo/GitRepository;", "localBranch", "dataProvider", "checkoutNewBranch", "pullRequestNumber", "", "checkoutOrCreateNew", "generateSuggestedBranchName", "trySetTrackingUpstreamBranch", "git", "Lgit4idea/commands/Git;", "branchName", "ghPullRequest", "Lorg/jetbrains/plugins/github/api/data/pullrequest/GHPullRequest;", "update", "branchWithTrackingExist", "createRemote", "Lgit4idea/repo/GitRemote;", "remoteName", "url", "findOrCreateRemote", "httpUrl", "sshUrl", "intellij.vcs.github"})
public final class GHPRCreateBranchAction
extends DumbAwareAction {
    public void update(@NotNull AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        GitRepository repository = (GitRepository)e.getData(GHPRActionKeys.getGIT_REPOSITORY());
        GHPRDataProvider selection2 = (GHPRDataProvider)e.getData(GHPRActionKeys.getPULL_REQUEST_DATA_PROVIDER());
        if (repository != null) {
            GHPullRequest loadedDetails;
            Object object = selection2;
            GHPullRequest gHPullRequest = loadedDetails = object != null && (object = object.getDetailsData()) != null ? object.getLoadedDetails() : null;
            String headRefName = gHPullRequest != null ? gHPullRequest.getHeadRefName() : null;
            Object object2 = loadedDetails;
            String httpUrl = object2 != null && (object2 = ((GHPullRequest)object2).getHeadRepository()) != null ? ((GHPullRequest.HeadRepository)object2).getUrl() : null;
            Object object3 = loadedDetails;
            String sshUrl = object3 != null && (object3 = ((GHPullRequest)object3).getHeadRepository()) != null ? ((GHPullRequest.HeadRepository)object3).getSshUrl() : null;
            Object object4 = loadedDetails;
            boolean isFork = object4 != null && (object4 = ((GHPullRequest)object4).getHeadRepository()) != null ? ((GHPullRequest.Repository)object4).isFork() : false;
            GitRemote remote = GithubGitHelper.Companion.getInstance().findRemote(repository, httpUrl, sshUrl);
            if (remote != null) {
                String localBranch = GithubGitHelper.Companion.getInstance().findLocalBranch(repository, remote, isFork, headRefName);
                if (Intrinsics.areEqual((Object)repository.getCurrentBranchName(), (Object)localBranch)) {
                    e.getPresentation().setEnabled(false);
                    return;
                }
            }
        }
        e.getPresentation().setEnabled(project != null && !project.isDefault() && selection2 != null && repository != null);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project = (Project)e.getRequiredData(CommonDataKeys.PROJECT);
        GitRepository repository = (GitRepository)e.getRequiredData(GHPRActionKeys.getGIT_REPOSITORY());
        GHPRDataProvider dataProvider = (GHPRDataProvider)e.getRequiredData(GHPRActionKeys.getPULL_REQUEST_DATA_PROVIDER());
        long pullRequestNumber = dataProvider.getId().getNumber();
        this.checkoutOrCreateNew(project, repository, pullRequestNumber, dataProvider);
    }

    private final void checkoutOrCreateNew(Project project, GitRepository repository, long pullRequestNumber, GHPRDataProvider dataProvider) {
        String localBranch;
        String httpForkUrl = this.getHttpForkUrl(dataProvider);
        String sshForkUrl = this.getSshForkUrl(dataProvider);
        GHPullRequest gHPullRequest = dataProvider.getDetailsData().getLoadedDetails();
        String possibleBranchName = gHPullRequest != null ? gHPullRequest.getHeadRefName() : null;
        GitRemote existingRemote = GithubGitHelper.Companion.getInstance().findRemote(repository, httpForkUrl, sshForkUrl);
        if (existingRemote != null && (localBranch = GithubGitHelper.Companion.getInstance().findLocalBranch(repository, existingRemote, this.isFork(dataProvider), possibleBranchName)) != null) {
            this.checkoutBranch(project, repository, localBranch, dataProvider);
            return;
        }
        this.checkoutNewBranch(project, repository, pullRequestNumber, dataProvider);
    }

    private final void checkoutBranch(Project project, GitRepository repository, String localBranch, GHPRDataProvider dataProvider) {
        new Task.Backgroundable(dataProvider, project, localBranch, repository, project, GithubBundle.message("pull.request.branch.checkout.task.title", new Object[0]), true){
            private final Git git;
            final /* synthetic */ GHPRDataProvider $dataProvider;
            final /* synthetic */ Project $project;
            final /* synthetic */ String $localBranch;
            final /* synthetic */ GitRepository $repository;

            public void run(@NotNull ProgressIndicator indicator) {
                ProgressIndicatorUtils.awaitWithCheckCanceled((Future)this.$dataProvider.getChangesData().fetchHeadBranch(), (ProgressIndicator)indicator);
                indicator.setText(GithubBundle.message("pull.request.branch.checkout.task.indicator", new Object[0]));
                new GitBranchWorker(this.$project, this.git, (GitBranchUiHandler)new GitBranchUiHandlerImpl(this.$project, indicator)).checkout(this.$localBranch, false, CollectionsKt.listOf((Object)this.$repository));
            }
            {
                this.$dataProvider = $captured_local_variable$0;
                this.$project = $captured_local_variable$1;
                this.$localBranch = $captured_local_variable$2;
                this.$repository = $captured_local_variable$3;
                super($super_call_param$4, $super_call_param$5, $super_call_param$6);
                this.git = Git.getInstance();
            }
        }.queue();
    }

    private final void checkoutNewBranch(Project project, GitRepository repository, long pullRequestNumber, GHPRDataProvider dataProvider) {
        GitNewBranchOptions gitNewBranchOptions = GitBranchUtil.getNewBranchNameFromUser((Project)project, (Collection)CollectionsKt.listOf((Object)repository), (String)GithubBundle.message("pull.request.branch.checkout.create.dialog.title", pullRequestNumber), (String)this.generateSuggestedBranchName(repository, pullRequestNumber, dataProvider), (boolean)true);
        if (gitNewBranchOptions == null) {
            return;
        }
        GitNewBranchOptions options = gitNewBranchOptions;
        if (!options.shouldCheckout()) {
            new Task.Backgroundable(this, dataProvider, project, options, repository, project, GithubBundle.message("pull.request.branch.checkout.create.task.title", new Object[0]), true){
                private final Git git;
                final /* synthetic */ GHPRCreateBranchAction this$0;
                final /* synthetic */ GHPRDataProvider $dataProvider;
                final /* synthetic */ Project $project;
                final /* synthetic */ GitNewBranchOptions $options;
                final /* synthetic */ GitRepository $repository;

                public void run(@NotNull ProgressIndicator indicator) {
                    GHPullRequest ghPullRequest = (GHPullRequest)ProgressIndicatorUtils.awaitWithCheckCanceled((Future)this.$dataProvider.getDetailsData().loadDetails(), (ProgressIndicator)indicator);
                    String sha = ghPullRequest.getHeadRefOid();
                    ProgressIndicatorUtils.awaitWithCheckCanceled((Future)this.$dataProvider.getChangesData().fetchHeadBranch(), (ProgressIndicator)indicator);
                    indicator.setText(GithubBundle.message("pull.request.branch.checkout.create.task.indicator", new Object[0]));
                    new GitBranchWorker(this.$project, this.git, (GitBranchUiHandler)new GitBranchUiHandlerImpl(this.$project, indicator)).createBranch(this.$options.getName(), MapsKt.mapOf((Pair)TuplesKt.to((Object)this.$repository, (Object)sha)));
                    if (this.$options.shouldSetTracking()) {
                        GHPRCreateBranchAction.access$trySetTrackingUpstreamBranch(this.this$0, this.git, this.$repository, this.$dataProvider, this.$options.getName(), ghPullRequest);
                    }
                    this.$repository.update();
                }
                {
                    this.this$0 = this$0;
                    this.$dataProvider = $captured_local_variable$1;
                    this.$project = $captured_local_variable$2;
                    this.$options = $captured_local_variable$3;
                    this.$repository = $captured_local_variable$4;
                    super($super_call_param$5, $super_call_param$6, $super_call_param$7);
                    this.git = Git.getInstance();
                }
            }.queue();
        } else {
            new Task.Backgroundable(this, dataProvider, project, options, repository, project, GithubBundle.message("pull.request.branch.checkout.task.title", new Object[0]), true){
                private final Git git;
                final /* synthetic */ GHPRCreateBranchAction this$0;
                final /* synthetic */ GHPRDataProvider $dataProvider;
                final /* synthetic */ Project $project;
                final /* synthetic */ GitNewBranchOptions $options;
                final /* synthetic */ GitRepository $repository;

                public void run(@NotNull ProgressIndicator indicator) {
                    GHPullRequest ghPullRequest = (GHPullRequest)ProgressIndicatorUtils.awaitWithCheckCanceled((Future)this.$dataProvider.getDetailsData().loadDetails(), (ProgressIndicator)indicator);
                    String sha = ghPullRequest.getHeadRefOid();
                    ProgressIndicatorUtils.awaitWithCheckCanceled((Future)this.$dataProvider.getChangesData().fetchHeadBranch(), (ProgressIndicator)indicator);
                    indicator.setText(GithubBundle.message("pull.request.branch.checkout.task.indicator", new Object[0]));
                    new GitBranchWorker(this.$project, this.git, (GitBranchUiHandler)new GitBranchUiHandlerImpl(this.$project, indicator)).checkoutNewBranchStartingFrom(this.$options.getName(), sha, CollectionsKt.listOf((Object)this.$repository));
                    if (this.$options.shouldSetTracking()) {
                        GHPRCreateBranchAction.access$trySetTrackingUpstreamBranch(this.this$0, this.git, this.$repository, this.$dataProvider, this.$options.getName(), ghPullRequest);
                    }
                    this.$repository.update();
                }
                {
                    this.this$0 = this$0;
                    this.$dataProvider = $captured_local_variable$1;
                    this.$project = $captured_local_variable$2;
                    this.$options = $captured_local_variable$3;
                    this.$repository = $captured_local_variable$4;
                    super($super_call_param$5, $super_call_param$6, $super_call_param$7);
                    this.git = Git.getInstance();
                }
            }.queue();
        }
    }

    private final String generateSuggestedBranchName(GitRepository repository, long pullRequestNumber, GHPRDataProvider dataProvider) {
        GHPullRequest gHPullRequest;
        GHPullRequest ghPullRequest = gHPullRequest = dataProvider.getDetailsData().getLoadedDetails();
        boolean bl = false;
        Object object = ghPullRequest;
        String login2 = object != null && (object = ((GHPullRequest)object).getHeadRepository()) != null && (object = ((GHPullRequest.Repository)object).getOwner()) != null ? ((GHPullRequest.Owner)object).getLogin() : null;
        GHPullRequest gHPullRequest2 = ghPullRequest;
        String headRefName = gHPullRequest2 != null ? gHPullRequest2.getHeadRefName() : null;
        return headRefName == null || login2 == null ? "pull/" + pullRequestNumber : (this.branchWithTrackingExist(repository, headRefName) ? login2 + "_" + headRefName : headRefName);
    }

    private final boolean branchWithTrackingExist(GitRepository $this$branchWithTrackingExist, String branchName) {
        GitLocalBranch gitLocalBranch = $this$branchWithTrackingExist.getBranches().findLocalBranch(branchName);
        return (gitLocalBranch != null ? gitLocalBranch.findTrackedBranch($this$branchWithTrackingExist) : null) != null;
    }

    private final void trySetTrackingUpstreamBranch(Git git, GitRepository repository, GHPRDataProvider dataProvider, String branchName, GHPullRequest ghPullRequest) {
        GitCommandResult setUpstream;
        Project project;
        Project $this$service$iv = project = repository.getProject();
        boolean $i$f$service = false;
        VcsNotifier vcsNotifier = (VcsNotifier)$this$service$iv.getService(VcsNotifier.class);
        GHActor pullRequestAuthor = ghPullRequest.getAuthor();
        if (pullRequestAuthor == null) {
            vcsNotifier.notifyError("github.pull.request.cannot.set.tracking.branch", GithubBundle.message("pull.request.branch.checkout.set.tracking.branch.failed", new Object[0]), GithubBundle.message("pull.request.branch.checkout.resolve.author.failed", new Object[0]));
            return;
        }
        String httpForkUrl = this.getHttpForkUrl(dataProvider);
        String sshForkUrl = this.getSshForkUrl(dataProvider);
        GitRemote forkRemote = this.findOrCreateRemote(git, repository, pullRequestAuthor.getLogin(), httpForkUrl, sshForkUrl);
        if (forkRemote == null) {
            Object failedMessage = GithubBundle.message("pull.request.branch.checkout.resolve.remote.failed", new Object[0]);
            if (httpForkUrl != null) {
                failedMessage = (String)failedMessage + "\n" + httpForkUrl;
            }
            if (sshForkUrl != null) {
                failedMessage = (String)failedMessage + "\n" + sshForkUrl;
            }
            vcsNotifier.notifyError("github.pull.request.cannot.set.tracking.branch", GithubBundle.message("pull.request.branch.checkout.set.tracking.branch.failed", new Object[0]), (String)failedMessage);
            return;
        }
        String forkBranchName = forkRemote.getName() + "/" + ghPullRequest.getHeadRefName();
        GitFetchResult fetchResult = GitFetchSupport.fetchSupport((Project)project).fetch(repository, forkRemote, ghPullRequest.getHeadRefName());
        if (fetchResult.showNotificationIfFailed(GithubBundle.message("pull.request.branch.checkout.set.tracking.branch.failed", new Object[0])) && !(setUpstream = git.setUpstream(repository, forkBranchName, branchName)).success()) {
            vcsNotifier.notifyError("github.pull.request.cannot.set.tracking.branch", GithubBundle.message("pull.request.branch.checkout.set.tracking.branch.failed", new Object[0]), setUpstream.getErrorOutputAsHtmlString());
        }
    }

    private final GitRemote findOrCreateRemote(Git $this$findOrCreateRemote, GitRepository repository, String remoteName, String httpUrl, String sshUrl) {
        String sshOrHttpUrl;
        GitRemote existingRemote = GithubGitHelper.Companion.getInstance().findRemote(repository, httpUrl, sshUrl);
        if (existingRemote != null) {
            return existingRemote;
        }
        boolean useSshUrl = GithubSettings.getInstance().isCloneGitUsingSsh();
        String string = sshOrHttpUrl = useSshUrl ? sshUrl : httpUrl;
        if (sshOrHttpUrl != null) {
            boolean bl;
            block6: {
                Iterable $this$any$iv = repository.getRemotes();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        GitRemote it = (GitRemote)element$iv;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)it.getName(), (Object)remoteName)) continue;
                        bl = true;
                        break block6;
                    }
                    bl = false;
                }
            }
            if (bl) {
                return this.createRemote($this$findOrCreateRemote, repository, "pull_" + remoteName, sshOrHttpUrl);
            }
        }
        return useSshUrl && sshUrl != null ? this.createRemote($this$findOrCreateRemote, repository, remoteName, sshUrl) : (!useSshUrl && httpUrl != null ? this.createRemote($this$findOrCreateRemote, repository, remoteName, httpUrl) : (sshUrl != null ? this.createRemote($this$findOrCreateRemote, repository, remoteName, sshUrl) : (httpUrl != null ? this.createRemote($this$findOrCreateRemote, repository, remoteName, httpUrl) : null)));
    }

    private final GitRemote createRemote(Git $this$createRemote, GitRepository repository, String remoteName, String url) {
        Object v0;
        block1: {
            Iterable iterable;
            GitRepository $this$with = repository;
            boolean bl = false;
            $this$createRemote.addRemote($this$with, remoteName, url);
            $this$with.update();
            Iterable iterable2 = iterable = (Iterable)$this$with.getRemotes();
            for (Object t : iterable2) {
                GitRemote it = (GitRemote)t;
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)remoteName)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    private final boolean isFork(GHPRDataProvider $this$isFork) {
        Object object = $this$isFork.getDetailsData().getLoadedDetails();
        return object != null && (object = ((GHPullRequest)object).getHeadRepository()) != null ? ((GHPullRequest.Repository)object).isFork() : false;
    }

    private final String getHttpForkUrl(GHPRDataProvider $this$httpForkUrl) {
        Object object = $this$httpForkUrl.getDetailsData().getLoadedDetails();
        return object != null && (object = ((GHPullRequest)object).getHeadRepository()) != null ? ((GHPullRequest.HeadRepository)object).getUrl() : null;
    }

    private final String getSshForkUrl(GHPRDataProvider $this$sshForkUrl) {
        Object object = $this$sshForkUrl.getDetailsData().getLoadedDetails();
        return object != null && (object = ((GHPullRequest)object).getHeadRepository()) != null ? ((GHPullRequest.HeadRepository)object).getSshUrl() : null;
    }

    public GHPRCreateBranchAction() {
        super(GithubBundle.messagePointer("pull.request.branch.checkout.create.action", new Object[0]), GithubBundle.messagePointer("pull.request.branch.checkout.create.action.description", new Object[0]), null);
    }

    public static final /* synthetic */ void access$trySetTrackingUpstreamBranch(GHPRCreateBranchAction $this, Git git, GitRepository repository, GHPRDataProvider dataProvider, String branchName, GHPullRequest ghPullRequest) {
        $this.trySetTrackingUpstreamBranch(git, repository, dataProvider, branchName, ghPullRequest);
    }
}

