/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.extensions;

import com.intellij.collaboration.api.dto.GraphQLPagedResponseDataDTO;
import com.intellij.concurrency.SensitiveProgressWrapper;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.util.PatternUtil;
import git4idea.config.GitSharedSettings;
import git4idea.fetch.GitFetchHandler;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.github.api.GHGQLRequests;
import org.jetbrains.plugins.github.api.GHRepositoryCoordinates;
import org.jetbrains.plugins.github.api.GithubApiRequest;
import org.jetbrains.plugins.github.api.GithubApiRequestExecutor;
import org.jetbrains.plugins.github.api.GithubApiRequestExecutorManager;
import org.jetbrains.plugins.github.api.GithubServerPath;
import org.jetbrains.plugins.github.api.data.GHBranchProtectionRule;
import org.jetbrains.plugins.github.api.data.graphql.GHGQLRequestPagination;
import org.jetbrains.plugins.github.api.util.SimpleGHGQLPagesLoader;
import org.jetbrains.plugins.github.authentication.GithubAuthenticationManager;
import org.jetbrains.plugins.github.authentication.accounts.GithubAccount;
import org.jetbrains.plugins.github.extensions.GHProtectedBranchRulesLoaderKt;
import org.jetbrains.plugins.github.i18n.GithubBundle;
import org.jetbrains.plugins.github.util.GHGitRepositoryMapping;
import org.jetbrains.plugins.github.util.GHProjectRepositoriesManager;
import org.jetbrains.plugins.github.util.GithubProjectSettings;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J2\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0018\u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\b2\u0006\u0010\f\u001a\u00020\rH\u0016J2\u0010\u000e\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0018\u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/plugins/github/extensions/GHProtectedBranchRulesLoader;", "Lgit4idea/fetch/GitFetchHandler;", "()V", "doAfterSuccessfulFetch", "", "project", "Lcom/intellij/openapi/project/Project;", "fetches", "", "Lgit4idea/repo/GitRepository;", "", "Lgit4idea/repo/GitRemote;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "loadProtectionRules", "intellij.vcs.github"})
public final class GHProtectedBranchRulesLoader
implements GitFetchHandler {
    public void doAfterSuccessfulFetch(@NotNull Project project, @NotNull Map<GitRepository, ? extends List<GitRemote>> fetches, @NotNull ProgressIndicator indicator) {
        try {
            this.loadProtectionRules(indicator, fetches, project);
        }
        catch (Exception e) {
            if (e instanceof ProcessCanceledException) {
                throw (Throwable)e;
            }
            GHProtectedBranchRulesLoaderKt.access$getLOG$p().info("Error occurred while trying to load branch protection rules", (Throwable)e);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void loadProtectionRules(ProgressIndicator indicator, Map<GitRepository, ? extends List<GitRemote>> fetches, Project project) {
        GithubAuthenticationManager githubAuthenticationManager;
        block18: {
            block17: {
                githubAuthenticationManager = GithubAuthenticationManager.Companion.getInstance();
                if (!GitSharedSettings.getInstance((Project)project).isSynchronizeBranchProtectionRules()) break block17;
                if (githubAuthenticationManager.hasAccounts()) break block18;
            }
            ModalityState modalityState$iv = null;
            boolean $i$f$runInEdt = false;
            Application app$iv = ApplicationManager.getApplication();
            if (app$iv.isDispatchThread()) {
                boolean bl = false;
                Project $this$service$iv = project;
                boolean $i$f$service = false;
                ((GithubProjectSettings)$this$service$iv.getService(GithubProjectSettings.class)).setBranchProtectionPatterns(new ArrayList());
            } else {
                boolean $i$f$invokeLater = false;
                ApplicationManager.getApplication().invokeLater(new Runnable(project){
                    final /* synthetic */ Project $project$inlined;
                    {
                        this.$project$inlined = project;
                    }

                    public final void run() {
                        boolean bl = false;
                        Project $this$service$iv = this.$project$inlined;
                        boolean $i$f$service = false;
                        ((GithubProjectSettings)$this$service$iv.getService(GithubProjectSettings.class)).setBranchProtectionPatterns((List<String>)new ArrayList<E>());
                    }
                }, ModalityState.defaultModalityState());
            }
            return;
        }
        indicator.setText(GithubBundle.message("progress.text.loading.protected.branches", new Object[0]));
        Set branchProtectionPatterns = new LinkedHashSet();
        GitRepository bl = fetches;
        Iterator<Map.Entry<GitRepository, ? extends List<GitRemote>>> app$iv = bl.entrySet().iterator();
        while (app$iv.hasNext()) {
            Map.Entry<GitRepository, ? extends List<GitRemote>> $i$f$runInEdt;
            Map.Entry<GitRepository, ? extends List<GitRemote>> $i$f$service = $i$f$runInEdt = app$iv.next();
            bl = $i$f$service.getKey();
            $i$f$service = $i$f$runInEdt;
            List<GitRemote> remotes = $i$f$service.getValue();
            indicator.checkCanceled();
            for (GitRemote remote : remotes) {
                void $this$forEach$iv;
                GHGitRepositoryMapping githubRepositoryMapping;
                Object v3;
                Object $i$f$service22;
                GithubApiRequestExecutor requestExecutor;
                block16: {
                    void repository;
                    GithubAccount account;
                    Object v2;
                    Object it;
                    block15: {
                        Iterable iterable;
                        indicator.checkCanceled();
                        Iterable iterable2 = iterable = (Iterable)githubAuthenticationManager.getAccounts();
                        for (Object t : iterable2) {
                            it = (GithubAccount)((Object)t);
                            boolean bl2 = false;
                            GithubServerPath githubServerPath = ((GithubAccount)((Object)it)).getServer();
                            String string = remote.getFirstUrl();
                            String string2 = string;
                            if (string2 == null) {
                                string2 = "";
                            }
                            if (!githubServerPath.matches(string2)) continue;
                            v2 = t;
                            break block15;
                        }
                        v2 = null;
                    }
                    if ((GithubAccount)v2 == null) {
                        continue;
                    }
                    requestExecutor = GithubApiRequestExecutorManager.Companion.getInstance().getExecutor(account);
                    Object $this$service$iv = project;
                    boolean $i$f$service22 = false;
                    $i$f$service22 = $this$service$iv = (Iterable)((GHProjectRepositoriesManager)$this$service$iv.getService(GHProjectRepositoriesManager.class)).findKnownRepositories((GitRepository)repository);
                    it = $i$f$service22.iterator();
                    while (it.hasNext()) {
                        Object e = it.next();
                        GHGitRepositoryMapping it2 = (GHGitRepositoryMapping)e;
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual((Object)it2.getGitRemoteUrlCoordinates().getRemote(), (Object)remote)) continue;
                        v3 = e;
                        break block16;
                    }
                    v3 = null;
                }
                if ((GHGitRepositoryMapping)v3 == null) {
                    continue;
                }
                GHRepositoryCoordinates repositoryCoordinates = githubRepositoryMapping.getGhRepositoryCoordinates();
                $i$f$service22 = new SimpleGHGQLPagesLoader(requestExecutor, (Function1)new Function1<GHGQLRequestPagination, GithubApiRequest.Post<? extends GraphQLPagedResponseDataDTO<? extends GHBranchProtectionRule>>>(repositoryCoordinates){
                    final /* synthetic */ GHRepositoryCoordinates $repositoryCoordinates;

                    @NotNull
                    public final GithubApiRequest.Post<GraphQLPagedResponseDataDTO<GHBranchProtectionRule>> invoke(@NotNull GHGQLRequestPagination it) {
                        return GHGQLRequests.Repo.getProtectionRules$default(GHGQLRequests.Repo.INSTANCE, this.$repositoryCoordinates, null, 2, null);
                    }
                    {
                        this.$repositoryCoordinates = gHRepositoryCoordinates;
                        super(1);
                    }
                }, false, 0, 12, null).loadAll((ProgressIndicator)new SensitiveProgressWrapper(indicator));
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    GHBranchProtectionRule rule = (GHBranchProtectionRule)element$iv;
                    boolean bl4 = false;
                    branchProtectionPatterns.add(PatternUtil.convertToRegex((String)rule.getPattern()));
                }
            }
        }
        ModalityState modalityState$iv = null;
        boolean $i$f$runInEdt = false;
        Application app$iv2 = ApplicationManager.getApplication();
        if (app$iv2.isDispatchThread()) {
            boolean bl5 = false;
            Project $this$service$iv = project;
            boolean $i$f$service = false;
            ((GithubProjectSettings)$this$service$iv.getService(GithubProjectSettings.class)).setBranchProtectionPatterns(CollectionsKt.toMutableList((Collection)branchProtectionPatterns));
        } else {
            boolean $i$f$invokeLater = false;
            ApplicationManager.getApplication().invokeLater(new Runnable(project, branchProtectionPatterns){
                final /* synthetic */ Project $project$inlined;
                final /* synthetic */ Set $branchProtectionPatterns$inlined;
                {
                    this.$project$inlined = project;
                    this.$branchProtectionPatterns$inlined = set;
                }

                public final void run() {
                    boolean bl = false;
                    Project $this$service$iv = this.$project$inlined;
                    boolean $i$f$service = false;
                    ((GithubProjectSettings)$this$service$iv.getService(GithubProjectSettings.class)).setBranchProtectionPatterns(CollectionsKt.toMutableList((Collection)this.$branchProtectionPatterns$inlined));
                }
            }, ModalityState.defaultModalityState());
        }
    }
}

