/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.authentication.ui;

import com.intellij.codeWithMe.ClientId;
import com.intellij.collaboration.async.CompletableFutureUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.ui.AnimatedIcon;
import com.intellij.ui.components.fields.ExtendableTextComponent;
import com.intellij.ui.components.fields.ExtendableTextField;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.ui.layout.LayoutBuilder;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTextField;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.GithubApiRequestExecutor;
import org.jetbrains.plugins.github.api.GithubServerPath;
import org.jetbrains.plugins.github.authentication.ui.GHCredentialsUi;
import org.jetbrains.plugins.github.authentication.ui.GHOAuthCredentialsUi;
import org.jetbrains.plugins.github.authentication.ui.GHTokenCredentialsUi;
import org.jetbrains.plugins.github.i18n.GithubBundle;
import org.jetbrains.plugins.github.ui.util.DialogValidationUtils;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u009e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0003\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001BI\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012:\u0010\u0004\u001a6\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\u000b\u0012\u0004\u0012\u00020\f0\u0005j\u0002`\r\u00a2\u0006\u0002\u0010\u000eJ \u0010'\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060)0(2\u0006\u0010*\u001a\u00020+J\u0010\u0010,\u001a\u00020\u00142\u0006\u0010-\u001a\u00020\u0010H\u0002J\f\u0010.\u001a\b\u0012\u0004\u0012\u00020$0/J\b\u00100\u001a\u0004\u0018\u000101J\u0006\u00102\u001a\u00020\nJ\u0010\u00103\u001a\u00020\u00142\u0006\u00104\u001a\u00020\fH\u0002J\u0010\u00105\u001a\u00020\u00142\b\u00106\u001a\u0004\u0018\u000107J\u0018\u00108\u001a\u00020\u00142\b\u0010\t\u001a\u0004\u0018\u00010\u00062\u0006\u00109\u001a\u00020\fJ\u0006\u0010:\u001a\u00020\u0014J\u0016\u0010;\u001a\u00020\u00142\u0006\u0010<\u001a\u00020\u00062\u0006\u00109\u001a\u00020\fJ\u0010\u0010=\u001a\u00020\u00142\b\u0010>\u001a\u0004\u0018\u00010\u0006J\u0006\u0010?\u001a\u00020\u0014J\u0012\u0010@\u001a\u0004\u0018\u00010$2\u0006\u0010A\u001a\u00020BH\u0002R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082.\u00a2\u0006\u0002\n\u0000RF\u0010\u0016\u001a\u0013\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u0012\u00a2\u0006\u0002\b\u00152\u0017\u0010\u0011\u001a\u0013\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u0012\u00a2\u0006\u0002\b\u00158F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010#\u001a\u0004\u0018\u00010$X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020&X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006C"}, d2={"Lorg/jetbrains/plugins/github/authentication/ui/GithubLoginPanel;", "Lcom/intellij/ui/components/panels/Wrapper;", "executorFactory", "Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor$Factory;", "isAccountUnique", "Lkotlin/Function2;", "", "Lkotlin/ParameterName;", "name", "login", "Lorg/jetbrains/plugins/github/api/GithubServerPath;", "server", "", "Lorg/jetbrains/plugins/github/authentication/ui/UniqueLoginPredicate;", "(Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor$Factory;Lkotlin/jvm/functions/Function2;)V", "currentUi", "Lorg/jetbrains/plugins/github/authentication/ui/GHCredentialsUi;", "value", "Lkotlin/Function1;", "Lcom/intellij/ui/layout/LayoutBuilder;", "", "Lkotlin/ExtensionFunctionType;", "footer", "getFooter", "()Lkotlin/jvm/functions/Function1;", "setFooter", "(Lkotlin/jvm/functions/Function1;)V", "oauthUi", "Lorg/jetbrains/plugins/github/authentication/ui/GHOAuthCredentialsUi;", "progressExtension", "Lcom/intellij/ui/components/fields/ExtendableTextComponent$Extension;", "progressIcon", "Lcom/intellij/ui/AnimatedIcon$Default;", "serverTextField", "Lcom/intellij/ui/components/fields/ExtendableTextField;", "tokenAcquisitionError", "Lcom/intellij/openapi/ui/ValidationInfo;", "tokenUi", "Lorg/jetbrains/plugins/github/authentication/ui/GHTokenCredentialsUi;", "acquireLoginAndToken", "Ljava/util/concurrent/CompletableFuture;", "Lkotlin/Pair;", "progressIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "applyUi", "ui", "doValidateAll", "", "getPreferredFocusableComponent", "Ljavax/swing/JComponent;", "getServer", "setBusy", "busy", "setError", "exception", "", "setLogin", "editable", "setOAuthUi", "setServer", "path", "setToken", "token", "setTokenUi", "validateServerPath", "field", "Ljavax/swing/JTextField;", "intellij.vcs.github"})
public final class GithubLoginPanel
extends Wrapper {
    private final ExtendableTextField serverTextField = new ExtendableTextField("github.com", 0);
    private ValidationInfo tokenAcquisitionError;
    private GHCredentialsUi currentUi;
    private GHTokenCredentialsUi tokenUi;
    private GHOAuthCredentialsUi oauthUi;
    private final AnimatedIcon.Default progressIcon;
    private final ExtendableTextComponent.Extension progressExtension;

    @NotNull
    public final Function1<LayoutBuilder, Unit> getFooter() {
        return this.tokenUi.getFooter();
    }

    public final void setFooter(@NotNull Function1<? super LayoutBuilder, Unit> value) {
        this.tokenUi.setFooter(value);
        this.oauthUi.setFooter(value);
        GHCredentialsUi gHCredentialsUi = this.currentUi;
        if (gHCredentialsUi == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"currentUi");
        }
        this.applyUi(gHCredentialsUi);
    }

    private final void applyUi(GHCredentialsUi ui) {
        GHCredentialsUi gHCredentialsUi = this.currentUi = ui;
        if (gHCredentialsUi == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"currentUi");
        }
        this.setContent(gHCredentialsUi.getPanel());
        GHCredentialsUi gHCredentialsUi2 = this.currentUi;
        if (gHCredentialsUi2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"currentUi");
        }
        JComponent jComponent = gHCredentialsUi2.getPreferredFocusableComponent();
        if (jComponent != null) {
            jComponent.requestFocus();
        }
        this.tokenAcquisitionError = null;
    }

    @Nullable
    public final JComponent getPreferredFocusableComponent() {
        JComponent jComponent;
        ExtendableTextField extendableTextField;
        ExtendableTextField it = extendableTextField = this.serverTextField;
        boolean bl = false;
        Object object = it.isEditable() && StringsKt.isBlank((CharSequence)it.getText()) ? extendableTextField : null;
        if (object != null) {
            jComponent = (JComponent)object;
        } else {
            GHCredentialsUi gHCredentialsUi = this.currentUi;
            if (gHCredentialsUi == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"currentUi");
            }
            jComponent = gHCredentialsUi.getPreferredFocusableComponent();
        }
        return jComponent;
    }

    @NotNull
    public final List<ValidationInfo> doValidateAll() {
        ValidationInfo validationInfo;
        ValidationInfo validationInfo2 = DialogValidationUtils.INSTANCE.notBlank((JTextField)this.serverTextField, GithubBundle.message("credentials.server.cannot.be.empty", new Object[0]));
        if (validationInfo2 == null) {
            validationInfo2 = validationInfo = this.validateServerPath((JTextField)this.serverTextField);
        }
        if (validationInfo2 == null) {
            GHCredentialsUi gHCredentialsUi = this.currentUi;
            if (gHCredentialsUi == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"currentUi");
            }
            validationInfo = (ValidationInfo)gHCredentialsUi.getValidator().invoke();
        }
        ValidationInfo uiError = validationInfo;
        return CollectionsKt.listOfNotNull((Object[])new ValidationInfo[]{uiError, this.tokenAcquisitionError});
    }

    private final ValidationInfo validateServerPath(JTextField field) {
        ValidationInfo validationInfo;
        try {
            GithubServerPath.from(field.getText());
            validationInfo = null;
        }
        catch (Exception e) {
            validationInfo = new ValidationInfo(GithubBundle.message("credentials.server.path.invalid", new Object[0]), (JComponent)field);
        }
        return validationInfo;
    }

    private final void setBusy(boolean busy) {
        ExtendableTextField extendableTextField;
        ExtendableTextField $this$apply = extendableTextField = this.serverTextField;
        boolean bl = false;
        if (busy) {
            $this$apply.addExtension(this.progressExtension);
        } else {
            $this$apply.removeExtension(this.progressExtension);
        }
        this.serverTextField.setEnabled(!busy);
        GHCredentialsUi gHCredentialsUi = this.currentUi;
        if (gHCredentialsUi == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"currentUi");
        }
        gHCredentialsUi.setBusy(busy);
    }

    @NotNull
    public final CompletableFuture<Pair<String, String>> acquireLoginAndToken(@NotNull ProgressIndicator progressIndicator) {
        this.setBusy(true);
        this.tokenAcquisitionError = null;
        GithubServerPath server = this.getServer();
        GHCredentialsUi gHCredentialsUi = this.currentUi;
        if (gHCredentialsUi == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"currentUi");
        }
        GithubApiRequestExecutor executor = gHCredentialsUi.createExecutor();
        boolean $i$f$service = false;
        Class<ProgressManager> serviceClass$iv = ProgressManager.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw (Throwable)new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
        }
        return CompletableFutureUtil.INSTANCE.errorOnEdt(CompletableFutureUtil.INSTANCE.completionOnEdt(CompletableFutureUtil.INSTANCE.submitIOTask((ProgressManager)object, progressIndicator, (Function1)new Function1<ProgressIndicator, Pair<? extends String, ? extends String>>(this, server, executor){
            final /* synthetic */ GithubLoginPanel this$0;
            final /* synthetic */ GithubServerPath $server;
            final /* synthetic */ GithubApiRequestExecutor $executor;

            @NotNull
            public final Pair<String, String> invoke(@NotNull ProgressIndicator it) {
                return GithubLoginPanel.access$getCurrentUi$p(this.this$0).acquireLoginAndToken(this.$server, this.$executor, it);
            }
            {
                this.this$0 = githubLoginPanel;
                this.$server = githubServerPath;
                this.$executor = githubApiRequestExecutor;
                super(1);
            }
        }), progressIndicator.getModalityState(), (Function0)new Function0<Unit>(this){
            final /* synthetic */ GithubLoginPanel this$0;

            public final void invoke() {
                GithubLoginPanel.access$setBusy(this.this$0, false);
            }
            {
                this.this$0 = githubLoginPanel;
                super(0);
            }
        }), progressIndicator.getModalityState(), (Function1)new Function1<Throwable, Unit>(this){
            final /* synthetic */ GithubLoginPanel this$0;

            public final void invoke(@NotNull Throwable it) {
                this.this$0.setError(it);
            }
            {
                this.this$0 = githubLoginPanel;
                super(1);
            }
        });
    }

    @NotNull
    public final GithubServerPath getServer() {
        String string = this.serverTextField.getText();
        return GithubServerPath.from(((Object)StringsKt.trim((CharSequence)string)).toString());
    }

    public final void setServer(@NotNull String path, boolean editable) {
        this.serverTextField.setText(path);
        this.serverTextField.setEditable(editable);
    }

    public final void setLogin(@Nullable String login2, boolean editable) {
        this.tokenUi.setFixedLogin(editable ? null : login2);
    }

    public final void setToken(@Nullable String token) {
        String string = token;
        String string2 = string;
        if (string2 == null) {
            string2 = "";
        }
        this.tokenUi.setToken(string2);
    }

    /*
     * WARNING - void declaration
     */
    public final void setError(@Nullable Throwable exception) {
        ValidationInfo validationInfo;
        GithubLoginPanel githubLoginPanel = this;
        Throwable throwable = exception;
        if (throwable != null) {
            void it;
            Throwable throwable2;
            Throwable throwable3 = throwable2 = throwable;
            GithubLoginPanel githubLoginPanel2 = githubLoginPanel;
            boolean bl = false;
            GHCredentialsUi gHCredentialsUi = this.currentUi;
            if (gHCredentialsUi == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"currentUi");
            }
            ValidationInfo validationInfo2 = gHCredentialsUi.handleAcquireError((Throwable)it);
            githubLoginPanel = githubLoginPanel2;
            validationInfo = validationInfo2;
        } else {
            validationInfo = null;
        }
        githubLoginPanel.tokenAcquisitionError = validationInfo;
    }

    public final void setOAuthUi() {
        this.applyUi(this.oauthUi);
    }

    public final void setTokenUi() {
        this.applyUi(this.tokenUi);
    }

    public GithubLoginPanel(@NotNull GithubApiRequestExecutor.Factory executorFactory, @NotNull Function2<? super String, ? super GithubServerPath, Boolean> isAccountUnique) {
        this.tokenUi = new GHTokenCredentialsUi(this.serverTextField, executorFactory, isAccountUnique);
        this.oauthUi = new GHOAuthCredentialsUi(executorFactory, isAccountUnique);
        this.progressIcon = new AnimatedIcon.Default();
        this.progressExtension = new ExtendableTextComponent.Extension(this){
            final /* synthetic */ GithubLoginPanel this$0;

            public final Icon getIcon(boolean it) {
                return (Icon)GithubLoginPanel.access$getProgressIcon$p(this.this$0);
            }
            {
                this.this$0 = githubLoginPanel;
            }
        };
        this.applyUi(this.tokenUi);
    }

    public static final /* synthetic */ GHCredentialsUi access$getCurrentUi$p(GithubLoginPanel $this) {
        GHCredentialsUi gHCredentialsUi = $this.currentUi;
        if (gHCredentialsUi == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"currentUi");
        }
        return gHCredentialsUi;
    }

    public static final /* synthetic */ void access$setCurrentUi$p(GithubLoginPanel $this, GHCredentialsUi gHCredentialsUi) {
        $this.currentUi = gHCredentialsUi;
    }

    public static final /* synthetic */ void access$setBusy(GithubLoginPanel $this, boolean busy) {
        $this.setBusy(busy);
    }

    public static final /* synthetic */ AnimatedIcon.Default access$getProgressIcon$p(GithubLoginPanel $this) {
        return $this.progressIcon;
    }
}

