/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.authentication.ui;

import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.components.fields.ExtendableTextField;
import com.intellij.ui.layout.CCFlags;
import com.intellij.ui.layout.Cell;
import com.intellij.ui.layout.GrowPolicy;
import com.intellij.ui.layout.InnerCell;
import com.intellij.ui.layout.LayoutBuilder;
import com.intellij.ui.layout.Row;
import com.intellij.ui.layout.RowBuilder;
import java.awt.event.ActionEvent;
import java.net.UnknownHostException;
import javax.swing.JComponent;
import javax.swing.JTextField;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.GithubApiRequestExecutor;
import org.jetbrains.plugins.github.api.GithubServerPath;
import org.jetbrains.plugins.github.api.data.GithubAuthenticatedUser;
import org.jetbrains.plugins.github.authentication.ui.GHCredentialsUi;
import org.jetbrains.plugins.github.authentication.ui.GHTokenCredentialsUi;
import org.jetbrains.plugins.github.authentication.ui.GHTokenCredentialsUiKt;
import org.jetbrains.plugins.github.authentication.ui.LoginNotUniqueException;
import org.jetbrains.plugins.github.authentication.util.GHSecurityUtil;
import org.jetbrains.plugins.github.exceptions.GithubAuthenticationException;
import org.jetbrains.plugins.github.exceptions.GithubParseException;
import org.jetbrains.plugins.github.i18n.GithubBundle;
import org.jetbrains.plugins.github.ui.util.DialogValidationUtils;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 12\u00020\u0001:\u00011BQ\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012:\u0010\u0006\u001a6\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\r\u0012\u0004\u0012\u00020\u000e0\u0007j\u0002`\u000f\u00a2\u0006\u0002\u0010\u0010J,\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u00182\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0002J\b\u0010\u001f\u001a\u00020 H\u0016J\b\u0010!\u001a\u00020\"H\u0016J\u0014\u0010#\u001a\u000e\u0012\u0006\u0012\u0004\u0018\u00010%0$j\u0002`&H\u0016J\u0010\u0010'\u001a\u00020%2\u0006\u0010(\u001a\u00020)H\u0016J\u0010\u0010*\u001a\u00020\u001e2\u0006\u0010+\u001a\u00020\u000eH\u0016J\u0010\u0010,\u001a\u00020\u001e2\b\u0010\u0013\u001a\u0004\u0018\u00010\bJ\u000e\u0010-\u001a\u00020\u001e2\u0006\u0010.\u001a\u00020\bJ\f\u0010/\u001a\u00020\u001e*\u000200H\u0014R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000RE\u0010\u0006\u001a6\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\r\u0012\u0004\u0012\u00020\u000e0\u0007j\u0002`\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lorg/jetbrains/plugins/github/authentication/ui/GHTokenCredentialsUi;", "Lorg/jetbrains/plugins/github/authentication/ui/GHCredentialsUi;", "serverTextField", "Lcom/intellij/ui/components/fields/ExtendableTextField;", "factory", "Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor$Factory;", "isAccountUnique", "Lkotlin/Function2;", "", "Lkotlin/ParameterName;", "name", "login", "Lorg/jetbrains/plugins/github/api/GithubServerPath;", "server", "", "Lorg/jetbrains/plugins/github/authentication/ui/UniqueLoginPredicate;", "(Lcom/intellij/ui/components/fields/ExtendableTextField;Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor$Factory;Lkotlin/jvm/functions/Function2;)V", "getFactory", "()Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor$Factory;", "fixedLogin", "()Lkotlin/jvm/functions/Function2;", "tokenTextField", "Lcom/intellij/ui/components/JBTextField;", "acquireLoginAndToken", "Lkotlin/Pair;", "executor", "Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "browseNewTokenUrl", "", "createExecutor", "Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor$WithTokenAuth;", "getPreferredFocusableComponent", "Ljavax/swing/JComponent;", "getValidator", "Lkotlin/Function0;", "Lcom/intellij/openapi/ui/ValidationInfo;", "Lorg/jetbrains/plugins/github/ui/util/Validator;", "handleAcquireError", "error", "", "setBusy", "busy", "setFixedLogin", "setToken", "token", "centerPanel", "Lcom/intellij/ui/layout/LayoutBuilder;", "Companion", "intellij.vcs.github"})
public final class GHTokenCredentialsUi
extends GHCredentialsUi {
    private final JBTextField tokenTextField;
    private String fixedLogin;
    private final ExtendableTextField serverTextField;
    @NotNull
    private final GithubApiRequestExecutor.Factory factory;
    @NotNull
    private final Function2<String, GithubServerPath, Boolean> isAccountUnique;
    @NotNull
    public static final Companion Companion = new Companion(null);

    public final void setToken(@NotNull String token) {
        this.tokenTextField.setText(token);
    }

    @Override
    protected void centerPanel(@NotNull LayoutBuilder $this$centerPanel) {
        RowBuilder.DefaultImpls.row$default((RowBuilder)((RowBuilder)$this$centerPanel), (String)GithubBundle.message("credentials.server.field", new Object[0]), (boolean)false, (Function1)((Function1)new Function1<Row, Unit>(this){
            final /* synthetic */ GHTokenCredentialsUi this$0;

            public final void invoke(@NotNull Row $this$row) {
                Cell.invoke$default((Cell)((Cell)$this$row), (JComponent)((JComponent)GHTokenCredentialsUi.access$getServerTextField$p(this.this$0)), (CCFlags[])new CCFlags[]{$this$row.getPushX(), $this$row.getGrowX()}, null, null, (int)6, null);
            }
            {
                this.this$0 = gHTokenCredentialsUi;
                super(1);
            }
        }), (int)2, null);
        RowBuilder.DefaultImpls.row$default((RowBuilder)((RowBuilder)$this$centerPanel), (String)GithubBundle.message("credentials.token.field", new Object[0]), (boolean)false, (Function1)((Function1)new Function1<Row, Unit>(this){
            final /* synthetic */ GHTokenCredentialsUi this$0;

            public final void invoke(@NotNull Row $this$row) {
                Row this_$iv = $this$row;
                boolean isVerticalFlow$iv = false;
                boolean isFullWidth$iv = false;
                boolean $i$f$cell = false;
                this_$iv.setCellMode(true, isVerticalFlow$iv, isFullWidth$iv);
                InnerCell $this$cell = new InnerCell((Cell)this_$iv);
                boolean bl = false;
                CCFlags[] cCFlagsArray = new CCFlags[]{$this$cell.getPushX(), $this$cell.getGrowX()};
                GrowPolicy growPolicy = null;
                String string = GithubBundle.message("login.insufficient.scopes", GHSecurityUtil.INSTANCE.getMASTER_SCOPES());
                Cell.invoke$default((Cell)((Cell)$this$cell), (JComponent)((JComponent)GHTokenCredentialsUi.access$getTokenTextField$p(this.this$0)), (CCFlags[])cCFlagsArray, growPolicy, (String)string, (int)2, null);
                $this$cell.button(GithubBundle.message("credentials.button.generate", new Object[0]), (Function1)new Function1<ActionEvent, Unit>(this){
                    final /* synthetic */ centerPanel.2 this$0;
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }

                    public final void invoke(@NotNull ActionEvent it) {
                        GHTokenCredentialsUi.access$browseNewTokenUrl(this.this$0.this$0);
                    }
                }).enableIf(GHTokenCredentialsUiKt.access$getServerValid$p((JTextField)GHTokenCredentialsUi.access$getServerTextField$p(this.this$0)));
                this_$iv.setCellMode(false, isVerticalFlow$iv, isFullWidth$iv);
            }
            {
                this.this$0 = gHTokenCredentialsUi;
                super(1);
            }
        }), (int)2, null);
    }

    private final void browseNewTokenUrl() {
        GithubServerPath githubServerPath = GHTokenCredentialsUiKt.access$tryParseServer((JTextField)this.serverTextField);
        Intrinsics.checkNotNull((Object)githubServerPath);
        BrowserUtil.browse((String)GHSecurityUtil.INSTANCE.buildNewTokenUrl$intellij_vcs_github(githubServerPath));
    }

    @Override
    @NotNull
    public JComponent getPreferredFocusableComponent() {
        return (JComponent)this.tokenTextField;
    }

    @Override
    @NotNull
    public Function0<ValidationInfo> getValidator() {
        return (Function0)new Function0<ValidationInfo>(this){
            final /* synthetic */ GHTokenCredentialsUi this$0;

            @Nullable
            public final ValidationInfo invoke() {
                return DialogValidationUtils.INSTANCE.notBlank((JTextField)GHTokenCredentialsUi.access$getTokenTextField$p(this.this$0), GithubBundle.message("login.token.cannot.be.empty", new Object[0]));
            }
            {
                this.this$0 = gHTokenCredentialsUi;
                super(0);
            }
        };
    }

    @Override
    @NotNull
    public GithubApiRequestExecutor.WithTokenAuth createExecutor() {
        return this.factory.create(this.tokenTextField.getText());
    }

    @Override
    @NotNull
    public Pair<String, String> acquireLoginAndToken(@NotNull GithubServerPath server, @NotNull GithubApiRequestExecutor executor, @NotNull ProgressIndicator indicator) {
        String login2 = Companion.acquireLogin(server, executor, indicator, this.isAccountUnique, this.fixedLogin);
        return TuplesKt.to((Object)login2, (Object)this.tokenTextField.getText());
    }

    @Override
    @NotNull
    public ValidationInfo handleAcquireError(@NotNull Throwable error) {
        ValidationInfo validationInfo;
        Throwable throwable = error;
        if (throwable instanceof GithubParseException) {
            String string = error.getMessage();
            if (string == null) {
                string = GithubBundle.message("credentials.invalid.server.path", new Object[0]);
            }
            validationInfo = new ValidationInfo(string, (JComponent)this.serverTextField);
        } else {
            validationInfo = Companion.handleError(error);
        }
        return validationInfo;
    }

    @Override
    public void setBusy(boolean busy) {
        this.tokenTextField.setEnabled(!busy);
    }

    public final void setFixedLogin(@Nullable String fixedLogin) {
        this.fixedLogin = fixedLogin;
    }

    @NotNull
    public final GithubApiRequestExecutor.Factory getFactory() {
        return this.factory;
    }

    @NotNull
    public final Function2<String, GithubServerPath, Boolean> isAccountUnique() {
        return this.isAccountUnique;
    }

    public GHTokenCredentialsUi(@NotNull ExtendableTextField serverTextField, @NotNull GithubApiRequestExecutor.Factory factory2, @NotNull Function2<? super String, ? super GithubServerPath, Boolean> isAccountUnique) {
        this.serverTextField = serverTextField;
        this.factory = factory2;
        this.isAccountUnique = isAccountUnique;
        this.tokenTextField = new JBTextField();
    }

    public static final /* synthetic */ ExtendableTextField access$getServerTextField$p(GHTokenCredentialsUi $this) {
        return $this.serverTextField;
    }

    public static final /* synthetic */ JBTextField access$getTokenTextField$p(GHTokenCredentialsUi $this) {
        return $this.tokenTextField;
    }

    public static final /* synthetic */ void access$browseNewTokenUrl(GHTokenCredentialsUi $this) {
        $this.browseNewTokenUrl();
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002Jd\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2:\u0010\u000b\u001a6\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u000f\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u0005\u0012\u0004\u0012\u00020\u00100\fj\u0002`\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0004J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/plugins/github/authentication/ui/GHTokenCredentialsUi$Companion;", "", "()V", "acquireLogin", "", "server", "Lorg/jetbrains/plugins/github/api/GithubServerPath;", "executor", "Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "isAccountUnique", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "login", "", "Lorg/jetbrains/plugins/github/authentication/ui/UniqueLoginPredicate;", "fixedLogin", "handleError", "Lcom/intellij/openapi/ui/ValidationInfo;", "error", "", "intellij.vcs.github"})
    public static final class Companion {
        /*
         * WARNING - void declaration
         */
        @NotNull
        public final String acquireLogin(@NotNull GithubServerPath server, @NotNull GithubApiRequestExecutor executor, @NotNull ProgressIndicator indicator, @NotNull Function2<? super String, ? super GithubServerPath, Boolean> isAccountUnique, @Nullable String fixedLogin) {
            void details2;
            Pair<GithubAuthenticatedUser, String> pair = GHSecurityUtil.loadCurrentUserWithScopes$intellij_vcs_github(executor, indicator, server);
            GithubAuthenticatedUser githubAuthenticatedUser = (GithubAuthenticatedUser)pair.component1();
            String scopes = (String)pair.component2();
            if (scopes == null || !GHSecurityUtil.isEnoughScopes$intellij_vcs_github(scopes)) {
                throw (Throwable)new GithubAuthenticationException("Insufficient scopes granted to token.");
            }
            String login2 = details2.getLogin();
            if (fixedLogin != null && Intrinsics.areEqual((Object)fixedLogin, (Object)login2) ^ true) {
                throw (Throwable)new GithubAuthenticationException("Token should match username \"" + fixedLogin + "\"");
            }
            if (!((Boolean)isAccountUnique.invoke((Object)login2, (Object)server)).booleanValue()) {
                throw (Throwable)new LoginNotUniqueException(login2);
            }
            return login2;
        }

        @NotNull
        public final ValidationInfo handleError(@NotNull Throwable error) {
            ValidationInfo validationInfo;
            Throwable throwable = error;
            if (throwable instanceof LoginNotUniqueException) {
                validationInfo = new ValidationInfo(GithubBundle.message("login.account.already.added", ((LoginNotUniqueException)error).getLogin())).withOKEnabled();
            } else if (throwable instanceof UnknownHostException) {
                validationInfo = new ValidationInfo(GithubBundle.message("server.unreachable", new Object[0])).withOKEnabled();
            } else if (throwable instanceof GithubAuthenticationException) {
                Object[] objectArray = new Object[1];
                String string = error.getMessage();
                String string2 = string;
                if (string2 == null) {
                    string2 = "";
                }
                objectArray[0] = string2;
                validationInfo = new ValidationInfo(GithubBundle.message("credentials.incorrect", objectArray)).withOKEnabled();
            } else {
                Object[] objectArray = new Object[1];
                String string = error.getMessage();
                String string3 = string;
                if (string3 == null) {
                    string3 = "";
                }
                objectArray[0] = string3;
                validationInfo = new ValidationInfo(GithubBundle.message("credentials.invalid.auth.data", objectArray)).withOKEnabled();
            }
            return validationInfo;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

