/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.authentication.ui;

import com.intellij.codeWithMe.ClientId;
import com.intellij.collaboration.async.CompletableFutureUtil;
import com.intellij.collaboration.auth.Account;
import com.intellij.collaboration.auth.AccountDetails;
import com.intellij.collaboration.auth.ui.AccountsDetailsLoader;
import com.intellij.collaboration.ui.ExceptionUtil;
import com.intellij.collaboration.util.ProgressIndicatorsProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import java.awt.Image;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.functions.Function1;
import kotlinx.coroutines.CompletableDeferred;
import kotlinx.coroutines.CompletableDeferredKt;
import kotlinx.coroutines.Deferred;
import kotlinx.coroutines.future.FutureKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.github.api.GithubApiRequestExecutor;
import org.jetbrains.plugins.github.api.data.GithubAuthenticatedUser;
import org.jetbrains.plugins.github.api.data.GithubUserDetailed;
import org.jetbrains.plugins.github.authentication.accounts.GHAccountManager;
import org.jetbrains.plugins.github.authentication.accounts.GithubAccount;
import org.jetbrains.plugins.github.authentication.ui.GHAccountsListModel;
import org.jetbrains.plugins.github.authentication.util.GHSecurityUtil;
import org.jetbrains.plugins.github.i18n.GithubBundle;
import org.jetbrains.plugins.github.util.CachingGHUserAvatarLoader;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u001d\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u0002H\u0002J&\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u0002H\u0002J \u0010\u0014\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00160\u00152\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u001c\u0010\u0019\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u000f0\u00152\u0006\u0010\r\u001a\u00020\u0002H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/plugins/github/authentication/ui/GHAccountsDetailsLoader;", "Lcom/intellij/collaboration/auth/ui/AccountsDetailsLoader;", "Lorg/jetbrains/plugins/github/authentication/accounts/GithubAccount;", "Lorg/jetbrains/plugins/github/api/data/GithubUserDetailed;", "accountManager", "Lorg/jetbrains/plugins/github/authentication/accounts/GHAccountManager;", "indicatorsProvider", "Lcom/intellij/collaboration/util/ProgressIndicatorsProvider;", "accountsModel", "Lorg/jetbrains/plugins/github/authentication/ui/GHAccountsListModel;", "(Lorg/jetbrains/plugins/github/authentication/accounts/GHAccountManager;Lcom/intellij/collaboration/util/ProgressIndicatorsProvider;Lorg/jetbrains/plugins/github/authentication/ui/GHAccountsListModel;)V", "createExecutor", "Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor;", "account", "doLoadDetails", "Lcom/intellij/collaboration/auth/ui/AccountsDetailsLoader$Result;", "Lorg/jetbrains/plugins/github/api/data/GithubAuthenticatedUser;", "executor", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "loadAvatarAsync", "Lkotlinx/coroutines/Deferred;", "Ljava/awt/Image;", "url", "", "loadDetailsAsync", "intellij.vcs.github"})
public final class GHAccountsDetailsLoader
implements AccountsDetailsLoader<GithubAccount, GithubUserDetailed> {
    private final GHAccountManager accountManager;
    private final ProgressIndicatorsProvider indicatorsProvider;
    private final GHAccountsListModel accountsModel;

    @NotNull
    public Deferred<AccountsDetailsLoader.Result<GithubUserDetailed>> loadDetailsAsync(@NotNull GithubAccount account) {
        GithubApiRequestExecutor githubApiRequestExecutor = this.createExecutor(account);
        if (githubApiRequestExecutor == null) {
            return (Deferred)CompletableDeferredKt.CompletableDeferred((Object)new AccountsDetailsLoader.Result.Error(GithubBundle.message("account.token.missing", new Object[0]), true));
        }
        GithubApiRequestExecutor executor = githubApiRequestExecutor;
        return FutureKt.asDeferred((CompletionStage)CompletableFutureUtil.INSTANCE.submitIOTask(ProgressManager.getInstance(), this.indicatorsProvider, true, (Function1)new Function1<ProgressIndicator, AccountsDetailsLoader.Result<? extends GithubAuthenticatedUser>>(this, executor, account){
            final /* synthetic */ GHAccountsDetailsLoader this$0;
            final /* synthetic */ GithubApiRequestExecutor $executor;
            final /* synthetic */ GithubAccount $account;

            @NotNull
            public final AccountsDetailsLoader.Result<GithubAuthenticatedUser> invoke(@NotNull ProgressIndicator it) {
                return GHAccountsDetailsLoader.access$doLoadDetails(this.this$0, this.$executor, it, this.$account);
            }
            {
                this.this$0 = gHAccountsDetailsLoader;
                this.$executor = githubApiRequestExecutor;
                this.$account = githubAccount;
                super(1);
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    private final AccountsDetailsLoader.Result<GithubAuthenticatedUser> doLoadDetails(GithubApiRequestExecutor executor, ProgressIndicator indicator, GithubAccount account) {
        void details2;
        Pair<GithubAuthenticatedUser, String> pair;
        try {
            pair = GHSecurityUtil.loadCurrentUserWithScopes$intellij_vcs_github(executor, indicator, account.getServer());
        }
        catch (Throwable e) {
            String errorMessage = ExceptionUtil.INSTANCE.getPresentableMessage(e);
            return (AccountsDetailsLoader.Result)new AccountsDetailsLoader.Result.Error(errorMessage, false);
        }
        Object object = pair;
        GithubAuthenticatedUser githubAuthenticatedUser = (GithubAuthenticatedUser)object.component1();
        String scopes = (String)object.component2();
        object = scopes;
        Object object2 = object;
        if (object2 == null) {
            object2 = "";
        }
        if (!GHSecurityUtil.isEnoughScopes$intellij_vcs_github(object2)) {
            return (AccountsDetailsLoader.Result)new AccountsDetailsLoader.Result.Error(GithubBundle.message("account.scopes.insufficient", new Object[0]), true);
        }
        return (AccountsDetailsLoader.Result)new AccountsDetailsLoader.Result.Success((AccountDetails)details2);
    }

    @NotNull
    public Deferred<Image> loadAvatarAsync(@NotNull GithubAccount account, @NotNull String url) {
        GithubApiRequestExecutor githubApiRequestExecutor = this.createExecutor(account);
        if (githubApiRequestExecutor == null) {
            CompletableDeferred completableDeferred;
            CompletableDeferred $this$apply = completableDeferred = CompletableDeferredKt.CompletableDeferred(null);
            boolean bl = false;
            $this$apply.complete(null);
            return (Deferred)completableDeferred;
        }
        GithubApiRequestExecutor apiExecutor = githubApiRequestExecutor;
        return FutureKt.asDeferred((CompletionStage)CachingGHUserAvatarLoader.Companion.getInstance().requestAvatar(apiExecutor, url));
    }

    private final GithubApiRequestExecutor createExecutor(GithubAccount account) {
        Map map2 = this.accountsModel.getNewCredentials();
        Object object = map2.get((Object)account);
        if (object == null) {
            boolean bl = false;
            object = (String)this.accountManager.findCredentials((Account)account);
        }
        String string = (String)object;
        if (string == null) {
            return null;
        }
        String token = string;
        boolean $i$f$service = false;
        Class<GithubApiRequestExecutor.Factory> serviceClass$iv = GithubApiRequestExecutor.Factory.class;
        Object object2 = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object2 == null) {
            throw (Throwable)new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
        }
        return ((GithubApiRequestExecutor.Factory)object2).create(token);
    }

    public GHAccountsDetailsLoader(@NotNull GHAccountManager accountManager, @NotNull ProgressIndicatorsProvider indicatorsProvider, @NotNull GHAccountsListModel accountsModel) {
        this.accountManager = accountManager;
        this.indicatorsProvider = indicatorsProvider;
        this.accountsModel = accountsModel;
    }

    public static final /* synthetic */ AccountsDetailsLoader.Result access$doLoadDetails(GHAccountsDetailsLoader $this, GithubApiRequestExecutor executor, ProgressIndicator indicator, GithubAccount account) {
        return $this.doLoadDetails(executor, indicator, account);
    }
}

