/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.api.data;

import com.intellij.util.ObjectUtils;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.data.GithubIssueLabel;
import org.jetbrains.plugins.github.api.data.GithubIssueState;
import org.jetbrains.plugins.github.api.data.GithubLink;
import org.jetbrains.plugins.github.api.data.GithubRepo;
import org.jetbrains.plugins.github.api.data.GithubUser;

public class GithubPullRequest {
    private String url;
    private Long id;
    private String htmlUrl;
    private String diffUrl;
    private String patchUrl;
    private Long number;
    private GithubIssueState state;
    private Boolean locked;
    private String activeLockReason;
    private String title;
    private GithubUser user;
    private String body;
    private Date updatedAt;
    private Date closedAt;
    private Date mergedAt;
    private Date createdAt;
    private String mergeCommitSha;
    private List<GithubUser> assignees;
    private List<GithubUser> requestedReviewers;
    private List<GithubIssueLabel> labels;
    private Tag head;
    private Tag base;
    private Links _links;
    private String authorAssociation;

    @NotNull
    public String getUrl() {
        return this.url;
    }

    @NotNull
    public String getHtmlUrl() {
        return this.htmlUrl;
    }

    @NotNull
    public String getDiffUrl() {
        return this.diffUrl;
    }

    @NotNull
    public String getPatchUrl() {
        return this.patchUrl;
    }

    public long getNumber() {
        return this.number;
    }

    @NotNull
    public GithubIssueState getState() {
        return this.state;
    }

    @NotNull
    public String getTitle() {
        return this.title;
    }

    @NotNull
    public String getBody() {
        return this.body;
    }

    @NotNull
    public Date getCreatedAt() {
        return this.createdAt;
    }

    @NotNull
    public Date getUpdatedAt() {
        return this.updatedAt;
    }

    @Nullable
    public Date getClosedAt() {
        return this.closedAt;
    }

    @Nullable
    public Date getMergedAt() {
        return this.mergedAt;
    }

    @NotNull
    public GithubUser getUser() {
        return (GithubUser)ObjectUtils.notNull((Object)this.user, (Object)GithubUser.UNKNOWN);
    }

    @NotNull
    public List<GithubUser> getAssignees() {
        return this.assignees;
    }

    @NotNull
    public List<GithubUser> getRequestedReviewers() {
        return this.requestedReviewers;
    }

    @Nullable
    public List<GithubIssueLabel> getLabels() {
        return this.labels;
    }

    @NotNull
    public Links getLinks() {
        return this._links;
    }

    @NotNull
    public Tag getHead() {
        return this.head;
    }

    @NotNull
    public Tag getBase() {
        return this.base;
    }

    public static class Links {
        private GithubLink self;
        private GithubLink html;
        private GithubLink issue;
        private GithubLink comments;
        private GithubLink reviewComments;
        private GithubLink reviewComment;
        private GithubLink commits;
        private GithubLink statuses;
    }

    public static class Tag {
        private String label;
        private String ref;
        private String sha;
        private GithubRepo repo;
        private GithubUser user;

        @NotNull
        public String getLabel() {
            return this.label;
        }

        @NotNull
        public String getRef() {
            return this.ref;
        }

        @NotNull
        public String getSha() {
            return this.sha;
        }

        @Nullable
        public GithubRepo getRepo() {
            return this.repo;
        }

        @Nullable
        public GithubUser getUser() {
            return this.user;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Tag)) {
                return false;
            }
            Tag tag = (Tag)o;
            return Objects.equals(this.label, tag.label) && Objects.equals(this.ref, tag.ref) && Objects.equals(this.sha, tag.sha) && Objects.equals(this.repo, tag.repo) && Objects.equals(this.user, tag.user);
        }

        public int hashCode() {
            return Objects.hash(this.label, this.ref, this.sha, this.repo, this.user);
        }
    }
}

