/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.api;

import com.intellij.collaboration.api.ServerPath;
import com.intellij.collaboration.hosting.GitHostingUrlUtil;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Tag;
import java.net.URI;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.exceptions.GithubParseException;

@Tag(value="server")
public final class GithubServerPath
implements ServerPath {
    public static final String DEFAULT_HOST = "github.com";
    public static final GithubServerPath DEFAULT_SERVER = new GithubServerPath("github.com");
    private static final String API_PREFIX = "api.";
    private static final String API_SUFFIX = "/api";
    private static final String ENTERPRISE_API_V3_SUFFIX = "/v3";
    private static final String GRAPHQL_SUFFIX = "/graphql";
    @Attribute(value="useHttp")
    @Nullable
    private final Boolean myUseHttp;
    @Attribute(value="host")
    @NotNull
    private final String myHost;
    @Attribute(value="port")
    @Nullable
    private final Integer myPort;
    @Attribute(value="suffix")
    @Nullable
    private final String mySuffix;
    private static final Pattern URL_REGEX = Pattern.compile("^(https?://)?([^/?:]+)(:(\\d+))?((/[^/?#]+)*)?/?", 2);

    public GithubServerPath() {
        this(null, "", null, null);
    }

    public GithubServerPath(@NonNls @NotNull String host) {
        this(null, host, null, null);
    }

    public GithubServerPath(@Nullable Boolean useHttp, @NonNls @NotNull String host, @Nullable Integer port, @NonNls @Nullable String suffix) {
        this.myUseHttp = useHttp;
        this.myHost = StringUtil.toLowerCase((String)host);
        this.myPort = port;
        this.mySuffix = suffix;
    }

    @NotNull
    public String getSchema() {
        return this.myUseHttp == null || this.myUseHttp == false ? "https" : "http";
    }

    @NotNull
    public String getHost() {
        return this.myHost;
    }

    @Nullable
    public Integer getPort() {
        return this.myPort;
    }

    @Nullable
    public String getSuffix() {
        return this.mySuffix;
    }

    public boolean matches(@NotNull String gitRemoteUrl) {
        URI uri = GitHostingUrlUtil.getUriFromRemoteUrl((String)gitRemoteUrl);
        if (uri == null) {
            return false;
        }
        String host = uri.getHost();
        if (host == null) {
            return false;
        }
        if (!this.myHost.equalsIgnoreCase(host)) {
            return false;
        }
        if (this.mySuffix != null) {
            String path = uri.getPath();
            if (path == null) {
                return false;
            }
            return StringUtil.startsWithIgnoreCase((String)path, (String)this.mySuffix);
        }
        return true;
    }

    @NotNull
    public static GithubServerPath from(@NotNull String uri) throws GithubParseException {
        Integer port;
        Matcher matcher = URL_REGEX.matcher(uri);
        if (!matcher.matches()) {
            throw new GithubParseException("Not a valid URL");
        }
        String schema = matcher.group(1);
        Boolean httpSchema = schema == null || schema.isEmpty() ? null : Boolean.valueOf(schema.equalsIgnoreCase("http://"));
        String host = matcher.group(2);
        if (host == null) {
            throw new GithubParseException("Empty host");
        }
        String portGroup = matcher.group(4);
        if (portGroup == null) {
            port = null;
        } else {
            try {
                port = Integer.parseInt(portGroup);
            }
            catch (NumberFormatException e) {
                throw new GithubParseException("Invalid port format");
            }
        }
        String path = StringUtil.nullize((String)matcher.group(5));
        return new GithubServerPath(httpSchema, host, port, path);
    }

    @NotNull
    public String toUrl() {
        return this.toUrl(true);
    }

    @NotNull
    public String toUrl(boolean showSchema) {
        StringBuilder builder = new StringBuilder();
        if (showSchema) {
            builder.append(this.getSchemaUrlPart());
        }
        builder.append(this.myHost).append(this.getPortUrlPart()).append(StringUtil.notNullize((String)this.mySuffix));
        return builder.toString();
    }

    @NotNull
    public String toApiUrl() {
        StringBuilder builder = new StringBuilder(this.getSchemaUrlPart());
        if (this.isGithubDotCom()) {
            builder.append(API_PREFIX).append(this.myHost).append(this.getPortUrlPart()).append(StringUtil.notNullize((String)this.mySuffix));
        } else {
            builder.append(this.myHost).append(this.getPortUrlPart()).append(StringUtil.notNullize((String)this.mySuffix)).append(API_SUFFIX).append(ENTERPRISE_API_V3_SUFFIX);
        }
        return builder.toString();
    }

    @NotNull
    public String toGraphQLUrl() {
        StringBuilder builder = new StringBuilder(this.getSchemaUrlPart());
        if (this.isGithubDotCom()) {
            builder.append(API_PREFIX).append(this.myHost).append(this.getPortUrlPart()).append(StringUtil.notNullize((String)this.mySuffix)).append(GRAPHQL_SUFFIX);
        } else {
            builder.append(this.myHost).append(this.getPortUrlPart()).append(StringUtil.notNullize((String)this.mySuffix)).append(API_SUFFIX).append(GRAPHQL_SUFFIX);
        }
        return builder.toString();
    }

    public boolean isGithubDotCom() {
        return this.myHost.equalsIgnoreCase(DEFAULT_HOST);
    }

    @NlsSafe
    @NotNull
    public String toString() {
        String schema = this.myUseHttp != null ? this.getSchemaUrlPart() : "";
        return schema + this.myHost + this.getPortUrlPart() + StringUtil.notNullize((String)this.mySuffix);
    }

    @NotNull
    private String getPortUrlPart() {
        return this.myPort != null ? ":" + this.myPort.toString() : "";
    }

    @NotNull
    private String getSchemaUrlPart() {
        return this.getSchema() + "://";
    }

    public boolean equals(Object o) {
        return this.equals(o, false);
    }

    public boolean equals(Object o, boolean ignoreProtocol) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GithubServerPath)) {
            return false;
        }
        GithubServerPath path = (GithubServerPath)o;
        return (ignoreProtocol || Objects.equals(this.myUseHttp, path.myUseHttp)) && Objects.equals(this.myHost, path.myHost) && Objects.equals(this.myPort, path.myPort) && Objects.equals(this.mySuffix, path.mySuffix);
    }

    public int hashCode() {
        return Objects.hash(this.myHost, this.myPort, this.mySuffix);
    }
}

