/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.api;

import java.util.List;
import kotlin.Metadata;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0004J\u0018\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u0006H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/plugins/github/api/GHEServerVersionChecker;", "", "()V", "ENTERPRISE_VERSION_HEADER", "", "REQUIRED_VERSION_MAJOR", "", "REQUIRED_VERSION_MINOR", "checkVersionSupported", "", "versionValue", "throwUnsupportedVersion", "currentMajor", "currentMinor", "intellij.vcs.github"})
public final class GHEServerVersionChecker {
    private static final int REQUIRED_VERSION_MAJOR = 2;
    private static final int REQUIRED_VERSION_MINOR = 21;
    @NotNull
    public static final String ENTERPRISE_VERSION_HEADER = "x-github-enterprise-version";
    @NotNull
    public static final GHEServerVersionChecker INSTANCE;

    public final void checkVersionSupported(@NotNull String versionValue) {
        block4: {
            int minorVersion;
            int majorVersion;
            block3: {
                majorVersion = 0;
                minorVersion = 0;
                try {
                    List versionSplit = StringsKt.split$default((CharSequence)versionValue, (char[])new char[]{'.'}, (boolean)false, (int)0, (int)6, null);
                    String string = (String)versionSplit.get(0);
                    majorVersion = Integer.parseInt(string);
                    string = (String)versionSplit.get(1);
                    minorVersion = Integer.parseInt(string);
                }
                catch (Throwable e) {
                    throw (Throwable)new IllegalStateException("Could not determine GitHub Enterprise server version", e);
                }
                if (majorVersion > 2) {
                    return;
                }
                if (majorVersion >= 2) break block3;
                this.throwUnsupportedVersion(majorVersion, minorVersion);
                break block4;
            }
            if (majorVersion != 2 || minorVersion >= 21) break block4;
            this.throwUnsupportedVersion(majorVersion, minorVersion);
        }
    }

    private final void throwUnsupportedVersion(int currentMajor, int currentMinor) {
        String string = "Unsupported GitHub Enterprise server version " + currentMajor + "." + currentMinor + ". Earliest supported version is 2.21";
        throw new IllegalStateException(string.toString());
    }

    private GHEServerVersionChecker() {
    }

    static {
        GHEServerVersionChecker gHEServerVersionChecker;
        INSTANCE = gHEServerVersionChecker = new GHEServerVersionChecker();
    }
}

