/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github;

import com.intellij.icons.AllIcons;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.GithubApiRequestExecutor;
import org.jetbrains.plugins.github.api.GithubApiRequestExecutorManager;
import org.jetbrains.plugins.github.api.GithubApiRequests;
import org.jetbrains.plugins.github.api.GithubServerPath;
import org.jetbrains.plugins.github.api.data.request.GithubGistRequest;
import org.jetbrains.plugins.github.authentication.GithubAuthenticationManager;
import org.jetbrains.plugins.github.authentication.accounts.GithubAccount;
import org.jetbrains.plugins.github.i18n.GithubBundle;
import org.jetbrains.plugins.github.ui.GithubCreateGistDialog;
import org.jetbrains.plugins.github.util.GithubNotifications;
import org.jetbrains.plugins.github.util.GithubSettings;
import org.jetbrains.plugins.github.util.GithubUtil;

public class GithubCreateGistAction
extends DumbAwareAction {
    private static final Logger LOG = GithubUtil.LOG;
    private static final Condition<@Nullable VirtualFile> FILE_WITH_CONTENT = f -> f != null && !f.getFileType().isBinary();

    protected GithubCreateGistAction() {
        super(GithubBundle.messagePointer("create.gist.action.title", new Object[0]), GithubBundle.messagePointer("create.gist.action.description", new Object[0]), AllIcons.Vcs.Vendors.Github);
    }

    public void update(@NotNull AnActionEvent e) {
        boolean hasFilesWithContent;
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project == null || project.isDefault()) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        VirtualFile file = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        Object[] files = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        boolean bl = hasFilesWithContent = FILE_WITH_CONTENT.value((Object)file) || files != null && ContainerUtil.exists((Object[])files, FILE_WITH_CONTENT);
        if (!hasFilesWithContent || editor != null && editor.getDocument().getTextLength() == 0) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        e.getPresentation().setEnabledAndVisible(true);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project == null || project.isDefault()) {
            return;
        }
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        VirtualFile file = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        VirtualFile[] files = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        if (editor == null && file == null && files == null) {
            return;
        }
        GithubCreateGistAction.createGistAction(project, editor, (VirtualFile)(FILE_WITH_CONTENT.value((Object)file) ? file : null), GithubCreateGistAction.filterFilesWithContent(files));
    }

    private static VirtualFile @Nullable [] filterFilesWithContent(@Nullable @Nullable VirtualFile @Nullable [] files) {
        if (files == null) {
            return null;
        }
        return ContainerUtil.filter((Object[])files, FILE_WITH_CONTENT).toArray(VirtualFile.EMPTY_ARRAY);
    }

    private static void createGistAction(final @NotNull Project project, final @Nullable Editor editor, final @Nullable VirtualFile file, final VirtualFile @Nullable [] files) {
        GithubAuthenticationManager authManager = GithubAuthenticationManager.getInstance();
        GithubSettings settings = GithubSettings.getInstance();
        final GithubCreateGistDialog dialog2 = new GithubCreateGistDialog(project, authManager.getAccounts(), authManager.getDefaultAccount(project), GithubCreateGistAction.getFileName(editor, files), settings.isPrivateGist(), settings.isOpenInBrowserGist(), settings.isCopyURLGist());
        if (!dialog2.showAndGet()) {
            return;
        }
        settings.setPrivateGist(dialog2.isSecret());
        settings.setOpenInBrowserGist(dialog2.isOpenInBrowser());
        settings.setCopyURLGist(dialog2.isCopyURL());
        final GithubAccount account = Objects.requireNonNull(dialog2.getAccount());
        final GithubApiRequestExecutor requestExecutor = GithubApiRequestExecutorManager.getInstance().getExecutor(account, project);
        if (requestExecutor == null) {
            return;
        }
        final Ref url = new Ref();
        new Task.Backgroundable(project, GithubBundle.message("create.gist.process", new Object[0])){

            public void run(@NotNull ProgressIndicator indicator) {
                List<GithubGistRequest.FileContent> contents = GithubCreateGistAction.collectContents(project, editor, file, files);
                if (contents.isEmpty()) {
                    return;
                }
                String gistUrl = GithubCreateGistAction.createGist(project, requestExecutor, indicator, account.getServer(), contents, dialog2.isSecret(), dialog2.getDescription(), dialog2.getFileName());
                url.set((Object)gistUrl);
            }

            public void onSuccess() {
                if (url.isNull()) {
                    return;
                }
                if (dialog2.isCopyURL()) {
                    StringSelection stringSelection = new StringSelection((String)url.get());
                    CopyPasteManager.getInstance().setContents((Transferable)stringSelection);
                }
                if (dialog2.isOpenInBrowser()) {
                    BrowserUtil.browse((String)((String)url.get()));
                } else {
                    GithubNotifications.showInfoURL(project, "github.gist.created", GithubBundle.message("create.gist.success", new Object[0]), GithubBundle.message("create.gist.url", new Object[0]), (String)url.get());
                }
            }
        }.queue();
    }

    @Nullable
    private static String getFileName(@Nullable Editor editor, VirtualFile @Nullable [] files) {
        if (files != null && files.length == 1 && !files[0].isDirectory()) {
            return files[0].getName();
        }
        if (editor != null) {
            return "";
        }
        return null;
    }

    @NotNull
    static List<GithubGistRequest.FileContent> collectContents(@NotNull Project project, @Nullable Editor editor, @Nullable VirtualFile file, VirtualFile @Nullable [] files) {
        if (editor != null) {
            String content2 = GithubCreateGistAction.getContentFromEditor(editor);
            if (content2 == null) {
                return Collections.emptyList();
            }
            if (file != null) {
                return Collections.singletonList(new GithubGistRequest.FileContent(file.getName(), content2));
            }
            return Collections.singletonList(new GithubGistRequest.FileContent("", content2));
        }
        if (files != null) {
            ArrayList<GithubGistRequest.FileContent> contents = new ArrayList<GithubGistRequest.FileContent>();
            for (VirtualFile vf : files) {
                contents.addAll(GithubCreateGistAction.getContentFromFile(vf, project, null));
            }
            return contents;
        }
        if (file != null) {
            return GithubCreateGistAction.getContentFromFile(file, project, null);
        }
        LOG.error("File, files and editor can't be null all at once!");
        throw new IllegalStateException("File, files and editor can't be null all at once!");
    }

    @Nullable
    static String createGist(@NotNull Project project, @NotNull GithubApiRequestExecutor executor, @NotNull ProgressIndicator indicator, @NotNull GithubServerPath server, @NotNull List<? extends GithubGistRequest.FileContent> contents, boolean isSecret, @NotNull String description, @Nullable String filename) {
        if (contents.isEmpty()) {
            GithubNotifications.showWarning(project, "github.gist.cannot.create", GithubBundle.message("cannot.create.gist", new Object[0]), GithubBundle.message("create.gist.error.empty", new Object[0]));
            return null;
        }
        if (contents.size() == 1 && filename != null) {
            GithubGistRequest.FileContent entry = contents.iterator().next();
            contents = Collections.singletonList(new GithubGistRequest.FileContent(filename, entry.getContent()));
        }
        try {
            return executor.execute(indicator, GithubApiRequests.Gists.create(server, contents, description, !isSecret)).getHtmlUrl();
        }
        catch (IOException e) {
            GithubNotifications.showError(project, "github.gist.cannot.create", GithubBundle.message("cannot.create.gist", new Object[0]), e);
            return null;
        }
    }

    @Nullable
    private static String getContentFromEditor(@NotNull Editor editor) {
        String text = (String)ReadAction.compute(() -> editor.getSelectionModel().getSelectedText());
        if (text == null) {
            text = editor.getDocument().getText();
        }
        if (StringUtil.isEmptyOrSpaces((String)text)) {
            return null;
        }
        return text;
    }

    @NotNull
    private static List<GithubGistRequest.FileContent> getContentFromFile(@NotNull VirtualFile file, @NotNull Project project, @Nullable String prefix) {
        if (file.isDirectory()) {
            return GithubCreateGistAction.getContentFromDirectory(file, project, prefix);
        }
        if (file.getFileType().isBinary()) {
            GithubNotifications.showWarning(project, "github.gist.cannot.create", GithubBundle.message("cannot.create.gist", new Object[0]), GithubBundle.message("create.gist.error.binary.file", file.getName()));
            return Collections.emptyList();
        }
        String content2 = (String)ReadAction.compute(() -> {
            try {
                Document document = FileDocumentManager.getInstance().getDocument(file);
                if (document != null) {
                    return document.getText();
                }
                return new String(file.contentsToByteArray(), file.getCharset());
            }
            catch (IOException e) {
                LOG.info("Couldn't read contents of the file " + file, (Throwable)e);
                return null;
            }
        });
        if (content2 == null) {
            GithubNotifications.showWarning(project, "github.gist.cannot.create", GithubBundle.message("cannot.create.gist", new Object[0]), GithubBundle.message("create.gist.error.content.read", file.getName()));
            return Collections.emptyList();
        }
        if (StringUtil.isEmptyOrSpaces((String)content2)) {
            return Collections.emptyList();
        }
        String filename = GithubCreateGistAction.addPrefix(file.getName(), prefix, false);
        return Collections.singletonList(new GithubGistRequest.FileContent(filename, content2));
    }

    @NotNull
    private static List<GithubGistRequest.FileContent> getContentFromDirectory(@NotNull VirtualFile dir, @NotNull Project project, @Nullable String prefix) {
        ArrayList<GithubGistRequest.FileContent> contents = new ArrayList<GithubGistRequest.FileContent>();
        for (VirtualFile file : dir.getChildren()) {
            if (GithubCreateGistAction.isFileIgnored(file, project)) continue;
            String pref = GithubCreateGistAction.addPrefix(dir.getName(), prefix, true);
            contents.addAll(GithubCreateGistAction.getContentFromFile(file, project, pref));
        }
        return contents;
    }

    private static String addPrefix(@NotNull String name, @Nullable String prefix, boolean addTrailingSlash) {
        Object pref = prefix == null ? "" : prefix;
        pref = (String)pref + name;
        if (addTrailingSlash) {
            pref = (String)pref + "_";
        }
        return pref;
    }

    private static boolean isFileIgnored(@NotNull VirtualFile file, @NotNull Project project) {
        ChangeListManager manager = ChangeListManager.getInstance((Project)project);
        return manager.isIgnoredFile(file) || FileTypeManager.getInstance().isFileIgnored(file);
    }
}

