/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github;

import com.intellij.icons.AllIcons;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.VcsLog;
import com.intellij.vcs.log.VcsLogDataKeys;
import com.intellij.vcsUtil.VcsUtil;
import git4idea.GitFileRevision;
import git4idea.GitRevisionNumber;
import git4idea.GitUtil;
import git4idea.history.GitHistoryUtils;
import git4idea.repo.GitRepository;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.GHPathUtil;
import org.jetbrains.plugins.github.api.GHRepositoryCoordinates;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequestShort;
import org.jetbrains.plugins.github.i18n.GithubBundle;
import org.jetbrains.plugins.github.pullrequest.action.GHPRActionKeys;
import org.jetbrains.plugins.github.pullrequest.data.provider.GHPRDataProvider;
import org.jetbrains.plugins.github.util.GHGitRepositoryMapping;
import org.jetbrains.plugins.github.util.GHProjectRepositoriesManager;
import org.jetbrains.plugins.github.util.GithubNotifications;
import org.jetbrains.plugins.github.util.GithubUtil;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0016\u0018\u0000 \u00182\u00020\u00012\u00020\u0002:\u0002\u0018\u0019B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u001d\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016\u00a2\u0006\u0002\u0010\u000bJ\u0018\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J \u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\r2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J \u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\r2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J \u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\r2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J \u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\r2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/plugins/github/GHOpenInBrowserActionGroup;", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "Lcom/intellij/openapi/project/DumbAware;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getChildren", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "(Lcom/intellij/openapi/actionSystem/AnActionEvent;)[Lcom/intellij/openapi/actionSystem/AnAction;", "getData", "", "Lorg/jetbrains/plugins/github/GHOpenInBrowserActionGroup$Data;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "getDataFromHistory", "project", "Lcom/intellij/openapi/project/Project;", "getDataFromLog", "getDataFromPullRequest", "getDataFromVirtualFile", "update", "Companion", "Data", "intellij.vcs.github"})
public class GHOpenInBrowserActionGroup
extends ActionGroup
implements DumbAware {
    @NotNull
    private static final Companion Companion = new Companion(null);

    public void update(@NotNull AnActionEvent e) {
        Collection collection;
        List<Data> data = this.getData(e.getDataContext());
        e.getPresentation().setEnabledAndVisible(!((collection = (Collection)data) == null || collection.isEmpty()));
        List<Data> list2 = data;
        e.getPresentation().setPerformGroup(list2 != null && list2.size() == 1);
        e.getPresentation().setPopupGroup(true);
        e.getPresentation().setDisableGroupIfEmpty(false);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public AnAction[] getChildren(@Nullable AnActionEvent e) {
        void $this$mapTo$iv$iv;
        if (e == null) {
            return new AnAction[0];
        }
        List<Data> list2 = this.getData(e.getDataContext());
        if (list2 == null) {
            return new AnAction[0];
        }
        List<Data> data = list2;
        if (data.size() <= 1) {
            return new AnAction[0];
        }
        Iterable $this$map$iv = data;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Data data2 = (Data)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Companion.GithubOpenInBrowserAction githubOpenInBrowserAction = new Companion.GithubOpenInBrowserAction((Data)it);
            collection.add(githubOpenInBrowserAction);
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        AnAction[] anActionArray = thisCollection$iv.toArray(new AnAction[0]);
        if (anActionArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        }
        return anActionArray;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        block0: {
            List<Data> list2;
            List<Data> list3 = this.getData(e.getDataContext());
            if (list3 == null) break block0;
            List<Data> it = list2 = list3;
            boolean bl = false;
            new Companion.GithubOpenInBrowserAction((Data)CollectionsKt.first(it)).actionPerformed(e);
        }
    }

    @Nullable
    protected List<Data> getData(@NotNull DataContext dataContext) {
        List<Data> list2;
        List<Data> list3;
        Project project = (Project)dataContext.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            return null;
        }
        Project project2 = project;
        List<Data> list4 = this.getDataFromPullRequest(project2, dataContext);
        if (list4 == null) {
            list4 = list3 = this.getDataFromHistory(project2, dataContext);
        }
        if (list4 == null) {
            list3 = list2 = this.getDataFromLog(project2, dataContext);
        }
        if (list3 == null) {
            list2 = this.getDataFromVirtualFile(project2, dataContext);
        }
        return list2;
    }

    private final List<Data> getDataFromPullRequest(Project project, DataContext dataContext) {
        GHPullRequestShort gHPullRequestShort = (GHPullRequestShort)dataContext.getData(GHPRActionKeys.getSELECTED_PULL_REQUEST());
        if (gHPullRequestShort == null) {
            Object object = (GHPRDataProvider)dataContext.getData(GHPRActionKeys.getPULL_REQUEST_DATA_PROVIDER());
            gHPullRequestShort = object != null && (object = object.getDetailsData()) != null ? object.getLoadedDetails() : null;
        }
        if (gHPullRequestShort == null) {
            return null;
        }
        GHPullRequestShort pullRequest = gHPullRequestShort;
        return CollectionsKt.listOf((Object)new Data.URL(project, pullRequest.getUrl()));
    }

    /*
     * WARNING - void declaration
     */
    private final List<Data> getDataFromHistory(Project project, DataContext dataContext) {
        void $this$mapTo$iv$iv;
        VcsFileRevision vcsFileRevision = (VcsFileRevision)dataContext.getData(VcsDataKeys.VCS_FILE_REVISION);
        if (vcsFileRevision == null) {
            return null;
        }
        VcsFileRevision fileRevision = vcsFileRevision;
        if (!(fileRevision instanceof GitFileRevision)) {
            return null;
        }
        GitRepository repository = (GitRepository)GitUtil.getRepositoryManager((Project)project).getRepositoryForFileQuick(((GitFileRevision)fileRevision).getPath());
        if (repository == null) {
            return null;
        }
        Project $this$service$iv = project;
        boolean $i$f$service = false;
        List<GHGitRepositoryMapping> accessibleRepositories = ((GHProjectRepositoriesManager)$this$service$iv.getService(GHProjectRepositoriesManager.class)).findKnownRepositories(repository);
        if (accessibleRepositories.isEmpty()) {
            return null;
        }
        Iterable $this$map$iv = accessibleRepositories;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            GHGitRepositoryMapping gHGitRepositoryMapping = (GHGitRepositoryMapping)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Data.Revision revision = new Data.Revision(project, it.getGhRepositoryCoordinates(), ((GitFileRevision)fileRevision).getRevisionNumber().asString());
            collection.add(revision);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Data> getDataFromLog(Project project, DataContext dataContext) {
        void $this$mapTo$iv$iv;
        VcsLog vcsLog = (VcsLog)dataContext.getData(VcsLogDataKeys.VCS_LOG);
        if (vcsLog == null) {
            return null;
        }
        VcsLog log = vcsLog;
        List selectedCommits = log.getSelectedCommits();
        if (selectedCommits.size() != 1) {
            return null;
        }
        CommitId commitId = (CommitId)ContainerUtil.getFirstItem((List)selectedCommits);
        if (commitId == null) {
            return null;
        }
        CommitId commit = commitId;
        GitRepository repository = (GitRepository)GitUtil.getRepositoryManager((Project)project).getRepositoryForRootQuick(commit.getRoot());
        if (repository == null) {
            return null;
        }
        Project $this$service$iv = project;
        boolean $i$f$service = false;
        List<GHGitRepositoryMapping> accessibleRepositories = ((GHProjectRepositoriesManager)$this$service$iv.getService(GHProjectRepositoriesManager.class)).findKnownRepositories(repository);
        if (accessibleRepositories.isEmpty()) {
            return null;
        }
        Iterable $this$map$iv = accessibleRepositories;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            GHGitRepositoryMapping gHGitRepositoryMapping = (GHGitRepositoryMapping)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Data.Revision revision = new Data.Revision(project, it.getGhRepositoryCoordinates(), commit.getHash().asString());
            collection.add(revision);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Data> getDataFromVirtualFile(Project project, DataContext dataContext) {
        List list2;
        VirtualFile virtualFile = (VirtualFile)dataContext.getData(CommonDataKeys.VIRTUAL_FILE);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile virtualFile2 = virtualFile;
        GitRepository repository = (GitRepository)GitUtil.getRepositoryManager((Project)project).getRepositoryForFileQuick(virtualFile2);
        if (repository == null) {
            return null;
        }
        Project $this$service$iv = project;
        boolean $i$f$service = false;
        List<GHGitRepositoryMapping> accessibleRepositories = ((GHProjectRepositoriesManager)$this$service$iv.getService(GHProjectRepositoriesManager.class)).findKnownRepositories(repository);
        if (accessibleRepositories.isEmpty()) {
            return null;
        }
        ChangeListManager changeListManager = ChangeListManager.getInstance((Project)project);
        if (changeListManager.isUnversioned(virtualFile2)) {
            return null;
        }
        Change change = changeListManager.getChange(virtualFile2);
        if (change != null && change.getType() == Change.Type.NEW) {
            list2 = null;
        } else {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = accessibleRepositories;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                GHGitRepositoryMapping gHGitRepositoryMapping = (GHGitRepositoryMapping)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Data.File file = new Data.File(project, it.getGhRepositoryCoordinates(), repository.getRoot(), virtualFile2);
                collection.add(file);
            }
            list2 = (List)destination$iv$iv;
        }
        return list2;
    }

    public GHOpenInBrowserActionGroup() {
        super(GithubBundle.messagePointer("open.on.github.action", new Object[0]), GithubBundle.messagePointer("open.on.github.action.description", new Object[0]), AllIcons.Vcs.Vendors.Github);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b4\u0018\u00002\u00020\u0001:\u0003\t\n\u000bB\u000f\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH'R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u0082\u0001\u0003\f\r\u000e\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/plugins/github/GHOpenInBrowserActionGroup$Data;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getName", "", "File", "Revision", "URL", "Lorg/jetbrains/plugins/github/GHOpenInBrowserActionGroup$Data$File;", "Lorg/jetbrains/plugins/github/GHOpenInBrowserActionGroup$Data$Revision;", "Lorg/jetbrains/plugins/github/GHOpenInBrowserActionGroup$Data$URL;", "intellij.vcs.github"})
    protected static abstract class Data {
        @NotNull
        private final Project project;

        @Nls
        @NotNull
        public abstract String getName();

        @NotNull
        public final Project getProject() {
            return this.project;
        }

        private Data(Project project) {
            this.project = project;
        }

        public /* synthetic */ Data(Project project, DefaultConstructorMarker $constructor_marker) {
            this(project);
        }

        @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tJ\b\u0010\u000f\u001a\u00020\u0010H\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000b\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/plugins/github/GHOpenInBrowserActionGroup$Data$File;", "Lorg/jetbrains/plugins/github/GHOpenInBrowserActionGroup$Data;", "project", "Lcom/intellij/openapi/project/Project;", "repository", "Lorg/jetbrains/plugins/github/api/GHRepositoryCoordinates;", "gitRepoRoot", "Lcom/intellij/openapi/vfs/VirtualFile;", "virtualFile", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/plugins/github/api/GHRepositoryCoordinates;Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/openapi/vfs/VirtualFile;)V", "getGitRepoRoot", "()Lcom/intellij/openapi/vfs/VirtualFile;", "getRepository", "()Lorg/jetbrains/plugins/github/api/GHRepositoryCoordinates;", "getVirtualFile", "getName", "", "intellij.vcs.github"})
        public static final class File
        extends Data {
            @NotNull
            private final GHRepositoryCoordinates repository;
            @NotNull
            private final VirtualFile gitRepoRoot;
            @NotNull
            private final VirtualFile virtualFile;

            @Override
            @NotNull
            public String getName() {
                String formatted = StringsKt.replace$default((String)this.repository.toString(), (char)'_', (char)' ', (boolean)false, (int)4, null);
                return formatted;
            }

            @NotNull
            public final GHRepositoryCoordinates getRepository() {
                return this.repository;
            }

            @NotNull
            public final VirtualFile getGitRepoRoot() {
                return this.gitRepoRoot;
            }

            @NotNull
            public final VirtualFile getVirtualFile() {
                return this.virtualFile;
            }

            public File(@NotNull Project project, @NotNull GHRepositoryCoordinates repository, @NotNull VirtualFile gitRepoRoot, @NotNull VirtualFile virtualFile) {
                super(project, null);
                this.repository = repository;
                this.gitRepoRoot = gitRepoRoot;
                this.virtualFile = virtualFile;
            }
        }

        @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\r\u001a\u00020\u0007H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/plugins/github/GHOpenInBrowserActionGroup$Data$Revision;", "Lorg/jetbrains/plugins/github/GHOpenInBrowserActionGroup$Data;", "project", "Lcom/intellij/openapi/project/Project;", "repository", "Lorg/jetbrains/plugins/github/api/GHRepositoryCoordinates;", "revisionHash", "", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/plugins/github/api/GHRepositoryCoordinates;Ljava/lang/String;)V", "getRepository", "()Lorg/jetbrains/plugins/github/api/GHRepositoryCoordinates;", "getRevisionHash", "()Ljava/lang/String;", "getName", "intellij.vcs.github"})
        public static final class Revision
        extends Data {
            @NotNull
            private final GHRepositoryCoordinates repository;
            @NotNull
            private final String revisionHash;

            @Override
            @NotNull
            public String getName() {
                String formatted = StringsKt.replace$default((String)this.repository.toString(), (char)'_', (char)' ', (boolean)false, (int)4, null);
                return formatted;
            }

            @NotNull
            public final GHRepositoryCoordinates getRepository() {
                return this.repository;
            }

            @NotNull
            public final String getRevisionHash() {
                return this.revisionHash;
            }

            public Revision(@NotNull Project project, @NotNull GHRepositoryCoordinates repository, @NotNull String revisionHash) {
                super(project, null);
                this.repository = repository;
                this.revisionHash = revisionHash;
            }
        }

        @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\t\u001a\u00020\u0005H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\n"}, d2={"Lorg/jetbrains/plugins/github/GHOpenInBrowserActionGroup$Data$URL;", "Lorg/jetbrains/plugins/github/GHOpenInBrowserActionGroup$Data;", "project", "Lcom/intellij/openapi/project/Project;", "htmlUrl", "", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;)V", "getHtmlUrl", "()Ljava/lang/String;", "getName", "intellij.vcs.github"})
        public static final class URL
        extends Data {
            @NotNull
            private final String htmlUrl;

            @Override
            @NotNull
            public String getName() {
                return this.htmlUrl;
            }

            @NotNull
            public final String getHtmlUrl() {
                return this.htmlUrl;
            }

            public URL(@NotNull Project project, @NlsSafe @NotNull String htmlUrl) {
                super(project, null);
                this.htmlUrl = htmlUrl;
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001:\u0001\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lorg/jetbrains/plugins/github/GHOpenInBrowserActionGroup$Companion;", "", "()V", "GithubOpenInBrowserAction", "intellij.vcs.github"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u001a\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\fH\u0002J2\u0010\u0015\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u00102\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/plugins/github/GHOpenInBrowserActionGroup$Companion$GithubOpenInBrowserAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "data", "Lorg/jetbrains/plugins/github/GHOpenInBrowserActionGroup$Data;", "(Lorg/jetbrains/plugins/github/GHOpenInBrowserActionGroup$Data;)V", "getData", "()Lorg/jetbrains/plugins/github/GHOpenInBrowserActionGroup$Data;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getCurrentFileRevisionHash", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "openCommitInBrowser", "path", "Lorg/jetbrains/plugins/github/api/GHRepositoryCoordinates;", "revisionHash", "openFileInBrowser", "repositoryRoot", "virtualFile", "editor", "Lcom/intellij/openapi/editor/Editor;", "intellij.vcs.github"})
        public static final class GithubOpenInBrowserAction
        extends DumbAwareAction {
            @NotNull
            private final Data data;

            public void actionPerformed(@NotNull AnActionEvent e) {
                block1: {
                    Data data;
                    block2: {
                        block0: {
                            data = this.data;
                            if (!(data instanceof Data.Revision)) break block0;
                            this.openCommitInBrowser(((Data.Revision)this.data).getRepository(), ((Data.Revision)this.data).getRevisionHash());
                            break block1;
                        }
                        if (!(data instanceof Data.File)) break block2;
                        this.openFileInBrowser(this.data.getProject(), ((Data.File)this.data).getGitRepoRoot(), ((Data.File)this.data).getRepository(), ((Data.File)this.data).getVirtualFile(), (Editor)e.getData(CommonDataKeys.EDITOR));
                        break block1;
                    }
                    if (!(data instanceof Data.URL)) break block1;
                    BrowserUtil.browse((String)((Data.URL)this.data).getHtmlUrl());
                }
            }

            private final void openCommitInBrowser(GHRepositoryCoordinates path, String revisionHash) {
                BrowserUtil.browse((String)(path.toUrl() + "/commit/" + revisionHash));
            }

            private final void openFileInBrowser(Project project, VirtualFile repositoryRoot, GHRepositoryCoordinates path, VirtualFile virtualFile, Editor editor) {
                String relativePath = VfsUtilCore.getRelativePath((VirtualFile)virtualFile, (VirtualFile)repositoryRoot);
                if (relativePath == null) {
                    GithubNotifications.showError(project, "github.open.in.browser.file.is.not.under.repo", GithubBundle.message("cannot.open.in.browser", new Object[0]), GithubBundle.message("open.on.github.file.is.not.under.repository", new Object[0]), "Root: " + repositoryRoot.getPresentableUrl() + ", file: " + virtualFile.getPresentableUrl());
                    return;
                }
                String hash = this.getCurrentFileRevisionHash(project, virtualFile);
                if (hash == null) {
                    GithubNotifications.showError(project, "github.open.in.browser.cannot.get.last.revision", GithubBundle.message("cannot.open.in.browser", new Object[0]), GithubBundle.message("cannot.get.last.revision", new Object[0]));
                    return;
                }
                String githubUrl = GHPathUtil.INSTANCE.makeUrlToOpen(editor, relativePath, hash, path);
                BrowserUtil.browse((String)githubUrl);
            }

            private final String getCurrentFileRevisionHash(Project project, VirtualFile file) {
                Ref ref = new Ref();
                new Task.Modal(ref, project, file, project, GithubBundle.message("open.on.github.getting.last.revision", new Object[0]), true){
                    final /* synthetic */ Ref $ref;
                    final /* synthetic */ Project $project;
                    final /* synthetic */ VirtualFile $file;

                    public void run(@NotNull ProgressIndicator indicator) {
                        this.$ref.set((Object)((GitRevisionNumber)GitHistoryUtils.getCurrentRevision((Project)this.$project, (FilePath)VcsUtil.getFilePath((VirtualFile)this.$file), (String)"HEAD")));
                    }

                    public void onThrowable(@NotNull Throwable error) {
                        GithubUtil.LOG.warn(error);
                    }
                    {
                        this.$ref = $captured_local_variable$0;
                        this.$project = $captured_local_variable$1;
                        this.$file = $captured_local_variable$2;
                        super($super_call_param$3, $super_call_param$4, $super_call_param$5);
                    }
                }.queue();
                return ref.isNull() ? null : ((GitRevisionNumber)ref.get()).getRev();
            }

            @NotNull
            public final Data getData() {
                return this.data;
            }

            public GithubOpenInBrowserAction(final @NotNull Data data) {
                super(new Supplier(){

                    public final String get() {
                        return data.getName();
                    }
                });
                this.data = data;
            }
        }
    }
}

