/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.cocoa.NSAffineTransform;
import org.eclipse.swt.internal.cocoa.NSApplication;
import org.eclipse.swt.internal.cocoa.NSArray;
import org.eclipse.swt.internal.cocoa.NSAttributedString;
import org.eclipse.swt.internal.cocoa.NSBezierPath;
import org.eclipse.swt.internal.cocoa.NSButton;
import org.eclipse.swt.internal.cocoa.NSButtonCell;
import org.eclipse.swt.internal.cocoa.NSCell;
import org.eclipse.swt.internal.cocoa.NSColor;
import org.eclipse.swt.internal.cocoa.NSDictionary;
import org.eclipse.swt.internal.cocoa.NSEvent;
import org.eclipse.swt.internal.cocoa.NSFont;
import org.eclipse.swt.internal.cocoa.NSGraphicsContext;
import org.eclipse.swt.internal.cocoa.NSImage;
import org.eclipse.swt.internal.cocoa.NSIndexSet;
import org.eclipse.swt.internal.cocoa.NSMutableAttributedString;
import org.eclipse.swt.internal.cocoa.NSMutableDictionary;
import org.eclipse.swt.internal.cocoa.NSMutableIndexSet;
import org.eclipse.swt.internal.cocoa.NSMutableParagraphStyle;
import org.eclipse.swt.internal.cocoa.NSNotification;
import org.eclipse.swt.internal.cocoa.NSNumber;
import org.eclipse.swt.internal.cocoa.NSObject;
import org.eclipse.swt.internal.cocoa.NSPoint;
import org.eclipse.swt.internal.cocoa.NSRange;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSScrollView;
import org.eclipse.swt.internal.cocoa.NSSize;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.NSTableColumn;
import org.eclipse.swt.internal.cocoa.NSTableHeaderCell;
import org.eclipse.swt.internal.cocoa.NSTableHeaderView;
import org.eclipse.swt.internal.cocoa.NSTableView;
import org.eclipse.swt.internal.cocoa.NSTextFieldCell;
import org.eclipse.swt.internal.cocoa.NSView;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.cocoa.SWTImageTextCell;
import org.eclipse.swt.internal.cocoa.SWTScrollView;
import org.eclipse.swt.internal.cocoa.SWTTableHeaderCell;
import org.eclipse.swt.internal.cocoa.SWTTableHeaderView;
import org.eclipse.swt.internal.cocoa.SWTTableView;
import org.eclipse.swt.internal.cocoa.id;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class Table
extends Composite {
    TableItem[] items;
    TableColumn[] columns;
    TableColumn sortColumn;
    TableItem currentItem;
    NSTableHeaderView headerView;
    NSTableColumn firstColumn;
    NSTableColumn checkColumn;
    NSTextFieldCell dataCell;
    NSButtonCell buttonCell;
    int columnCount;
    int itemCount;
    int lastIndexOf;
    int sortDirection;
    boolean ignoreSelect;
    boolean fixScrollWidth;
    boolean drawExpansion;
    Rectangle imageBounds;
    static int NEXT_ID;
    static final int FIRST_COLUMN_MINIMUM_WIDTH = 5;
    static final int IMAGE_GAP = 3;
    static final int TEXT_GAP = 2;
    static final int CELL_GAP = 1;

    public Table(Composite composite, int n) {
        super(composite, Table.checkStyle(n));
    }

    long accessibilityAttributeValue(long l, long l2, long l3) {
        NSString nSString;
        id id2;
        if (this.accessible != null && (id2 = this.accessible.internal_accessibilityAttributeValue(nSString = new NSString(l3), -1)) != null) {
            return id2.id;
        }
        nSString = new NSString(l3);
        if (nSString.isEqualToString(OS.NSAccessibilityDescriptionAttribute)) {
            return NSString.stringWith((String)"").id;
        }
        return super.accessibilityAttributeValue(l, l2, l3);
    }

    void _addListener(int n, Listener listener) {
        super._addListener(n, listener);
        this.clearCachedWidth(this.items);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    TableItem _getItem(int n) {
        if ((this.style & 0x10000000) == 0) {
            return this.items[n];
        }
        if (this.items[n] != null) {
            return this.items[n];
        }
        this.items[n] = new TableItem(this, 0, -1, false);
        return this.items[n];
    }

    int calculateWidth(TableItem[] tableItemArray, int n, GC gC) {
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.itemCount) {
            TableItem tableItem = tableItemArray[n3];
            if (tableItem != null && tableItem.cached) {
                n2 = Math.max(n2, tableItem.calculateWidth(n, gC));
            }
            ++n3;
        }
        return n2;
    }

    NSSize cellSize(long l, long l2) {
        NSSize nSSize = super.cellSize(l, l2);
        NSImage nSImage = new NSCell(l).image();
        if (nSImage != null) {
            nSSize.width += (double)(this.imageBounds.width + 3);
        }
        if (this.hooks(41)) {
            long[] lArray = new long[1];
            OS.object_getInstanceVariable(l, Display.SWT_ROW, lArray);
            long l3 = lArray[0];
            TableItem tableItem = this._getItem((int)l3);
            OS.object_getInstanceVariable(l, Display.SWT_COLUMN, lArray);
            long l4 = lArray[0];
            int n = 0;
            int n2 = 0;
            while (n2 < this.columnCount) {
                if (this.columns[n2].nsColumn.id == l4) {
                    n = n2;
                    break;
                }
                ++n2;
            }
            this.sendMeasureItem(tableItem, n, nSSize);
        }
        return nSSize;
    }

    boolean canDragRowsWithIndexes_atPoint(long l, long l2, long l3, long l4) {
        boolean bl;
        NSPoint nSPoint = new NSPoint();
        OS.memmove(nSPoint, l4, (long)NSPoint.sizeof);
        NSTableView nSTableView = (NSTableView)this.view;
        long l5 = nSTableView.rowAtPoint(nSPoint);
        long l6 = NSApplication.sharedApplication().currentEvent().modifierFlags();
        boolean bl2 = bl = (this.state & 0x40000) != 0 && this.hooks(29);
        if (bl && !nSTableView.isRowSelected(l5) && (l6 & 0x1A0000L) == 0L) {
            NSIndexSet nSIndexSet = (NSIndexSet)new NSIndexSet().alloc();
            nSIndexSet = nSIndexSet.initWithIndex(l5);
            nSTableView.selectRowIndexes(nSIndexSet, false);
            nSIndexSet.release();
        }
        return nSTableView.isRowSelected(l5) && bl;
    }

    boolean checkData(TableItem tableItem) {
        return this.checkData(tableItem, this.indexOf(tableItem));
    }

    boolean checkData(TableItem tableItem, int n) {
        if (tableItem.cached) {
            return true;
        }
        if ((this.style & 0x10000000) != 0) {
            tableItem.cached = true;
            Event event = new Event();
            event.item = tableItem;
            event.index = this.indexOf(tableItem);
            this.currentItem = tableItem;
            this.sendEvent(36, event);
            this.currentItem = null;
            if (this.isDisposed() || tableItem.isDisposed()) {
                return false;
            }
            if (!this.setScrollWidth(tableItem)) {
                tableItem.redraw(-1);
            }
        }
        return true;
    }

    static int checkStyle(int n) {
        if ((n & 0x10) == 0) {
            n |= 0x300;
        }
        return Table.checkBits(n |= 0x10000, 4, 2, 0, 0, 0, 0);
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    public void clear(int n) {
        TableItem tableItem;
        this.checkWidget();
        if (n < 0 || n >= this.itemCount) {
            this.error(6);
        }
        if ((tableItem = this.items[n]) != null) {
            if (this.currentItem != tableItem) {
                tableItem.clear();
            }
            if (this.currentItem == null) {
                tableItem.redraw(-1);
            }
            this.setScrollWidth(tableItem);
        }
    }

    public void clear(int n, int n2) {
        this.checkWidget();
        if (n > n2) {
            return;
        }
        if (n < 0 || n > n2 || n2 >= this.itemCount) {
            this.error(6);
        }
        if (n == 0 && n2 == this.itemCount - 1) {
            this.clearAll();
        } else {
            int n3 = n;
            while (n3 <= n2) {
                this.clear(n3);
                ++n3;
            }
        }
    }

    public void clear(int[] nArray) {
        this.checkWidget();
        if (nArray == null) {
            this.error(4);
        }
        if (nArray.length == 0) {
            return;
        }
        int n = 0;
        while (n < nArray.length) {
            if (nArray[n] < 0 || nArray[n] >= this.itemCount) {
                this.error(6);
            }
            ++n;
        }
        n = 0;
        while (n < nArray.length) {
            this.clear(nArray[n]);
            ++n;
        }
    }

    public void clearAll() {
        this.checkWidget();
        int n = 0;
        while (n < this.itemCount) {
            TableItem tableItem = this.items[n];
            if (tableItem != null) {
                tableItem.clear();
            }
            ++n;
        }
        if (this.currentItem == null && this.isDrawing()) {
            this.view.setNeedsDisplay(true);
        }
        this.setScrollWidth(this.items, true);
    }

    void clearCachedWidth(TableItem[] tableItemArray) {
        if (tableItemArray == null) {
            return;
        }
        int n = 0;
        while (n < tableItemArray.length) {
            if (tableItemArray[n] != null) {
                tableItemArray[n].width = -1;
            }
            ++n;
        }
    }

    public Point computeSize(int n, int n2, boolean bl) {
        this.checkWidget();
        int n3 = 0;
        if (n == -1) {
            if (this.columnCount != 0) {
                int n4 = 0;
                while (n4 < this.columnCount) {
                    n3 += this.columns[n4].getWidth();
                    ++n4;
                }
            } else {
                GC gC = new GC(this);
                n3 += this.calculateWidth(this.items, 0, gC) + 1;
                gC.dispose();
            }
            if ((this.style & 0x20) != 0) {
                n3 += this.getCheckColumnWidth();
            }
        } else {
            n3 = n;
        }
        if (n3 <= 0) {
            n3 = 64;
        }
        int n5 = 0;
        n5 = n2 == -1 ? this.itemCount * this.getItemHeight() + this.getHeaderHeight() : n2;
        if (n5 <= 0) {
            n5 = 64;
        }
        Rectangle rectangle = this.computeTrim(0, 0, n3, n5);
        return new Point(rectangle.width, rectangle.height);
    }

    void createColumn(TableItem tableItem, int n) {
        Resource[] resourceArray;
        Color[] colorArray;
        Resource[] resourceArray2;
        Object[] objectArray;
        String[] stringArray = tableItem.strings;
        if (stringArray != null) {
            objectArray = new String[this.columnCount];
            System.arraycopy(stringArray, 0, objectArray, 0, n);
            System.arraycopy(stringArray, n, objectArray, n + 1, this.columnCount - n - 1);
            objectArray[n] = "";
            tableItem.strings = objectArray;
        }
        if (n == 0) {
            tableItem.text = "";
        }
        if ((objectArray = tableItem.images) != null) {
            resourceArray2 = new Image[this.columnCount];
            System.arraycopy(objectArray, 0, resourceArray2, 0, n);
            System.arraycopy(objectArray, n, resourceArray2, n + 1, this.columnCount - n - 1);
            tableItem.images = resourceArray2;
        }
        if (n == 0) {
            tableItem.image = null;
        }
        if ((resourceArray2 = tableItem.cellBackground) != null) {
            colorArray = new Color[this.columnCount];
            System.arraycopy(resourceArray2, 0, colorArray, 0, n);
            System.arraycopy(resourceArray2, n, colorArray, n + 1, this.columnCount - n - 1);
            tableItem.cellBackground = colorArray;
        }
        if ((colorArray = tableItem.cellForeground) != null) {
            resourceArray = new Color[this.columnCount];
            System.arraycopy(colorArray, 0, resourceArray, 0, n);
            System.arraycopy(colorArray, n, resourceArray, n + 1, this.columnCount - n - 1);
            tableItem.cellForeground = resourceArray;
        }
        if ((resourceArray = tableItem.cellFont) != null) {
            Font[] fontArray = new Font[this.columnCount];
            System.arraycopy(resourceArray, 0, fontArray, 0, n);
            System.arraycopy(resourceArray, n, fontArray, n + 1, this.columnCount - n - 1);
            tableItem.cellFont = fontArray;
        }
    }

    void createHandle() {
        NSScrollView nSScrollView = (NSScrollView)new SWTScrollView().alloc();
        nSScrollView.init();
        nSScrollView.setHasHorizontalScroller((this.style & 0x100) != 0);
        nSScrollView.setHasVerticalScroller((this.style & 0x200) != 0);
        nSScrollView.setAutohidesScrollers(true);
        nSScrollView.setBorderType(this.hasBorder() ? 2 : 0);
        NSTableView nSTableView = (NSTableView)new SWTTableView().alloc();
        nSTableView.init();
        nSTableView.setAllowsMultipleSelection((this.style & 2) != 0);
        nSTableView.setAllowsColumnReordering(false);
        nSTableView.setDataSource(nSTableView);
        nSTableView.setDelegate(nSTableView);
        nSTableView.setColumnAutoresizingStyle(0L);
        NSSize nSSize = new NSSize();
        nSSize.height = 1.0;
        nSSize.width = 1.0;
        nSTableView.setIntercellSpacing(nSSize);
        nSTableView.setDoubleAction(OS.sel_sendDoubleSelection);
        if (!this.hasBorder()) {
            nSTableView.setFocusRingType(1L);
        }
        this.headerView = (NSTableHeaderView)new SWTTableHeaderView().alloc().init();
        nSTableView.setHeaderView(null);
        NSString nSString = NSString.stringWith("");
        if ((this.style & 0x20) != 0) {
            this.checkColumn = (NSTableColumn)new NSTableColumn().alloc();
            this.checkColumn = this.checkColumn.initWithIdentifier(NSString.stringWith(String.valueOf(++NEXT_ID)));
            this.checkColumn.headerCell().setTitle(nSString);
            nSTableView.addTableColumn(this.checkColumn);
            this.checkColumn.setResizingMask(0L);
            this.checkColumn.setEditable(false);
            long l = NSButton.cellClass();
            this.buttonCell = new NSButtonCell(OS.class_createInstance(l, 0L));
            this.buttonCell.init();
            this.checkColumn.setDataCell(this.buttonCell);
            this.buttonCell.setButtonType(3L);
            this.buttonCell.setImagePosition(1L);
            this.buttonCell.setAllowsMixedState(true);
            this.checkColumn.setWidth(this.getCheckColumnWidth());
        }
        this.firstColumn = (NSTableColumn)new NSTableColumn().alloc();
        this.firstColumn = this.firstColumn.initWithIdentifier(NSString.stringWith(String.valueOf(++NEXT_ID)));
        this.firstColumn.setMinWidth(5.0);
        this.firstColumn.setWidth(0.0);
        this.firstColumn.headerCell().setTitle(nSString);
        nSTableView.addTableColumn(this.firstColumn);
        this.dataCell = (NSTextFieldCell)new SWTImageTextCell().alloc().init();
        this.dataCell.setLineBreakMode(2L);
        this.firstColumn.setDataCell(this.dataCell);
        this.scrollView = nSScrollView;
        this.view = nSTableView;
    }

    void createItem(TableColumn tableColumn, int n) {
        Object object;
        if (n < 0 || n > this.columnCount) {
            this.error(6);
        }
        if (this.columnCount == this.columns.length) {
            object = new TableColumn[this.columnCount + 4];
            System.arraycopy(this.columns, 0, object, 0, this.columns.length);
            this.columns = object;
        }
        if (this.columnCount == 0) {
            object = this.firstColumn;
            ((NSTableColumn)object).setMinWidth(0.0);
            this.firstColumn = null;
        } else {
            object = (NSTableColumn)new NSTableColumn().alloc();
            object = ((NSTableColumn)object).initWithIdentifier(NSString.stringWith(String.valueOf(++NEXT_ID)));
            ((NSTableColumn)object).setMinWidth(0.0);
            ((NSTableView)this.view).addTableColumn((NSTableColumn)object);
            int n2 = (this.style & 0x20) != 0 ? 1 : 0;
            ((NSTableView)this.view).moveColumn(this.columnCount + n2, n + n2);
            ((NSTableColumn)object).setDataCell(this.dataCell);
        }
        tableColumn.createJNIRef();
        NSTableHeaderCell nSTableHeaderCell = (NSTableHeaderCell)new SWTTableHeaderCell().alloc().init();
        ((NSTableColumn)object).setHeaderCell(nSTableHeaderCell);
        this.display.addWidget(nSTableHeaderCell, tableColumn);
        tableColumn.nsColumn = object;
        ((NSTableColumn)object).setWidth(0.0);
        System.arraycopy(this.columns, n, this.columns, n + 1, this.columnCount++ - n);
        this.columns[n] = tableColumn;
        int n3 = 0;
        while (n3 < this.itemCount) {
            TableItem tableItem = this.items[n3];
            if (tableItem != null && this.columnCount > 1) {
                this.createColumn(tableItem, n);
            }
            ++n3;
        }
    }

    void createItem(TableItem tableItem, int n) {
        if (n < 0 || n > this.itemCount) {
            this.error(6);
        }
        if (this.itemCount == this.items.length) {
            int n2 = this.getDrawing() ? this.items.length + 4 : Math.max(4, this.items.length * 3 / 2);
            TableItem[] tableItemArray = new TableItem[n2];
            System.arraycopy(this.items, 0, tableItemArray, 0, this.items.length);
            this.items = tableItemArray;
        }
        System.arraycopy(this.items, n, this.items, n + 1, this.itemCount++ - n);
        this.items[n] = tableItem;
        ((NSTableView)this.view).noteNumberOfRowsChanged();
        if (n != this.itemCount) {
            this.fixSelection(n, true);
        }
    }

    void createWidget() {
        super.createWidget();
        this.items = new TableItem[4];
        this.columns = new TableColumn[4];
    }

    Color defaultBackground() {
        return this.display.getWidgetColor(25);
    }

    NSFont defaultNSFont() {
        return this.display.tableViewFont;
    }

    Color defaultForeground() {
        return this.display.getWidgetColor(24);
    }

    void deregister() {
        super.deregister();
        this.display.removeWidget(this.headerView);
        this.display.removeWidget(this.dataCell);
        if (this.buttonCell != null) {
            this.display.removeWidget(this.buttonCell);
        }
    }

    public void deselect(int n) {
        this.checkWidget();
        if (n >= 0 && n < this.itemCount) {
            NSTableView nSTableView = (NSTableView)this.view;
            this.ignoreSelect = true;
            nSTableView.deselectRow(n);
            this.ignoreSelect = false;
        }
    }

    public void deselect(int n, int n2) {
        this.checkWidget();
        if (n > n2) {
            return;
        }
        if (n2 < 0 || n >= this.itemCount) {
            return;
        }
        n = Math.max(0, n);
        n2 = Math.min(this.itemCount - 1, n2);
        if (n == 0 && n2 == this.itemCount - 1) {
            this.deselectAll();
        } else {
            NSTableView nSTableView = (NSTableView)this.view;
            this.ignoreSelect = true;
            int n3 = n;
            while (n3 <= n2) {
                nSTableView.deselectRow(n3);
                ++n3;
            }
            this.ignoreSelect = false;
        }
    }

    public void deselect(int[] nArray) {
        this.checkWidget();
        if (nArray == null) {
            this.error(4);
        }
        NSTableView nSTableView = (NSTableView)this.view;
        this.ignoreSelect = true;
        int n = 0;
        while (n < nArray.length) {
            nSTableView.deselectRow(nArray[n]);
            ++n;
        }
        this.ignoreSelect = false;
    }

    public void deselectAll() {
        this.checkWidget();
        NSTableView nSTableView = (NSTableView)this.view;
        this.ignoreSelect = true;
        nSTableView.deselectAll(null);
        this.ignoreSelect = false;
    }

    void destroyItem(TableColumn tableColumn) {
        Object object;
        int n = 0;
        while (n < this.columnCount) {
            if (this.columns[n] == tableColumn) break;
            ++n;
        }
        int n2 = 0;
        while (n2 < this.itemCount) {
            object = this.items[n2];
            if (object != null) {
                if (this.columnCount <= 1) {
                    ((TableItem)object).strings = null;
                    ((TableItem)object).images = null;
                    ((TableItem)object).cellBackground = null;
                    ((TableItem)object).cellForeground = null;
                    ((TableItem)object).cellFont = null;
                } else {
                    Object[] objectArray;
                    Object[] objectArray2;
                    if (((TableItem)object).strings != null) {
                        objectArray2 = ((TableItem)object).strings;
                        if (n == 0) {
                            ((TableItem)object).text = objectArray2[1] != null ? objectArray2[1] : "";
                        }
                        objectArray = new String[this.columnCount - 1];
                        System.arraycopy(objectArray2, 0, objectArray, 0, n);
                        System.arraycopy(objectArray2, n + 1, objectArray, n, this.columnCount - 1 - n);
                        ((TableItem)object).strings = objectArray;
                    } else if (n == 0) {
                        ((TableItem)object).text = "";
                    }
                    if (((TableItem)object).images != null) {
                        objectArray2 = ((TableItem)object).images;
                        if (n == 0) {
                            ((TableItem)object).image = objectArray2[1];
                        }
                        objectArray = new Image[this.columnCount - 1];
                        System.arraycopy(objectArray2, 0, objectArray, 0, n);
                        System.arraycopy(objectArray2, n + 1, objectArray, n, this.columnCount - 1 - n);
                        ((TableItem)object).images = objectArray;
                    } else if (n == 0) {
                        ((TableItem)object).image = null;
                    }
                    if (((TableItem)object).cellBackground != null) {
                        objectArray2 = ((TableItem)object).cellBackground;
                        objectArray = new Color[this.columnCount - 1];
                        System.arraycopy(objectArray2, 0, objectArray, 0, n);
                        System.arraycopy(objectArray2, n + 1, objectArray, n, this.columnCount - 1 - n);
                        ((TableItem)object).cellBackground = objectArray;
                    }
                    if (((TableItem)object).cellForeground != null) {
                        objectArray2 = ((TableItem)object).cellForeground;
                        objectArray = new Color[this.columnCount - 1];
                        System.arraycopy(objectArray2, 0, objectArray, 0, n);
                        System.arraycopy(objectArray2, n + 1, objectArray, n, this.columnCount - 1 - n);
                        ((TableItem)object).cellForeground = objectArray;
                    }
                    if (((TableItem)object).cellFont != null) {
                        objectArray2 = ((TableItem)object).cellFont;
                        objectArray = new Font[this.columnCount - 1];
                        System.arraycopy(objectArray2, 0, objectArray, 0, n);
                        System.arraycopy(objectArray2, n + 1, objectArray, n, this.columnCount - 1 - n);
                        ((TableItem)object).cellFont = objectArray;
                    }
                }
            }
            ++n2;
        }
        n2 = this.indexOf(tableColumn.nsColumn);
        System.arraycopy(this.columns, n + 1, this.columns, n, --this.columnCount - n);
        this.columns[this.columnCount] = null;
        if (this.columnCount == 0) {
            this.firstColumn = tableColumn.nsColumn;
            this.firstColumn.retain();
            this.firstColumn.setMinWidth(5.0);
            this.setScrollWidth();
        } else {
            ((NSTableView)this.view).removeTableColumn(tableColumn.nsColumn);
        }
        object = ((NSTableView)this.view).tableColumns();
        int n3 = (int)((NSArray)object).count();
        int n4 = n2;
        while (n4 < n3) {
            long l = ((NSArray)object).objectAtIndex((long)((long)n4)).id;
            int n5 = 0;
            while (n5 < this.columnCount) {
                if (this.columns[n5].nsColumn.id == l) {
                    this.columns[n5].sendEvent(10);
                    break;
                }
                ++n5;
            }
            ++n4;
        }
    }

    void destroyItem(TableItem tableItem) {
        int n = 0;
        while (n < this.itemCount) {
            if (this.items[n] == tableItem) break;
            ++n;
        }
        if (n != this.itemCount - 1) {
            this.fixSelection(n, false);
        }
        System.arraycopy(this.items, n + 1, this.items, n, --this.itemCount - n);
        this.items[this.itemCount] = null;
        ((NSTableView)this.view).noteNumberOfRowsChanged();
        if (this.itemCount == 0) {
            this.setTableEmpty();
        }
    }

    boolean dragDetect(int n, int n2, boolean bl, boolean[] blArray) {
        return false;
    }

    void drawInteriorWithFrame_inView(long l, long l2, NSRect nSRect, long l3) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        boolean bl;
        Color color;
        boolean bl2 = this.hooks(40);
        boolean bl3 = this.hooks(42);
        boolean bl4 = this.hooks(41);
        NSTextFieldCell nSTextFieldCell = new NSTextFieldCell(l);
        NSTableView nSTableView = (NSTableView)this.view;
        long[] lArray = new long[1];
        OS.object_getInstanceVariable(l, Display.SWT_ROW, lArray);
        long l4 = lArray[0];
        TableItem tableItem = this._getItem((int)l4);
        OS.object_getInstanceVariable(l, Display.SWT_COLUMN, lArray);
        long l5 = lArray[0];
        long l6 = nSTableView.tableColumns().indexOfObjectIdenticalTo(new id(l5));
        int n = 0;
        int n2 = 0;
        while (n2 < this.columnCount) {
            if (this.columns[n2].nsColumn.id == l5) {
                n = n2;
                break;
            }
            ++n2;
        }
        Color color2 = color = tableItem.cellBackground != null ? tableItem.cellBackground[n] : null;
        if (color == null) {
            color = tableItem.background;
        }
        boolean bl5 = color != null;
        boolean bl6 = true;
        boolean bl7 = bl = nSTextFieldCell.isHighlighted();
        boolean bl8 = bl2 && this.hasFocus();
        Color color3 = null;
        Color color4 = null;
        if (bl && (bl2 || bl3)) {
            color4 = Color.cocoa_new(this.display, bl8 ? this.display.alternateSelectedControlTextColor : this.display.selectedControlTextColor);
            color3 = Color.cocoa_new(this.display, bl8 ? this.display.alternateSelectedControlColor : this.display.secondarySelectedControlColor);
        }
        NSSize nSSize = super.cellSize(l, OS.sel_cellSize);
        NSImage nSImage = nSTextFieldCell.image();
        if (nSImage != null) {
            nSSize.width += (double)(this.imageBounds.width + 3);
        }
        int n3 = (int)Math.ceil(nSSize.width);
        NSSize nSSize2 = nSTableView.intercellSpacing();
        int n4 = (int)Math.ceil(nSTableView.rowHeight() + nSSize2.height);
        NSRect nSRect2 = nSTableView.rectOfColumn(l6);
        nSRect2.y = nSRect.y;
        nSRect2.height = nSRect.height + nSSize2.height;
        if (this.columnCount == 0) {
            NSRect nSRect3 = nSTableView.rectOfRow(l4);
            nSRect2.width = nSRect3.width;
        }
        double d = 0.0;
        double d2 = 0.0;
        if (bl3 || bl2) {
            NSRect nSRect4 = nSTableView.frameOfCellAtColumn(l6, l4);
            d = nSRect.x - nSRect4.x;
            d2 = nSRect.y - nSRect4.y;
            if (this.drawExpansion) {
                d -= 0.5;
                d2 -= 0.5;
            }
        }
        int n5 = (int)(nSRect.x - d);
        int n6 = (int)(nSRect.y - d2);
        NSGraphicsContext nSGraphicsContext = NSGraphicsContext.currentContext();
        if (bl4) {
            this.sendMeasureItem(tableItem, n, nSSize);
        }
        Color color5 = null;
        if (bl2) {
            nSGraphicsContext.saveGraphicsState();
            object4 = NSAffineTransform.transform();
            ((NSAffineTransform)object4).translateXBy(d, d2);
            ((NSAffineTransform)object4).concat();
            object3 = new GCData();
            ((GCData)object3).paintRect = nSRect2;
            object2 = GC.cocoa_new(this, (GCData)object3);
            ((GC)object2).setFont(tableItem.getFont(n));
            if (bl) {
                ((GC)object2).setForeground(color4);
                ((GC)object2).setBackground(color3);
            } else {
                ((GC)object2).setForeground(tableItem.getForeground(n));
                ((GC)object2).setBackground(tableItem.getBackground(n));
            }
            if (!this.drawExpansion) {
                ((GC)object2).setClipping((int)(nSRect2.x - d), (int)(nSRect2.y - d2), (int)nSRect2.width, (int)nSRect2.height);
            }
            object = new Event();
            ((Event)object).item = tableItem;
            ((Event)object).gc = object2;
            ((Event)object).index = n;
            ((Event)object).detail = 16;
            if (bl5) {
                ((Event)object).detail |= 8;
            }
            if (bl) {
                ((Event)object).detail |= 2;
            }
            ((Event)object).x = (int)nSRect2.x;
            ((Event)object).y = (int)nSRect2.y;
            ((Event)object).width = (int)nSRect2.width;
            ((Event)object).height = (int)nSRect2.height;
            this.sendEvent(40, (Event)object);
            if (!((Event)object).doit) {
                bl7 = false;
                bl5 = false;
                bl6 = false;
            } else {
                bl5 = bl5 && (((Event)object).detail & 8) != 0;
                bl6 = (((Event)object).detail & 0x10) != 0;
                boolean bl9 = bl7 = bl7 && (((Event)object).detail & 2) != 0;
            }
            if (!bl7 && bl) {
                color5 = Color.cocoa_new(this.display, ((GC)object2).getForeground().handle);
            }
            ((Resource)object2).dispose();
            nSGraphicsContext.restoreGraphicsState();
            if (this.isDisposed()) {
                return;
            }
            if (tableItem.isDisposed()) {
                return;
            }
            if (bl7 && ((this.style & 0x8000) == 0 || bl8)) {
                nSRect2.height -= nSSize2.height;
                this.callSuper(nSTableView.id, OS.sel_highlightSelectionInClipRect_, nSRect2);
                nSRect2.height += nSSize2.height;
            }
        }
        if (bl5 && !bl7) {
            nSGraphicsContext.saveGraphicsState();
            object4 = color.handle;
            object3 = NSColor.colorWithDeviceRed((double)object4[0], (double)object4[1], (double)object4[2], 1.0);
            ((NSColor)object3).setFill();
            NSBezierPath.fillRect(nSRect2);
            nSGraphicsContext.restoreGraphicsState();
        }
        if (bl6) {
            if ((!this.drawExpansion || bl4) && nSImage != null) {
                object4 = new NSRect();
                ((NSRect)object4).x = nSRect.x + 3.0;
                ((NSRect)object4).y = nSRect.y + (double)((float)Math.ceil((nSRect.height - (double)this.imageBounds.height) / 2.0));
                ((NSRect)object4).width = this.imageBounds.width;
                ((NSRect)object4).height = this.imageBounds.height;
                object3 = new NSRect();
                object2 = nSImage.size();
                ((NSRect)object3).width = ((NSSize)object2).width;
                ((NSRect)object3).height = ((NSSize)object2).height;
                nSGraphicsContext.saveGraphicsState();
                NSBezierPath.bezierPathWithRect(nSRect).addClip();
                object = NSAffineTransform.transform();
                ((NSAffineTransform)object).scaleXBy(1.0, -1.0);
                ((NSAffineTransform)object).translateXBy(0.0, -(((NSRect)object4).height + 2.0 * ((NSRect)object4).y));
                ((NSAffineTransform)object).concat();
                nSImage.drawInRect((NSRect)object4, (NSRect)object3, 2L, 1.0);
                nSGraphicsContext.restoreGraphicsState();
                int n7 = this.imageBounds.width + 3;
                nSRect.x += (double)n7;
                nSRect.width -= (double)n7;
            }
            nSTextFieldCell.setHighlighted(false);
            boolean bl10 = false;
            if (color5 != null) {
                object3 = color5.handle;
                if (object3[0] == 0.0 && object3[1] == 0.0 && object3[2] == 0.0 && object3[3] == 1.0) {
                    object2 = new NSMutableAttributedString(nSTextFieldCell.attributedStringValue().mutableCopy());
                    object = new NSRange();
                    ((NSRange)object).length = ((NSAttributedString)object2).length();
                    ((NSMutableAttributedString)object2).removeAttribute(OS.NSForegroundColorAttributeName, (NSRange)object);
                    NSRect nSRect5 = new NSRect();
                    nSRect5.x = nSRect.x + 2.0;
                    nSRect5.y = nSRect.y;
                    nSRect5.width = nSRect.width - 2.0;
                    nSRect5.height = nSRect.height;
                    NSSize nSSize3 = ((NSAttributedString)object2).size();
                    if (nSRect5.height > nSSize3.height) {
                        nSRect5.y += (nSRect5.height - nSSize3.height) / 2.0;
                        nSRect5.height = nSSize3.height;
                    }
                    ((NSAttributedString)object2).drawInRect(nSRect5);
                    ((NSObject)object2).release();
                } else {
                    object2 = NSColor.colorWithDeviceRed((double)object3[0], (double)object3[1], (double)object3[2], (double)object3[3]);
                    nSTextFieldCell.setTextColor((NSColor)object2);
                    bl10 = true;
                }
            } else {
                bl10 = true;
            }
            if (bl10) {
                object3 = nSTextFieldCell.attributedStringValue();
                object2 = ((NSAttributedString)object3).size();
                if (nSRect.height > ((NSSize)object2).height) {
                    nSRect.y += (nSRect.height - ((NSSize)object2).height) / 2.0;
                    nSRect.height = ((NSSize)object2).height;
                }
                super.drawInteriorWithFrame_inView(l, l2, nSRect, l3);
            }
        }
        if (bl3) {
            nSGraphicsContext.saveGraphicsState();
            NSAffineTransform nSAffineTransform = NSAffineTransform.transform();
            nSAffineTransform.translateXBy(d, d2);
            nSAffineTransform.concat();
            object3 = new GCData();
            ((GCData)object3).paintRect = nSRect2;
            object2 = GC.cocoa_new(this, (GCData)object3);
            ((GC)object2).setFont(tableItem.getFont(n));
            if (bl7) {
                ((GC)object2).setForeground(color4);
                ((GC)object2).setBackground(color3);
            } else {
                ((GC)object2).setForeground(color5 != null ? color5 : tableItem.getForeground(n));
                ((GC)object2).setBackground(tableItem.getBackground(n));
            }
            if (!this.drawExpansion) {
                ((GC)object2).setClipping((int)(nSRect2.x - d), (int)(nSRect2.y - d2), (int)nSRect2.width, (int)nSRect2.height);
            }
            object = new Event();
            ((Event)object).item = tableItem;
            ((Event)object).gc = object2;
            ((Event)object).index = n;
            if (bl6) {
                ((Event)object).detail |= 0x10;
            }
            if (bl5) {
                ((Event)object).detail |= 8;
            }
            if (bl7) {
                ((Event)object).detail |= 2;
            }
            ((Event)object).x = n5;
            ((Event)object).y = n6;
            ((Event)object).width = n3;
            ((Event)object).height = n4;
            this.sendEvent(42, (Event)object);
            ((Resource)object2).dispose();
            nSGraphicsContext.restoreGraphicsState();
        }
    }

    void drawWithExpansionFrame_inView(long l, long l2, NSRect nSRect, long l3) {
        this.drawExpansion = true;
        super.drawWithExpansionFrame_inView(l, l2, nSRect, l3);
        this.drawExpansion = false;
    }

    void drawRect(int n, int n2, NSRect nSRect) {
        this.fixScrollWidth = false;
        super.drawRect(n, n2, nSRect);
        if (this.isDisposed()) {
            return;
        }
        if (this.fixScrollWidth) {
            this.fixScrollWidth = false;
            if (this.setScrollWidth(this.items, true)) {
                this.view.setNeedsDisplay(true);
            }
        }
    }

    NSRect expansionFrameWithFrame_inView(long l, long l2, NSRect nSRect, long l3) {
        if (this.toolTipText == null) {
            NSRect nSRect2 = super.expansionFrameWithFrame_inView(l, l2, nSRect, l3);
            NSCell nSCell = new NSCell(l);
            if (nSRect2.width != 0.0 && nSRect2.height != 0.0) {
                if (this.hooks(41)) {
                    NSSize nSSize = nSCell.cellSize();
                    nSRect.width = nSSize.width;
                    return nSRect;
                }
            } else {
                Object object;
                NSRect nSRect3;
                if (this.hooks(41)) {
                    nSRect3 = nSRect;
                    object = nSCell.cellSize();
                    nSRect3.width = ((NSSize)object).width;
                } else {
                    nSRect3 = nSCell.titleRectForBounds(nSRect);
                    object = super.cellSize(l, OS.sel_cellSize);
                    nSRect3.width = ((NSSize)object).width;
                }
                object = this.scrollView.contentView().bounds();
                OS.NSIntersectionRect((NSRect)object, nSRect3, (NSRect)object);
                if (!OS.NSEqualRects(nSRect3, (NSRect)object)) {
                    return nSRect3;
                }
            }
            return nSRect2;
        }
        return new NSRect();
    }

    Widget findTooltip(NSPoint nSPoint) {
        long l;
        NSTableView nSTableView = (NSTableView)this.view;
        NSTableHeaderView nSTableHeaderView = nSTableView.headerView();
        if (nSTableHeaderView != null && (l = nSTableHeaderView.columnAtPoint(nSPoint = nSTableHeaderView.convertPoint_fromView_(nSPoint, null))) != -1L) {
            NSArray nSArray = nSTableView.tableColumns();
            id id2 = nSArray.objectAtIndex(l);
            int n = 0;
            while (n < this.columnCount) {
                TableColumn tableColumn = this.columns[n];
                if (tableColumn.nsColumn.id == id2.id) {
                    return tableColumn;
                }
                ++n;
            }
        }
        return super.findTooltip(nSPoint);
    }

    void fixSelection(int n, boolean bl) {
        int[] nArray = this.getSelectionIndices();
        if (nArray.length == 0) {
            return;
        }
        int n2 = 0;
        boolean bl2 = false;
        int n3 = 0;
        while (n3 < nArray.length) {
            if (!bl && nArray[n3] == n) {
                bl2 = true;
            } else {
                int n4 = n2++;
                nArray[n4] = nArray[n3];
                if (nArray[n4] >= n) {
                    int n5 = n4;
                    nArray[n5] = nArray[n5] + (bl ? 1 : -1);
                    bl2 = true;
                }
            }
            ++n3;
        }
        if (bl2) {
            this.select(nArray, n2, true);
        }
    }

    int getCheckColumnWidth() {
        return (int)this.checkColumn.dataCell().cellSize().width;
    }

    public Rectangle getClientArea() {
        this.checkWidget();
        Rectangle rectangle = super.getClientArea();
        NSTableHeaderView nSTableHeaderView = ((NSTableView)this.view).headerView();
        if (nSTableHeaderView != null) {
            int n = (int)nSTableHeaderView.bounds().height;
            rectangle.y -= n;
            rectangle.height += n;
        }
        return rectangle;
    }

    TableColumn getColumn(id id2) {
        int n = 0;
        while (n < this.columnCount) {
            if (this.columns[n].nsColumn.id == id2.id) {
                return this.columns[n];
            }
            ++n;
        }
        return null;
    }

    public TableColumn getColumn(int n) {
        this.checkWidget();
        if (n < 0 || n >= this.columnCount) {
            this.error(6);
        }
        return this.columns[n];
    }

    public int getColumnCount() {
        this.checkWidget();
        return this.columnCount;
    }

    public int[] getColumnOrder() {
        this.checkWidget();
        int[] nArray = new int[this.columnCount];
        int n = 0;
        while (n < this.columnCount) {
            TableColumn tableColumn = this.columns[n];
            int n2 = this.indexOf(tableColumn.nsColumn);
            if ((this.style & 0x20) != 0) {
                --n2;
            }
            nArray[n2] = n++;
        }
        return nArray;
    }

    public TableColumn[] getColumns() {
        this.checkWidget();
        TableColumn[] tableColumnArray = new TableColumn[this.columnCount];
        System.arraycopy(this.columns, 0, tableColumnArray, 0, this.columnCount);
        return tableColumnArray;
    }

    public int getGridLineWidth() {
        this.checkWidget();
        return 0;
    }

    public int getHeaderHeight() {
        this.checkWidget();
        NSTableHeaderView nSTableHeaderView = ((NSTableView)this.view).headerView();
        if (nSTableHeaderView == null) {
            return 0;
        }
        return (int)nSTableHeaderView.bounds().height;
    }

    public boolean getHeaderVisible() {
        this.checkWidget();
        return ((NSTableView)this.view).headerView() != null;
    }

    public TableItem getItem(int n) {
        this.checkWidget();
        if (n < 0 || n >= this.itemCount) {
            this.error(6);
        }
        return this._getItem(n);
    }

    public TableItem getItem(Point point) {
        this.checkWidget();
        NSTableView nSTableView = (NSTableView)this.view;
        NSPoint nSPoint = new NSPoint();
        nSPoint.x = point.x;
        nSPoint.y = point.y;
        int n = (int)nSTableView.rowAtPoint(nSPoint);
        if (n == -1) {
            return null;
        }
        return this.items[n];
    }

    public int getItemCount() {
        this.checkWidget();
        return this.itemCount;
    }

    public int getItemHeight() {
        this.checkWidget();
        return (int)((NSTableView)this.view).rowHeight() + 1;
    }

    public TableItem[] getItems() {
        this.checkWidget();
        TableItem[] tableItemArray = new TableItem[this.itemCount];
        if ((this.style & 0x10000000) != 0) {
            int n = 0;
            while (n < this.itemCount) {
                tableItemArray[n] = this._getItem(n);
                ++n;
            }
        } else {
            System.arraycopy(this.items, 0, tableItemArray, 0, this.itemCount);
        }
        return tableItemArray;
    }

    public boolean getLinesVisible() {
        this.checkWidget();
        return ((NSTableView)this.view).usesAlternatingRowBackgroundColors();
    }

    public TableItem[] getSelection() {
        this.checkWidget();
        NSTableView nSTableView = (NSTableView)this.view;
        if (nSTableView.numberOfSelectedRows() == 0L) {
            return new TableItem[0];
        }
        NSIndexSet nSIndexSet = nSTableView.selectedRowIndexes();
        int n = (int)nSIndexSet.count();
        long[] lArray = new long[n];
        nSIndexSet.getIndexes(lArray, n, 0L);
        TableItem[] tableItemArray = new TableItem[n];
        int n2 = 0;
        while (n2 < n) {
            tableItemArray[n2] = this._getItem((int)lArray[n2]);
            ++n2;
        }
        return tableItemArray;
    }

    public int getSelectionCount() {
        this.checkWidget();
        return (int)((NSTableView)this.view).numberOfSelectedRows();
    }

    public int getSelectionIndex() {
        this.checkWidget();
        NSTableView nSTableView = (NSTableView)this.view;
        if (nSTableView.numberOfSelectedRows() == 0L) {
            return -1;
        }
        NSIndexSet nSIndexSet = nSTableView.selectedRowIndexes();
        int n = (int)nSIndexSet.count();
        long[] lArray = new long[n];
        nSIndexSet.getIndexes(lArray, n, 0L);
        return (int)lArray[0];
    }

    public int[] getSelectionIndices() {
        this.checkWidget();
        NSTableView nSTableView = (NSTableView)this.view;
        if (nSTableView.numberOfSelectedRows() == 0L) {
            return new int[0];
        }
        NSIndexSet nSIndexSet = nSTableView.selectedRowIndexes();
        int n = (int)nSIndexSet.count();
        long[] lArray = new long[n];
        nSIndexSet.getIndexes(lArray, n, 0L);
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < lArray.length) {
            nArray[n2] = (int)lArray[n2];
            ++n2;
        }
        return nArray;
    }

    public TableColumn getSortColumn() {
        this.checkWidget();
        return this.sortColumn;
    }

    public int getSortDirection() {
        this.checkWidget();
        return this.sortDirection;
    }

    public int getTopIndex() {
        this.checkWidget();
        NSRect nSRect = this.scrollView.documentVisibleRect();
        NSPoint nSPoint = new NSPoint();
        nSPoint.x = nSRect.x;
        nSPoint.y = nSRect.y;
        return (int)((NSTableView)this.view).rowAtPoint(nSPoint);
    }

    void highlightSelectionInClipRect(long l, long l2, long l3) {
        if (this.hooks(40)) {
            return;
        }
        if ((this.style & 0x8000) != 0 && !this.hasFocus()) {
            return;
        }
        NSRect nSRect = new NSRect();
        OS.memmove(nSRect, l3, (long)NSRect.sizeof);
        this.callSuper(l, l2, nSRect);
    }

    long hitTestForEvent(long l, long l2, long l3, NSRect nSRect, long l4) {
        return this.callSuper(l, l2, l3, nSRect, l4);
    }

    long image(long l, long l2) {
        long[] lArray = new long[1];
        OS.object_getInstanceVariable(l, Display.SWT_IMAGE, lArray);
        return lArray[0];
    }

    NSRect imageRectForBounds(long l, long l2, NSRect nSRect) {
        NSImage nSImage = new NSCell(l).image();
        if (nSImage != null) {
            nSRect.x += 3.0;
            nSRect.width = this.imageBounds.width;
            nSRect.height = this.imageBounds.height;
        }
        return nSRect;
    }

    int indexOf(NSTableColumn nSTableColumn) {
        return (int)((NSTableView)this.view).tableColumns().indexOfObjectIdenticalTo(nSTableColumn);
    }

    public int indexOf(TableColumn tableColumn) {
        this.checkWidget();
        if (tableColumn == null) {
            this.error(4);
        }
        int n = 0;
        while (n < this.columnCount) {
            if (this.columns[n] == tableColumn) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public int indexOf(TableItem tableItem) {
        this.checkWidget();
        if (tableItem == null) {
            this.error(4);
        }
        if (1 <= this.lastIndexOf && this.lastIndexOf < this.itemCount - 1) {
            if (this.items[this.lastIndexOf] == tableItem) {
                return this.lastIndexOf;
            }
            if (this.items[this.lastIndexOf + 1] == tableItem) {
                return ++this.lastIndexOf;
            }
            if (this.items[this.lastIndexOf - 1] == tableItem) {
                return --this.lastIndexOf;
            }
        }
        if (this.lastIndexOf < this.itemCount / 2) {
            int n = 0;
            while (n < this.itemCount) {
                if (this.items[n] == tableItem) {
                    this.lastIndexOf = n;
                    return this.lastIndexOf;
                }
                ++n;
            }
        } else {
            int n = this.itemCount - 1;
            while (n >= 0) {
                if (this.items[n] == tableItem) {
                    this.lastIndexOf = n;
                    return this.lastIndexOf;
                }
                --n;
            }
        }
        return -1;
    }

    public boolean isSelected(int n) {
        this.checkWidget();
        if (n < 0 || n >= this.itemCount) {
            return false;
        }
        return ((NSTableView)this.view).isRowSelected(n);
    }

    boolean isTrim(NSView nSView) {
        if (super.isTrim(nSView)) {
            return true;
        }
        return nSView.id == this.headerView.id;
    }

    long menuForEvent(long l, long l2, long l3) {
        if (l != this.headerView.id) {
            NSPoint nSPoint;
            long l4;
            NSEvent nSEvent = new NSEvent(l3);
            NSTableView nSTableView = (NSTableView)this.view;
            NSIndexSet nSIndexSet = nSTableView.selectedRowIndexes();
            if (!nSIndexSet.containsIndex(l4 = nSTableView.rowAtPoint(nSPoint = this.view.convertPoint_fromView_(nSEvent.locationInWindow(), null)))) {
                NSIndexSet nSIndexSet2 = (NSIndexSet)new NSIndexSet().alloc();
                nSIndexSet2 = nSIndexSet2.initWithIndex(l4);
                nSTableView.selectRowIndexes(nSIndexSet2, false);
                nSIndexSet2.release();
            }
        }
        return super.menuForEvent(l, l2, l3);
    }

    void mouseDown(long l, long l2, long l3) {
        NSEvent nSEvent;
        if (this.headerView != null && l == this.headerView.id) {
            NSTableView nSTableView = (NSTableView)this.view;
            nSTableView.setAllowsColumnReordering(false);
            NSPoint nSPoint = this.headerView.convertPoint_fromView_(new NSEvent(l3).locationInWindow(), null);
            long l4 = this.headerView.columnAtPoint(nSPoint);
            if (l4 != -1L) {
                id id2 = nSTableView.tableColumns().objectAtIndex(l4);
                int n = 0;
                while (n < this.columnCount) {
                    if (this.columns[n].nsColumn.id == id2.id) {
                        nSTableView.setAllowsColumnReordering(this.columns[n].movable);
                        break;
                    }
                    ++n;
                }
            }
        } else if (l == this.view.id && ((nSEvent = new NSEvent(l3)).modifierFlags() & 0x40000L) != 0L) {
            return;
        }
        super.mouseDown(l, l2, l3);
    }

    long nextState(long l, long l2) {
        NSTableView nSTableView = (NSTableView)this.view;
        int n = (int)nSTableView.selectedRow();
        TableItem tableItem = this.items[n];
        if (tableItem.grayed) {
            return tableItem.checked ? 0 : -1;
        }
        return tableItem.checked ? 0 : 1;
    }

    long numberOfRowsInTableView(long l, long l2, long l3) {
        return this.itemCount;
    }

    void register() {
        super.register();
        this.display.addWidget(this.headerView, this);
        this.display.addWidget(this.dataCell, this);
        if (this.buttonCell != null) {
            this.display.addWidget(this.buttonCell, this);
        }
    }

    void releaseChildren(boolean bl) {
        Item item;
        int n;
        if (this.items != null) {
            n = 0;
            while (n < this.itemCount) {
                item = this.items[n];
                if (item != null && !item.isDisposed()) {
                    item.release(false);
                }
                ++n;
            }
            this.items = null;
        }
        if (this.columns != null) {
            n = 0;
            while (n < this.columnCount) {
                item = this.columns[n];
                if (item != null && !item.isDisposed()) {
                    item.release(false);
                }
                ++n;
            }
            this.columns = null;
        }
        super.releaseChildren(bl);
    }

    void releaseHandle() {
        super.releaseHandle();
        if (this.headerView != null) {
            this.headerView.release();
        }
        this.headerView = null;
        if (this.firstColumn != null) {
            this.firstColumn.release();
        }
        this.firstColumn = null;
        if (this.checkColumn != null) {
            this.checkColumn.release();
        }
        this.checkColumn = null;
        if (this.dataCell != null) {
            this.dataCell.release();
        }
        this.dataCell = null;
        if (this.buttonCell != null) {
            this.buttonCell.release();
        }
        this.buttonCell = null;
    }

    void releaseWidget() {
        super.releaseWidget();
        this.currentItem = null;
        this.sortColumn = null;
    }

    public void remove(int n) {
        TableItem tableItem;
        this.checkWidget();
        if (n < 0 || n >= this.itemCount) {
            this.error(6);
        }
        if ((tableItem = this.items[n]) != null) {
            tableItem.release(false);
        }
        if (n != this.itemCount - 1) {
            this.fixSelection(n, false);
        }
        System.arraycopy(this.items, n + 1, this.items, n, --this.itemCount - n);
        this.items[this.itemCount] = null;
        ((NSTableView)this.view).noteNumberOfRowsChanged();
        if (this.itemCount == 0) {
            this.setTableEmpty();
        }
    }

    public void remove(int n, int n2) {
        this.checkWidget();
        if (n > n2) {
            return;
        }
        if (n < 0 || n > n2 || n2 >= this.itemCount) {
            this.error(6);
        }
        if (n == 0 && n2 == this.itemCount - 1) {
            this.removeAll();
        } else {
            int n3 = n2 - n + 1;
            int n4 = 0;
            while (n4 < n3) {
                this.remove(n);
                ++n4;
            }
        }
    }

    public void remove(int[] nArray) {
        this.checkWidget();
        if (nArray == null) {
            this.error(4);
        }
        if (nArray.length == 0) {
            return;
        }
        int[] nArray2 = new int[nArray.length];
        System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
        this.sort(nArray2);
        int n = nArray2[nArray2.length - 1];
        int n2 = nArray2[0];
        if (n < 0 || n > n2 || n2 >= this.itemCount) {
            this.error(6);
        }
        int n3 = -1;
        int n4 = 0;
        while (n4 < nArray2.length) {
            int n5 = nArray2[n4];
            if (n5 != n3) {
                this.remove(n5);
                n3 = n5;
            }
            ++n4;
        }
    }

    public void removeAll() {
        this.checkWidget();
        int n = 0;
        while (n < this.itemCount) {
            TableItem tableItem = this.items[n];
            if (tableItem != null && !tableItem.isDisposed()) {
                tableItem.release(false);
            }
            ++n;
        }
        this.setTableEmpty();
        ((NSTableView)this.view).noteNumberOfRowsChanged();
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    public void select(int n) {
        this.checkWidget();
        if (n >= 0 && n < this.itemCount) {
            NSIndexSet nSIndexSet = (NSIndexSet)new NSIndexSet().alloc();
            nSIndexSet = nSIndexSet.initWithIndex(n);
            NSTableView nSTableView = (NSTableView)this.view;
            this.ignoreSelect = true;
            nSTableView.selectRowIndexes(nSIndexSet, (this.style & 2) != 0);
            this.ignoreSelect = false;
            nSIndexSet.release();
        }
    }

    public void select(int n, int n2) {
        this.checkWidget();
        if (n2 < 0 || n > n2 || (this.style & 4) != 0 && n != n2) {
            return;
        }
        if (this.itemCount == 0 || n >= this.itemCount) {
            return;
        }
        if (n == 0 && n2 == this.itemCount - 1) {
            this.selectAll();
        } else {
            n = Math.max(0, n);
            n2 = Math.min(n2, this.itemCount - 1);
            NSRange nSRange = new NSRange();
            nSRange.location = n;
            nSRange.length = n2 - n + 1;
            NSIndexSet nSIndexSet = (NSIndexSet)new NSIndexSet().alloc();
            nSIndexSet = nSIndexSet.initWithIndexesInRange(nSRange);
            NSTableView nSTableView = (NSTableView)this.view;
            this.ignoreSelect = true;
            nSTableView.selectRowIndexes(nSIndexSet, (this.style & 2) != 0);
            this.ignoreSelect = false;
            nSIndexSet.release();
        }
    }

    public void select(int[] nArray) {
        int n;
        this.checkWidget();
        if (nArray == null) {
            this.error(4);
        }
        if ((n = nArray.length) == 0 || (this.style & 4) != 0 && n > 1) {
            return;
        }
        int n2 = 0;
        NSMutableIndexSet nSMutableIndexSet = (NSMutableIndexSet)new NSMutableIndexSet().alloc().init();
        int n3 = 0;
        while (n3 < n) {
            int n4 = nArray[n3];
            if (n4 >= 0 && n4 < this.itemCount) {
                nSMutableIndexSet.addIndex(nArray[n3]);
                ++n2;
            }
            ++n3;
        }
        if (n2 > 0) {
            NSTableView nSTableView = (NSTableView)this.view;
            this.ignoreSelect = true;
            nSTableView.selectRowIndexes(nSMutableIndexSet, (this.style & 2) != 0);
            this.ignoreSelect = false;
        }
        nSMutableIndexSet.release();
    }

    void select(int[] nArray, int n, boolean bl) {
        NSMutableIndexSet nSMutableIndexSet = (NSMutableIndexSet)new NSMutableIndexSet().alloc().init();
        int n2 = 0;
        while (n2 < n) {
            nSMutableIndexSet.addIndex(nArray[n2]);
            ++n2;
        }
        NSTableView nSTableView = (NSTableView)this.view;
        this.ignoreSelect = true;
        nSTableView.selectRowIndexes(nSMutableIndexSet, !bl);
        this.ignoreSelect = false;
        nSMutableIndexSet.release();
    }

    public void selectAll() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return;
        }
        NSTableView nSTableView = (NSTableView)this.view;
        this.ignoreSelect = true;
        nSTableView.selectAll(null);
        this.ignoreSelect = false;
    }

    void updateBackground() {
        NSColor nSColor = null;
        if (this.backgroundImage != null) {
            nSColor = NSColor.colorWithPatternImage(this.backgroundImage.handle);
        } else if (this.background != null) {
            nSColor = NSColor.colorWithDeviceRed(this.background[0], this.background[1], this.background[2], this.background[3]);
        }
        ((NSTableView)this.view).setBackgroundColor(nSColor);
    }

    public void setColumnOrder(int[] nArray) {
        this.checkWidget();
        if (nArray == null) {
            this.error(4);
        }
        if (this.columnCount == 0) {
            if (nArray.length != 0) {
                this.error(5);
            }
            return;
        }
        if (nArray.length != this.columnCount) {
            this.error(5);
        }
        int[] nArray2 = this.getColumnOrder();
        boolean bl = false;
        boolean[] blArray = new boolean[this.columnCount];
        int n = 0;
        while (n < nArray.length) {
            int n2 = nArray[n];
            if (n2 < 0 || n2 >= this.columnCount) {
                this.error(5);
            }
            if (blArray[n2]) {
                this.error(5);
            }
            blArray[n2] = true;
            if (nArray[n] != nArray2[n]) {
                bl = true;
            }
            ++n;
        }
        if (bl) {
            TableColumn tableColumn;
            int n3;
            int n4;
            NSTableView nSTableView = (NSTableView)this.view;
            int[] nArray3 = new int[nArray2.length];
            int n5 = (this.style & 0x20) != 0 ? 1 : 0;
            int n6 = 0;
            while (n6 < nArray2.length) {
                n4 = nArray2[n6];
                nArray3[n4] = (int)nSTableView.rectOfColumn((long)((long)(n6 + n5))).x;
                ++n6;
            }
            int[] nArray4 = new int[nArray.length];
            n4 = 0;
            while (n4 < nArray.length) {
                n3 = nArray[n4];
                tableColumn = this.columns[n3];
                int n7 = this.indexOf(tableColumn.nsColumn);
                int n8 = n4 + n5;
                nSTableView.moveColumn(n7, n8);
                nArray4[n3] = (int)nSTableView.rectOfColumn((long)((long)n8)).x;
                ++n4;
            }
            TableColumn[] tableColumnArray = new TableColumn[this.columnCount];
            System.arraycopy(this.columns, 0, tableColumnArray, 0, this.columnCount);
            n3 = 0;
            while (n3 < this.columnCount) {
                tableColumn = tableColumnArray[n3];
                if (!tableColumn.isDisposed() && nArray4[n3] != nArray3[n3]) {
                    tableColumn.sendEvent(10);
                }
                ++n3;
            }
        }
    }

    void setFont(NSFont nSFont) {
        super.setFont(nSFont);
        this.setItemHeight(null, nSFont, !this.hooks(41));
        this.view.setNeedsDisplay(true);
        this.clearCachedWidth(this.items);
        this.setScrollWidth(this.items, true);
    }

    public void setHeaderVisible(boolean bl) {
        this.checkWidget();
        ((NSTableView)this.view).setHeaderView(bl ? this.headerView : null);
    }

    void setImage(long l, long l2, long l3) {
        OS.object_setInstanceVariable(l, Display.SWT_IMAGE, l3);
    }

    public void setItemCount(int n) {
        TableItem[] tableItemArray;
        int n2;
        this.checkWidget();
        n = Math.max(0, n);
        if (n == this.itemCount) {
            return;
        }
        if (n == this.itemCount) {
            return;
        }
        TableItem[] tableItemArray2 = this.items;
        if (n < this.itemCount) {
            n2 = n;
            while (n2 < this.itemCount) {
                tableItemArray = tableItemArray2[n2];
                if (tableItemArray != null && !tableItemArray.isDisposed()) {
                    tableItemArray.release(false);
                }
                ++n2;
            }
        }
        if (n > this.itemCount && (this.getStyle() & 0x10000000) == 0) {
            n2 = this.itemCount;
            while (n2 < n) {
                new TableItem(this, 0, n2, true);
                ++n2;
            }
            return;
        }
        n2 = Math.max(4, (n + 3) / 4 * 4);
        tableItemArray = new TableItem[n2];
        if (tableItemArray2 != null) {
            System.arraycopy(this.items, 0, tableItemArray, 0, Math.min(n, this.itemCount));
        }
        tableItemArray2 = tableItemArray;
        this.items = tableItemArray;
        this.itemCount = n;
        ((NSTableView)this.view).noteNumberOfRowsChanged();
    }

    void setItemHeight(int n) {
        this.checkWidget();
        if (n < -1) {
            this.error(5);
        }
        if (n != -1) {
            ((NSTableView)this.view).setRowHeight(n);
        }
    }

    void setItemHeight(Image image, NSFont nSFont, boolean bl) {
        Rectangle rectangle;
        if (nSFont == null) {
            nSFont = this.getFont().handle;
        }
        double d = nSFont.ascender();
        double d2 = -nSFont.descender() + nSFont.leading();
        int n = (int)Math.ceil(d + d2) + 1;
        Rectangle rectangle2 = rectangle = image != null ? image.getBounds() : this.imageBounds;
        if (rectangle != null) {
            this.imageBounds = rectangle;
            n = Math.max(n, rectangle.height);
        }
        NSTableView nSTableView = (NSTableView)this.view;
        if (bl || nSTableView.rowHeight() < (double)n) {
            nSTableView.setRowHeight(n);
        }
    }

    public void setRedraw(boolean bl) {
        this.checkWidget();
        super.setRedraw(bl);
        if (bl && this.drawCount == 0) {
            if (this.items.length > 4 && this.items.length - this.itemCount > 3) {
                int n = Math.max(4, (this.itemCount + 3) / 4 * 4);
                TableItem[] tableItemArray = new TableItem[n];
                System.arraycopy(this.items, 0, tableItemArray, 0, this.itemCount);
                this.items = tableItemArray;
            }
            this.setScrollWidth();
        }
    }

    public void setLinesVisible(boolean bl) {
        this.checkWidget();
        ((NSTableView)this.view).setUsesAlternatingRowBackgroundColors(bl);
    }

    boolean setScrollWidth() {
        return this.setScrollWidth(this.items, true);
    }

    boolean setScrollWidth(TableItem tableItem) {
        if (this.columnCount != 0) {
            return false;
        }
        if (!this.getDrawing()) {
            return false;
        }
        if (this.currentItem != null) {
            if (this.currentItem != tableItem) {
                this.fixScrollWidth = true;
            }
            return false;
        }
        GC gC = new GC(this);
        int n = tableItem.calculateWidth(0, gC);
        gC.dispose();
        int n2 = (int)this.firstColumn.width();
        if (n2 < n) {
            this.firstColumn.setWidth(n);
            if (this.horizontalBar != null && this.horizontalBar.view != null) {
                this.redrawWidget(this.horizontalBar.view, false);
            }
            return true;
        }
        return false;
    }

    boolean setScrollWidth(TableItem[] tableItemArray, boolean bl) {
        if (tableItemArray == null) {
            return false;
        }
        if (this.columnCount != 0) {
            return false;
        }
        if (!this.getDrawing()) {
            return false;
        }
        if (this.currentItem != null) {
            this.fixScrollWidth = true;
            return false;
        }
        GC gC = new GC(this);
        int n = 0;
        int n2 = 0;
        while (n2 < tableItemArray.length) {
            TableItem tableItem = tableItemArray[n2];
            if (tableItem != null) {
                n = Math.max(n, tableItem.calculateWidth(0, gC));
            }
            ++n2;
        }
        gC.dispose();
        if (!bl && (n2 = (int)this.firstColumn.width()) >= n) {
            return false;
        }
        this.firstColumn.setWidth(n);
        if (this.horizontalBar != null && this.horizontalBar.view != null) {
            this.redrawWidget(this.horizontalBar.view, false);
        }
        return true;
    }

    public void setSelection(int n) {
        this.checkWidget();
        this.deselectAll();
        if (n >= 0 && n < this.itemCount) {
            this.select(n);
            this.showIndex(n);
        }
    }

    public void setSelection(int n, int n2) {
        this.checkWidget();
        this.deselectAll();
        if (n2 < 0 || n > n2 || (this.style & 4) != 0 && n != n2) {
            return;
        }
        if (this.itemCount == 0 || n >= this.itemCount) {
            return;
        }
        n = Math.max(0, n);
        n2 = Math.min(n2, this.itemCount - 1);
        this.select(n, n2);
        this.showIndex(n);
    }

    public void setSelection(int[] nArray) {
        this.checkWidget();
        if (nArray == null) {
            this.error(4);
        }
        this.deselectAll();
        int n = nArray.length;
        if (n == 0 || (this.style & 4) != 0 && n > 1) {
            return;
        }
        this.select(nArray);
        this.showIndex(nArray[0]);
    }

    public void setSelection(TableItem tableItem) {
        this.checkWidget();
        if (tableItem == null) {
            this.error(4);
        }
        this.setSelection(new TableItem[]{tableItem});
    }

    public void setSelection(TableItem[] tableItemArray) {
        this.checkWidget();
        if (tableItemArray == null) {
            this.error(4);
        }
        this.deselectAll();
        int n = tableItemArray.length;
        if (n == 0 || (this.style & 4) != 0 && n > 1) {
            return;
        }
        int[] nArray = new int[n];
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            int n4 = this.indexOf(tableItemArray[n - n3 - 1]);
            if (n4 != -1) {
                nArray[n2++] = n4;
            }
            ++n3;
        }
        if (n2 > 0) {
            this.select(nArray);
            this.showIndex(nArray[0]);
        }
    }

    void setSmallSize() {
        if (this.checkColumn == null) {
            return;
        }
        this.checkColumn.dataCell().setControlSize(1L);
        this.checkColumn.setWidth(this.getCheckColumnWidth());
    }

    public void setSortColumn(TableColumn tableColumn) {
        this.checkWidget();
        if (tableColumn != null && tableColumn.isDisposed()) {
            this.error(5);
        }
        if (tableColumn == this.sortColumn) {
            return;
        }
        this.sortColumn = tableColumn;
        ((NSTableView)this.view).setHighlightedTableColumn(tableColumn == null ? null : tableColumn.nsColumn);
    }

    public void setSortDirection(int n) {
        this.checkWidget();
        if (n != 128 && n != 1024 && n != 0) {
            return;
        }
        if (n == this.sortDirection) {
            return;
        }
        this.sortDirection = n;
        if (this.sortColumn == null) {
            return;
        }
        NSTableHeaderView nSTableHeaderView = ((NSTableView)this.view).headerView();
        if (nSTableHeaderView == null) {
            return;
        }
        int n2 = this.indexOf(this.sortColumn.nsColumn);
        NSRect nSRect = nSTableHeaderView.headerRectOfColumn(n2);
        nSTableHeaderView.setNeedsDisplayInRect(nSRect);
    }

    void setTableEmpty() {
        this.itemCount = 0;
        this.items = new TableItem[4];
        this.imageBounds = null;
    }

    public void setTopIndex(int n) {
        this.checkWidget();
        NSTableView nSTableView = (NSTableView)this.view;
        int n2 = Math.max(0, Math.min(n, this.itemCount));
        NSPoint nSPoint = new NSPoint();
        nSPoint.x = this.scrollView.contentView().bounds().x;
        nSPoint.y = nSTableView.frameOfCellAtColumn((long)0L, (long)((long)n2)).y;
        this.view.scrollPoint(nSPoint);
    }

    public void showColumn(TableColumn tableColumn) {
        this.checkWidget();
        if (tableColumn == null) {
            this.error(4);
        }
        if (tableColumn.isDisposed()) {
            this.error(5);
        }
        if (tableColumn.parent != this) {
            return;
        }
        if (this.columnCount <= 1) {
            return;
        }
        int n = this.indexOf(tableColumn.nsColumn);
        if (n < 0 || n >= this.columnCount + ((this.style & 0x20) != 0 ? 1 : 0)) {
            return;
        }
        ((NSTableView)this.view).scrollColumnToVisible(n);
    }

    void showIndex(int n) {
        if (n >= 0 && n < this.itemCount) {
            ((NSTableView)this.view).scrollRowToVisible(n);
        }
    }

    public void showItem(TableItem tableItem) {
        int n;
        this.checkWidget();
        if (tableItem == null) {
            this.error(4);
        }
        if (tableItem.isDisposed()) {
            this.error(5);
        }
        if ((n = this.indexOf(tableItem)) != -1) {
            this.showIndex(n);
        }
    }

    public void showSelection() {
        this.checkWidget();
        int n = this.getSelectionIndex();
        if (n >= 0) {
            this.checkData(this._getItem(n));
            this.showIndex(n);
        }
    }

    void sendDoubleSelection() {
        NSTableView nSTableView = (NSTableView)this.view;
        int n = (int)nSTableView.clickedRow();
        if (n != -1) {
            Object object;
            if ((this.style & 0x20) != 0) {
                object = nSTableView.tableColumns();
                int n2 = (int)nSTableView.clickedColumn();
                id id2 = ((NSArray)object).objectAtIndex(n2);
                if (id2.id == this.checkColumn.id) {
                    return;
                }
            }
            object = new Event();
            ((Event)object).item = this._getItem(n);
            this.postEvent(14, (Event)object);
        }
    }

    boolean sendKeyEvent(NSEvent nSEvent, int n) {
        boolean bl = super.sendKeyEvent(nSEvent, n);
        if (!bl) {
            return bl;
        }
        if (n != 1) {
            return bl;
        }
        short s = nSEvent.keyCode();
        switch (s) {
            case 36: 
            case 76: {
                this.postEvent(14);
            }
        }
        return bl;
    }

    void sendMeasureItem(TableItem tableItem, int n, NSSize nSSize) {
        NSTableView nSTableView = (NSTableView)this.view;
        int n2 = (int)Math.ceil(nSSize.width);
        NSSize nSSize2 = nSTableView.intercellSpacing();
        int n3 = (int)Math.ceil(nSTableView.rowHeight() + nSSize2.height);
        GCData gCData = new GCData();
        gCData.paintRect = nSTableView.frame();
        GC gC = GC.cocoa_new(this, gCData);
        gC.setFont(tableItem.getFont(n));
        Event event = new Event();
        event.item = tableItem;
        event.gc = gC;
        event.index = n;
        event.width = n2;
        event.height = n3;
        this.sendEvent(41, event);
        gC.dispose();
        if (!this.isDisposed() && !tableItem.isDisposed()) {
            nSSize.width = event.width;
            nSSize.height = event.height;
            if (n3 < event.height) {
                nSTableView.setRowHeight(event.height);
            }
            if (n2 != event.width && this.columnCount == 0 && n == 0) {
                tableItem.width = event.width;
                if (this.setScrollWidth(tableItem)) {
                    nSTableView.setNeedsDisplay(true);
                }
            }
        }
    }

    void tableViewColumnDidMove(long l, long l2, long l3) {
        NSNotification nSNotification = new NSNotification(l3);
        NSDictionary nSDictionary = nSNotification.userInfo();
        id id2 = nSDictionary.valueForKey(NSString.stringWith("NSOldColumn"));
        id id3 = nSDictionary.valueForKey(NSString.stringWith("NSNewColumn"));
        int n = new NSNumber(id2).intValue();
        int n2 = new NSNumber(id3).intValue();
        int n3 = Math.min(n, n2);
        int n4 = Math.max(n, n2);
        NSTableView nSTableView = (NSTableView)this.view;
        NSArray nSArray = nSTableView.tableColumns();
        int n5 = n3;
        while (n5 <= n4) {
            id id4 = nSArray.objectAtIndex(n5);
            TableColumn tableColumn = this.getColumn(id4);
            if (tableColumn != null) {
                tableColumn.sendEvent(10);
                if (this.isDisposed()) {
                    return;
                }
            }
            ++n5;
        }
    }

    void tableViewColumnDidResize(long l, long l2, long l3) {
        NSNotification nSNotification = new NSNotification(l3);
        NSDictionary nSDictionary = nSNotification.userInfo();
        id id2 = nSDictionary.valueForKey(NSString.stringWith("NSTableColumn"));
        TableColumn tableColumn = this.getColumn(id2);
        if (tableColumn == null) {
            return;
        }
        tableColumn.sendEvent(11);
        if (this.isDisposed()) {
            return;
        }
        NSTableView nSTableView = (NSTableView)this.view;
        int n = this.indexOf(tableColumn.nsColumn);
        if (n == -1) {
            return;
        }
        NSArray nSArray = nSTableView.tableColumns();
        int n2 = (int)nSTableView.numberOfColumns();
        int n3 = n + 1;
        while (n3 < n2) {
            id2 = nSArray.objectAtIndex(n3);
            tableColumn = this.getColumn(id2);
            if (tableColumn != null) {
                tableColumn.sendEvent(10);
                if (this.isDisposed()) {
                    return;
                }
            }
            ++n3;
        }
    }

    void tableViewSelectionDidChange(long l, long l2, long l3) {
        if (this.ignoreSelect) {
            return;
        }
        NSTableView nSTableView = (NSTableView)this.view;
        int n = (int)nSTableView.selectedRow();
        if (n == -1) {
            this.postEvent(13);
        } else {
            TableItem tableItem = this._getItem(n);
            Event event = new Event();
            event.item = tableItem;
            event.index = n;
            this.postEvent(13, event);
        }
    }

    void tableView_didClickTableColumn(long l, long l2, long l3, long l4) {
        TableColumn tableColumn = this.getColumn(new id(l4));
        if (tableColumn == null) {
            return;
        }
        tableColumn.postEvent(13);
    }

    long tableView_objectValueForTableColumn_row(long l, long l2, long l3, long l4, long l5) {
        int n = (int)l5;
        TableItem tableItem = this._getItem(n);
        this.checkData(tableItem, n);
        if (this.checkColumn != null && l4 == this.checkColumn.id) {
            NSNumber nSNumber = tableItem.checked && tableItem.grayed ? NSNumber.numberWithInt(-1) : NSNumber.numberWithInt(tableItem.checked ? 1 : 0);
            return nSNumber.id;
        }
        int n2 = 0;
        while (n2 < this.columnCount) {
            if (this.columns[n2].nsColumn.id == l4) {
                return tableItem.createString((int)n2).id;
            }
            ++n2;
        }
        return tableItem.createString((int)0).id;
    }

    void tableView_setObjectValue_forTableColumn_row(long l, long l2, long l3, long l4, long l5, long l6) {
        if (this.checkColumn != null && l5 == this.checkColumn.id) {
            TableItem tableItem = this.items[(int)l6];
            tableItem.checked = !tableItem.checked;
            Event event = new Event();
            event.detail = 32;
            event.item = tableItem;
            event.index = (int)l6;
            this.postEvent(13, event);
            tableItem.redraw(-1);
        }
    }

    boolean tableView_shouldEditTableColumn_row(long l, long l2, long l3, long l4, long l5) {
        return false;
    }

    void tableView_willDisplayCell_forTableColumn_row(long l, long l2, long l3, long l4, long l5, long l6) {
        Font font;
        NSColor nSColor;
        if (this.checkColumn != null && l5 == this.checkColumn.id) {
            return;
        }
        TableItem tableItem = this.items[(int)l6];
        int n = 0;
        int n2 = 0;
        while (n2 < this.columnCount) {
            if (this.columns[n2].nsColumn.id == l5) {
                n = n2;
                break;
            }
            ++n2;
        }
        NSTextFieldCell nSTextFieldCell = new NSTextFieldCell(l4);
        OS.object_setInstanceVariable(l4, Display.SWT_ROW, l6);
        OS.object_setInstanceVariable(l4, Display.SWT_COLUMN, l5);
        Image image = n == 0 ? tableItem.image : (tableItem.images == null ? null : tableItem.images[n]);
        nSTextFieldCell.setImage(image != null ? image.handle : null);
        if (nSTextFieldCell.isEnabled()) {
            if (nSTextFieldCell.isHighlighted()) {
                nSColor = NSColor.selectedControlTextColor();
            } else {
                Color color;
                Color color2 = color = tableItem.cellForeground != null ? tableItem.cellForeground[n] : null;
                if (color == null) {
                    color = tableItem.foreground;
                }
                if (color == null) {
                    color = this.getForegroundColor();
                }
                nSColor = NSColor.colorWithDeviceRed(color.handle[0], color.handle[1], color.handle[2], 1.0);
            }
        } else {
            nSColor = NSColor.disabledControlTextColor();
        }
        int n3 = 0;
        if (this.columnCount > 0) {
            int n4 = this.columns[n].style;
            if ((n4 & 0x1000000) != 0) {
                n3 = 2;
            } else if ((n4 & 0x20000) != 0) {
                n3 = 1;
            }
        }
        Font font2 = font = tableItem.cellFont != null ? tableItem.cellFont[n] : null;
        if (font == null) {
            font = tableItem.font;
        }
        if (font == null) {
            font = this.font;
        }
        if (font == null) {
            font = this.defaultFont();
        }
        if (font.extraTraits != 0) {
            NSMutableDictionary nSMutableDictionary = ((NSMutableDictionary)new NSMutableDictionary().alloc()).initWithCapacity(5L);
            nSMutableDictionary.setObject(nSColor, OS.NSForegroundColorAttributeName);
            nSMutableDictionary.setObject(font.handle, OS.NSFontAttributeName);
            this.addTraits(nSMutableDictionary, font);
            NSMutableParagraphStyle nSMutableParagraphStyle = (NSMutableParagraphStyle)new NSMutableParagraphStyle().alloc().init();
            nSMutableParagraphStyle.setLineBreakMode(2L);
            nSMutableParagraphStyle.setAlignment(n3);
            nSMutableDictionary.setObject(nSMutableParagraphStyle, OS.NSParagraphStyleAttributeName);
            nSMutableParagraphStyle.release();
            NSAttributedString nSAttributedString = ((NSAttributedString)new NSAttributedString().alloc()).initWithString(nSTextFieldCell.title(), nSMutableDictionary);
            nSTextFieldCell.setAttributedStringValue(nSAttributedString);
            nSAttributedString.release();
            nSMutableDictionary.release();
        } else {
            nSTextFieldCell.setFont(font.handle);
            nSTextFieldCell.setTextColor(nSColor);
            nSTextFieldCell.setAlignment(n3);
        }
    }

    boolean tableView_writeRowsWithIndexes_toPasteboard(long l, long l2, long l3, long l4, long l5) {
        return this.sendMouseEvent(NSApplication.sharedApplication().currentEvent(), 29, true);
    }

    NSRect titleRectForBounds(long l, long l2, NSRect nSRect) {
        NSImage nSImage = new NSCell(l).image();
        if (nSImage != null) {
            int n = this.imageBounds.width + 3;
            nSRect.x += (double)n;
            nSRect.width -= (double)n;
        }
        return nSRect;
    }

    void updateCursorRects(boolean bl) {
        super.updateCursorRects(bl);
        if (this.headerView == null) {
            return;
        }
        this.updateCursorRects(bl, this.headerView);
    }
}

