/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.structureView;

import com.intellij.icons.AllIcons;
import com.intellij.ide.structureView.StructureViewBundle;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.structureView.TextEditorBasedStructureViewModel;
import com.intellij.ide.util.treeView.smartTree.ActionPresentation;
import com.intellij.ide.util.treeView.smartTree.ActionPresentationData;
import com.intellij.ide.util.treeView.smartTree.Grouper;
import com.intellij.ide.util.treeView.smartTree.Sorter;
import com.intellij.lang.properties.editor.PropertiesGroupingStructureViewModel;
import com.intellij.lang.properties.psi.Property;
import com.intellij.lang.properties.psi.impl.PropertiesFileImpl;
import com.intellij.lang.properties.structureView.GroupByWordPrefixes;
import com.intellij.lang.properties.structureView.PropertiesFileStructureViewElement;
import com.intellij.lang.properties.structureView.PropertiesPrefixGroup;
import com.intellij.lang.properties.structureView.PropertiesSeparatorManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiFile;
import java.util.Comparator;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class PropertiesFileStructureViewModel
extends TextEditorBasedStructureViewModel
implements PropertiesGroupingStructureViewModel {
    private final GroupByWordPrefixes myByWordPrefixesGrouper;
    private volatile boolean myGroupingState = true;
    @NonNls
    public static final String KIND_SORTER_ID = "KIND_SORTER";
    private static final Sorter KIND_SORTER = new Sorter(){

        @NotNull
        public Comparator getComparator() {
            return (o1, o2) -> {
                int weight1 = o1 instanceof PropertiesPrefixGroup ? 1 : 0;
                int weight2 = o2 instanceof PropertiesPrefixGroup ? 1 : 0;
                return weight1 - weight2;
            };
        }

        public boolean isVisible() {
            return true;
        }

        @NotNull
        public ActionPresentation getPresentation() {
            String name = StructureViewBundle.message((String)"action.sort.by.type", (Object[])new Object[0]);
            return new ActionPresentationData(name, name, AllIcons.ObjectBrowser.SortByType);
        }

        @NotNull
        public String getName() {
            return PropertiesFileStructureViewModel.KIND_SORTER_ID;
        }
    };

    public PropertiesFileStructureViewModel(PropertiesFileImpl file, Editor editor) {
        super(editor, (PsiFile)file);
        String separator = PropertiesSeparatorManager.getInstance(file.getProject()).getSeparator(file.getResourceBundle());
        this.myByWordPrefixesGrouper = new GroupByWordPrefixes(separator);
    }

    @Override
    public void setSeparator(String separator) {
        this.myByWordPrefixesGrouper.setSeparator(separator);
        PropertiesSeparatorManager separatorManager = PropertiesSeparatorManager.getInstance(this.getPsiFile().getProject());
        separatorManager.setSeparator(((PropertiesFileImpl)this.getPsiFile()).getResourceBundle(), separator);
    }

    @Override
    public String getSeparator() {
        return this.myByWordPrefixesGrouper.getSeparator();
    }

    @Override
    public void setGroupingActive(boolean state) {
        this.myGroupingState = state;
    }

    @NotNull
    public StructureViewTreeElement getRoot() {
        return new PropertiesFileStructureViewElement((PropertiesFileImpl)this.getPsiFile(), () -> this.myGroupingState);
    }

    public Grouper @NotNull [] getGroupers() {
        return new Grouper[]{this.myByWordPrefixesGrouper};
    }

    public Sorter @NotNull [] getSorters() {
        return new Sorter[]{Sorter.ALPHA_SORTER, KIND_SORTER};
    }

    protected Class @NotNull [] getSuitableClasses() {
        return new Class[]{Property.class};
    }

    public boolean isAlwaysShowsPlus(StructureViewTreeElement element) {
        return false;
    }

    public boolean isAlwaysLeaf(StructureViewTreeElement element) {
        return false;
    }
}

