/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.references;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionInitializationContext;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.LookupElementRenderer;
import com.intellij.icons.AllIcons;
import com.intellij.lang.properties.EmptyResourceBundle;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.PropertiesHighlighter;
import com.intellij.lang.properties.ResourceBundle;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.references.PropertiesPsiCompletionUtil;
import com.intellij.lang.properties.references.PropertyReference;
import com.intellij.lang.properties.references.PropertyReferenceBase;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.util.ArrayUtil;
import com.intellij.util.PlatformIcons;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PropertiesCompletionContributor
extends CompletionContributor {
    public static final LookupElementRenderer<LookupElement> LOOKUP_ELEMENT_RENDERER = new LookupElementRenderer<LookupElement>(){

        public void renderElement(LookupElement element, LookupElementPresentation presentation) {
            IProperty defaultProperty;
            PropertiesFile defaultPropertiesFile;
            boolean hasBundle;
            IProperty property = (IProperty)element.getObject();
            presentation.setIcon(PlatformIcons.PROPERTY_ICON);
            String key = StringUtil.notNullize((String)property.getUnescapedKey());
            presentation.setItemText(key);
            PropertiesFile propertiesFile = property.getPropertiesFile();
            ResourceBundle resourceBundle = propertiesFile.getResourceBundle();
            String value = property.getValue();
            boolean bl = hasBundle = resourceBundle != EmptyResourceBundle.getInstance();
            if (hasBundle && (defaultPropertiesFile = resourceBundle.getDefaultPropertiesFile()).getContainingFile() != propertiesFile.getContainingFile() && (defaultProperty = defaultPropertiesFile.findPropertyByKey(key)) != null) {
                value = defaultProperty.getValue();
            }
            if (hasBundle) {
                presentation.setTypeText(resourceBundle.getBaseName(), AllIcons.FileTypes.Properties);
            }
            TextAttributes attrs = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(PropertiesHighlighter.PropertiesComponent.PROPERTY_VALUE.getTextAttributesKey());
            presentation.setTailText("=" + value, attrs.getForegroundColor());
        }
    };

    public PropertiesCompletionContributor() {
        this.extend(null, (ElementPattern)PlatformPatterns.psiElement(), (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
                PropertiesCompletionContributor.doAdd(parameters, result);
            }
        });
    }

    private static void doAdd(CompletionParameters parameters, CompletionResultSet result) {
        TextRange range;
        PsiElement element;
        int startOffset;
        int offsetInElement;
        PsiElement position = parameters.getPosition();
        PsiElement parent = position.getParent();
        Object[] references = parent == null ? position.getReferences() : (PsiReference[])ArrayUtil.mergeArrays((Object[])position.getReferences(), (Object[])parent.getReferences());
        PropertyReference propertyReference = (PropertyReference)ContainerUtil.findInstance((Object[])references, PropertyReference.class);
        if (propertyReference != null && !PropertiesCompletionContributor.hasMoreImportantReference((PsiReference[])references, propertyReference) && (offsetInElement = (startOffset = parameters.getOffset()) - (element = propertyReference.getElement()).getTextRange().getStartOffset()) >= (range = propertyReference.getRangeInElement()).getStartOffset()) {
            String prefix = element.getText().substring(range.getStartOffset(), offsetInElement);
            LookupElement[] variants = PropertiesCompletionContributor.getVariants(propertyReference);
            result.withPrefixMatcher(prefix).addAllElements(Arrays.asList(variants));
        }
    }

    public static boolean hasMoreImportantReference(PsiReference @NotNull [] references, @NotNull PropertyReference propertyReference) {
        return propertyReference.isSoft() && ContainerUtil.or((Object[])references, reference -> !reference.isSoft());
    }

    public static LookupElement @NotNull [] getVariants(PropertyReferenceBase propertyReference) {
        Set<Object> variants = PropertiesPsiCompletionUtil.getPropertiesKeys(propertyReference);
        return PropertiesCompletionContributor.getVariants(variants);
    }

    public static LookupElement[] getVariants(Set<Object> variants) {
        return (LookupElement[])variants.stream().map(o -> o instanceof String ? LookupElementBuilder.create((String)((String)o)).withIcon(PlatformIcons.PROPERTY_ICON) : PropertiesCompletionContributor.createVariant((IProperty)o)).filter(Objects::nonNull).toArray(LookupElement[]::new);
    }

    @Nullable
    public static LookupElement createVariant(IProperty property) {
        String key = property.getKey();
        return key == null ? null : LookupElementBuilder.create((Object)property, (String)key).withRenderer(LOOKUP_ELEMENT_RENDERER);
    }

    public void beforeCompletion(@NotNull CompletionInitializationContext context) {
        if (context.getFile() instanceof PropertiesFile) {
            context.setDummyIdentifier(CompletionUtil.DUMMY_IDENTIFIER_TRIMMED);
        }
    }
}

