/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.refactoring.rename;

import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.PropertiesBundle;
import com.intellij.lang.properties.PropertiesImplUtil;
import com.intellij.lang.properties.PropertiesUtil;
import com.intellij.lang.properties.ResourceBundle;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.refactoring.PropertiesRefactoringSettings;
import com.intellij.lang.properties.xml.XmlProperty;
import com.intellij.pom.PomTargetPsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.rename.RenamePsiElementProcessor;
import com.intellij.refactoring.rename.UnresolvableCollisionUsageInfo;
import com.intellij.usageView.UsageInfo;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class RenamePropertyProcessor
extends RenamePsiElementProcessor {
    public boolean canProcessElement(@NotNull PsiElement element) {
        return element instanceof IProperty || element instanceof PomTargetPsiElement && ((PomTargetPsiElement)element).getTarget() instanceof XmlProperty;
    }

    public void prepareRenaming(@NotNull PsiElement element, @NotNull String newName, @NotNull Map<PsiElement, String> allRenames) {
        ResourceBundle resourceBundle = Objects.requireNonNull(PropertiesImplUtil.getProperty(element)).getPropertiesFile().getResourceBundle();
        LinkedHashMap<PsiElement, String> allRenamesCopy = new LinkedHashMap<PsiElement, String>(allRenames);
        allRenames.clear();
        allRenamesCopy.forEach((key, value) -> {
            IProperty property = PropertiesImplUtil.getProperty(key);
            if (property != null) {
                List<IProperty> properties = PropertiesUtil.findAllProperties(resourceBundle, property.getUnescapedKey());
                for (IProperty toRename : properties) {
                    allRenames.put(toRename.getPsiElement(), (String)value);
                }
            }
        });
    }

    public void findCollisions(@NotNull PsiElement element, @NotNull String newName, @NotNull Map<? extends PsiElement, String> allRenames, @NotNull List<UsageInfo> result) {
        allRenames.forEach((key, value) -> {
            PropertiesFile propertiesFile = PropertiesImplUtil.getPropertiesFile(key.getContainingFile());
            if (propertiesFile == null) {
                return;
            }
            IProperty property = propertiesFile.findPropertyByKey((String)value);
            if (property == null) {
                return;
            }
            result.add((UsageInfo)new UnresolvableCollisionUsageInfo(property.getPsiElement(), (PsiElement)key, (String)value){
                final /* synthetic */ String val$value;
                {
                    this.val$value = string;
                    super(arg0, arg1);
                }

                public String getDescription() {
                    return PropertiesBundle.message("rename.hides.existing.property.conflict", this.val$value);
                }
            });
        });
    }

    public boolean isToSearchInComments(@NotNull PsiElement element) {
        return PropertiesRefactoringSettings.getInstance().RENAME_SEARCH_IN_COMMENTS;
    }

    public void setToSearchInComments(@NotNull PsiElement element, boolean enabled) {
        PropertiesRefactoringSettings.getInstance().RENAME_SEARCH_IN_COMMENTS = enabled;
    }
}

