/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.refactoring;

import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.RefactoringSettings;
import com.intellij.refactoring.safeDelete.NonCodeUsageSearchInfo;
import com.intellij.refactoring.safeDelete.SafeDeleteProcessor;
import com.intellij.refactoring.safeDelete.SafeDeleteProcessorDelegateBase;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PropertyKeysSafeDeleteProcessor
extends SafeDeleteProcessorDelegateBase {
    @Nullable
    public Collection<? extends PsiElement> getElementsToSearch(@NotNull PsiElement element, @Nullable Module module, @NotNull Collection<PsiElement> allElementsToDelete) {
        return Collections.singleton(element);
    }

    public boolean handlesElement(PsiElement element) {
        return element instanceof IProperty;
    }

    @Nullable
    public NonCodeUsageSearchInfo findUsages(@NotNull PsiElement element, PsiElement @NotNull [] allElementsToDelete, @NotNull List<UsageInfo> result) {
        SafeDeleteProcessor.findGenericElementUsages((PsiElement)element, result, (PsiElement[])allElementsToDelete);
        return new NonCodeUsageSearchInfo(SafeDeleteProcessor.getDefaultInsideDeletedCondition((PsiElement[])allElementsToDelete), element);
    }

    @Nullable
    public Collection<PsiElement> getAdditionalElementsToDelete(@NotNull PsiElement element, @NotNull Collection<PsiElement> allElementsToDelete, boolean askUser) {
        IProperty property = (IProperty)element;
        String key = property.getKey();
        if (key == null) {
            return null;
        }
        PropertiesFile file = property.getPropertiesFile();
        if (file == null) {
            return null;
        }
        ArrayList<PsiElement> result = new ArrayList<PsiElement>();
        for (PropertiesFile propertiesFile : file.getResourceBundle().getPropertiesFiles()) {
            for (IProperty p : propertiesFile.findPropertiesByKey(key)) {
                PsiElement propertyElement = p.getPsiElement();
                if (allElementsToDelete.contains(propertyElement)) continue;
                result.add(propertyElement);
            }
        }
        return result;
    }

    @Nullable
    public Collection<String> findConflicts(@NotNull PsiElement element, PsiElement @NotNull [] allElementsToDelete) {
        return null;
    }

    public UsageInfo @Nullable [] preprocessUsages(Project project, UsageInfo[] usages) {
        return usages;
    }

    public void prepareForDeletion(PsiElement element) throws IncorrectOperationException {
    }

    public boolean isToSearchInComments(PsiElement element) {
        return RefactoringSettings.getInstance().SAFE_DELETE_SEARCH_IN_COMMENTS;
    }

    public void setToSearchInComments(PsiElement element, boolean enabled) {
        RefactoringSettings.getInstance().SAFE_DELETE_SEARCH_IN_COMMENTS = enabled;
    }

    public boolean isToSearchForTextOccurrences(PsiElement element) {
        return RefactoringSettings.getInstance().SAFE_DELETE_SEARCH_IN_NON_JAVA;
    }

    public void setToSearchForTextOccurrences(PsiElement element, boolean enabled) {
        RefactoringSettings.getInstance().SAFE_DELETE_SEARCH_IN_NON_JAVA = enabled;
    }
}

