/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.projectView;

import com.intellij.ide.projectView.TreeStructureProvider;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.PsiFileNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.lang.properties.CustomResourceBundle;
import com.intellij.lang.properties.PropertiesImplUtil;
import com.intellij.lang.properties.ResourceBundle;
import com.intellij.lang.properties.ResourceBundleImpl;
import com.intellij.lang.properties.ResourceBundleManager;
import com.intellij.lang.properties.projectView.CustomResourceBundlePropertiesFileNode;
import com.intellij.lang.properties.projectView.ResourceBundleDeleteProvider;
import com.intellij.lang.properties.projectView.ResourceBundleNode;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.psi.PsiFile;
import com.intellij.util.Consumer;
import com.intellij.util.SmartList;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class ResourceBundleGrouper
implements TreeStructureProvider,
DumbAware {
    private final Project myProject;

    public ResourceBundleGrouper(Project project) {
        this.myProject = project;
    }

    @NotNull
    public Collection<AbstractTreeNode<?>> modify(@NotNull AbstractTreeNode<?> parent, @NotNull Collection<AbstractTreeNode<?>> children, ViewSettings settings) {
        if (parent instanceof ResourceBundleNode) {
            return children;
        }
        return (Collection)ReadAction.compute(() -> {
            ArrayList<AbstractTreeNode> result = new ArrayList<AbstractTreeNode>();
            SmartList dirPropertiesFiles = new SmartList();
            for (AbstractTreeNode child : children) {
                PropertiesFile propertiesFile;
                Object f = child.getValue();
                if (f instanceof PsiFile && child.getClass() == PsiFileNode.class && (propertiesFile = PropertiesImplUtil.getPropertiesFile((PsiFile)f)) != null) {
                    dirPropertiesFiles.add(propertiesFile);
                    continue;
                }
                result.add(child);
            }
            if (dirPropertiesFiles.isEmpty()) {
                return result;
            }
            ResourceBundleGrouper.appendPropertiesFilesNodes((List<? extends PropertiesFile>)dirPropertiesFiles, this.myProject, result::add, settings);
            return result;
        });
    }

    private static void appendPropertiesFilesNodes(@NotNull List<? extends PropertiesFile> files, @NotNull Project project, @NotNull Consumer<? super AbstractTreeNode<?>> nodeConsumer, ViewSettings settings) {
        Collection bundleFiles;
        ResourceBundleManager manager = ResourceBundleManager.getInstance(project);
        MultiMap resourceBundles = new MultiMap();
        MultiMap customResourceBundles = new MultiMap();
        for (PropertiesFile propertiesFile : files) {
            CustomResourceBundle customResourceBundle = manager.getCustomResourceBundle(propertiesFile);
            if (customResourceBundle != null) {
                customResourceBundles.putValue((Object)customResourceBundle, (Object)propertiesFile);
                continue;
            }
            String extension = propertiesFile.getVirtualFile().getExtension();
            String baseName = manager.getBaseName(propertiesFile.getContainingFile());
            resourceBundles.putValue((Object)Couple.of((Object)baseName, (Object)extension), (Object)propertiesFile);
        }
        for (Map.Entry entry : resourceBundles.entrySet()) {
            bundleFiles = (Collection)entry.getValue();
            PropertiesFile defaultFile = (PropertiesFile)bundleFiles.iterator().next();
            nodeConsumer.consume(bundleFiles.size() == 1 ? new PsiFileNode(project, defaultFile.getContainingFile(), settings) : new ResourceBundleNode(project, new ResourceBundleImpl(defaultFile), settings));
        }
        for (Map.Entry entry : customResourceBundles.entrySet()) {
            bundleFiles = (Collection)entry.getValue();
            if (bundleFiles.size() == 1) {
                PropertiesFile representative = (PropertiesFile)bundleFiles.iterator().next();
                nodeConsumer.consume((Object)new CustomResourceBundlePropertiesFileNode(project, representative.getContainingFile(), settings));
                continue;
            }
            nodeConsumer.consume((Object)new ResourceBundleNode(project, (ResourceBundle)entry.getKey(), settings));
        }
    }

    public Object getData(@NotNull Collection<AbstractTreeNode<?>> selected, @NotNull String dataId) {
        if (PlatformCoreDataKeys.SLOW_DATA_PROVIDERS.is(dataId)) {
            return Collections.singletonList(realDataId -> ResourceBundleGrouper.getSlowData(selected, realDataId));
        }
        return null;
    }

    private static Object getSlowData(@NotNull Collection<AbstractTreeNode<?>> selected, @NotNull String dataId) {
        if (PlatformDataKeys.DELETE_ELEMENT_PROVIDER.is(dataId)) {
            for (AbstractTreeNode<?> selectedElement : selected) {
                Object element = selectedElement.getValue();
                if (!(element instanceof ResourceBundle)) continue;
                return new ResourceBundleDeleteProvider();
            }
        } else if (ResourceBundle.ARRAY_DATA_KEY.is(dataId)) {
            ArrayList<ResourceBundle> selectedElements = new ArrayList<ResourceBundle>();
            for (AbstractTreeNode<?> node : selected) {
                Object value = node.getValue();
                if (!(value instanceof ResourceBundle)) continue;
                selectedElements.add((ResourceBundle)value);
            }
            return selectedElements.isEmpty() ? null : selectedElements.toArray(new ResourceBundle[0]);
        }
        return null;
    }
}

