/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.customizeActions;

import com.intellij.icons.AllIcons;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.ide.projectView.impl.AbstractProjectViewPane;
import com.intellij.lang.properties.PropertiesBundle;
import com.intellij.lang.properties.PropertiesImplUtil;
import com.intellij.lang.properties.ResourceBundle;
import com.intellij.lang.properties.ResourceBundleManager;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public class DissociateResourceBundleAction
extends AnAction {
    public DissociateResourceBundleAction() {
        super(Presentation.NULL_STRING, Presentation.NULL_STRING, AllIcons.FileTypes.Properties);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Collection<ResourceBundle> resourceBundles = DissociateResourceBundleAction.extractResourceBundles(e);
        assert (resourceBundles.size() > 0);
        DissociateResourceBundleAction.dissociate(resourceBundles, project);
    }

    public void update(@NotNull AnActionEvent e) {
        Collection<ResourceBundle> resourceBundles = DissociateResourceBundleAction.extractResourceBundles(e);
        if (!resourceBundles.isEmpty()) {
            String actionText = resourceBundles.size() == 1 ? PropertiesBundle.message("action.DissociateResourceBundleSingle.text", ((ResourceBundle)ContainerUtil.getFirstItem(resourceBundles)).getBaseName()) : PropertiesBundle.message("action.DissociateResourceBundleMultiple.text", resourceBundles.size());
            e.getPresentation().setText(actionText, false);
            e.getPresentation().setVisible(true);
        } else {
            e.getPresentation().setVisible(false);
        }
    }

    public static void dissociate(Collection<? extends ResourceBundle> resourceBundles, Project project) {
        HashSet<PsiDirectory> toUpdateInProjectView = new HashSet<PsiDirectory>();
        for (ResourceBundle resourceBundle : resourceBundles) {
            for (PropertiesFile propertiesFile : resourceBundle.getPropertiesFiles()) {
                PsiDirectory containingDirectory = propertiesFile.getContainingFile().getContainingDirectory();
                if (containingDirectory == null) continue;
                toUpdateInProjectView.add(containingDirectory);
            }
            ResourceBundleManager.getInstance(project).dissociateResourceBundle(resourceBundle);
        }
        AbstractProjectViewPane currentProjectViewPane = ProjectView.getInstance((Project)project).getCurrentProjectViewPane();
        if (currentProjectViewPane != null) {
            for (PsiFileSystemItem psiFileSystemItem : toUpdateInProjectView) {
                currentProjectViewPane.updateFrom((Object)psiFileSystemItem, false, true);
            }
        }
    }

    @NotNull
    private static Collection<ResourceBundle> extractResourceBundles(AnActionEvent event) {
        PsiElement[] psiElements;
        HashSet<ResourceBundle> targetResourceBundles = new HashSet<ResourceBundle>();
        ResourceBundle[] chosenResourceBundles = (ResourceBundle[])event.getData(ResourceBundle.ARRAY_DATA_KEY);
        if (chosenResourceBundles != null) {
            for (ResourceBundle resourceBundle : chosenResourceBundles) {
                if (resourceBundle.getPropertiesFiles().size() <= 1) continue;
                targetResourceBundles.add(resourceBundle);
            }
        }
        if ((psiElements = (PsiElement[])event.getData(LangDataKeys.PSI_ELEMENT_ARRAY)) != null) {
            for (PsiElement element : psiElements) {
                ResourceBundle bundle;
                PropertiesFile propertiesFile = PropertiesImplUtil.getPropertiesFile(element);
                if (propertiesFile == null || (bundle = propertiesFile.getResourceBundle()).getPropertiesFiles().size() <= 1) continue;
                targetResourceBundles.add(bundle);
            }
        }
        return targetResourceBundles;
    }
}

