/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.create;

import com.intellij.icons.AllIcons;
import com.intellij.lang.properties.PropertiesBundle;
import com.intellij.lang.properties.ResourceBundle;
import com.intellij.lang.properties.create.CreateResourceBundleDialogComponent;
import com.intellij.lang.properties.projectView.ResourceBundleAwareNode;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.pom.Navigatable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddNewPropertyFileAction
extends AnAction {
    protected AddNewPropertyFileAction() {
        super(PropertiesBundle.messagePointer("add.property.files.to.resource.bundle.dialog.action.title", new Object[0]), AllIcons.FileTypes.Properties);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        ResourceBundle resourceBundle = AddNewPropertyFileAction.getResourceBundle(e);
        e.getPresentation().setEnabledAndVisible(resourceBundle != null && CreateResourceBundleDialogComponent.getResourceBundlePlacementDirectory(resourceBundle) != null);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        ResourceBundle resourceBundle = AddNewPropertyFileAction.getResourceBundle(e);
        if (resourceBundle == null) {
            return;
        }
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        new CreateResourceBundleDialogComponent.Dialog(project, null, resourceBundle).show();
    }

    @Nullable
    private static ResourceBundle getResourceBundle(@NotNull AnActionEvent e) {
        Navigatable[] data = (Navigatable[])e.getData(CommonDataKeys.NAVIGATABLE_ARRAY);
        if (data == null || data.length != 1) {
            return null;
        }
        if (!(data[0] instanceof ResourceBundleAwareNode)) {
            return null;
        }
        return ((ResourceBundleAwareNode)data[0]).getResourceBundle();
    }
}

