/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.codeInspection.unused;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ex.InspectionProfileWrapper;
import com.intellij.codeInspection.ui.InspectionOptionsPanel;
import com.intellij.lang.ASTNode;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.PropertiesBundle;
import com.intellij.lang.properties.PropertiesFileType;
import com.intellij.lang.properties.PropertiesImplUtil;
import com.intellij.lang.properties.PropertiesInspectionBase;
import com.intellij.lang.properties.PropertiesQuickFixFactory;
import com.intellij.lang.properties.codeInspection.unused.ImplicitPropertyUsageProvider;
import com.intellij.lang.properties.psi.Property;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentValidator;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBTextField;
import java.awt.Component;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.JComponent;
import javax.swing.text.JTextComponent;
import org.intellij.lang.annotations.RegExp;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class UnusedPropertyInspection
extends PropertiesInspectionBase {
    private static final ExtensionPointName<ImplicitPropertyUsageProvider> EP_NAME = new ExtensionPointName("com.intellij.properties.implicitPropertyUsageProvider");
    public static final String SHORT_NAME = "UnusedProperty";
    @NotNull
    @RegExp
    public String fileNameMask = ".*";

    @NotNull
    public String getShortName() {
        return SHORT_NAME;
    }

    @NotNull
    public JComponent createOptionsPanel() {
        final Disposable disposable = Disposer.newDisposable();
        InspectionOptionsPanel panel = new InspectionOptionsPanel(){

            public void removeNotify() {
                super.removeNotify();
                Disposer.dispose((Disposable)disposable);
            }
        };
        panel.add((Component)new JBLabel(PropertiesBundle.message("label.analyze.only.property.files.whose.name.matches", new Object[0])));
        JBTextField textField = new JBTextField(this.fileNameMask);
        panel.add((Component)textField, (Object)"growx");
        ComponentValidator validator = new ComponentValidator(disposable).withValidator(() -> {
            String text = textField.getText();
            this.fileNameMask = text.isEmpty() ? ".*" : text;
            String errorMessage = null;
            try {
                Pattern.compile(text);
            }
            catch (PatternSyntaxException ex) {
                errorMessage = StringUtil.substringBefore((String)ex.getMessage(), (String)"\n");
            }
            boolean hasError = StringUtil.isNotEmpty(errorMessage);
            return hasError ? new ValidationInfo(errorMessage, (JComponent)textField) : null;
        }).andRegisterOnDocumentListener((JTextComponent)textField).installOn((JComponent)textField);
        validator.revalidate();
        return panel;
    }

    @Nullable
    private static GlobalSearchScope getWidestUseScope(@Nullable String key, @NotNull Project project, @NotNull Module ownModule) {
        if (key == null) {
            return null;
        }
        LinkedHashSet<Module> modules = new LinkedHashSet<Module>();
        for (IProperty property : PropertiesImplUtil.findPropertiesByKey(project, key)) {
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)property.getPsiElement());
            if (module == null) {
                return GlobalSearchScope.allScope((Project)project);
            }
            if (module == ownModule) continue;
            modules.add(module);
        }
        if (modules.isEmpty()) {
            return null;
        }
        return GlobalSearchScope.union((GlobalSearchScope[])((GlobalSearchScope[])modules.stream().map(Module::getModuleWithDependentsScope).toArray(GlobalSearchScope[]::new)));
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        Module module;
        PsiFile file = session.getFile();
        if (!this.fileNameMask.isEmpty()) {
            try {
                Pattern p = Pattern.compile(this.fileNameMask);
                if (!p.matcher(file.getName()).matches()) {
                    return PsiElementVisitor.EMPTY_VISITOR;
                }
            }
            catch (PatternSyntaxException p) {
                // empty catch block
            }
        }
        if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file)) == null) {
            return PsiElementVisitor.EMPTY_VISITOR;
        }
        if (InjectedLanguageManager.getInstance((Project)module.getProject()).isInjectedFragment(holder.getFile())) {
            return PsiElementVisitor.EMPTY_VISITOR;
        }
        final UnusedPropertiesSearchHelper helper = new UnusedPropertiesSearchHelper(module);
        final Set<PsiElement> propertiesBeingCommitted = UnusedPropertyInspection.getBeingCommittedProperties(file);
        return new PsiElementVisitor(){

            public void visitElement(@NotNull PsiElement element) {
                if (!(element instanceof Property)) {
                    return;
                }
                Property property = (Property)element;
                if (propertiesBeingCommitted != null && !propertiesBeingCommitted.contains(property)) {
                    return;
                }
                if (UnusedPropertyInspection.isPropertyUsed(property, helper, isOnTheFly)) {
                    return;
                }
                ASTNode propertyNode = property.getNode();
                assert (propertyNode != null);
                ASTNode[] nodes = propertyNode.getChildren(null);
                Property key = nodes.length == 0 ? property : nodes[0].getPsi();
                LocalQuickFix fix = PropertiesQuickFixFactory.getInstance().createRemovePropertyLocalFix();
                holder.registerProblem((PsiElement)key, isOnTheFly ? PropertiesBundle.message("unused.property.problem.descriptor.name", new Object[0]) : PropertiesBundle.message("unused.property.problem.descriptor.name.offline", property.getUnescapedKey()), new LocalQuickFix[]{fix});
            }
        };
    }

    @Nullable
    private static Set<PsiElement> getBeingCommittedProperties(@NotNull PsiFile file) {
        Map data = (Map)file.getUserData(InspectionProfileWrapper.PSI_ELEMENTS_BEING_COMMITTED);
        if (data == null) {
            return null;
        }
        return (Set)data.get(Property.class);
    }

    private static boolean isImplicitlyUsed(@NotNull Property property) {
        for (ImplicitPropertyUsageProvider provider : EP_NAME.getIterable()) {
            if (!provider.isUsed(property)) continue;
            return true;
        }
        return false;
    }

    public static boolean isPropertyUsed(@NotNull Property property, @NotNull UnusedPropertiesSearchHelper helper, boolean isOnTheFly) {
        GlobalSearchScope widerScope;
        ProgressIndicator original = ProgressManager.getInstance().getProgressIndicator();
        if (original != null) {
            if (original.isCanceled()) {
                return true;
            }
            original.setText(PropertiesBundle.message("searching.for.property.key.progress.text", property.getUnescapedKey()));
        }
        if (UnusedPropertyInspection.isImplicitlyUsed(property)) {
            return true;
        }
        String name = property.getName();
        if (name == null) {
            return true;
        }
        PsiSearchHelper searchHelper = helper.getSearchHelper();
        if (UnusedPropertyInspection.mayHaveUsages((PsiElement)property, name, searchHelper, helper.getOwnUseScope(), isOnTheFly, original)) {
            return true;
        }
        GlobalSearchScope globalSearchScope = widerScope = isOnTheFly ? UnusedPropertyInspection.getWidestUseScope(property.getKey(), property.getProject(), helper.getModule()) : GlobalSearchScope.projectScope((Project)property.getProject());
        return widerScope != null && UnusedPropertyInspection.mayHaveUsages((PsiElement)property, name, searchHelper, widerScope, isOnTheFly, original);
    }

    private static boolean mayHaveUsages(@NotNull PsiElement property, @NotNull String name, @NotNull PsiSearchHelper psiSearchHelper, @NotNull GlobalSearchScope searchScope, boolean onTheFly, @Nullable ProgressIndicator indicator) {
        GlobalSearchScope exceptPropertyFiles = UnusedPropertyInspection.createExceptPropertyFilesScope(searchScope);
        GlobalSearchScope newScope = searchScope.intersectWith(exceptPropertyFiles);
        if (onTheFly) {
            PsiSearchHelper.SearchCostResult cheapEnough = psiSearchHelper.isCheapEnoughToSearch(name, newScope, null, indicator);
            if (cheapEnough == PsiSearchHelper.SearchCostResult.ZERO_OCCURRENCES) {
                return false;
            }
            if (cheapEnough == PsiSearchHelper.SearchCostResult.TOO_MANY_OCCURRENCES) {
                return true;
            }
        }
        return ReferencesSearch.search((PsiElement)property, (SearchScope)newScope, (boolean)false).findFirst() != null;
    }

    @NotNull
    private static GlobalSearchScope createExceptPropertyFilesScope(@NotNull GlobalSearchScope origin) {
        return new DelegatingGlobalSearchScope(origin){

            public boolean contains(@NotNull VirtualFile file) {
                return super.contains(file) && !FileTypeRegistry.getInstance().isFileOfType(file, (FileType)PropertiesFileType.INSTANCE);
            }
        };
    }

    public static class UnusedPropertiesSearchHelper {
        private final GlobalSearchScope myOwnUseScope;
        private final Module myModule;
        private final PsiSearchHelper mySearchHelper;

        public UnusedPropertiesSearchHelper(Module module) {
            this.myOwnUseScope = GlobalSearchScope.moduleWithDependentsScope((Module)module);
            this.myModule = module;
            this.mySearchHelper = PsiSearchHelper.getInstance((Project)module.getProject());
        }

        public Module getModule() {
            return this.myModule;
        }

        GlobalSearchScope getOwnUseScope() {
            return this.myOwnUseScope;
        }

        PsiSearchHelper getSearchHelper() {
            return this.mySearchHelper;
        }
    }
}

