/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties;

import com.intellij.icons.AllIcons;
import com.intellij.lang.Language;
import com.intellij.lang.properties.PropertiesBundle;
import com.intellij.lang.properties.PropertiesLanguage;
import com.intellij.lang.properties.charset.Native2AsciiCharset;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingRegistry;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public final class PropertiesFileType
extends LanguageFileType {
    public static final LanguageFileType INSTANCE = new PropertiesFileType();
    public static final String DEFAULT_EXTENSION = "properties";
    public static final String DOT_DEFAULT_EXTENSION = ".properties";
    public static final Charset PROPERTIES_DEFAULT_CHARSET = StandardCharsets.ISO_8859_1;

    private PropertiesFileType() {
        super((Language)PropertiesLanguage.INSTANCE);
    }

    @NotNull
    public String getName() {
        return "Properties";
    }

    @NotNull
    public String getDescription() {
        return PropertiesBundle.message("filetype.properties.description", new Object[0]);
    }

    @NotNull
    public String getDefaultExtension() {
        return DEFAULT_EXTENSION;
    }

    public Icon getIcon() {
        return AllIcons.FileTypes.Properties;
    }

    public String getCharset(@NotNull VirtualFile file, byte @NotNull [] content) {
        Charset charset = EncodingRegistry.getInstance().getDefaultCharsetForPropertiesFiles(file);
        if (charset == null) {
            charset = PROPERTIES_DEFAULT_CHARSET;
        }
        if (EncodingRegistry.getInstance().isNative2Ascii(file)) {
            charset = Native2AsciiCharset.wrap((Charset)charset);
        }
        return charset.name();
    }
}

