/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.unwrap;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.unwrap.GroovyUnwrapper;

public class GroovyMethodParameterUnwrapper
extends GroovyUnwrapper {
    public GroovyMethodParameterUnwrapper() {
        super("");
    }

    @NotNull
    public String getDescription(@NotNull PsiElement e) {
        Object text = e.getText();
        if (((String)text).length() > 20) {
            text = ((String)text).substring(0, 17) + "...";
        }
        return CodeInsightBundle.message((String)"unwrap.with.placeholder", (Object[])new Object[]{text});
    }

    public boolean isApplicableTo(@NotNull PsiElement e) {
        return e instanceof GrExpression && e.getParent() instanceof GrArgumentList;
    }

    public PsiElement collectAffectedElements(@NotNull PsiElement e, @NotNull List<PsiElement> toExtract) {
        super.collectAffectedElements(e, toExtract);
        return e.getParent().getParent();
    }

    protected void doUnwrap(PsiElement element, GroovyUnwrapper.Context context) throws IncorrectOperationException {
        PsiElement methodCall = element.getParent().getParent();
        context.extractElement(element, methodCall);
        context.deleteExactly(methodCall);
    }
}

