/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.unwrap;

import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrIfStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.unwrap.GroovyUnwrapper;

public abstract class GroovyElseUnwrapperBase
extends GroovyUnwrapper {
    public GroovyElseUnwrapperBase(@NotNull @Nls String description) {
        super(description);
    }

    public boolean isApplicableTo(@NotNull PsiElement e) {
        return (GroovyElseUnwrapperBase.isElseBlock(e) || GroovyElseUnwrapperBase.isElseKeyword(e)) && GroovyElseUnwrapperBase.isValidConstruct(e);
    }

    private static boolean isElseKeyword(PsiElement e) {
        PsiElement p = e.getParent();
        return p instanceof GrIfStatement && PsiImplUtil.isLeafElementOfType((PsiElement)e, (IElementType)GroovyTokenTypes.kELSE);
    }

    private static boolean isValidConstruct(PsiElement e) {
        return ((GrIfStatement)e.getParent()).getElseBranch() != null;
    }

    public void collectElementsToIgnore(@NotNull PsiElement element, @NotNull Set<PsiElement> result2) {
        PsiElement parent2 = element.getParent();
        while (parent2 instanceof GrIfStatement) {
            result2.add(parent2);
            parent2 = parent2.getParent();
        }
    }

    protected void doUnwrap(PsiElement element, GroovyUnwrapper.Context context) throws IncorrectOperationException {
        GrStatement elseBranch = GroovyElseUnwrapperBase.isElseKeyword(element) ? ((GrIfStatement)element.getParent()).getElseBranch() : (GrStatement)element;
        this.unwrapElseBranch(elseBranch, element.getParent(), context);
    }

    protected abstract void unwrapElseBranch(GrStatement var1, PsiElement var2, GroovyUnwrapper.Context var3) throws IncorrectOperationException;
}

