/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.transformations.impl;

import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.light.LightMethodBuilder;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyLanguage;
import org.jetbrains.plugins.groovy.dsl.GroovyDslFileIndex;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.imports.GrImportStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.packaging.GrPackageDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrAnnotationUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrAnnotationUtilKt;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GroovyScriptClass;
import org.jetbrains.plugins.groovy.transformations.AstTransformationSupport;
import org.jetbrains.plugins.groovy.transformations.TransformationContext;

public class BaseScriptTransformationSupport
implements AstTransformationSupport {
    @Override
    public void applyTransformation(@NotNull TransformationContext context) {
        if (!(context.getCodeClass() instanceof GroovyScriptClass)) {
            return;
        }
        GroovyScriptClass scriptClass = (GroovyScriptClass)context.getCodeClass();
        LightMethodBuilder mainMethod = new LightMethodBuilder(scriptClass.getManager(), (Language)GroovyLanguage.INSTANCE, "main").setMethodReturnType((PsiType)PsiType.VOID).addParameter("args", (PsiType)new PsiArrayType((PsiType)PsiType.getJavaLangString((PsiManager)scriptClass.getManager(), (GlobalSearchScope)scriptClass.getResolveScope()))).addModifiers(new String[]{"public", "static"});
        LightMethodBuilder runMethod = new LightMethodBuilder(scriptClass.getManager(), (Language)GroovyLanguage.INSTANCE, "run").setMethodReturnType((PsiType)TypesUtil.getJavaLangObject(scriptClass)).addModifier("public");
        context.addMethod((PsiMethod)runMethod, true);
        context.addMethod((PsiMethod)mainMethod, true);
        context.setSuperType(BaseScriptTransformationSupport.getBaseClassType(scriptClass));
    }

    @NotNull
    private static PsiClassType getBaseClassType(@NotNull GroovyScriptClass scriptClass) {
        PsiClassType type2 = (PsiClassType)CachedValuesManager.getCachedValue((PsiElement)scriptClass, () -> CachedValueProvider.Result.create((Object)BaseScriptTransformationSupport.getSuperClassTypeFromBaseScriptAnnotation(scriptClass), (Object[])new Object[]{scriptClass.getContainingFile()}));
        if (type2 != null) {
            PsiClass resolved = type2.resolve();
            if (resolved instanceof GrTypeDefinition && BaseScriptTransformationSupport.reachableInHierarchy(new HashSet<PsiClass>(List.of(scriptClass)), (GrTypeDefinition)resolved)) {
                return TypesUtil.createTypeByFQClassName("groovy.lang.Script", scriptClass);
            }
            return type2;
        }
        PsiClassType superClassFromDSL = GroovyDslFileIndex.processScriptSuperClasses(scriptClass.getContainingFile());
        if (superClassFromDSL != null) {
            return superClassFromDSL;
        }
        return TypesUtil.createTypeByFQClassName("groovy.lang.Script", scriptClass);
    }

    private static boolean reachableInHierarchy(Set<PsiClass> forbidden, GrTypeDefinition root) {
        for (PsiClass aSuper : root.getSupers(false)) {
            if (forbidden.contains(aSuper)) {
                return true;
            }
            forbidden.add(aSuper);
            if (!(aSuper instanceof GrTypeDefinition) || !BaseScriptTransformationSupport.reachableInHierarchy(forbidden, (GrTypeDefinition)aSuper)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private static PsiClassType getSuperClassTypeFromBaseScriptAnnotation(@NotNull GroovyScriptClass scriptClass) {
        PsiClassType fromVariable = BaseScriptTransformationSupport.getSuperClassTypeFromBaseScriptAnnotatedVariable(scriptClass);
        if (fromVariable != null) {
            return fromVariable;
        }
        PsiClassType fromImport = BaseScriptTransformationSupport.getSuperClassTypeFromBaseScriptAnnotatedImportDefinition(scriptClass);
        if (fromImport != null) {
            return fromImport;
        }
        return BaseScriptTransformationSupport.getSuperClassTypeFromBaseScriptAnnotatedPackageDefinition(scriptClass);
    }

    @Nullable
    private static PsiClassType getSuperClassTypeFromBaseScriptAnnotatedImportDefinition(@NotNull GroovyScriptClass scriptClass) {
        GrImportStatement[] importStatements;
        for (GrImportStatement importStatement : importStatements = scriptClass.getContainingFile().getImportStatements()) {
            PsiClassType superClassType;
            GrModifierList annotations2 = importStatement.getAnnotationList();
            PsiAnnotation baseScriptAnnotation = annotations2.findAnnotation("groovy.transform.BaseScript");
            if (baseScriptAnnotation == null || (superClassType = BaseScriptTransformationSupport.getSuperClassTypeFromAnnotationValue(scriptClass, baseScriptAnnotation)) == null) continue;
            return superClassType;
        }
        return null;
    }

    @Nullable
    private static PsiClassType getSuperClassTypeFromBaseScriptAnnotatedPackageDefinition(@NotNull GroovyScriptClass scriptClass) {
        GrPackageDefinition packageDefinition = scriptClass.getContainingFile().getPackageDefinition();
        if (packageDefinition == null) {
            return null;
        }
        PsiModifierList modifierList = packageDefinition.getModifierList();
        if (modifierList == null) {
            return null;
        }
        PsiAnnotation baseScriptAnnotation = modifierList.findAnnotation("groovy.transform.BaseScript");
        if (baseScriptAnnotation == null) {
            return null;
        }
        return BaseScriptTransformationSupport.getSuperClassTypeFromAnnotationValue(scriptClass, baseScriptAnnotation);
    }

    @Nullable
    private static PsiClassType getSuperClassTypeFromAnnotationValue(GroovyScriptClass scriptClass, PsiAnnotation baseScriptAnnotation) {
        PsiClass clazz = GrAnnotationUtil.getPsiClass(GrAnnotationUtilKt.findDeclaredDetachedValue(baseScriptAnnotation, "value"));
        if (clazz != null) {
            String className = clazz.getQualifiedName();
            if (className == null) {
                clazz.getName();
            }
            if (className != null) {
                return TypesUtil.createTypeByFQClassName(className, scriptClass);
            }
        }
        return null;
    }

    @Nullable
    private static PsiClassType getSuperClassTypeFromBaseScriptAnnotatedVariable(GroovyScriptClass scriptClass) {
        PsiType type2;
        GrTypeElement typeElement;
        GrVariableDeclaration declaration = BaseScriptTransformationSupport.findDeclaration(scriptClass.getContainingFile());
        if (declaration != null && (typeElement = declaration.getTypeElementGroovy()) != null && (type2 = typeElement.getType()) instanceof PsiClassType) {
            return (PsiClassType)type2;
        }
        return null;
    }

    @Nullable
    private static GrVariableDeclaration findDeclaration(GroovyFile file) {
        if (!PsiSearchHelper.getInstance((Project)file.getProject()).hasIdentifierInFile((PsiFile)file, "BaseScript")) {
            return null;
        }
        for (GrVariableDeclaration declaration : file.getScriptDeclarations(false)) {
            if (!declaration.getModifierList().hasAnnotation("groovy.transform.BaseScript")) continue;
            return declaration;
        }
        return null;
    }
}

