/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.template;

import com.intellij.codeInsight.template.EverywhereContextType;
import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.lang.Language;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.GroovyLanguage;
import org.jetbrains.plugins.groovy.lang.completion.GroovyCompletionData;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrCodeBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public abstract class GroovyTemplateContextType
extends TemplateContextType {
    protected GroovyTemplateContextType(@NotNull @NonNls String id, @NlsContexts.Label @NotNull String presentableName, @Nullable Class<? extends TemplateContextType> baseContextType) {
        super(id, presentableName, baseContextType);
    }

    public boolean isInContext(@NotNull PsiFile file, int offset) {
        if (PsiUtilCore.getLanguageAtOffset((PsiFile)file, (int)offset).isKindOf((Language)GroovyLanguage.INSTANCE)) {
            PsiElement element = file.findElementAt(offset);
            if (element instanceof PsiWhiteSpace) {
                return false;
            }
            return element != null && this.isInContext(element);
        }
        return false;
    }

    protected abstract boolean isInContext(@NotNull PsiElement var1);

    private static boolean isAfterExpression(PsiElement element) {
        PsiElement prevExpr;
        ProcessingContext context = new ProcessingContext();
        return ((PsiElementPattern.Capture)PlatformPatterns.psiElement().afterLeaf((ElementPattern)PlatformPatterns.psiElement().inside((ElementPattern)PlatformPatterns.psiElement(GrExpression.class).save("prevExpr")))).accepts((Object)element, context) && (prevExpr = (PsiElement)context.get((Object)"prevExpr")).getTextRange().getEndOffset() <= element.getTextRange().getStartOffset();
    }

    public static class Declaration
    extends GroovyTemplateContextType {
        public Declaration() {
            super("GROOVY_DECLARATION", GroovyBundle.message("live.template.context.declaration", new Object[0]), Generic.class);
        }

        @Override
        protected boolean isInContext(@NotNull PsiElement element) {
            if (PsiTreeUtil.getParentOfType((PsiElement)element, GrCodeBlock.class, (boolean)false, (Class[])new Class[]{GrTypeDefinition.class}) != null) {
                return false;
            }
            if (element instanceof PsiComment) {
                return false;
            }
            return GroovyCompletionData.suggestClassInterfaceEnum(element) || GroovyCompletionData.suggestFinalDef(element);
        }
    }

    public static class Expression
    extends GroovyTemplateContextType {
        public Expression() {
            super("GROOVY_EXPRESSION", GroovyBundle.message("live.template.context.expression", new Object[0]), Generic.class);
        }

        @Override
        protected boolean isInContext(@NotNull PsiElement element) {
            return Expression.isExpressionContext(element);
        }

        private static boolean isExpressionContext(PsiElement element) {
            PsiElement parent2 = element.getParent();
            if (!(parent2 instanceof GrReferenceExpression)) {
                return false;
            }
            if (((GrReferenceExpression)parent2).isQualified()) {
                return false;
            }
            if (parent2.getParent() instanceof GrCall) {
                return false;
            }
            return !GroovyTemplateContextType.isAfterExpression(element);
        }
    }

    public static class Statement
    extends GroovyTemplateContextType {
        public Statement() {
            super("GROOVY_STATEMENT", GroovyBundle.message("live.template.context.statement", new Object[0]), Generic.class);
        }

        @Override
        protected boolean isInContext(@NotNull PsiElement element) {
            PsiElement stmt = PsiTreeUtil.findFirstParent((PsiElement)element, element11 -> PsiUtil.isExpressionStatement(element11));
            return !GroovyTemplateContextType.isAfterExpression(element) && stmt != null && stmt.getTextRange().getStartOffset() == element.getTextRange().getStartOffset();
        }
    }

    public static class Generic
    extends GroovyTemplateContextType {
        public Generic() {
            super("GROOVY", GroovyBundle.message("language.groovy", new Object[0]), EverywhereContextType.class);
        }

        @Override
        protected boolean isInContext(@NotNull PsiElement element) {
            return true;
        }
    }
}

