/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.convertToStatic;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.annotator.InaccessibleElementVisitor;
import org.jetbrains.plugins.groovy.annotator.VisitorCallback;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyRecursiveElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;

public class DynamicFeaturesVisitor
extends GroovyRecursiveElementVisitor {
    private final VisitorCallback myCallback;
    private final InaccessibleElementVisitor accessibilityChecker;

    public DynamicFeaturesVisitor(@NotNull GroovyFile file, @NotNull Project project, @NotNull VisitorCallback callback) {
        this.accessibilityChecker = new InaccessibleElementVisitor(file, project, callback);
        this.myCallback = callback;
    }

    @Override
    public void visitReferenceExpression(@NotNull GrReferenceExpression referenceExpression) {
        this.accessibilityChecker.visitReferenceExpression(referenceExpression);
        PsiElement resolved = referenceExpression.resolve();
        if (resolved == null) {
            this.myCallback.trigger(referenceExpression, null);
        } else if (!(referenceExpression.getType() != null || resolved instanceof GrMethod && ((GrMethod)resolved).isConstructor())) {
            this.myCallback.trigger(referenceExpression, null);
        }
        super.visitReferenceExpression(referenceExpression);
    }

    @Override
    public void visitCodeReferenceElement(@NotNull GrCodeReferenceElement refElement) {
        this.accessibilityChecker.visitCodeReferenceElement(refElement);
        super.visitCodeReferenceElement(refElement);
    }
}

