/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.convertToStatic;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.ui.UsageViewDescriptorAdapter;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.annotator.VisitorCallback;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyRecursiveElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.util.CompileStaticUtil;
import org.jetbrains.plugins.groovy.refactoring.GroovyRefactoringBundle;
import org.jetbrains.plugins.groovy.refactoring.convertToStatic.ConvertToStatic;
import org.jetbrains.plugins.groovy.refactoring.convertToStatic.DynamicFeaturesVisitor;

public class ConvertToStaticProcessor
extends BaseRefactoringProcessor {
    private static final Logger LOG = Logger.getInstance(ConvertToStaticProcessor.class);
    private final GroovyFile[] myFiles;

    public ConvertToStaticProcessor(Project project, GroovyFile ... files) {
        super(project);
        this.myFiles = files;
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(UsageInfo @NotNull [] usages) {
        return new UsageViewDescriptorAdapter(){

            public PsiElement @NotNull [] getElements() {
                return ConvertToStaticProcessor.this.myFiles;
            }

            public String getProcessedElementsHeader() {
                return GroovyRefactoringBundle.message("files.to.be.converted", new Object[0]);
            }
        };
    }

    protected UsageInfo @NotNull [] findUsages() {
        return UsageInfo.EMPTY_ARRAY;
    }

    protected void performRefactoring(UsageInfo @NotNull [] usages) {
        int counter = 0;
        ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
        LOG.assertTrue(progressIndicator != null);
        progressIndicator.setIndeterminate(false);
        for (GroovyFile file : this.myFiles) {
            this.commitFile(file);
            progressIndicator.setText2(file.getName());
            progressIndicator.setFraction((double)(++counter) / (double)this.myFiles.length);
            try {
                ConvertToStatic.applyDeclarationFixes(file);
                this.putCompileAnnotations(file);
                ConvertToStatic.applyErrorFixes(file);
                this.commitFile(file);
            }
            catch (Exception e) {
                LOG.error("Error in converting file: " + file.getName(), (Throwable)e);
            }
        }
    }

    private void commitFile(@NotNull GroovyFile file) {
        Document document = PsiDocumentManager.getInstance((Project)this.myProject).getDocument((PsiFile)file);
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)file.getProject());
        LOG.assertTrue(document != null);
        psiDocumentManager.commitDocument(document);
        LOG.assertTrue(file.isValid());
    }

    private void putCompileAnnotations(@NotNull GroovyFile file) {
        final HashSet classesWithUnresolvedRef = new HashSet();
        final HashSet methodsWithUnresolvedRef = new HashSet();
        VisitorCallback callback = (element, info) -> {
            GrMethod containingMethod = (GrMethod)PsiTreeUtil.getParentOfType((PsiElement)element, GrMethod.class);
            if (containingMethod != null) {
                methodsWithUnresolvedRef.add(containingMethod);
                return;
            }
            GrTypeDefinition containingClass = (GrTypeDefinition)PsiTreeUtil.getParentOfType((PsiElement)element, GrTypeDefinition.class);
            if (containingClass != null) {
                classesWithUnresolvedRef.add(containingClass);
            }
        };
        file.accept(new DynamicFeaturesVisitor(file, this.myProject, callback));
        file.accept(new GroovyRecursiveElementVisitor(){

            @Override
            public void visitTypeDefinition(@NotNull GrTypeDefinition typeDef) {
                ConvertToStaticProcessor.this.processDefinitions(typeDef, classesWithUnresolvedRef);
                super.visitTypeDefinition(typeDef);
            }

            @Override
            public void visitMethod(@NotNull GrMethod method) {
                ConvertToStaticProcessor.this.processMethods(method, methodsWithUnresolvedRef);
                super.visitMethod(method);
            }
        });
    }

    private void processMethods(@NotNull GrMethod method, Set<GrMethod> dynamicMethods) {
        PsiClass containingClass = method.getContainingClass();
        boolean isOuterStatic = containingClass != null && CompileStaticUtil.isCompileStatic((PsiElement)containingClass);
        boolean isStatic = dynamicMethods.stream().noneMatch(arg_0 -> ((GrMethod)method).isEquivalentTo(arg_0));
        if (isOuterStatic != isStatic) {
            this.addAnnotation(method, isStatic);
        }
    }

    private void processDefinitions(GrTypeDefinition typeDef, Set<GrTypeDefinition> dynamicClasses) {
        boolean isStatic;
        PsiClass containingClass = typeDef.getContainingClass();
        boolean isOuterStatic = containingClass != null && CompileStaticUtil.isCompileStatic((PsiElement)containingClass);
        boolean bl = isStatic = !dynamicClasses.contains(typeDef);
        if (isOuterStatic && !isStatic) {
            this.addAnnotation(typeDef, false);
        }
        if (!isOuterStatic && isStatic) {
            this.addAnnotation(typeDef, true);
        }
    }

    @NotNull
    protected String getCommandName() {
        return GroovyRefactoringBundle.message("converting.files.to.static", new Object[0]);
    }

    void addAnnotation(@NotNull PsiMember owner, boolean isStatic) {
        PsiModifierList modifierList = owner.getModifierList();
        if (modifierList != null && CompileStaticUtil.getCompileStaticAnnotation(owner) == null) {
            String annotation = isStatic ? "groovy.transform.CompileStatic" : "groovy.transform.CompileDynamic";
            modifierList.addAnnotation(annotation);
        }
    }
}

